/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.util.Iterator;
import java.util.List;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JREvaluator;
import net.sf.jasperreports.engine.fill.JRFillBand;
import net.sf.jasperreports.engine.fill.JRFillGroup;
import net.sf.jasperreports.engine.fill.JRFillVariable;
import net.sf.jasperreports.engine.fill.JRPrintBand;

public class JRVerticalFiller
extends JRBaseFiller {
    private boolean isCreatingNewPage = false;
    private boolean isNewPage = false;
    private boolean isNewColumn = false;
    private boolean isNewGroup = true;
    private int columnIndex = 0;
    private int offsetX = 0;
    private int offsetY = 0;
    private int columnHeaderOffsetY = 0;
    private int columnFooterOffsetY = 0;
    private int lastPageColumnFooterOffsetY = 0;
    private boolean isLastPageFooter = false;

    protected JRVerticalFiller(JasperReport jasperReport) throws JRException {
        this(jasperReport, null, null);
    }

    protected JRVerticalFiller(JasperReport jasperReport, JRBaseFiller jRBaseFiller) throws JRException {
        super(jasperReport, null, jRBaseFiller);
        this.setPageHeight(this.pageHeight);
    }

    protected JRVerticalFiller(JasperReport jasperReport, JREvaluator jREvaluator, JRBaseFiller jRBaseFiller) throws JRException {
        super(jasperReport, jREvaluator, jRBaseFiller);
        this.setPageHeight(this.pageHeight);
    }

    protected void setPageHeight(int n) {
        this.pageHeight = n;
        this.columnFooterOffsetY = n - this.bottomMargin;
        if (this.pageFooter != null) {
            this.columnFooterOffsetY -= this.pageFooter.getHeight();
        }
        if (this.columnFooter != null) {
            this.columnFooterOffsetY -= this.columnFooter.getHeight();
        }
        this.lastPageColumnFooterOffsetY = n - this.bottomMargin;
        if (this.lastPageFooter != null) {
            this.lastPageColumnFooterOffsetY -= this.lastPageFooter.getHeight();
        }
        if (this.columnFooter != null) {
            this.lastPageColumnFooterOffsetY -= this.columnFooter.getHeight();
        }
    }

    protected synchronized void fillReport() throws JRException {
        this.setLastPageFooter(false);
        if (this.next()) {
            this.fillReportStart();
            while (this.next()) {
                this.fillReportContent();
            }
            this.fillReportEnd();
        } else {
            switch (this.whenNoDataType) {
                case 3: {
                    this.scriptlet.callBeforeReportInit();
                    this.calculator.initializeVariables((byte)1);
                    this.scriptlet.callAfterReportInit();
                    this.printPage = this.newPage();
                    this.addPage(this.printPage);
                    this.setFirstColumn();
                    this.offsetY = this.topMargin;
                    this.fillBackground();
                    this.fillTitle();
                    this.fillPageHeader((byte)3);
                    this.fillColumnHeader((byte)3);
                    this.fillGroupHeaders(true);
                    this.fillGroupFooters(true);
                    this.fillSummary();
                    break;
                }
                case 2: {
                    this.printPage = this.newPage();
                    this.addPage(this.printPage);
                    break;
                }
            }
        }
        if (this.isSubreport()) {
            this.printPageStretchHeight = this.offsetY + this.bottomMargin;
            if (this.fillContext.isUsingVirtualizer()) {
                this.removePageIdentityDataProvider();
            }
        }
        if (this.fillContext.isIgnorePagination()) {
            this.jasperPrint.setPageHeight(this.offsetY + this.bottomMargin);
        }
    }

    private void fillReportStart() throws JRException {
        this.scriptlet.callBeforeReportInit();
        this.calculator.initializeVariables((byte)1);
        this.scriptlet.callAfterReportInit();
        this.printPage = this.newPage();
        this.addPage(this.printPage);
        this.setFirstColumn();
        this.offsetY = this.topMargin;
        this.fillBackground();
        this.fillTitle();
        this.fillPageHeader((byte)3);
        this.fillColumnHeader((byte)3);
        this.fillGroupHeaders(true);
        this.fillDetail();
    }

    private void fillReportContent() throws JRException {
        this.calculator.estimateGroupRuptures();
        this.fillGroupFooters(false);
        this.resolveGroupBoundElements((byte)1, false);
        this.scriptlet.callBeforeGroupInit();
        this.calculator.initializeVariables((byte)4);
        this.scriptlet.callAfterGroupInit();
        this.fillGroupHeaders(false);
        this.fillDetail();
    }

    private void fillReportEnd() throws JRException {
        this.fillGroupFooters(true);
        this.fillSummary();
    }

    private void fillTitle() throws JRException {
        this.title.evaluatePrintWhenExpression((byte)3);
        if (this.title.isToPrint()) {
            while (this.title.getHeight() > this.pageHeight - this.bottomMargin - this.offsetY) {
                this.addPage(false);
            }
            this.title.evaluate((byte)3);
            JRPrintBand jRPrintBand = this.title.fill(this.pageHeight - this.bottomMargin - this.offsetY - this.title.getHeight());
            if (this.title.willOverflow() && !this.title.isSplitAllowed() && this.isSubreport()) {
                this.resolveGroupBoundElements((byte)3, false);
                this.resolveColumnBoundElements((byte)3);
                this.resolvePageBoundElements((byte)3);
                this.scriptlet.callBeforePageInit();
                this.calculator.initializeVariables((byte)2);
                this.scriptlet.callAfterPageInit();
                this.addPage(false);
                jRPrintBand = this.title.refill(this.pageHeight - this.bottomMargin - this.offsetY - this.title.getHeight());
            }
            this.fillBand(jRPrintBand);
            this.offsetY += jRPrintBand.getHeight();
            while (this.title.willOverflow()) {
                this.resolveGroupBoundElements((byte)3, false);
                this.resolveColumnBoundElements((byte)3);
                this.resolvePageBoundElements((byte)3);
                this.scriptlet.callBeforePageInit();
                this.calculator.initializeVariables((byte)2);
                this.scriptlet.callAfterPageInit();
                this.addPage(false);
                jRPrintBand = this.title.fill(this.pageHeight - this.bottomMargin - this.offsetY - this.title.getHeight());
                this.fillBand(jRPrintBand);
                this.offsetY += jRPrintBand.getHeight();
            }
            this.resolveBandBoundElements(this.title, (byte)3);
            if (this.isTitleNewPage) {
                this.resolveGroupBoundElements((byte)3, false);
                this.resolveColumnBoundElements((byte)3);
                this.resolvePageBoundElements((byte)3);
                this.scriptlet.callBeforePageInit();
                this.calculator.initializeVariables((byte)2);
                this.scriptlet.callAfterPageInit();
                this.addPage(false);
            }
        }
    }

    private void fillPageHeader(byte by) throws JRException {
        this.setNewPageColumnInBands();
        this.pageHeader.evaluatePrintWhenExpression((byte)3);
        if (this.pageHeader.isToPrint()) {
            int n = this.getMasterColumnCount();
            if (this.isCreatingNewPage) {
                --n;
            }
            boolean bl = this.fillBandNoOverflow(this.pageHeader, by);
            for (int i = 0; !bl && i < n; ++i) {
                this.resolveGroupBoundElements(by, false);
                this.resolveColumnBoundElements(by);
                this.resolvePageBoundElements(by);
                this.scriptlet.callBeforePageInit();
                this.calculator.initializeVariables((byte)2);
                this.scriptlet.callAfterPageInit();
                this.addPage(false);
                bl = this.fillBandNoOverflow(this.pageHeader, by);
            }
            if (!bl) {
                throw new JRRuntimeException("Infinite loop creating new page due to page header overflow.");
            }
        }
        this.columnHeaderOffsetY = this.offsetY;
        this.isNewPage = true;
    }

    private boolean fillBandNoOverflow(JRFillBand jRFillBand, byte by) throws JRException {
        boolean bl;
        int n = this.columnFooterOffsetY - this.offsetY - jRFillBand.getHeight();
        boolean bl2 = bl = n < 0;
        if (!bl) {
            jRFillBand.evaluate(by);
            JRPrintBand jRPrintBand = jRFillBand.fill(n);
            bl = jRFillBand.willOverflow();
            if (bl) {
                jRFillBand.rewind();
            } else {
                this.fillBand(jRPrintBand);
                this.offsetY += jRPrintBand.getHeight();
                this.resolveBandBoundElements(jRFillBand, by);
            }
        }
        return !bl;
    }

    private void fillColumnHeader(byte by) throws JRException {
        this.setNewPageColumnInBands();
        this.columnHeader.evaluatePrintWhenExpression(by);
        if (this.columnHeader.isToPrint()) {
            int n = this.getMasterColumnCount();
            if (this.isCreatingNewPage) {
                --n;
            }
            boolean bl = this.fillBandNoOverflow(this.columnHeader, by);
            for (int i = 0; !bl && i < n; ++i) {
                while (this.columnIndex < this.columnCount - 1) {
                    this.resolveGroupBoundElements(by, false);
                    this.resolveColumnBoundElements(by);
                    this.scriptlet.callBeforeColumnInit();
                    this.calculator.initializeVariables((byte)3);
                    this.scriptlet.callAfterColumnInit();
                    ++this.columnIndex;
                    this.offsetX = this.leftMargin + this.columnIndex * (this.columnSpacing + this.columnWidth);
                    this.offsetY = this.columnHeaderOffsetY;
                    this.setColumnNumberVar();
                }
                this.fillPageFooter(by);
                this.resolveGroupBoundElements(by, false);
                this.resolveColumnBoundElements(by);
                this.resolvePageBoundElements(by);
                this.scriptlet.callBeforePageInit();
                this.calculator.initializeVariables((byte)2);
                this.scriptlet.callAfterPageInit();
                this.addPage(false);
                this.fillPageHeader(by);
                bl = this.fillBandNoOverflow(this.columnHeader, by);
            }
            if (!bl) {
                throw new JRRuntimeException("Infinite loop creating new page due to column header overflow.");
            }
        }
        this.isNewColumn = true;
    }

    private void fillGroupHeaders(boolean bl) throws JRException {
        if (this.groups != null && this.groups.length > 0) {
            for (int i = 0; i < this.groups.length; ++i) {
                if (bl) {
                    this.fillGroupHeader(this.groups[i]);
                    continue;
                }
                if (!this.groups[i].hasChanged()) continue;
                this.fillGroupHeader(this.groups[i]);
            }
        }
    }

    private void fillGroupHeader(JRFillGroup jRFillGroup) throws JRException {
        byte by;
        byte by2 = by = jRFillGroup.isTopLevelChange() ? (byte)1 : 3;
        if ((jRFillGroup.isStartNewPage() || jRFillGroup.isResetPageNumber()) && !this.isNewPage) {
            this.fillPageBreak(jRFillGroup.isResetPageNumber(), by, (byte)3, true);
        } else if (jRFillGroup.isStartNewColumn() && !this.isNewColumn) {
            this.fillColumnBreak(by, (byte)3);
        }
        JRFillBand jRFillBand = (JRFillBand)jRFillGroup.getGroupHeader();
        jRFillBand.evaluatePrintWhenExpression((byte)3);
        if (jRFillBand.isToPrint()) {
            while (jRFillBand.getHeight() > this.columnFooterOffsetY - this.offsetY || jRFillGroup.getMinHeightToStartNewPage() > this.columnFooterOffsetY - this.offsetY) {
                this.fillColumnBreak(by, (byte)3);
            }
        }
        this.setNewGroupInBands(jRFillGroup);
        jRFillGroup.setFooterPrinted(false);
        if (jRFillBand.isToPrint()) {
            this.fillColumnBand(jRFillBand, (byte)3);
        }
        this.isNewGroup = true;
    }

    private void fillGroupHeadersReprint(byte by) throws JRException {
        if (this.groups != null && this.groups.length > 0) {
            for (int i = 0; i < this.groups.length; ++i) {
                this.fillGroupHeaderReprint(this.groups[i], by);
            }
        }
    }

    private void fillGroupHeaderReprint(JRFillGroup jRFillGroup, byte by) throws JRException {
        if (jRFillGroup.isReprintHeaderOnEachPage() && (!jRFillGroup.hasChanged() || jRFillGroup.hasChanged() && !jRFillGroup.isFooterPrinted())) {
            JRFillBand jRFillBand = (JRFillBand)jRFillGroup.getGroupHeader();
            jRFillBand.evaluatePrintWhenExpression(by);
            if (jRFillBand.isToPrint()) {
                while (jRFillBand.getHeight() > this.columnFooterOffsetY - this.offsetY || jRFillGroup.getMinHeightToStartNewPage() > this.columnFooterOffsetY - this.offsetY) {
                    this.fillColumnBreak(by, by);
                }
                this.fillColumnBand(jRFillBand, by);
            }
        }
    }

    private void fillDetail() throws JRException {
        if (!this.detail.isPrintWhenExpressionNull()) {
            this.calculator.estimateVariables();
            this.detail.evaluatePrintWhenExpression((byte)2);
        }
        if (this.detail.isToPrint()) {
            while (this.detail.getHeight() > this.columnFooterOffsetY - this.offsetY) {
                byte by = this.isNewGroup ? (byte)3 : 1;
                this.fillColumnBreak(by, (byte)3);
            }
        }
        this.scriptlet.callBeforeDetailEval();
        this.calculator.calculateVariables();
        this.scriptlet.callAfterDetailEval();
        if (!this.detail.isPrintWhenExpressionNull()) {
            this.detail.evaluatePrintWhenExpression((byte)3);
        }
        if (this.detail.isToPrint()) {
            this.fillColumnBand(this.detail, (byte)3);
        }
        this.isNewPage = false;
        this.isNewColumn = false;
        this.isNewGroup = false;
    }

    private void fillGroupFooters(boolean bl) throws JRException {
        if (this.groups != null && this.groups.length > 0) {
            byte by = bl ? (byte)3 : 1;
            for (int i = this.groups.length - 1; i >= 0; --i) {
                if (bl) {
                    this.fillGroupFooter(this.groups[i], by);
                    continue;
                }
                if (!this.groups[i].hasChanged()) continue;
                this.fillGroupFooter(this.groups[i], by);
            }
        }
    }

    private void fillGroupFooter(JRFillGroup jRFillGroup, byte by) throws JRException {
        JRFillBand jRFillBand = (JRFillBand)jRFillGroup.getGroupFooter();
        jRFillBand.evaluatePrintWhenExpression(by);
        if (jRFillBand.isToPrint()) {
            if (jRFillBand.getHeight() > this.columnFooterOffsetY - this.offsetY) {
                this.fillColumnBreak(by, by);
            }
            this.fillColumnBand(jRFillBand, by);
        }
        this.isNewPage = false;
        this.isNewColumn = false;
        jRFillGroup.setFooterPrinted(true);
    }

    private void fillColumnFooter(byte by) throws JRException {
        if (this.isSubreport() && this.columnIndex == 0) {
            this.columnFooterOffsetY = this.offsetY;
        }
        int n = this.offsetY;
        if (!this.isFloatColumnFooter && !this.fillContext.isIgnorePagination()) {
            this.offsetY = this.columnFooterOffsetY;
        }
        this.columnFooter.evaluatePrintWhenExpression(by);
        if (this.columnFooter.isToPrint()) {
            this.fillFixedBand(this.columnFooter, by);
        }
        if (this.isFloatColumnFooter && !this.fillContext.isIgnorePagination()) {
            this.offsetY += this.columnFooterOffsetY - n;
        }
    }

    private void fillPageFooter(byte by) throws JRException {
        JRFillBand jRFillBand = this.getCurrentPageFooter();
        this.offsetX = this.leftMargin;
        if (!this.isSubreport() && !this.fillContext.isIgnorePagination()) {
            this.offsetY = this.pageHeight - jRFillBand.getHeight() - this.bottomMargin;
        }
        jRFillBand.evaluatePrintWhenExpression(by);
        if (jRFillBand.isToPrint()) {
            this.fillFixedBand(jRFillBand, by);
        }
    }

    private void fillSummary() throws JRException {
        if (this.lastPageFooter == this.missingFillBand) {
            if (!this.isSummaryNewPage && this.columnIndex == 0 && this.summary.getHeight() <= this.columnFooterOffsetY - this.offsetY) {
                this.fillSummarySamePage();
            } else {
                this.fillSummaryNewPage();
            }
        } else if (!this.isSummaryNewPage && this.columnIndex == 0 && this.summary.getHeight() <= this.lastPageColumnFooterOffsetY - this.offsetY) {
            this.setLastPageFooter(true);
            this.fillSummarySamePage();
        } else if (!this.isSummaryNewPage && this.columnIndex == 0 && this.summary.getHeight() <= this.columnFooterOffsetY - this.offsetY) {
            this.fillSummarySamePageMixedFooters();
        } else if (this.columnIndex == 0 && this.offsetY <= this.lastPageColumnFooterOffsetY) {
            this.setLastPageFooter(true);
            this.fillSummaryNewPage();
        } else {
            this.fillPageBreak(false, (byte)3, (byte)3, false);
            this.setLastPageFooter(true);
            if (this.isSummaryNewPage) {
                this.fillSummaryNewPage();
            } else {
                this.fillSummarySamePage();
            }
        }
        this.resolveGroupBoundElements((byte)3, true);
        this.resolveColumnBoundElements((byte)3);
        this.resolvePageBoundElements((byte)3);
        this.resolveReportBoundElements();
    }

    private void fillSummarySamePage() throws JRException {
        this.summary.evaluatePrintWhenExpression((byte)3);
        if (this.summary != this.missingFillBand && this.summary.isToPrint()) {
            this.summary.evaluate((byte)3);
            JRPrintBand jRPrintBand = this.summary.fill(this.columnFooterOffsetY - this.offsetY - this.summary.getHeight());
            if (this.summary.willOverflow() && !this.summary.isSplitAllowed()) {
                this.fillColumnFooter((byte)3);
                this.fillPageFooter((byte)3);
                this.resolveGroupBoundElements((byte)3, true);
                this.resolveColumnBoundElements((byte)3);
                this.resolvePageBoundElements((byte)3);
                this.scriptlet.callBeforePageInit();
                this.calculator.initializeVariables((byte)2);
                this.scriptlet.callAfterPageInit();
                this.addPage(false);
                jRPrintBand = this.summary.refill(this.pageHeight - this.bottomMargin - this.offsetY - this.summary.getHeight());
                this.fillBand(jRPrintBand);
                this.offsetY += jRPrintBand.getHeight();
            } else {
                this.fillBand(jRPrintBand);
                this.offsetY += jRPrintBand.getHeight();
                this.fillColumnFooter((byte)3);
                this.fillPageFooter((byte)3);
            }
            while (this.summary.willOverflow()) {
                this.resolveGroupBoundElements((byte)3, true);
                this.resolveColumnBoundElements((byte)3);
                this.resolvePageBoundElements((byte)3);
                this.scriptlet.callBeforePageInit();
                this.calculator.initializeVariables((byte)2);
                this.scriptlet.callAfterPageInit();
                this.addPage(false);
                jRPrintBand = this.summary.fill(this.pageHeight - this.bottomMargin - this.offsetY - this.summary.getHeight());
                this.fillBand(jRPrintBand);
                this.offsetY += jRPrintBand.getHeight();
            }
            this.resolveBandBoundElements(this.summary, (byte)3);
        } else {
            this.fillColumnFooter((byte)3);
            this.fillPageFooter((byte)3);
        }
    }

    private void fillSummarySamePageMixedFooters() throws JRException {
        this.summary.evaluatePrintWhenExpression((byte)3);
        if (this.summary != this.missingFillBand && this.summary.isToPrint()) {
            this.summary.evaluate((byte)3);
            JRPrintBand jRPrintBand = this.summary.fill(this.columnFooterOffsetY - this.offsetY - this.summary.getHeight());
            if (this.summary.willOverflow() && !this.summary.isSplitAllowed()) {
                if (this.offsetY <= this.lastPageColumnFooterOffsetY) {
                    this.setLastPageFooter(true);
                    this.fillColumnFooter((byte)3);
                    this.fillPageFooter((byte)3);
                    this.resolveGroupBoundElements((byte)3, true);
                    this.resolveColumnBoundElements((byte)3);
                    this.resolvePageBoundElements((byte)3);
                    this.scriptlet.callBeforePageInit();
                    this.calculator.initializeVariables((byte)2);
                    this.scriptlet.callAfterPageInit();
                    this.addPage(false);
                    jRPrintBand = this.summary.refill(this.pageHeight - this.bottomMargin - this.offsetY - this.summary.getHeight());
                    this.fillBand(jRPrintBand);
                    this.offsetY += jRPrintBand.getHeight();
                } else {
                    this.fillPageBreak(false, (byte)3, (byte)3, false);
                    this.setLastPageFooter(true);
                    jRPrintBand = this.summary.refill(this.lastPageColumnFooterOffsetY - this.offsetY - this.summary.getHeight());
                    this.fillBand(jRPrintBand);
                    this.offsetY += jRPrintBand.getHeight();
                    this.fillColumnFooter((byte)3);
                    this.fillPageFooter((byte)3);
                }
            } else {
                this.fillBand(jRPrintBand);
                this.offsetY += jRPrintBand.getHeight();
                this.fillPageBreak(false, (byte)3, (byte)3, false);
                this.setLastPageFooter(true);
                if (this.summary.willOverflow()) {
                    jRPrintBand = this.summary.fill(this.lastPageColumnFooterOffsetY - this.offsetY - this.summary.getHeight());
                    this.fillBand(jRPrintBand);
                    this.offsetY += jRPrintBand.getHeight();
                }
                this.fillColumnFooter((byte)3);
                this.fillPageFooter((byte)3);
            }
            while (this.summary.willOverflow()) {
                this.resolveGroupBoundElements((byte)3, true);
                this.resolveColumnBoundElements((byte)3);
                this.resolvePageBoundElements((byte)3);
                this.scriptlet.callBeforePageInit();
                this.calculator.initializeVariables((byte)2);
                this.scriptlet.callAfterPageInit();
                this.addPage(false);
                jRPrintBand = this.summary.fill(this.pageHeight - this.bottomMargin - this.offsetY - this.summary.getHeight());
                this.fillBand(jRPrintBand);
                this.offsetY += jRPrintBand.getHeight();
            }
            this.resolveBandBoundElements(this.summary, (byte)3);
        } else {
            if (this.offsetY > this.lastPageColumnFooterOffsetY) {
                this.fillPageBreak(false, (byte)3, (byte)3, false);
            }
            this.setLastPageFooter(true);
            this.fillColumnFooter((byte)3);
            this.fillPageFooter((byte)3);
        }
    }

    private void fillSummaryNewPage() throws JRException {
        this.fillColumnFooter((byte)3);
        this.fillPageFooter((byte)3);
        this.summary.evaluatePrintWhenExpression((byte)3);
        if (this.summary != this.missingFillBand && this.summary.isToPrint()) {
            this.resolveGroupBoundElements((byte)3, true);
            this.resolveColumnBoundElements((byte)3);
            this.resolvePageBoundElements((byte)3);
            this.scriptlet.callBeforePageInit();
            this.calculator.initializeVariables((byte)2);
            this.scriptlet.callAfterPageInit();
            this.addPage(false);
            this.columnIndex = -1;
            this.summary.evaluate((byte)3);
            JRPrintBand jRPrintBand = this.summary.fill(this.pageHeight - this.bottomMargin - this.offsetY - this.summary.getHeight());
            if (this.summary.willOverflow() && !this.summary.isSplitAllowed() && this.isSubreport()) {
                this.resolveGroupBoundElements((byte)3, true);
                this.resolveColumnBoundElements((byte)3);
                this.resolvePageBoundElements((byte)3);
                this.scriptlet.callBeforePageInit();
                this.calculator.initializeVariables((byte)2);
                this.scriptlet.callAfterPageInit();
                this.addPage(false);
                jRPrintBand = this.summary.refill(this.pageHeight - this.bottomMargin - this.offsetY - this.summary.getHeight());
            }
            this.fillBand(jRPrintBand);
            this.offsetY += jRPrintBand.getHeight();
            while (this.summary.willOverflow()) {
                this.resolveGroupBoundElements((byte)3, true);
                this.resolveColumnBoundElements((byte)3);
                this.resolvePageBoundElements((byte)3);
                this.scriptlet.callBeforePageInit();
                this.calculator.initializeVariables((byte)2);
                this.scriptlet.callAfterPageInit();
                this.addPage(false);
                jRPrintBand = this.summary.fill(this.pageHeight - this.bottomMargin - this.offsetY - this.summary.getHeight());
                this.fillBand(jRPrintBand);
                this.offsetY += jRPrintBand.getHeight();
            }
            this.resolveBandBoundElements(this.summary, (byte)3);
        }
    }

    private void fillBackground() throws JRException {
        if (this.background.getHeight() <= this.pageHeight - this.bottomMargin - this.offsetY) {
            this.background.evaluatePrintWhenExpression((byte)3);
            if (this.background.isToPrint()) {
                this.background.evaluate((byte)3);
                JRPrintBand jRPrintBand = this.background.fill(this.pageHeight - this.bottomMargin - this.offsetY - this.background.getHeight());
                this.fillBand(jRPrintBand);
            }
        }
    }

    private void addPage(boolean bl) throws JRException {
        if (this.isSubreport()) {
            if (!this.parentFiller.isBandOverFlowAllowed()) {
                throw new JRRuntimeException("Subreport overflowed on a band that does not support overflow.");
            }
            this.printPageStretchHeight = this.offsetY + this.bottomMargin;
            if (this.fillContext.isUsingVirtualizer()) {
                this.removePageIdentityDataProvider();
            }
            this.notifyAll();
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                throw new JRException("Error encountered while waiting on the subreport filling thread.", interruptedException);
            }
        }
        this.printPage = this.newPage();
        if (this.isSubreport() && this.fillContext.isUsingVirtualizer()) {
            this.addPageIdentityDataProvider();
        }
        if (bl) {
            this.calculator.getPageNumber().setValue(new Integer(1));
        } else {
            this.calculator.getPageNumber().setValue(new Integer(((Number)this.calculator.getPageNumber().getValue()).intValue() + 1));
        }
        this.calculator.getPageNumber().setOldValue(this.calculator.getPageNumber().getValue());
        this.addPage(this.printPage);
        this.setFirstColumn();
        this.offsetY = this.topMargin;
        this.fillBackground();
    }

    private void setFirstColumn() {
        this.columnIndex = 0;
        this.offsetX = this.leftMargin;
        this.setColumnNumberVar();
    }

    private void setColumnNumberVar() {
        JRFillVariable jRFillVariable = this.calculator.getColumnNumber();
        jRFillVariable.setValue(new Integer(this.columnIndex + 1));
        jRFillVariable.setOldValue(jRFillVariable.getValue());
    }

    private void fillPageBreak(boolean bl, byte by, byte by2, boolean bl2) throws JRException {
        if (this.isCreatingNewPage) {
            throw new JRException("Infinite loop creating new page.");
        }
        this.isCreatingNewPage = true;
        this.fillColumnFooter(by);
        this.fillPageFooter(by);
        this.resolveGroupBoundElements(by, false);
        this.resolveColumnBoundElements(by);
        this.resolvePageBoundElements(by);
        this.scriptlet.callBeforePageInit();
        this.calculator.initializeVariables((byte)2);
        this.scriptlet.callAfterPageInit();
        this.addPage(bl);
        this.fillPageHeader(by2);
        this.fillColumnHeader(by2);
        if (bl2) {
            this.fillGroupHeadersReprint(by2);
        }
        this.isCreatingNewPage = false;
    }

    private void fillColumnBreak(byte by, byte by2) throws JRException {
        if (this.columnIndex == this.columnCount - 1) {
            this.fillPageBreak(false, by, by2, true);
        } else {
            this.fillColumnFooter(by);
            this.resolveGroupBoundElements(by, false);
            this.resolveColumnBoundElements(by);
            this.scriptlet.callBeforeColumnInit();
            this.calculator.initializeVariables((byte)3);
            this.scriptlet.callAfterColumnInit();
            ++this.columnIndex;
            this.offsetX = this.leftMargin + this.columnIndex * (this.columnSpacing + this.columnWidth);
            this.offsetY = this.columnHeaderOffsetY;
            this.setColumnNumberVar();
            this.fillColumnHeader(by2);
        }
    }

    protected void fillPageBand(JRFillBand jRFillBand, byte by) throws JRException {
        jRFillBand.evaluate(by);
        JRPrintBand jRPrintBand = jRFillBand.fill(this.columnFooterOffsetY - this.offsetY - jRFillBand.getHeight());
        if (jRFillBand.willOverflow() && !jRFillBand.isSplitAllowed()) {
            this.fillPageBreak(false, by, by, true);
            jRPrintBand = jRFillBand.refill(this.columnFooterOffsetY - this.offsetY - jRFillBand.getHeight());
        }
        this.fillBand(jRPrintBand);
        this.offsetY += jRPrintBand.getHeight();
        while (jRFillBand.willOverflow()) {
            this.fillPageBreak(false, by, by, true);
            jRPrintBand = jRFillBand.fill(this.columnFooterOffsetY - this.offsetY - jRFillBand.getHeight());
            this.fillBand(jRPrintBand);
            this.offsetY += jRPrintBand.getHeight();
        }
        this.resolveBandBoundElements(jRFillBand, by);
    }

    protected void fillColumnBand(JRFillBand jRFillBand, byte by) throws JRException {
        jRFillBand.evaluate(by);
        JRPrintBand jRPrintBand = jRFillBand.fill(this.columnFooterOffsetY - this.offsetY - jRFillBand.getHeight());
        if (jRFillBand.willOverflow() && !jRFillBand.isSplitAllowed()) {
            this.fillColumnBreak(by, by);
            jRPrintBand = jRFillBand.refill(this.columnFooterOffsetY - this.offsetY - jRFillBand.getHeight());
        }
        this.fillBand(jRPrintBand);
        this.offsetY += jRPrintBand.getHeight();
        while (jRFillBand.willOverflow()) {
            this.fillColumnBreak(by, by);
            jRPrintBand = jRFillBand.fill(this.columnFooterOffsetY - this.offsetY - jRFillBand.getHeight());
            this.fillBand(jRPrintBand);
            this.offsetY += jRPrintBand.getHeight();
        }
        this.resolveBandBoundElements(jRFillBand, by);
    }

    protected void fillFixedBand(JRFillBand jRFillBand, byte by) throws JRException {
        jRFillBand.evaluate(by);
        JRPrintBand jRPrintBand = jRFillBand.fill();
        this.fillBand(jRPrintBand);
        this.offsetY += jRPrintBand.getHeight();
        this.resolveBandBoundElements(jRFillBand, by);
    }

    protected void fillBand(JRPrintBand jRPrintBand) {
        List list = jRPrintBand.getElements();
        if (list != null && list.size() > 0) {
            JRPrintElement jRPrintElement = null;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                jRPrintElement = (JRPrintElement)iterator.next();
                jRPrintElement.setX(jRPrintElement.getX() + this.offsetX);
                jRPrintElement.setY(jRPrintElement.getY() + this.offsetY);
                this.printPage.addElement(jRPrintElement);
            }
        }
    }

    private void setNewPageColumnInBands() {
        this.title.setNewPageColumn(true);
        this.pageHeader.setNewPageColumn(true);
        this.columnHeader.setNewPageColumn(true);
        this.detail.setNewPageColumn(true);
        this.columnFooter.setNewPageColumn(true);
        this.pageFooter.setNewPageColumn(true);
        this.lastPageFooter.setNewPageColumn(true);
        this.summary.setNewPageColumn(true);
        if (this.groups != null && this.groups.length > 0) {
            for (int i = 0; i < this.groups.length; ++i) {
                ((JRFillBand)this.groups[i].getGroupHeader()).setNewPageColumn(true);
                ((JRFillBand)this.groups[i].getGroupFooter()).setNewPageColumn(true);
            }
        }
    }

    private void setNewGroupInBands(JRGroup jRGroup) {
        this.title.setNewGroup(jRGroup, true);
        this.pageHeader.setNewGroup(jRGroup, true);
        this.columnHeader.setNewGroup(jRGroup, true);
        this.detail.setNewGroup(jRGroup, true);
        this.columnFooter.setNewGroup(jRGroup, true);
        this.pageFooter.setNewGroup(jRGroup, true);
        this.lastPageFooter.setNewGroup(jRGroup, true);
        this.summary.setNewGroup(jRGroup, true);
        if (this.groups != null && this.groups.length > 0) {
            for (int i = 0; i < this.groups.length; ++i) {
                ((JRFillBand)this.groups[i].getGroupHeader()).setNewGroup(jRGroup, true);
                ((JRFillBand)this.groups[i].getGroupFooter()).setNewGroup(jRGroup, true);
            }
        }
    }

    private JRFillBand getCurrentPageFooter() {
        return this.isLastPageFooter ? this.lastPageFooter : this.pageFooter;
    }

    private void setLastPageFooter(boolean bl) {
        this.isLastPageFooter = bl;
        if (bl) {
            this.columnFooterOffsetY = this.lastPageColumnFooterOffsetY;
        }
    }
}

