/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.awt.Color;
import java.awt.font.TextAttribute;
import java.text.AttributedString;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.engine.JRBox;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRReportFont;
import net.sf.jasperreports.engine.JRTextElement;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JRFillCloneFactory;
import net.sf.jasperreports.engine.fill.JRFillElement;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.fill.TextMeasurer;
import net.sf.jasperreports.engine.util.JRFontUtil;
import net.sf.jasperreports.engine.util.JRStyledText;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.SAXException;

public abstract class JRFillTextElement
extends JRFillElement
implements JRTextElement {
    private static final Log log = LogFactory.getLog((Class)(class$net$sf$jasperreports$engine$fill$JRFillTextElement == null ? (class$net$sf$jasperreports$engine$fill$JRFillTextElement = JRFillTextElement.class$("net.sf.jasperreports.engine.fill.JRFillTextElement")) : class$net$sf$jasperreports$engine$fill$JRFillTextElement));
    private boolean isLeftToRight = true;
    private TextMeasurer textMeasurer = null;
    private float lineSpacingFactor = 0.0f;
    private float leadingOffset = 0.0f;
    private float textHeight = 0.0f;
    private int textStart = 0;
    private int textEnd = 0;
    private String rawText = null;
    private JRStyledText styledText = null;
    private Map styledTextAttributes = null;
    protected TextChopper textChopper = null;
    protected final JRReportFont reportFont;
    private static TextChopper simpleTextChopper = new TextChopper(){

        public String chop(JRFillTextElement jRFillTextElement, int n, int n2) {
            return jRFillTextElement.getStyledText().getText().substring(n, n2);
        }
    };
    private static TextChopper styledTextChopper = new TextChopper(){

        public String chop(JRFillTextElement jRFillTextElement, int n, int n2) {
            return jRFillTextElement.filler.getStyledTextParser().write(jRFillTextElement.getStyledTextAttributes(), new AttributedString(jRFillTextElement.getStyledText().getAttributedString().getIterator(), n, n2).getIterator(), jRFillTextElement.getText().substring(n, n2));
        }
    };
    static /* synthetic */ Class class$net$sf$jasperreports$engine$fill$JRFillTextElement;

    protected JRFillTextElement(JRBaseFiller jRBaseFiller, JRTextElement jRTextElement, JRFillObjectFactory jRFillObjectFactory) {
        super(jRBaseFiller, jRTextElement, jRFillObjectFactory);
        this.reportFont = jRFillObjectFactory.getReportFont(jRTextElement.getReportFont());
        this.createTextMeasurer();
        this.createTextChopper();
    }

    protected JRFillTextElement(JRFillTextElement jRFillTextElement, JRFillCloneFactory jRFillCloneFactory) {
        super(jRFillTextElement, jRFillCloneFactory);
        this.reportFont = jRFillTextElement.reportFont;
        this.createTextMeasurer();
        this.createTextChopper();
    }

    private void createTextMeasurer() {
        this.textMeasurer = new TextMeasurer(this);
    }

    private void createTextChopper() {
        this.textChopper = this.isStyledText() ? styledTextChopper : simpleTextChopper;
    }

    public byte getTextAlignment() {
        return ((JRTextElement)this.parent).getHorizontalAlignment();
    }

    public void setTextAlignment(byte by) {
    }

    public byte getHorizontalAlignment() {
        return ((JRTextElement)this.parent).getHorizontalAlignment();
    }

    public Byte getOwnHorizontalAlignment() {
        return ((JRTextElement)this.parent).getOwnHorizontalAlignment();
    }

    public void setHorizontalAlignment(byte by) {
    }

    public void setHorizontalAlignment(Byte by) {
    }

    public byte getVerticalAlignment() {
        return ((JRTextElement)this.parent).getVerticalAlignment();
    }

    public Byte getOwnVerticalAlignment() {
        return ((JRTextElement)this.parent).getOwnVerticalAlignment();
    }

    public void setVerticalAlignment(byte by) {
    }

    public void setVerticalAlignment(Byte by) {
    }

    public byte getRotation() {
        return ((JRTextElement)this.parent).getRotation();
    }

    public Byte getOwnRotation() {
        return ((JRTextElement)this.parent).getOwnRotation();
    }

    public void setRotation(byte by) {
    }

    public void setRotation(Byte by) {
    }

    public byte getLineSpacing() {
        return ((JRTextElement)this.parent).getLineSpacing();
    }

    public Byte getOwnLineSpacing() {
        return ((JRTextElement)this.parent).getOwnLineSpacing();
    }

    public void setLineSpacing(byte by) {
    }

    public void setLineSpacing(Byte by) {
    }

    public boolean isStyledText() {
        return ((JRTextElement)this.parent).isStyledText();
    }

    public Boolean isOwnStyledText() {
        return ((JRTextElement)this.parent).isOwnStyledText();
    }

    public void setStyledText(boolean bl) {
    }

    public void setStyledText(Boolean bl) {
    }

    public JRBox getBox() {
        return this;
    }

    public JRFont getFont() {
        return this;
    }

    protected Map getStyledTextAttributes() {
        if (this.styledTextAttributes == null) {
            this.styledTextAttributes = new HashMap();
            JRFontUtil.setAttributes(this.styledTextAttributes, (JRTextElement)this.parent);
            this.styledTextAttributes.put(TextAttribute.FOREGROUND, this.parent.getForecolor());
            if (this.parent.getMode() == 1) {
                this.styledTextAttributes.put(TextAttribute.BACKGROUND, this.parent.getBackcolor());
            }
        }
        return this.styledTextAttributes;
    }

    protected float getLineSpacingFactor() {
        return this.lineSpacingFactor;
    }

    protected void setLineSpacingFactor(float f) {
        this.lineSpacingFactor = f;
    }

    protected float getLeadingOffset() {
        return this.leadingOffset;
    }

    protected void setLeadingOffset(float f) {
        this.leadingOffset = f;
    }

    protected byte getRunDirection() {
        return this.isLeftToRight ? (byte)0 : 1;
    }

    protected float getTextHeight() {
        return this.textHeight;
    }

    protected void setTextHeight(float f) {
        this.textHeight = f;
    }

    protected int getTextStart() {
        return this.textStart;
    }

    protected void setTextStart(int n) {
        this.textStart = n;
    }

    protected int getTextEnd() {
        return this.textEnd;
    }

    protected void setTextEnd(int n) {
        this.textEnd = n;
    }

    protected String getRawText() {
        return this.rawText;
    }

    protected void setRawText(String string) {
        this.rawText = string;
        this.styledText = null;
    }

    protected void reset() {
        super.reset();
        this.isLeftToRight = true;
        this.lineSpacingFactor = 0.0f;
        this.leadingOffset = 0.0f;
        this.textHeight = 0.0f;
    }

    protected void rewind() {
        this.textStart = 0;
        this.textEnd = 0;
    }

    protected JRStyledText getStyledText() {
        String string;
        if (this.styledText == null && (string = this.getRawText()) != null) {
            block5: {
                if (this.isStyledText()) {
                    try {
                        this.styledText = this.filler.getStyledTextParser().parse(this.getStyledTextAttributes(), string);
                    }
                    catch (SAXException sAXException) {
                        if (!log.isWarnEnabled()) break block5;
                        log.warn((Object)"Invalid styled text.", (Throwable)sAXException);
                    }
                }
            }
            if (this.styledText == null) {
                this.styledText = new JRStyledText();
                this.styledText.append(string);
                this.styledText.addRun(new JRStyledText.Run(this.getStyledTextAttributes(), 0, string.length()));
            }
        }
        return this.styledText;
    }

    public String getText() {
        JRStyledText jRStyledText = this.getStyledText();
        if (jRStyledText == null) {
            return null;
        }
        return jRStyledText.getText();
    }

    protected void chopTextElement(int n) {
        JRStyledText jRStyledText = this.getStyledText();
        if (jRStyledText == null) {
            return;
        }
        String string = this.getText().substring(this.getTextEnd());
        if (string.length() == 0) {
            return;
        }
        this.textMeasurer.measure(jRStyledText, string, this.getTextEnd(), n);
        this.isLeftToRight = this.textMeasurer.isLeftToRight();
        this.setTextHeight(this.textMeasurer.getTextHeight());
        if (this.getRotation() == 0) {
            this.setStretchHeight((int)this.getTextHeight() + this.getTopPadding() + this.getBottomPadding());
        } else {
            this.setStretchHeight(this.getHeight());
        }
        this.setTextStart(this.getTextEnd());
        this.setTextEnd(this.textMeasurer.getTextOffset());
        this.setLineSpacingFactor(this.textMeasurer.getLineSpacingFactor());
        this.setLeadingOffset(this.textMeasurer.getLeadingOffset());
    }

    public byte getBorder() {
        return ((JRBox)((Object)this.parent)).getBorder();
    }

    public Byte getOwnBorder() {
        return ((JRBox)((Object)this.parent)).getOwnBorder();
    }

    public void setBorder(byte by) {
    }

    public Color getBorderColor() {
        return ((JRBox)((Object)this.parent)).getBorderColor();
    }

    public Color getOwnBorderColor() {
        return ((JRBox)((Object)this.parent)).getOwnBorderColor();
    }

    public void setBorderColor(Color color) {
    }

    public int getPadding() {
        return ((JRBox)((Object)this.parent)).getPadding();
    }

    public Integer getOwnPadding() {
        return ((JRBox)((Object)this.parent)).getOwnPadding();
    }

    public void setPadding(int n) {
    }

    public byte getTopBorder() {
        return ((JRBox)((Object)this.parent)).getTopBorder();
    }

    public Byte getOwnTopBorder() {
        return ((JRBox)((Object)this.parent)).getOwnTopBorder();
    }

    public void setTopBorder(byte by) {
    }

    public Color getTopBorderColor() {
        return ((JRBox)((Object)this.parent)).getTopBorderColor();
    }

    public Color getOwnTopBorderColor() {
        return ((JRBox)((Object)this.parent)).getOwnTopBorderColor();
    }

    public void setTopBorderColor(Color color) {
    }

    public int getTopPadding() {
        return ((JRBox)((Object)this.parent)).getTopPadding();
    }

    public Integer getOwnTopPadding() {
        return ((JRBox)((Object)this.parent)).getOwnTopPadding();
    }

    public void setTopPadding(int n) {
    }

    public byte getLeftBorder() {
        return ((JRBox)((Object)this.parent)).getLeftBorder();
    }

    public Byte getOwnLeftBorder() {
        return ((JRBox)((Object)this.parent)).getOwnLeftBorder();
    }

    public void setLeftBorder(byte by) {
    }

    public Color getLeftBorderColor() {
        return ((JRBox)((Object)this.parent)).getLeftBorderColor();
    }

    public Color getOwnLeftBorderColor() {
        return ((JRBox)((Object)this.parent)).getOwnLeftBorderColor();
    }

    public void setLeftBorderColor(Color color) {
    }

    public int getLeftPadding() {
        return ((JRBox)((Object)this.parent)).getLeftPadding();
    }

    public Integer getOwnLeftPadding() {
        return ((JRBox)((Object)this.parent)).getOwnLeftPadding();
    }

    public void setLeftPadding(int n) {
    }

    public byte getBottomBorder() {
        return ((JRBox)((Object)this.parent)).getBottomBorder();
    }

    public Byte getOwnBottomBorder() {
        return ((JRBox)((Object)this.parent)).getOwnBottomBorder();
    }

    public void setBottomBorder(byte by) {
    }

    public Color getBottomBorderColor() {
        return ((JRBox)((Object)this.parent)).getBottomBorderColor();
    }

    public Color getOwnBottomBorderColor() {
        return ((JRBox)((Object)this.parent)).getOwnBottomBorderColor();
    }

    public void setBottomBorderColor(Color color) {
    }

    public int getBottomPadding() {
        return ((JRBox)((Object)this.parent)).getBottomPadding();
    }

    public Integer getOwnBottomPadding() {
        return ((JRBox)((Object)this.parent)).getOwnBottomPadding();
    }

    public void setBottomPadding(int n) {
    }

    public byte getRightBorder() {
        return ((JRBox)((Object)this.parent)).getRightBorder();
    }

    public Byte getOwnRightBorder() {
        return ((JRBox)((Object)this.parent)).getOwnRightBorder();
    }

    public void setRightBorder(byte by) {
    }

    public Color getRightBorderColor() {
        return ((JRBox)((Object)this.parent)).getRightBorderColor();
    }

    public Color getOwnRightBorderColor() {
        return ((JRBox)((Object)this.parent)).getOwnRightBorderColor();
    }

    public void setRightBorderColor(Color color) {
    }

    public int getRightPadding() {
        return ((JRBox)((Object)this.parent)).getRightPadding();
    }

    public Integer getOwnRightPadding() {
        return ((JRBox)((Object)this.parent)).getOwnRightPadding();
    }

    public void setRightPadding(int n) {
    }

    public JRReportFont getReportFont() {
        return this.reportFont;
    }

    public void setReportFont(JRReportFont jRReportFont) {
    }

    public String getFontName() {
        return ((JRFont)((Object)this.parent)).getFontName();
    }

    public String getOwnFontName() {
        return ((JRFont)((Object)this.parent)).getOwnFontName();
    }

    public void setFontName(String string) {
    }

    public boolean isBold() {
        return ((JRFont)((Object)this.parent)).isBold();
    }

    public Boolean isOwnBold() {
        return ((JRFont)((Object)this.parent)).isOwnBold();
    }

    public void setBold(boolean bl) {
    }

    public void setBold(Boolean bl) {
    }

    public boolean isItalic() {
        return ((JRFont)((Object)this.parent)).isItalic();
    }

    public Boolean isOwnItalic() {
        return ((JRFont)((Object)this.parent)).isOwnItalic();
    }

    public void setItalic(boolean bl) {
    }

    public void setItalic(Boolean bl) {
    }

    public boolean isUnderline() {
        return ((JRFont)((Object)this.parent)).isUnderline();
    }

    public Boolean isOwnUnderline() {
        return ((JRFont)((Object)this.parent)).isOwnUnderline();
    }

    public void setUnderline(boolean bl) {
    }

    public void setUnderline(Boolean bl) {
    }

    public boolean isStrikeThrough() {
        return ((JRFont)((Object)this.parent)).isStrikeThrough();
    }

    public Boolean isOwnStrikeThrough() {
        return ((JRFont)((Object)this.parent)).isOwnStrikeThrough();
    }

    public void setStrikeThrough(boolean bl) {
    }

    public void setStrikeThrough(Boolean bl) {
    }

    public int getFontSize() {
        return ((JRFont)((Object)this.parent)).getFontSize();
    }

    public Integer getOwnFontSize() {
        return ((JRFont)((Object)this.parent)).getOwnFontSize();
    }

    public void setFontSize(int n) {
    }

    public void setFontSize(Integer n) {
    }

    public int getSize() {
        return this.getFontSize();
    }

    public Integer getOwnSize() {
        return this.getOwnFontSize();
    }

    public void setSize(int n) {
    }

    public void setSize(Integer n) {
    }

    public String getPdfFontName() {
        return ((JRFont)((Object)this.parent)).getPdfFontName();
    }

    public String getOwnPdfFontName() {
        return ((JRFont)((Object)this.parent)).getOwnPdfFontName();
    }

    public void setPdfFontName(String string) {
    }

    public String getPdfEncoding() {
        return ((JRFont)((Object)this.parent)).getPdfEncoding();
    }

    public String getOwnPdfEncoding() {
        return ((JRFont)((Object)this.parent)).getOwnPdfEncoding();
    }

    public void setPdfEncoding(String string) {
    }

    public boolean isPdfEmbedded() {
        return ((JRFont)((Object)this.parent)).isPdfEmbedded();
    }

    public Boolean isOwnPdfEmbedded() {
        return ((JRFont)((Object)this.parent)).isOwnPdfEmbedded();
    }

    public void setPdfEmbedded(boolean bl) {
        this.setPdfEmbedded(bl ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setPdfEmbedded(Boolean bl) {
    }

    public void setBorder(Byte by) {
    }

    public void setPadding(Integer n) {
    }

    public void setTopBorder(Byte by) {
    }

    public void setTopPadding(Integer n) {
    }

    public void setLeftBorder(Byte by) {
    }

    public void setLeftPadding(Integer n) {
    }

    public void setBottomBorder(Byte by) {
    }

    public void setBottomPadding(Integer n) {
    }

    public void setRightBorder(Byte by) {
    }

    public void setRightPadding(Integer n) {
    }

    public void setHeight(int n) {
        super.setHeight(n);
        this.createTextMeasurer();
    }

    public void setWidth(int n) {
        super.setWidth(n);
        this.createTextMeasurer();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected static interface TextChopper {
        public String chop(JRFillTextElement var1, int var2, int var3);
    }
}

