/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.awt.Color;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRAbstractObjectFactory;
import net.sf.jasperreports.engine.JRChild;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRFrame;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.base.JRBaseBox;
import net.sf.jasperreports.engine.base.JRBaseElementGroup;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JRCloneable;
import net.sf.jasperreports.engine.fill.JRFillCloneFactory;
import net.sf.jasperreports.engine.fill.JRFillElement;
import net.sf.jasperreports.engine.fill.JRFillElementContainer;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.fill.JRTemplateFrame;
import net.sf.jasperreports.engine.fill.JRTemplatePrintFrame;
import net.sf.jasperreports.engine.xml.JRXmlWriter;

public class JRFillFrame
extends JRFillElement
implements JRFrame {
    protected final JRFrame parentFrame;
    private JRFillFrameElements frameContainer;
    private Map bottomTemplateFrames;
    private Map topTemplateFrames;
    private Map topBottomTemplateFrames;
    private boolean first;
    private boolean fillBottomBorder;
    private boolean filling;

    public JRFillFrame(JRBaseFiller jRBaseFiller, JRFrame jRFrame, JRFillObjectFactory jRFillObjectFactory) {
        super(jRBaseFiller, jRFrame, jRFillObjectFactory);
        this.parentFrame = jRFrame;
        this.frameContainer = new JRFillFrameElements(jRFillObjectFactory);
        this.bottomTemplateFrames = new HashMap();
        this.topTemplateFrames = new HashMap();
        this.topBottomTemplateFrames = new HashMap();
        this.setShrinkable(true);
    }

    protected JRFillFrame(JRFillFrame jRFillFrame, JRFillCloneFactory jRFillCloneFactory) {
        super(jRFillFrame, jRFillCloneFactory);
        this.parentFrame = jRFillFrame.parentFrame;
        this.frameContainer = new JRFillFrameElements(jRFillFrame.frameContainer, jRFillCloneFactory);
        this.bottomTemplateFrames = jRFillFrame.bottomTemplateFrames;
        this.topTemplateFrames = jRFillFrame.topTemplateFrames;
        this.topBottomTemplateFrames = jRFillFrame.topBottomTemplateFrames;
    }

    protected void evaluate(byte by) throws JRException {
        this.reset();
        this.evaluatePrintWhenExpression(by);
        if (this.isPrintWhenExpressionNull() || this.isPrintWhenTrue()) {
            this.frameContainer.evaluate(by);
            boolean bl = true;
            JRFillElement[] jRFillElementArray = (JRFillElement[])this.getElements();
            for (int i = 0; bl && i < jRFillElementArray.length; bl &= jRFillElementArray[i].isValueRepeating(), ++i) {
            }
            this.setValueRepeating(bl);
        }
        this.filling = false;
    }

    protected void rewind() throws JRException {
        this.frameContainer.rewind();
        this.filling = false;
    }

    protected boolean prepare(int n, boolean bl) throws JRException {
        super.prepare(n, bl);
        if (!this.isToPrint()) {
            return false;
        }
        this.first = !bl || !this.filling;
        int n2 = this.first ? this.getTopPadding() : 0;
        int n3 = this.getBottomPadding();
        if (n < this.getRelativeY() - this.getY() - this.getBandBottomY() - n2) {
            this.setToPrint(false);
            return true;
        }
        if (!(this.filling || this.isPrintRepeatedValues() || !this.isValueRepeating() || this.isPrintInFirstWholeBand() && this.getBand().isFirstWholeOnPageColumn() || this.getPrintWhenGroupChanges() != null && this.getBand().isNewGroup(this.getPrintWhenGroupChanges()) || bl && this.isPrintWhenDetailOverflows())) {
            this.setToPrint(false);
            return false;
        }
        if (!this.filling && bl && this.isAlreadyPrinted()) {
            if (this.isPrintWhenDetailOverflows()) {
                this.rewind();
                this.setReprinted(true);
            } else {
                this.setToPrint(false);
                return false;
            }
        }
        int n4 = n - this.getRelativeY() + this.getY() + this.getBandBottomY();
        this.frameContainer.initFill();
        this.frameContainer.resetElements();
        this.frameContainer.prepareElements(n4 + n3, true);
        boolean bl2 = this.frameContainer.willOverflow();
        if (bl2) {
            this.setStretchHeight(this.getHeight() + n4);
            this.fillBottomBorder = false;
        } else {
            int n5 = this.frameContainer.getStretchHeight() - this.frameContainer.getFirstY() + n2 + n3;
            if (n5 <= this.getHeight() + n4) {
                this.setStretchHeight(n5);
                this.fillBottomBorder = true;
            } else {
                this.setStretchHeight(this.getHeight() + n4);
                this.fillBottomBorder = false;
            }
        }
        this.filling = bl2;
        return bl2;
    }

    protected void setStretchHeight(int n) {
        super.setStretchHeight(n);
        int n2 = this.first ? this.getTopPadding() : 0;
        int n3 = this.getBottomPadding();
        this.frameContainer.setStretchHeight(n + this.frameContainer.getFirstY() - n2 - n3);
    }

    protected void stretchHeightFinal() {
        this.frameContainer.stretchElements();
        this.frameContainer.moveBandBottomElements();
        this.frameContainer.removeBlankElements();
        int n = this.first ? this.getTopPadding() : 0;
        int n2 = this.getBottomPadding();
        super.setStretchHeight(this.frameContainer.getStretchHeight() - this.frameContainer.getFirstY() + n + n2);
    }

    protected JRPrintElement fill() throws JRException {
        JRTemplatePrintFrame jRTemplatePrintFrame = new JRTemplatePrintFrame(this.getTemplate());
        jRTemplatePrintFrame.setX(this.getX());
        jRTemplatePrintFrame.setY(this.getRelativeY());
        jRTemplatePrintFrame.setWidth(this.getWidth());
        this.frameContainer.fillElements(jRTemplatePrintFrame);
        jRTemplatePrintFrame.setHeight(this.getStretchHeight());
        return jRTemplatePrintFrame;
    }

    protected JRTemplateFrame getTemplate() {
        JRStyle jRStyle = this.getElementStyle();
        Map map = this.first ? (this.fillBottomBorder ? this.templates : this.bottomTemplateFrames) : (this.fillBottomBorder ? this.topTemplateFrames : this.topBottomTemplateFrames);
        JRTemplateFrame jRTemplateFrame = (JRTemplateFrame)map.get(jRStyle);
        if (jRTemplateFrame == null) {
            jRTemplateFrame = new JRTemplateFrame(this.filler.getJasperPrint().getDefaultStyleProvider(), this, jRStyle);
            if (this.first) {
                if (!this.fillBottomBorder) {
                    JRBaseBox jRBaseBox = new JRBaseBox(this, false, false, false, true);
                    jRTemplateFrame.setBox(jRBaseBox);
                }
            } else if (this.fillBottomBorder) {
                JRBaseBox jRBaseBox = new JRBaseBox(this, false, false, true, false);
                jRTemplateFrame.setBox(jRBaseBox);
            } else {
                JRBaseBox jRBaseBox = new JRBaseBox(this, false, false, true, true);
                jRTemplateFrame.setBox(jRBaseBox);
            }
            map.put(jRStyle, jRTemplateFrame);
        }
        return jRTemplateFrame;
    }

    protected void resolveElement(JRPrintElement jRPrintElement, byte by) {
    }

    public JRElement[] getElements() {
        return this.frameContainer.getElements();
    }

    public List getChildren() {
        return this.frameContainer.getChildren();
    }

    public void collectExpressions(JRExpressionCollector jRExpressionCollector) {
        jRExpressionCollector.collect(this);
    }

    public JRChild getCopy(JRAbstractObjectFactory jRAbstractObjectFactory) {
        return jRAbstractObjectFactory.getFrame(this);
    }

    public void writeXml(JRXmlWriter jRXmlWriter) throws IOException {
        jRXmlWriter.writeFrame(this);
    }

    public JRElement getElementByKey(String string) {
        return JRBaseElementGroup.getElementByKey(this.getElements(), string);
    }

    public JRCloneable createClone(JRFillCloneFactory jRFillCloneFactory) {
        return new JRFillFrame(this, jRFillCloneFactory);
    }

    public byte getBorder() {
        return this.parentFrame.getBorder();
    }

    public Byte getOwnBorder() {
        return this.parentFrame.getOwnBorder();
    }

    public void setBorder(byte by) {
    }

    public Color getBorderColor() {
        return this.parentFrame.getBorderColor();
    }

    public Color getOwnBorderColor() {
        return this.parentFrame.getOwnBorderColor();
    }

    public void setBorderColor(Color color) {
    }

    public int getPadding() {
        return this.parentFrame.getPadding();
    }

    public Integer getOwnPadding() {
        return this.parentFrame.getOwnPadding();
    }

    public void setPadding(int n) {
    }

    public byte getTopBorder() {
        return this.parentFrame.getTopBorder();
    }

    public Byte getOwnTopBorder() {
        return this.parentFrame.getOwnTopBorder();
    }

    public void setTopBorder(byte by) {
    }

    public Color getTopBorderColor() {
        return this.parentFrame.getTopBorderColor();
    }

    public Color getOwnTopBorderColor() {
        return this.parentFrame.getOwnTopBorderColor();
    }

    public void setTopBorderColor(Color color) {
    }

    public int getTopPadding() {
        return this.parentFrame.getTopPadding();
    }

    public Integer getOwnTopPadding() {
        return this.parentFrame.getOwnTopPadding();
    }

    public void setTopPadding(int n) {
    }

    public byte getLeftBorder() {
        return this.parentFrame.getLeftBorder();
    }

    public Byte getOwnLeftBorder() {
        return this.parentFrame.getOwnLeftBorder();
    }

    public void setLeftBorder(byte by) {
    }

    public Color getLeftBorderColor() {
        return this.parentFrame.getLeftBorderColor();
    }

    public Color getOwnLeftBorderColor() {
        return this.parentFrame.getOwnLeftBorderColor();
    }

    public void setLeftBorderColor(Color color) {
    }

    public int getLeftPadding() {
        return this.parentFrame.getLeftPadding();
    }

    public Integer getOwnLeftPadding() {
        return this.parentFrame.getOwnLeftPadding();
    }

    public void setLeftPadding(int n) {
    }

    public byte getBottomBorder() {
        return this.parentFrame.getBottomBorder();
    }

    public Byte getOwnBottomBorder() {
        return this.parentFrame.getOwnBottomBorder();
    }

    public void setBottomBorder(byte by) {
    }

    public Color getBottomBorderColor() {
        return this.parentFrame.getBottomBorderColor();
    }

    public Color getOwnBottomBorderColor() {
        return this.parentFrame.getOwnBottomBorderColor();
    }

    public void setBottomBorderColor(Color color) {
    }

    public int getBottomPadding() {
        return this.parentFrame.getBottomPadding();
    }

    public Integer getOwnBottomPadding() {
        return this.parentFrame.getOwnBottomPadding();
    }

    public void setBottomPadding(int n) {
    }

    public byte getRightBorder() {
        return this.parentFrame.getRightBorder();
    }

    public Byte getOwnRightBorder() {
        return this.parentFrame.getOwnRightBorder();
    }

    public void setRightBorder(byte by) {
    }

    public Color getRightBorderColor() {
        return this.parentFrame.getRightBorderColor();
    }

    public Color getOwnRightBorderColor() {
        return this.parentFrame.getOwnRightBorderColor();
    }

    public void setRightBorderColor(Color color) {
    }

    public int getRightPadding() {
        return this.parentFrame.getRightPadding();
    }

    public Integer getOwnRightPadding() {
        return this.parentFrame.getOwnRightPadding();
    }

    public void setRightPadding(int n) {
    }

    public void setBorder(Byte by) {
    }

    public void setPadding(Integer n) {
    }

    public void setTopBorder(Byte by) {
    }

    public void setTopPadding(Integer n) {
    }

    public void setLeftBorder(Byte by) {
    }

    public void setLeftPadding(Integer n) {
    }

    public void setBottomBorder(Byte by) {
    }

    public void setBottomPadding(Integer n) {
    }

    public void setRightBorder(Byte by) {
    }

    public void setRightPadding(Integer n) {
    }

    protected class JRFillFrameElements
    extends JRFillElementContainer {
        JRFillFrameElements(JRFillObjectFactory jRFillObjectFactory) {
            super(JRFillFrame.this.filler, JRFillFrame.this.parentFrame, jRFillObjectFactory);
            this.initElements();
        }

        JRFillFrameElements(JRFillFrameElements jRFillFrameElements, JRFillCloneFactory jRFillCloneFactory) {
            super(jRFillFrameElements, jRFillCloneFactory);
            this.initElements();
        }

        protected int getContainerHeight() {
            return JRFillFrame.this.getHeight() - JRFillFrame.this.getTopPadding() - JRFillFrame.this.getBottomPadding();
        }
    }
}

