/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import net.sf.jasperreports.engine.JRDatasetRun;
import net.sf.jasperreports.engine.JRElementDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JRCalculator;
import net.sf.jasperreports.engine.fill.JRExpressionEvalException;
import net.sf.jasperreports.engine.fill.JRFillDataset;
import net.sf.jasperreports.engine.fill.JRFillDatasetRun;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;

public abstract class JRFillElementDataset
implements JRElementDataset {
    protected JRElementDataset parent = null;
    private final JRBaseFiller filler;
    protected JRGroup resetGroup = null;
    protected JRGroup incrementGroup = null;
    private boolean isIncremented = true;
    protected JRFillDatasetRun datasetRun;

    protected JRFillElementDataset(JRElementDataset jRElementDataset, JRFillObjectFactory jRFillObjectFactory) {
        jRFillObjectFactory.put(jRElementDataset, this);
        this.parent = jRElementDataset;
        this.filler = jRFillObjectFactory.getFiller();
        this.resetGroup = jRFillObjectFactory.getGroup(jRElementDataset.getResetGroup());
        this.incrementGroup = jRFillObjectFactory.getGroup(jRElementDataset.getIncrementGroup());
        this.datasetRun = jRFillObjectFactory.getDatasetRun(jRElementDataset.getDatasetRun());
    }

    public byte getResetType() {
        return this.parent.getResetType();
    }

    public byte getIncrementType() {
        return this.parent.getIncrementType();
    }

    public JRGroup getResetGroup() {
        return this.resetGroup;
    }

    public JRGroup getIncrementGroup() {
        return this.incrementGroup;
    }

    protected void initialize() {
        this.customInitialize();
        this.isIncremented = false;
    }

    protected void evaluate(JRCalculator jRCalculator) throws JRExpressionEvalException {
        this.customEvaluate(jRCalculator);
        this.isIncremented = false;
    }

    protected void increment() {
        if (!this.isIncremented) {
            this.customIncrement();
        }
        this.isIncremented = true;
    }

    protected abstract void customInitialize();

    protected abstract void customEvaluate(JRCalculator var1) throws JRExpressionEvalException;

    protected abstract void customIncrement();

    public JRDatasetRun getDatasetRun() {
        return this.datasetRun;
    }

    public void evaluateDatasetRun(byte by) throws JRException {
        if (this.datasetRun != null) {
            this.datasetRun.evaluate(this, by);
        }
    }

    public JRFillDataset getInputDataset() {
        JRFillDataset jRFillDataset = this.datasetRun != null ? this.datasetRun.getDataset() : this.filler.mainDataset;
        return jRFillDataset;
    }
}

