/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.sql.Connection;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRDatasetParameter;
import net.sf.jasperreports.engine.JRDatasetRun;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRQuery;
import net.sf.jasperreports.engine.JRScriptletException;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JRFillDataset;
import net.sf.jasperreports.engine.fill.JRFillElementDataset;
import net.sf.jasperreports.engine.fill.JRFillInterruptedException;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.fill.JRFillParameter;
import net.sf.jasperreports.engine.fill.JRFillSubreport;

public class JRFillDatasetRun
implements JRDatasetRun {
    private final JRBaseFiller filler;
    private final JRFillDataset dataset;
    private JRExpression parametersMapExpression;
    private JRDatasetParameter[] parameters;
    private JRExpression connectionExpression;
    private JRExpression dataSourceExpression;

    public JRFillDatasetRun(JRBaseFiller jRBaseFiller, JRDatasetRun jRDatasetRun, JRFillObjectFactory jRFillObjectFactory) {
        jRFillObjectFactory.put(jRDatasetRun, this);
        this.filler = jRBaseFiller;
        this.dataset = (JRFillDataset)jRBaseFiller.datasetMap.get(jRDatasetRun.getDatasetName());
        this.parametersMapExpression = jRDatasetRun.getParametersMapExpression();
        this.parameters = jRDatasetRun.getParameters();
        this.connectionExpression = jRDatasetRun.getConnectionExpression();
        this.dataSourceExpression = jRDatasetRun.getDataSourceExpression();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evaluate(JRFillElementDataset jRFillElementDataset, byte by) throws JRException {
        boolean bl = this.dataset.getResourceBundle() != null;
        Map map = JRFillSubreport.getParameterValues(this.filler, this.parametersMapExpression, this.parameters, by, false, bl);
        try {
            if (this.dataSourceExpression != null) {
                JRDataSource jRDataSource = (JRDataSource)this.filler.evaluateExpression(this.dataSourceExpression, by);
                this.dataset.setDatasourceParameterValue(map, jRDataSource);
            } else if (this.connectionExpression != null) {
                Connection connection = (Connection)this.filler.evaluateExpression(this.connectionExpression, by);
                this.dataset.setConnectionParameterValue(map, connection);
            }
            this.copyConnectionParameter(map);
            this.dataset.setParameterValues(map);
            this.dataset.filterElementDatasets(jRFillElementDataset);
            this.dataset.initCalculator();
            this.iterate();
        }
        finally {
            this.dataset.closeDatasource();
            this.dataset.restoreElementDatasets();
        }
    }

    protected void copyConnectionParameter(Map map) {
        JRQuery jRQuery = this.dataset.getQuery();
        if (jRQuery != null) {
            String string = jRQuery.getLanguage();
            if (this.connectionExpression == null && (string.equals("sql") || string.equals("SQL")) && !map.containsKey("REPORT_CONNECTION")) {
                JRFillParameter jRFillParameter = (JRFillParameter)this.filler.getParametersMap().get("REPORT_CONNECTION");
                Connection connection = (Connection)jRFillParameter.getValue();
                map.put("REPORT_CONNECTION", connection);
            }
        }
    }

    protected void iterate() throws JRException {
        this.dataset.start();
        this.init();
        if (this.dataset.next()) {
            this.detail();
            while (this.dataset.next()) {
                this.checkInterrupted();
                this.group();
                this.detail();
            }
        }
    }

    protected void checkInterrupted() {
        if (Thread.currentThread().isInterrupted() || this.filler.isInterrupted()) {
            this.filler.setInterrupted(true);
            throw new JRFillInterruptedException();
        }
    }

    protected void group() throws JRException, JRScriptletException {
        this.dataset.calculator.estimateGroupRuptures();
        this.dataset.scriptlet.callBeforeGroupInit();
        this.dataset.calculator.initializeVariables((byte)4);
        this.dataset.scriptlet.callAfterGroupInit();
    }

    protected void init() throws JRScriptletException, JRException {
        this.dataset.scriptlet.callBeforeReportInit();
        this.dataset.calculator.initializeVariables((byte)1);
        this.dataset.scriptlet.callAfterReportInit();
    }

    protected void detail() throws JRScriptletException, JRException {
        this.dataset.scriptlet.callBeforeDetailEval();
        this.dataset.calculator.calculateVariables();
        this.dataset.scriptlet.callAfterDetailEval();
    }

    public String getDatasetName() {
        return this.dataset.getName();
    }

    public JRExpression getParametersMapExpression() {
        return this.parametersMapExpression;
    }

    public JRDatasetParameter[] getParameters() {
        return this.parameters;
    }

    public JRExpression getConnectionExpression() {
        return this.connectionExpression;
    }

    public JRExpression getDataSourceExpression() {
        return this.dataSourceExpression;
    }

    protected JRFillDataset getDataset() {
        return this.dataset;
    }
}

