/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.text.AttributedCharacterIterator;
import java.util.Map;
import net.sf.jasperreports.charts.JRAreaPlot;
import net.sf.jasperreports.charts.JRBar3DPlot;
import net.sf.jasperreports.charts.JRBarPlot;
import net.sf.jasperreports.charts.JRBubblePlot;
import net.sf.jasperreports.charts.JRCandlestickPlot;
import net.sf.jasperreports.charts.JRCategoryDataset;
import net.sf.jasperreports.charts.JRHighLowDataset;
import net.sf.jasperreports.charts.JRHighLowPlot;
import net.sf.jasperreports.charts.JRLinePlot;
import net.sf.jasperreports.charts.JRPie3DPlot;
import net.sf.jasperreports.charts.JRPieDataset;
import net.sf.jasperreports.charts.JRPiePlot;
import net.sf.jasperreports.charts.JRScatterPlot;
import net.sf.jasperreports.charts.JRTimePeriodDataset;
import net.sf.jasperreports.charts.JRTimeSeriesDataset;
import net.sf.jasperreports.charts.JRTimeSeriesPlot;
import net.sf.jasperreports.charts.JRXyDataset;
import net.sf.jasperreports.charts.JRXyzDataset;
import net.sf.jasperreports.charts.fill.JRFillBar3DPlot;
import net.sf.jasperreports.charts.fill.JRFillBarPlot;
import net.sf.jasperreports.charts.fill.JRFillBubblePlot;
import net.sf.jasperreports.charts.fill.JRFillCategoryDataset;
import net.sf.jasperreports.charts.fill.JRFillLinePlot;
import net.sf.jasperreports.charts.fill.JRFillPie3DPlot;
import net.sf.jasperreports.charts.fill.JRFillPieDataset;
import net.sf.jasperreports.charts.fill.JRFillTimePeriodDataset;
import net.sf.jasperreports.charts.fill.JRFillTimeSeriesDataset;
import net.sf.jasperreports.charts.fill.JRFillXyDataset;
import net.sf.jasperreports.charts.util.PieLabelGenerator;
import net.sf.jasperreports.engine.JRAbstractChartCustomizer;
import net.sf.jasperreports.engine.JRAbstractObjectFactory;
import net.sf.jasperreports.engine.JRBox;
import net.sf.jasperreports.engine.JRChart;
import net.sf.jasperreports.engine.JRChartCustomizer;
import net.sf.jasperreports.engine.JRChartDataset;
import net.sf.jasperreports.engine.JRChartPlot;
import net.sf.jasperreports.engine.JRChild;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRRenderable;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JRCloneable;
import net.sf.jasperreports.engine.fill.JRFillChartDataset;
import net.sf.jasperreports.engine.fill.JRFillCloneFactory;
import net.sf.jasperreports.engine.fill.JRFillElement;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.fill.JRTemplateImage;
import net.sf.jasperreports.engine.fill.JRTemplatePrintImage;
import net.sf.jasperreports.engine.util.JRClassLoader;
import net.sf.jasperreports.engine.util.JRFontUtil;
import net.sf.jasperreports.engine.xml.JRXmlWriter;
import net.sf.jasperreports.renderers.JCommonDrawableRenderer;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.labels.PieSectionLabelGenerator;
import org.jfree.chart.labels.XYItemLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.PiePlot3D;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.category.BarRenderer3D;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.chart.renderer.category.StackedBarRenderer3D;
import org.jfree.chart.renderer.xy.CandlestickRenderer;
import org.jfree.chart.renderer.xy.HighLowRenderer;
import org.jfree.chart.renderer.xy.XYBubbleRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.title.TextTitle;
import org.jfree.chart.title.Title;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.DefaultHighLowDataset;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.OHLCDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYZDataset;
import org.jfree.ui.Drawable;

public class JRFillChart
extends JRFillElement
implements JRChart {
    private static final Color TRANSPARENT_PAINT = new Color(0, 0, 0, 0);
    protected byte chartType = 0;
    protected JRFont titleFont = null;
    protected JRFont subtitleFont = null;
    protected JRGroup evaluationGroup = null;
    protected JRFillChartDataset dataset = null;
    protected JRChartPlot plot = null;
    protected JRRenderable renderer = null;
    private String anchorName = null;
    private String hyperlinkReference = null;
    private String hyperlinkAnchor = null;
    private Integer hyperlinkPage = null;
    protected String customizerClass;
    protected JRChartCustomizer chartCustomizer;

    protected JRFillChart(JRBaseFiller jRBaseFiller, JRChart jRChart, JRFillObjectFactory jRFillObjectFactory) {
        super(jRBaseFiller, jRChart, jRFillObjectFactory);
        this.chartType = jRChart.getChartType();
        switch (this.chartType) {
            case 1: {
                this.dataset = (JRFillChartDataset)((Object)jRFillObjectFactory.getCategoryDataset((JRCategoryDataset)jRChart.getDataset()));
                this.plot = jRFillObjectFactory.getAreaPlot((JRAreaPlot)jRChart.getPlot());
                break;
            }
            case 3: {
                this.dataset = (JRFillChartDataset)((Object)jRFillObjectFactory.getCategoryDataset((JRCategoryDataset)jRChart.getDataset()));
                this.plot = jRFillObjectFactory.getBarPlot((JRBarPlot)jRChart.getPlot());
                break;
            }
            case 2: {
                this.dataset = (JRFillChartDataset)((Object)jRFillObjectFactory.getCategoryDataset((JRCategoryDataset)jRChart.getDataset()));
                this.plot = jRFillObjectFactory.getBar3DPlot((JRBar3DPlot)jRChart.getPlot());
                break;
            }
            case 4: {
                this.dataset = (JRFillChartDataset)((Object)jRFillObjectFactory.getXyzDataset((JRXyzDataset)jRChart.getDataset()));
                this.plot = jRFillObjectFactory.getBubblePlot((JRBubblePlot)jRChart.getPlot());
                break;
            }
            case 5: {
                this.dataset = (JRFillChartDataset)((Object)jRFillObjectFactory.getHighLowDataset((JRHighLowDataset)jRChart.getDataset()));
                this.plot = jRFillObjectFactory.getCandlestickPlot((JRCandlestickPlot)jRChart.getPlot());
                break;
            }
            case 6: {
                this.dataset = (JRFillChartDataset)((Object)jRFillObjectFactory.getHighLowDataset((JRHighLowDataset)jRChart.getDataset()));
                this.plot = jRFillObjectFactory.getHighLowPlot((JRHighLowPlot)jRChart.getPlot());
                break;
            }
            case 7: {
                this.dataset = (JRFillChartDataset)((Object)jRFillObjectFactory.getCategoryDataset((JRCategoryDataset)jRChart.getDataset()));
                this.plot = jRFillObjectFactory.getLinePlot((JRLinePlot)jRChart.getPlot());
                break;
            }
            case 9: {
                this.dataset = (JRFillChartDataset)((Object)jRFillObjectFactory.getPieDataset((JRPieDataset)jRChart.getDataset()));
                this.plot = jRFillObjectFactory.getPiePlot((JRPiePlot)jRChart.getPlot());
                break;
            }
            case 8: {
                this.dataset = (JRFillChartDataset)((Object)jRFillObjectFactory.getPieDataset((JRPieDataset)jRChart.getDataset()));
                this.plot = jRFillObjectFactory.getPie3DPlot((JRPie3DPlot)jRChart.getPlot());
                break;
            }
            case 10: {
                this.dataset = (JRFillChartDataset)((Object)jRFillObjectFactory.getXyDataset((JRXyDataset)jRChart.getDataset()));
                this.plot = jRFillObjectFactory.getScatterPlot((JRScatterPlot)jRChart.getPlot());
                break;
            }
            case 12: {
                this.dataset = (JRFillChartDataset)((Object)jRFillObjectFactory.getCategoryDataset((JRCategoryDataset)jRChart.getDataset()));
                this.plot = jRFillObjectFactory.getBarPlot((JRBarPlot)jRChart.getPlot());
                break;
            }
            case 11: {
                this.dataset = (JRFillChartDataset)((Object)jRFillObjectFactory.getCategoryDataset((JRCategoryDataset)jRChart.getDataset()));
                this.plot = jRFillObjectFactory.getBar3DPlot((JRBar3DPlot)jRChart.getPlot());
                break;
            }
            case 16: {
                this.dataset = (JRFillChartDataset)((Object)jRFillObjectFactory.getTimeSeriesDataset((JRTimeSeriesDataset)jRChart.getDataset()));
                this.plot = jRFillObjectFactory.getTimeSeriesPlot((JRTimeSeriesPlot)jRChart.getPlot());
                break;
            }
            case 13: {
                this.dataset = (JRFillChartDataset)((Object)jRFillObjectFactory.getXyDataset((JRXyDataset)jRChart.getDataset()));
                this.plot = jRFillObjectFactory.getAreaPlot((JRAreaPlot)jRChart.getPlot());
                break;
            }
            case 14: {
                switch (jRChart.getDataset().getDatasetType()) {
                    case 6: {
                        this.dataset = (JRFillChartDataset)((Object)jRFillObjectFactory.getTimeSeriesDataset((JRTimeSeriesDataset)jRChart.getDataset()));
                        break;
                    }
                    case 5: {
                        this.dataset = (JRFillChartDataset)((Object)jRFillObjectFactory.getTimePeriodDataset((JRTimePeriodDataset)jRChart.getDataset()));
                        break;
                    }
                    case 3: {
                        this.dataset = (JRFillChartDataset)((Object)jRFillObjectFactory.getXyDataset((JRXyDataset)jRChart.getDataset()));
                    }
                }
                this.plot = jRFillObjectFactory.getBarPlot((JRBarPlot)jRChart.getPlot());
                break;
            }
            case 15: {
                this.dataset = (JRFillChartDataset)((Object)jRFillObjectFactory.getXyDataset((JRXyDataset)jRChart.getDataset()));
                this.plot = jRFillObjectFactory.getLinePlot((JRLinePlot)jRChart.getPlot());
                break;
            }
            default: {
                throw new JRRuntimeException("Chart type not supported.");
            }
        }
        if (jRChart.getTitleFont() != null) {
            this.titleFont = jRFillObjectFactory.getFont(jRChart.getTitleFont());
        }
        if (jRChart.getSubtitleFont() != null) {
            this.subtitleFont = jRFillObjectFactory.getFont(jRChart.getSubtitleFont());
        }
        this.evaluationGroup = jRFillObjectFactory.getGroup(jRChart.getEvaluationGroup());
        this.customizerClass = jRChart.getCustomizerClass();
        if (this.customizerClass != null && this.customizerClass.length() > 0) {
            try {
                Class clazz = JRClassLoader.loadClassForName(this.customizerClass);
                this.chartCustomizer = (JRChartCustomizer)clazz.newInstance();
            }
            catch (Exception exception) {
                throw new JRRuntimeException("Could not create chart customizer instance.", exception);
            }
            if (this.chartCustomizer instanceof JRAbstractChartCustomizer) {
                ((JRAbstractChartCustomizer)this.chartCustomizer).init(jRBaseFiller, this);
            }
        }
    }

    public boolean isShowLegend() {
        return ((JRChart)this.parent).isShowLegend();
    }

    public void setShowLegend(boolean bl) {
    }

    public byte getEvaluationTime() {
        return ((JRChart)this.parent).getEvaluationTime();
    }

    public JRGroup getEvaluationGroup() {
        return this.evaluationGroup;
    }

    public JRBox getBox() {
        return (JRBox)((Object)this.parent);
    }

    public JRFont getTitleFont() {
        return this.titleFont;
    }

    public byte getTitlePosition() {
        return ((JRChart)this.parent).getTitlePosition();
    }

    public void setTitlePosition(byte by) {
    }

    public Color getTitleColor() {
        return ((JRChart)this.parent).getTitleColor();
    }

    public void setTitleColor(Color color) {
    }

    public JRFont getSubtitleFont() {
        return this.subtitleFont;
    }

    public Color getSubtitleColor() {
        return ((JRChart)this.parent).getSubtitleColor();
    }

    public void setSubtitleColor(Color color) {
    }

    public JRExpression getTitleExpression() {
        return ((JRChart)this.parent).getTitleExpression();
    }

    public JRExpression getSubtitleExpression() {
        return ((JRChart)this.parent).getSubtitleExpression();
    }

    public byte getHyperlinkType() {
        return ((JRChart)this.parent).getHyperlinkType();
    }

    public byte getHyperlinkTarget() {
        return ((JRChart)this.parent).getHyperlinkTarget();
    }

    public JRExpression getAnchorNameExpression() {
        return ((JRChart)this.parent).getAnchorNameExpression();
    }

    public JRExpression getHyperlinkReferenceExpression() {
        return ((JRChart)this.parent).getHyperlinkReferenceExpression();
    }

    public JRExpression getHyperlinkAnchorExpression() {
        return ((JRChart)this.parent).getHyperlinkAnchorExpression();
    }

    public JRExpression getHyperlinkPageExpression() {
        return ((JRChart)this.parent).getHyperlinkPageExpression();
    }

    public JRChartDataset getDataset() {
        return this.dataset;
    }

    public JRChartPlot getPlot() {
        return this.plot;
    }

    protected JRRenderable getRenderer() {
        return this.renderer;
    }

    protected String getAnchorName() {
        return this.anchorName;
    }

    protected String getHyperlinkReference() {
        return this.hyperlinkReference;
    }

    protected String getHyperlinkAnchor() {
        return this.hyperlinkAnchor;
    }

    protected Integer getHyperlinkPage() {
        return this.hyperlinkPage;
    }

    protected JRTemplateImage getJRTemplateImage() {
        JRStyle jRStyle = this.getElementStyle();
        JRTemplateImage jRTemplateImage = (JRTemplateImage)this.getTemplate(jRStyle);
        if (jRTemplateImage == null) {
            jRTemplateImage = new JRTemplateImage(this.filler.getJasperPrint().getDefaultStyleProvider(), (JRChart)this.parent, jRStyle);
            this.registerTemplate(jRStyle, jRTemplateImage);
        }
        return jRTemplateImage;
    }

    protected void rewind() {
    }

    protected void evaluate(byte by) throws JRException {
        this.reset();
        this.evaluatePrintWhenExpression(by);
        if ((this.isPrintWhenExpressionNull() || !this.isPrintWhenExpressionNull() && this.isPrintWhenTrue()) && this.getEvaluationTime() == 1) {
            this.evaluateImage(by);
        }
    }

    protected void evaluateImage(byte by) throws JRException {
        JFreeChart jFreeChart;
        this.evaluateDatasetRun(by);
        switch (this.chartType) {
            case 1: {
                jFreeChart = this.evaluateAreaImage(by);
                break;
            }
            case 3: {
                jFreeChart = this.evaluateBarImage(by);
                break;
            }
            case 2: {
                jFreeChart = this.evaluateBar3DImage(by);
                break;
            }
            case 4: {
                jFreeChart = this.evaluateBubbleImage(by);
                break;
            }
            case 5: {
                jFreeChart = this.evaluateCandlestickImage(by);
                break;
            }
            case 6: {
                jFreeChart = this.evaluateHighLowImage(by);
                break;
            }
            case 7: {
                jFreeChart = this.evaluateLineImage(by);
                break;
            }
            case 9: {
                jFreeChart = this.evaluatePieImage(by);
                break;
            }
            case 8: {
                jFreeChart = this.evaluatePie3DImage(by);
                break;
            }
            case 10: {
                jFreeChart = this.evaluateScatterImage(by);
                break;
            }
            case 12: {
                jFreeChart = this.evaluateStackedBarImage(by);
                break;
            }
            case 11: {
                jFreeChart = this.evaluateStackedBar3DImage(by);
                break;
            }
            case 16: {
                jFreeChart = this.evaluateTimeSeriesImage(by);
                break;
            }
            case 13: {
                jFreeChart = this.evaluateXyAreaImage(by);
                break;
            }
            case 14: {
                jFreeChart = this.evaluateXYBarImage(by);
                break;
            }
            case 15: {
                jFreeChart = this.evaluateXyLineImage(by);
                break;
            }
            default: {
                throw new JRRuntimeException("Chart type " + this.getChartType() + " not supported.");
            }
        }
        if (this.chartCustomizer != null) {
            this.chartCustomizer.customize(jFreeChart, this);
        }
        this.renderer = new JCommonDrawableRenderer((Drawable)jFreeChart);
        this.anchorName = (String)this.evaluateExpression(this.getAnchorNameExpression(), by);
        this.hyperlinkReference = (String)this.evaluateExpression(this.getHyperlinkReferenceExpression(), by);
        this.hyperlinkAnchor = (String)this.evaluateExpression(this.getHyperlinkAnchorExpression(), by);
        this.hyperlinkPage = (Integer)this.evaluateExpression(this.getHyperlinkPageExpression(), by);
    }

    protected boolean prepare(int n, boolean bl) {
        boolean bl2 = false;
        if (this.isPrintWhenExpressionNull() || !this.isPrintWhenExpressionNull() && this.isPrintWhenTrue()) {
            this.setToPrint(true);
        } else {
            this.setToPrint(false);
        }
        if (!this.isToPrint()) {
            return bl2;
        }
        boolean bl3 = true;
        boolean bl4 = false;
        if (this.getEvaluationTime() == 1) {
            if (bl && this.isAlreadyPrinted() && !this.isPrintWhenDetailOverflows()) {
                bl3 = false;
            }
            if (bl3 && n < this.getRelativeY() - this.getY() - this.getBandBottomY()) {
                bl3 = false;
                bl2 = true;
            }
            if (bl3 && bl && this.isPrintWhenDetailOverflows() && (this.isAlreadyPrinted() || !this.isAlreadyPrinted() && !this.isPrintRepeatedValues())) {
                bl4 = true;
            }
            if (bl3 && this.isRemoveLineWhenBlank() && this.getRenderer() == null) {
                bl3 = false;
            }
        } else {
            if (bl && this.isAlreadyPrinted() && !this.isPrintWhenDetailOverflows()) {
                bl3 = false;
            }
            if (bl3 && n < this.getRelativeY() - this.getY() - this.getBandBottomY()) {
                bl3 = false;
                bl2 = true;
            }
            if (bl3 && bl && this.isPrintWhenDetailOverflows() && (this.isAlreadyPrinted() || !this.isAlreadyPrinted() && !this.isPrintRepeatedValues())) {
                bl4 = true;
            }
        }
        this.setToPrint(bl3);
        this.setReprinted(bl4);
        return bl2;
    }

    protected JRPrintElement fill() {
        JRTemplatePrintImage jRTemplatePrintImage = new JRTemplatePrintImage(this.getJRTemplateImage());
        jRTemplatePrintImage.setX(this.getX());
        jRTemplatePrintImage.setY(this.getRelativeY());
        jRTemplatePrintImage.setWidth(this.getWidth());
        jRTemplatePrintImage.setHeight(this.getStretchHeight());
        byte by = this.getEvaluationTime();
        if (by == 1) {
            this.copy(jRTemplatePrintImage);
        } else {
            this.filler.addBoundElement(this, jRTemplatePrintImage, by, this.getEvaluationGroup(), this.band);
        }
        return jRTemplatePrintImage;
    }

    protected void copy(JRPrintImage jRPrintImage) {
        jRPrintImage.setRenderer(this.getRenderer());
        jRPrintImage.setAnchorName(this.getAnchorName());
        jRPrintImage.setHyperlinkReference(this.getHyperlinkReference());
        jRPrintImage.setHyperlinkAnchor(this.getHyperlinkAnchor());
        jRPrintImage.setHyperlinkPage(this.getHyperlinkPage());
        jRPrintImage.setBookmarkLevel(this.getBookmarkLevel());
    }

    public byte getChartType() {
        return this.chartType;
    }

    public JRChild getCopy(JRAbstractObjectFactory jRAbstractObjectFactory) {
        return jRAbstractObjectFactory.getChart(this);
    }

    public void collectExpressions(JRExpressionCollector jRExpressionCollector) {
        jRExpressionCollector.collect(this);
    }

    public void writeXml(JRXmlWriter jRXmlWriter) {
    }

    private void configureChart(JFreeChart jFreeChart, byte by) throws JRException {
        Object object;
        JRFont jRFont;
        Object object2;
        if (this.getMode() == 1) {
            jFreeChart.setBackgroundPaint((Paint)this.getBackcolor());
        } else {
            jFreeChart.setBackgroundPaint((Paint)TRANSPARENT_PAINT);
        }
        if (jFreeChart.getTitle() != null) {
            object2 = jFreeChart.getTitle();
            object2.setPaint((Paint)this.getTitleColor());
            jRFont = this.getTitleFont();
            if (jRFont != null) {
                object = JRFontUtil.getNonPdfAttributes(jRFont);
                object2.setFont(new Font((Map<? extends AttributedCharacterIterator.Attribute, ?>)object));
            }
        }
        if ((object2 = (String)this.evaluateExpression(this.getSubtitleExpression(), by)) != null) {
            jRFont = new TextTitle((String)object2);
            jRFont.setPaint(this.getSubtitleColor());
            object = this.getSubtitleFont();
            if (object != null) {
                Map map = JRFontUtil.getNonPdfAttributes((JRFont)object);
                jRFont.setFont(new Font(map));
            }
            jFreeChart.addSubtitle((Title)jRFont);
        }
        this.configurePlot(jFreeChart.getPlot());
    }

    private void configurePlot(Plot plot) {
        plot.setOutlinePaint((Paint)TRANSPARENT_PAINT);
        if (this.getPlot().getBackcolor() == null) {
            plot.setBackgroundPaint((Paint)TRANSPARENT_PAINT);
        } else {
            plot.setBackgroundPaint((Paint)this.getPlot().getBackcolor());
        }
        plot.setBackgroundAlpha(this.getPlot().getBackgroundAlpha());
        plot.setForegroundAlpha(this.getPlot().getForegroundAlpha());
    }

    protected JFreeChart evaluateAreaImage(byte by) throws JRException {
        JFreeChart jFreeChart = ChartFactory.createAreaChart((String)((String)this.evaluateExpression(this.getTitleExpression(), by)), (String)((String)this.evaluateExpression(((JRAreaPlot)this.getPlot()).getCategoryAxisLabelExpression(), by)), (String)((String)this.evaluateExpression(((JRAreaPlot)this.getPlot()).getValueAxisLabelExpression(), by)), (CategoryDataset)((CategoryDataset)this.dataset.getDataset()), (PlotOrientation)this.getPlot().getOrientation(), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(jFreeChart, by);
        return jFreeChart;
    }

    protected JFreeChart evaluateBar3DImage(byte by) throws JRException {
        JFreeChart jFreeChart = ChartFactory.createBarChart3D((String)((String)this.evaluateExpression(this.getTitleExpression(), by)), (String)((String)this.evaluateExpression(((JRBar3DPlot)this.getPlot()).getCategoryAxisLabelExpression(), by)), (String)((String)this.evaluateExpression(((JRBar3DPlot)this.getPlot()).getValueAxisLabelExpression(), by)), (CategoryDataset)((CategoryDataset)this.dataset.getDataset()), (PlotOrientation)this.getPlot().getOrientation(), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(jFreeChart, by);
        CategoryPlot categoryPlot = (CategoryPlot)jFreeChart.getPlot();
        BarRenderer3D barRenderer3D = new BarRenderer3D(((JRFillBar3DPlot)this.getPlot()).getXOffset(), ((JRFillBar3DPlot)this.getPlot()).getYOffset());
        categoryPlot.setRenderer((CategoryItemRenderer)barRenderer3D);
        barRenderer3D.setBaseItemLabelGenerator((CategoryItemLabelGenerator)((JRFillCategoryDataset)this.getDataset()).getLabelGenerator());
        barRenderer3D.setItemLabelsVisible(((JRFillBar3DPlot)this.getPlot()).isShowLabels());
        return jFreeChart;
    }

    protected JFreeChart evaluateBarImage(byte by) throws JRException {
        CategoryDataset categoryDataset = (CategoryDataset)this.dataset.getDataset();
        JFreeChart jFreeChart = ChartFactory.createBarChart((String)((String)this.evaluateExpression(this.getTitleExpression(), by)), (String)((String)this.evaluateExpression(((JRBarPlot)this.getPlot()).getCategoryAxisLabelExpression(), by)), (String)((String)this.evaluateExpression(((JRBarPlot)this.getPlot()).getValueAxisLabelExpression(), by)), (CategoryDataset)categoryDataset, (PlotOrientation)this.getPlot().getOrientation(), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(jFreeChart, by);
        CategoryPlot categoryPlot = (CategoryPlot)jFreeChart.getPlot();
        categoryPlot.getDomainAxis().setTickMarksVisible(((JRFillBarPlot)this.getPlot()).isShowTickMarks());
        categoryPlot.getDomainAxis().setTickLabelsVisible(((JRFillBarPlot)this.getPlot()).isShowTickLabels());
        ((NumberAxis)categoryPlot.getRangeAxis()).setTickMarksVisible(((JRFillBarPlot)this.getPlot()).isShowTickMarks());
        ((NumberAxis)categoryPlot.getRangeAxis()).setTickLabelsVisible(((JRFillBarPlot)this.getPlot()).isShowTickLabels());
        CategoryItemRenderer categoryItemRenderer = categoryPlot.getRenderer();
        categoryItemRenderer.setBaseItemLabelGenerator((CategoryItemLabelGenerator)((JRFillCategoryDataset)this.getDataset()).getLabelGenerator());
        categoryItemRenderer.setItemLabelsVisible(((JRFillBarPlot)this.getPlot()).isShowLabels());
        return jFreeChart;
    }

    protected JFreeChart evaluateBubbleImage(byte by) throws JRException {
        JFreeChart jFreeChart = ChartFactory.createBubbleChart((String)((String)this.evaluateExpression(this.getTitleExpression(), by)), (String)((String)this.evaluateExpression(((JRBubblePlot)this.getPlot()).getXAxisLabelExpression(), by)), (String)((String)this.evaluateExpression(((JRBubblePlot)this.getPlot()).getYAxisLabelExpression(), by)), (XYZDataset)((XYZDataset)this.dataset.getDataset()), (PlotOrientation)this.getPlot().getOrientation(), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(jFreeChart, by);
        XYPlot xYPlot = (XYPlot)jFreeChart.getPlot();
        XYBubbleRenderer xYBubbleRenderer = new XYBubbleRenderer(((JRFillBubblePlot)this.getPlot()).getScaleType());
        xYPlot.setRenderer((XYItemRenderer)xYBubbleRenderer);
        return jFreeChart;
    }

    protected JFreeChart evaluateCandlestickImage(byte by) throws JRException {
        JFreeChart jFreeChart = ChartFactory.createCandlestickChart((String)((String)this.evaluateExpression(this.getTitleExpression(), by)), (String)((String)this.evaluateExpression(((JRCandlestickPlot)this.getPlot()).getTimeAxisLabelExpression(), by)), (String)((String)this.evaluateExpression(((JRCandlestickPlot)this.getPlot()).getValueAxisLabelExpression(), by)), (OHLCDataset)((DefaultHighLowDataset)this.dataset.getDataset()), (boolean)this.isShowLegend());
        this.configureChart(jFreeChart, by);
        XYPlot xYPlot = (XYPlot)jFreeChart.getPlot();
        CandlestickRenderer candlestickRenderer = (CandlestickRenderer)xYPlot.getRenderer();
        candlestickRenderer.setDrawVolume(((JRCandlestickPlot)this.getPlot()).isShowVolume());
        return jFreeChart;
    }

    protected JFreeChart evaluateHighLowImage(byte by) throws JRException {
        JFreeChart jFreeChart = ChartFactory.createHighLowChart((String)((String)this.evaluateExpression(this.getTitleExpression(), by)), (String)((String)this.evaluateExpression(((JRHighLowPlot)this.getPlot()).getTimeAxisLabelExpression(), by)), (String)((String)this.evaluateExpression(((JRHighLowPlot)this.getPlot()).getValueAxisLabelExpression(), by)), (OHLCDataset)((DefaultHighLowDataset)this.dataset.getDataset()), (boolean)this.isShowLegend());
        this.configureChart(jFreeChart, by);
        XYPlot xYPlot = (XYPlot)jFreeChart.getPlot();
        HighLowRenderer highLowRenderer = (HighLowRenderer)xYPlot.getRenderer();
        highLowRenderer.setDrawOpenTicks(((JRHighLowPlot)this.getPlot()).isShowOpenTicks());
        highLowRenderer.setDrawCloseTicks(((JRHighLowPlot)this.getPlot()).isShowCloseTicks());
        return jFreeChart;
    }

    protected JFreeChart evaluateLineImage(byte by) throws JRException {
        JFreeChart jFreeChart = ChartFactory.createLineChart((String)((String)this.evaluateExpression(this.getTitleExpression(), by)), (String)((String)this.evaluateExpression(((JRLinePlot)this.getPlot()).getCategoryAxisLabelExpression(), by)), (String)((String)this.evaluateExpression(((JRLinePlot)this.getPlot()).getValueAxisLabelExpression(), by)), (CategoryDataset)((CategoryDataset)this.dataset.getDataset()), (PlotOrientation)this.getPlot().getOrientation(), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(jFreeChart, by);
        CategoryPlot categoryPlot = (CategoryPlot)jFreeChart.getPlot();
        LineAndShapeRenderer lineAndShapeRenderer = (LineAndShapeRenderer)categoryPlot.getRenderer();
        lineAndShapeRenderer.setShapesVisible(((JRFillLinePlot)this.getPlot()).isShowShapes());
        lineAndShapeRenderer.setLinesVisible(((JRFillLinePlot)this.getPlot()).isShowLines());
        return jFreeChart;
    }

    protected JFreeChart evaluatePie3DImage(byte by) throws JRException {
        JFreeChart jFreeChart = ChartFactory.createPieChart3D((String)((String)this.evaluateExpression(this.getTitleExpression(), by)), (PieDataset)((PieDataset)this.dataset.getDataset()), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(jFreeChart, by);
        PiePlot3D piePlot3D = (PiePlot3D)jFreeChart.getPlot();
        piePlot3D.setDepthFactor(((JRFillPie3DPlot)this.getPlot()).getDepthFactor());
        PieLabelGenerator pieLabelGenerator = ((JRFillPieDataset)this.getDataset()).getLabelGenerator();
        if (pieLabelGenerator != null) {
            piePlot3D.setLabelGenerator((PieSectionLabelGenerator)pieLabelGenerator);
        }
        return jFreeChart;
    }

    protected JFreeChart evaluatePieImage(byte by) throws JRException {
        JFreeChart jFreeChart = ChartFactory.createPieChart((String)((String)this.evaluateExpression(this.getTitleExpression(), by)), (PieDataset)((PieDataset)this.dataset.getDataset()), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(jFreeChart, by);
        PiePlot piePlot = (PiePlot)jFreeChart.getPlot();
        PieLabelGenerator pieLabelGenerator = ((JRFillPieDataset)this.getDataset()).getLabelGenerator();
        if (pieLabelGenerator != null) {
            piePlot.setLabelGenerator((PieSectionLabelGenerator)pieLabelGenerator);
        }
        return jFreeChart;
    }

    protected JFreeChart evaluateScatterImage(byte by) throws JRException {
        JFreeChart jFreeChart = ChartFactory.createScatterPlot((String)((String)this.evaluateExpression(this.getTitleExpression(), by)), (String)((String)this.evaluateExpression(((JRScatterPlot)this.getPlot()).getXAxisLabelExpression(), by)), (String)((String)this.evaluateExpression(((JRScatterPlot)this.getPlot()).getYAxisLabelExpression(), by)), (XYDataset)((XYDataset)this.dataset.getDataset()), (PlotOrientation)this.getPlot().getOrientation(), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(jFreeChart, by);
        XYLineAndShapeRenderer xYLineAndShapeRenderer = (XYLineAndShapeRenderer)((XYPlot)jFreeChart.getPlot()).getRenderer();
        JRScatterPlot jRScatterPlot = (JRScatterPlot)this.getPlot();
        xYLineAndShapeRenderer.setLinesVisible(jRScatterPlot.isShowLines());
        xYLineAndShapeRenderer.setShapesVisible(jRScatterPlot.isShowShapes());
        return jFreeChart;
    }

    protected JFreeChart evaluateStackedBar3DImage(byte by) throws JRException {
        JFreeChart jFreeChart = ChartFactory.createStackedBarChart3D((String)((String)this.evaluateExpression(this.getTitleExpression(), by)), (String)((String)this.evaluateExpression(((JRBar3DPlot)this.getPlot()).getCategoryAxisLabelExpression(), by)), (String)((String)this.evaluateExpression(((JRBar3DPlot)this.getPlot()).getValueAxisLabelExpression(), by)), (CategoryDataset)((CategoryDataset)this.dataset.getDataset()), (PlotOrientation)this.getPlot().getOrientation(), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(jFreeChart, by);
        CategoryPlot categoryPlot = (CategoryPlot)jFreeChart.getPlot();
        StackedBarRenderer3D stackedBarRenderer3D = new StackedBarRenderer3D(((JRFillBar3DPlot)this.getPlot()).getXOffset(), ((JRFillBar3DPlot)this.getPlot()).getYOffset());
        categoryPlot.setRenderer((CategoryItemRenderer)stackedBarRenderer3D);
        stackedBarRenderer3D.setBaseItemLabelGenerator((CategoryItemLabelGenerator)((JRFillCategoryDataset)this.getDataset()).getLabelGenerator());
        stackedBarRenderer3D.setItemLabelsVisible(((JRFillBar3DPlot)this.getPlot()).isShowLabels());
        return jFreeChart;
    }

    protected JFreeChart evaluateStackedBarImage(byte by) throws JRException {
        JFreeChart jFreeChart = ChartFactory.createStackedBarChart((String)((String)this.evaluateExpression(this.getTitleExpression(), by)), (String)((String)this.evaluateExpression(((JRBarPlot)this.getPlot()).getCategoryAxisLabelExpression(), by)), (String)((String)this.evaluateExpression(((JRBarPlot)this.getPlot()).getValueAxisLabelExpression(), by)), (CategoryDataset)((CategoryDataset)this.dataset.getDataset()), (PlotOrientation)this.getPlot().getOrientation(), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(jFreeChart, by);
        CategoryPlot categoryPlot = (CategoryPlot)jFreeChart.getPlot();
        categoryPlot.getDomainAxis().setTickMarksVisible(((JRFillBarPlot)this.getPlot()).isShowTickMarks());
        categoryPlot.getDomainAxis().setTickLabelsVisible(((JRFillBarPlot)this.getPlot()).isShowTickLabels());
        ((NumberAxis)categoryPlot.getRangeAxis()).setTickMarksVisible(((JRFillBarPlot)this.getPlot()).isShowTickMarks());
        ((NumberAxis)categoryPlot.getRangeAxis()).setTickLabelsVisible(((JRFillBarPlot)this.getPlot()).isShowTickLabels());
        CategoryItemRenderer categoryItemRenderer = categoryPlot.getRenderer();
        categoryItemRenderer.setBaseItemLabelGenerator((CategoryItemLabelGenerator)((JRFillCategoryDataset)this.getDataset()).getLabelGenerator());
        categoryItemRenderer.setItemLabelsVisible(((JRFillBarPlot)this.getPlot()).isShowLabels());
        return jFreeChart;
    }

    protected JFreeChart evaluateXyAreaImage(byte by) throws JRException {
        JFreeChart jFreeChart = ChartFactory.createXYAreaChart((String)((String)this.evaluateExpression(this.getTitleExpression(), by)), (String)((String)this.evaluateExpression(((JRAreaPlot)this.getPlot()).getCategoryAxisLabelExpression(), by)), (String)((String)this.evaluateExpression(((JRAreaPlot)this.getPlot()).getValueAxisLabelExpression(), by)), (XYDataset)((XYDataset)this.dataset.getDataset()), (PlotOrientation)this.getPlot().getOrientation(), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(jFreeChart, by);
        return jFreeChart;
    }

    protected JFreeChart evaluateXYBarImage(byte by) throws JRException {
        IntervalXYDataset intervalXYDataset = (IntervalXYDataset)this.dataset.getDataset();
        boolean bl = true;
        if (this.dataset.getDatasetType() == 3) {
            bl = false;
        }
        JFreeChart jFreeChart = ChartFactory.createXYBarChart((String)((String)this.evaluateExpression(this.getTitleExpression(), by)), (String)((String)this.evaluateExpression(((JRBarPlot)this.getPlot()).getCategoryAxisLabelExpression(), by)), (boolean)bl, (String)((String)this.evaluateExpression(((JRBarPlot)this.getPlot()).getValueAxisLabelExpression(), by)), (IntervalXYDataset)intervalXYDataset, (PlotOrientation)this.getPlot().getOrientation(), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(jFreeChart, by);
        XYPlot xYPlot = (XYPlot)jFreeChart.getPlot();
        XYItemRenderer xYItemRenderer = xYPlot.getRenderer();
        if (this.getDataset().getDatasetType() == 6) {
            xYItemRenderer.setBaseItemLabelGenerator((XYItemLabelGenerator)((JRFillTimeSeriesDataset)this.getDataset()).getLabelGenerator());
        } else if (this.getDataset().getDatasetType() == 5) {
            xYItemRenderer.setBaseItemLabelGenerator((XYItemLabelGenerator)((JRFillTimePeriodDataset)this.getDataset()).getLabelGenerator());
        } else if (this.getDataset().getDatasetType() == 3) {
            xYItemRenderer.setBaseItemLabelGenerator((XYItemLabelGenerator)((JRFillXyDataset)this.getDataset()).getLabelGenerator());
        }
        xYItemRenderer.setBaseItemLabelsVisible(((JRFillBarPlot)this.getPlot()).isShowLabels());
        return jFreeChart;
    }

    protected JFreeChart evaluateXyLineImage(byte by) throws JRException {
        JFreeChart jFreeChart = ChartFactory.createXYLineChart((String)((String)this.evaluateExpression(this.getTitleExpression(), by)), (String)((String)this.evaluateExpression(((JRLinePlot)this.getPlot()).getCategoryAxisLabelExpression(), by)), (String)((String)this.evaluateExpression(((JRLinePlot)this.getPlot()).getValueAxisLabelExpression(), by)), (XYDataset)((XYDataset)this.dataset.getDataset()), (PlotOrientation)this.getPlot().getOrientation(), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(jFreeChart, by);
        return jFreeChart;
    }

    protected JFreeChart evaluateTimeSeriesImage(byte by) throws JRException {
        String string = (String)this.evaluateExpression(((JRTimeSeriesPlot)this.getPlot()).getTimeAxisLabelExpression(), by);
        String string2 = (String)this.evaluateExpression(((JRTimeSeriesPlot)this.getPlot()).getValueAxisLabelExpression(), by);
        JFreeChart jFreeChart = ChartFactory.createTimeSeriesChart((String)((String)this.evaluateExpression(this.getTitleExpression(), by)), (String)string, (String)string2, (XYDataset)((TimeSeriesCollection)this.dataset.getDataset()), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(jFreeChart, by);
        XYPlot xYPlot = (XYPlot)jFreeChart.getPlot();
        XYLineAndShapeRenderer xYLineAndShapeRenderer = (XYLineAndShapeRenderer)xYPlot.getRenderer();
        xYLineAndShapeRenderer.setLinesVisible(((JRTimeSeriesPlot)this.getPlot()).isShowLines());
        xYLineAndShapeRenderer.setShapesVisible(((JRTimeSeriesPlot)this.getPlot()).isShowShapes());
        return jFreeChart;
    }

    protected void resolveElement(JRPrintElement jRPrintElement, byte by) throws JRException {
        this.evaluateImage(by);
        this.copy((JRPrintImage)jRPrintElement);
    }

    public int getBookmarkLevel() {
        return ((JRChart)this.parent).getBookmarkLevel();
    }

    public String getCustomizerClass() {
        return this.customizerClass;
    }

    public byte getBorder() {
        return ((JRBox)((Object)this.parent)).getBorder();
    }

    public Byte getOwnBorder() {
        return ((JRBox)((Object)this.parent)).getOwnBorder();
    }

    public void setBorder(byte by) {
    }

    public void setBorder(Byte by) {
    }

    public Color getBorderColor() {
        return ((JRBox)((Object)this.parent)).getBorderColor();
    }

    public Color getOwnBorderColor() {
        return ((JRBox)((Object)this.parent)).getOwnBorderColor();
    }

    public void setBorderColor(Color color) {
    }

    public int getPadding() {
        return ((JRBox)((Object)this.parent)).getPadding();
    }

    public Integer getOwnPadding() {
        return ((JRBox)((Object)this.parent)).getOwnPadding();
    }

    public void setPadding(int n) {
    }

    public void setPadding(Integer n) {
    }

    public byte getTopBorder() {
        return ((JRBox)((Object)this.parent)).getTopBorder();
    }

    public Byte getOwnTopBorder() {
        return ((JRBox)((Object)this.parent)).getOwnTopBorder();
    }

    public void setTopBorder(byte by) {
    }

    public void setTopBorder(Byte by) {
    }

    public Color getTopBorderColor() {
        return ((JRBox)((Object)this.parent)).getTopBorderColor();
    }

    public Color getOwnTopBorderColor() {
        return ((JRBox)((Object)this.parent)).getOwnTopBorderColor();
    }

    public void setTopBorderColor(Color color) {
    }

    public int getTopPadding() {
        return ((JRBox)((Object)this.parent)).getTopPadding();
    }

    public Integer getOwnTopPadding() {
        return ((JRBox)((Object)this.parent)).getOwnTopPadding();
    }

    public void setTopPadding(int n) {
    }

    public void setTopPadding(Integer n) {
    }

    public byte getLeftBorder() {
        return ((JRBox)((Object)this.parent)).getLeftBorder();
    }

    public Byte getOwnLeftBorder() {
        return ((JRBox)((Object)this.parent)).getOwnLeftBorder();
    }

    public void setLeftBorder(byte by) {
    }

    public void setLeftBorder(Byte by) {
    }

    public Color getLeftBorderColor() {
        return ((JRBox)((Object)this.parent)).getLeftBorderColor();
    }

    public Color getOwnLeftBorderColor() {
        return ((JRBox)((Object)this.parent)).getOwnLeftBorderColor();
    }

    public void setLeftBorderColor(Color color) {
    }

    public int getLeftPadding() {
        return ((JRBox)((Object)this.parent)).getLeftPadding();
    }

    public Integer getOwnLeftPadding() {
        return ((JRBox)((Object)this.parent)).getOwnLeftPadding();
    }

    public void setLeftPadding(int n) {
    }

    public void setLeftPadding(Integer n) {
    }

    public byte getBottomBorder() {
        return ((JRBox)((Object)this.parent)).getBottomBorder();
    }

    public Byte getOwnBottomBorder() {
        return ((JRBox)((Object)this.parent)).getOwnBottomBorder();
    }

    public void setBottomBorder(byte by) {
    }

    public void setBottomBorder(Byte by) {
    }

    public Color getBottomBorderColor() {
        return ((JRBox)((Object)this.parent)).getBottomBorderColor();
    }

    public Color getOwnBottomBorderColor() {
        return ((JRBox)((Object)this.parent)).getOwnBottomBorderColor();
    }

    public void setBottomBorderColor(Color color) {
    }

    public int getBottomPadding() {
        return ((JRBox)((Object)this.parent)).getBottomPadding();
    }

    public Integer getOwnBottomPadding() {
        return ((JRBox)((Object)this.parent)).getOwnBottomPadding();
    }

    public void setBottomPadding(int n) {
    }

    public void setBottomPadding(Integer n) {
    }

    public byte getRightBorder() {
        return ((JRBox)((Object)this.parent)).getRightBorder();
    }

    public Byte getOwnRightBorder() {
        return ((JRBox)((Object)this.parent)).getOwnRightBorder();
    }

    public void setRightBorder(byte by) {
    }

    public void setRightBorder(Byte by) {
    }

    public Color getRightBorderColor() {
        return ((JRBox)((Object)this.parent)).getRightBorderColor();
    }

    public Color getOwnRightBorderColor() {
        return ((JRBox)((Object)this.parent)).getOwnRightBorderColor();
    }

    public void setRightBorderColor(Color color) {
    }

    public int getRightPadding() {
        return ((JRBox)((Object)this.parent)).getRightPadding();
    }

    public Integer getOwnRightPadding() {
        return ((JRBox)((Object)this.parent)).getOwnRightPadding();
    }

    public void setRightPadding(int n) {
    }

    public void setRightPadding(Integer n) {
    }

    private void evaluateDatasetRun(byte by) throws JRException {
        this.dataset.evaluateDatasetRun(by);
    }

    public JRCloneable createClone(JRFillCloneFactory jRFillCloneFactory) {
        return null;
    }
}

