/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRVirtualizable;
import net.sf.jasperreports.engine.fill.JRAbstractLRUVirtualizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JRFileVirtualizer
extends JRAbstractLRUVirtualizer {
    private static final Log log = LogFactory.getLog((Class)(class$net$sf$jasperreports$engine$fill$JRFileVirtualizer == null ? (class$net$sf$jasperreports$engine$fill$JRFileVirtualizer = JRFileVirtualizer.class$("net.sf.jasperreports.engine.fill.JRFileVirtualizer")) : class$net$sf$jasperreports$engine$fill$JRFileVirtualizer));
    private final String directory;
    static /* synthetic */ Class class$net$sf$jasperreports$engine$fill$JRFileVirtualizer;

    public JRFileVirtualizer(int n) {
        this(n, null);
    }

    public JRFileVirtualizer(int n, String string) {
        super(n);
        this.directory = string;
    }

    private String makeFilename(JRVirtualizable jRVirtualizable) {
        String string = jRVirtualizable.getUID();
        return "virt" + string;
    }

    protected void pageOut(JRVirtualizable jRVirtualizable) throws IOException {
        String string = this.makeFilename(jRVirtualizable);
        File file = new File(this.directory, string);
        if (file.createNewFile()) {
            file.deleteOnExit();
            FileOutputStream fileOutputStream = null;
            try {
                fileOutputStream = new FileOutputStream(file);
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
                this.writeData(jRVirtualizable, bufferedOutputStream);
            }
            catch (FileNotFoundException fileNotFoundException) {
                log.error((Object)"Error virtualizing object", (Throwable)fileNotFoundException);
                throw new JRRuntimeException(fileNotFoundException);
            }
            finally {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
        } else if (!this.readOnly) {
            throw new IllegalStateException("Cannot virtualize data because the file \"" + string + "\" already exists.");
        }
    }

    protected void pageIn(JRVirtualizable jRVirtualizable) throws IOException {
        String string = this.makeFilename(jRVirtualizable);
        File file = new File(this.directory, string);
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
            this.readData(jRVirtualizable, bufferedInputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            log.error((Object)"Error devirtualizing object", (Throwable)fileNotFoundException);
            throw new JRRuntimeException(fileNotFoundException);
        }
        finally {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
        if (!this.readOnly) {
            file.delete();
        }
    }

    protected void dispose(JRVirtualizable jRVirtualizable) {
        String string = this.makeFilename(jRVirtualizable);
        File file = new File(this.directory, string);
        file.delete();
    }

    public void cleanup() {
        Map.Entry entry;
        Iterator iterator = this.pagedOut.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            try {
                this.dispose((JRVirtualizable)entry.getValue());
                iterator.remove();
            }
            catch (Exception exception) {
                log.error((Object)"Error cleaning up virtualizer.", (Throwable)exception);
            }
        }
        iterator = this.pagedIn.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            try {
                this.dispose((JRVirtualizable)entry.getValue());
                iterator.remove();
            }
            catch (Exception exception) {
                log.error((Object)"Error cleaning up virtualizer.", (Throwable)exception);
            }
        }
        this.readOnly = false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

