/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.text.MessageFormat;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.fill.JRExpressionEvalException;
import net.sf.jasperreports.engine.fill.JRFillParameter;

public abstract class JREvaluator {
    private JRFillParameter resourceBundle = null;
    private byte whenResourceMissingType;

    protected JREvaluator() {
    }

    public void init(Map map, Map map2, Map map3, JRFillParameter jRFillParameter, byte by) throws JRException {
        this.resourceBundle = jRFillParameter;
        this.whenResourceMissingType = by;
        this.customizedInit(map, map2, map3);
    }

    public String msg(String string, Object object) {
        return MessageFormat.format(string, object);
    }

    public String msg(String string, Object object, Object object2) {
        return MessageFormat.format(string, object, object2);
    }

    public String msg(String string, Object object, Object object2, Object object3) {
        return MessageFormat.format(string, object, object2, object3);
    }

    public String str(String string) {
        String string2 = null;
        try {
            string2 = ((ResourceBundle)this.resourceBundle.getValue()).getString(string);
        }
        catch (NullPointerException nullPointerException) {
            string2 = this.handleMissingResource(string, nullPointerException);
        }
        catch (MissingResourceException missingResourceException) {
            string2 = this.handleMissingResource(string, missingResourceException);
        }
        return string2;
    }

    public Object evaluate(JRExpression jRExpression) throws JRExpressionEvalException {
        Object object = null;
        if (jRExpression != null) {
            try {
                object = this.evaluate(jRExpression.getId());
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (OutOfMemoryError outOfMemoryError) {
                throw outOfMemoryError;
            }
            catch (Throwable throwable) {
                throw new JRExpressionEvalException(jRExpression, throwable);
            }
        }
        return object;
    }

    public Object evaluateOld(JRExpression jRExpression) throws JRExpressionEvalException {
        Object object = null;
        if (jRExpression != null) {
            try {
                object = this.evaluateOld(jRExpression.getId());
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (OutOfMemoryError outOfMemoryError) {
                throw outOfMemoryError;
            }
            catch (Throwable throwable) {
                throw new JRExpressionEvalException(jRExpression, throwable);
            }
        }
        return object;
    }

    public Object evaluateEstimated(JRExpression jRExpression) throws JRExpressionEvalException {
        Object object = null;
        if (jRExpression != null) {
            try {
                object = this.evaluateEstimated(jRExpression.getId());
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (OutOfMemoryError outOfMemoryError) {
                throw outOfMemoryError;
            }
            catch (Throwable throwable) {
                throw new JRExpressionEvalException(jRExpression, throwable);
            }
        }
        return object;
    }

    protected String handleMissingResource(String string, Exception exception) throws JRRuntimeException {
        String string2;
        switch (this.whenResourceMissingType) {
            case 2: {
                string2 = "";
                break;
            }
            case 3: {
                string2 = string;
                break;
            }
            case 4: {
                throw new JRRuntimeException("Resource nout found for key \"" + string + "\".", exception);
            }
            default: {
                string2 = null;
            }
        }
        return string2;
    }

    protected abstract void customizedInit(Map var1, Map var2, Map var3) throws JRException;

    protected abstract Object evaluate(int var1) throws Throwable;

    protected abstract Object evaluateOld(int var1) throws Throwable;

    protected abstract Object evaluateEstimated(int var1) throws Throwable;
}

