/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.io.Serializable;
import java.net.URLStreamHandlerFactory;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.engine.JRAbstractScriptlet;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRReportFont;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRVirtualizer;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.base.JRBasePrintPage;
import net.sf.jasperreports.engine.base.JRVirtualPrintPage;
import net.sf.jasperreports.engine.fill.JRCalculator;
import net.sf.jasperreports.engine.fill.JREvaluationTime;
import net.sf.jasperreports.engine.fill.JREvaluator;
import net.sf.jasperreports.engine.fill.JRFillBand;
import net.sf.jasperreports.engine.fill.JRFillContext;
import net.sf.jasperreports.engine.fill.JRFillDataset;
import net.sf.jasperreports.engine.fill.JRFillElement;
import net.sf.jasperreports.engine.fill.JRFillField;
import net.sf.jasperreports.engine.fill.JRFillGroup;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.fill.JRFillParameter;
import net.sf.jasperreports.engine.fill.JRFillTextField;
import net.sf.jasperreports.engine.fill.JRFillVariable;
import net.sf.jasperreports.engine.util.JRGraphEnvInitializer;
import net.sf.jasperreports.engine.util.JRResourcesUtil;
import net.sf.jasperreports.engine.util.JRStyledTextParser;

public abstract class JRBaseFiller
implements JRDefaultStyleProvider,
JRVirtualPrintPage.IdentityDataProvider {
    protected JRBaseFiller parentFiller = null;
    private JRStyledTextParser styledTextParser = new JRStyledTextParser();
    private boolean isInterrupted = false;
    protected String name = null;
    protected int columnCount = 1;
    protected byte printOrder = 1;
    protected int pageWidth = 0;
    protected int pageHeight = 0;
    protected byte orientation = 1;
    protected byte whenNoDataType = 1;
    protected int columnWidth = 0;
    protected int columnSpacing = 0;
    protected int leftMargin = 0;
    protected int rightMargin = 0;
    protected int topMargin = 0;
    protected int bottomMargin = 0;
    protected boolean isTitleNewPage = false;
    protected boolean isSummaryNewPage = false;
    protected boolean isFloatColumnFooter = false;
    protected byte whenResourceMissingType = 1;
    protected JRReportFont defaultFont = null;
    protected JRReportFont[] fonts = null;
    protected JRStyle defaultStyle = null;
    protected JRStyle[] styles = null;
    protected JRFillDataset mainDataset;
    protected JRFillGroup[] groups = null;
    protected JRFillBand missingFillBand = null;
    protected JRFillBand background = null;
    protected JRFillBand title = null;
    protected JRFillBand pageHeader = null;
    protected JRFillBand columnHeader = null;
    protected JRFillBand detail = null;
    protected JRFillBand columnFooter = null;
    protected JRFillBand pageFooter = null;
    protected JRFillBand lastPageFooter = null;
    protected JRFillBand summary = null;
    protected JRVirtualizer virtualizer = null;
    protected ClassLoader reportClassLoader = null;
    protected URLStreamHandlerFactory urlHandlerFactory;
    protected List formattedTextFields = new ArrayList();
    protected Map loadedSubreports = null;
    protected JRFillContext fillContext;
    protected Map boundElements;
    protected JasperPrint jasperPrint = null;
    protected JRPrintPage printPage = null;
    protected int printPageStretchHeight = 0;
    protected List bands;
    protected Set subfillers;
    private List identityPages;
    private Thread fillingThread;
    protected JRCalculator calculator;
    protected JRAbstractScriptlet scriptlet;
    protected Map datasetMap;
    protected JasperReport jasperReport;
    private boolean bandOverFlowAllowed;
    protected boolean isPerPageBoundElements;
    protected Map consolidatedStyles = new HashMap();

    protected JRBaseFiller(JasperReport jasperReport, JREvaluator jREvaluator, JRBaseFiller jRBaseFiller) throws JRException {
        JRGraphEnvInitializer.initializeGraphEnv();
        this.jasperReport = jasperReport;
        this.parentFiller = jRBaseFiller;
        this.fillContext = jRBaseFiller == null ? new JRFillContext() : jRBaseFiller.fillContext;
        this.name = jasperReport.getName();
        this.columnCount = jasperReport.getColumnCount();
        this.printOrder = jasperReport.getPrintOrder();
        this.pageWidth = jasperReport.getPageWidth();
        this.pageHeight = jasperReport.getPageHeight();
        this.orientation = jasperReport.getOrientation();
        this.whenNoDataType = jasperReport.getWhenNoDataType();
        this.columnWidth = jasperReport.getColumnWidth();
        this.columnSpacing = jasperReport.getColumnSpacing();
        this.leftMargin = jasperReport.getLeftMargin();
        this.rightMargin = jasperReport.getRightMargin();
        this.topMargin = jasperReport.getTopMargin();
        this.bottomMargin = jasperReport.getBottomMargin();
        this.isTitleNewPage = jasperReport.isTitleNewPage();
        this.isSummaryNewPage = jasperReport.isSummaryNewPage();
        this.isFloatColumnFooter = jasperReport.isFloatColumnFooter();
        this.whenResourceMissingType = jasperReport.getWhenResourceMissingType();
        this.jasperPrint = new JasperPrint();
        this.calculator = jREvaluator == null ? JRFillDataset.createCalculator(jasperReport, jasperReport.getMainDataset()) : new JRCalculator(jREvaluator);
        JRFillObjectFactory jRFillObjectFactory = new JRFillObjectFactory(this);
        this.defaultFont = jRFillObjectFactory.getReportFont(jasperReport.getDefaultFont());
        JRReportFont[] jRReportFontArray = jasperReport.getFonts();
        if (jRReportFontArray != null && jRReportFontArray.length > 0) {
            this.fonts = new JRReportFont[jRReportFontArray.length];
            for (int i = 0; i < this.fonts.length; ++i) {
                this.fonts[i] = jRFillObjectFactory.getReportFont(jRReportFontArray[i]);
            }
        }
        this.createDatasets(jRFillObjectFactory);
        this.mainDataset = jRFillObjectFactory.getDataset(jasperReport.getMainDataset());
        this.groups = this.mainDataset.groups;
        this.defaultStyle = jRFillObjectFactory.getStyle(jasperReport.getDefaultStyle());
        JRStyle[] jRStyleArray = jasperReport.getStyles();
        if (jRStyleArray != null && jRStyleArray.length > 0) {
            this.styles = new JRStyle[jRStyleArray.length];
            for (int i = 0; i < this.styles.length; ++i) {
                this.styles[i] = jRFillObjectFactory.getStyle(jRStyleArray[i]);
            }
        }
        this.missingFillBand = jRFillObjectFactory.getBand(null);
        this.background = jRFillObjectFactory.getBand(jasperReport.getBackground());
        this.title = jRFillObjectFactory.getBand(jasperReport.getTitle());
        this.pageHeader = jRFillObjectFactory.getBand(jasperReport.getPageHeader());
        this.columnHeader = jRFillObjectFactory.getBand(jasperReport.getColumnHeader());
        this.detail = jRFillObjectFactory.getBand(jasperReport.getDetail());
        this.columnFooter = jRFillObjectFactory.getBand(jasperReport.getColumnFooter());
        this.pageFooter = jRFillObjectFactory.getBand(jasperReport.getPageFooter());
        this.lastPageFooter = jRFillObjectFactory.getBand(jasperReport.getLastPageFooter());
        this.summary = this.isEmpty(jasperReport.getSummary()) ? this.missingFillBand : jRFillObjectFactory.getBand(jasperReport.getSummary());
        this.mainDataset.initElementDatasets(jRFillObjectFactory);
        this.initDatasets(jRFillObjectFactory);
        this.mainDataset.checkVariableCalculationReqs(jRFillObjectFactory);
        this.scriptlet = this.mainDataset.initScriptlet();
        this.mainDataset.setCalculator(this.calculator);
        this.mainDataset.initCalculator();
        this.initBands();
    }

    protected Map getParametersMap() {
        return this.mainDataset.parametersMap;
    }

    protected Map getFieldsMap() {
        return this.mainDataset.fieldsMap;
    }

    protected Map getVariablesMap() {
        return this.mainDataset.variablesMap;
    }

    protected JRFillVariable getVariable(String string) {
        return (JRFillVariable)this.mainDataset.variablesMap.get(string);
    }

    protected JRFillField getField(String string) {
        return (JRFillField)this.mainDataset.fieldsMap.get(string);
    }

    private void initBands() {
        this.bands = new ArrayList(8 + (this.groups == null ? 0 : 2 * this.groups.length));
        this.bands.add(this.title);
        this.bands.add(this.summary);
        this.bands.add(this.pageHeader);
        this.bands.add(this.pageFooter);
        this.bands.add(this.lastPageFooter);
        this.bands.add(this.columnHeader);
        this.bands.add(this.columnFooter);
        this.bands.add(this.detail);
        if (this.groups != null && this.groups.length > 0) {
            for (int i = 0; i < this.groups.length; ++i) {
                JRFillGroup jRFillGroup = this.groups[i];
                this.bands.add(jRFillGroup.getGroupHeader());
                this.bands.add(jRFillGroup.getGroupFooter());
            }
        }
        this.initBandsNowEvaluationTimes();
    }

    private void initBandsNowEvaluationTimes() {
        JREvaluationTime[] jREvaluationTimeArray;
        if (this.groups == null) {
            jREvaluationTimeArray = new JREvaluationTime[]{};
        } else {
            int n;
            jREvaluationTimeArray = new JREvaluationTime[this.groups.length];
            for (n = 0; n < this.groups.length; ++n) {
                jREvaluationTimeArray[n] = JREvaluationTime.getGroupEvaluationTime(this.groups[n].getName());
            }
            for (n = 0; n < this.groups.length; ++n) {
                JRFillGroup jRFillGroup = this.groups[n];
                JRFillBand jRFillBand = (JRFillBand)jRFillGroup.getGroupFooter();
                for (int i = n; i < jREvaluationTimeArray.length; ++i) {
                    jRFillBand.addNowEvaluationTime(jREvaluationTimeArray[i]);
                }
            }
        }
        this.columnFooter.addNowEvaluationTime(JREvaluationTime.EVALUATION_TIME_COLUMN);
        this.pageFooter.addNowEvaluationTime(JREvaluationTime.EVALUATION_TIME_COLUMN);
        this.pageFooter.addNowEvaluationTime(JREvaluationTime.EVALUATION_TIME_PAGE);
        this.summary.addNowEvaluationTimes(jREvaluationTimeArray);
    }

    public JRStyledTextParser getStyledTextParser() {
        return this.styledTextParser;
    }

    public JasperPrint getJasperPrint() {
        return this.jasperPrint;
    }

    public JRReportFont getDefaultFont() {
        return this.defaultFont;
    }

    public JRStyle getDefaultStyle() {
        return this.defaultStyle;
    }

    protected boolean isSubreport() {
        return this.parentFiller != null;
    }

    protected boolean isInterrupted() {
        return this.isInterrupted || this.parentFiller != null && this.parentFiller.isInterrupted();
    }

    protected void setInterrupted(boolean bl) {
        this.isInterrupted = bl;
    }

    protected JRPrintPage getCurrentPage() {
        return this.printPage;
    }

    protected JRReportFont[] getFonts() {
        return this.fonts;
    }

    protected JRStyle[] getStyles() {
        return this.styles;
    }

    protected int getCurrentPageStretchHeight() {
        return this.printPageStretchHeight;
    }

    protected abstract void setPageHeight(int var1);

    public JasperPrint fill(Map hashMap, Connection connection) throws JRException {
        if (hashMap == null) {
            hashMap = new HashMap();
        }
        this.setConnectionParameterValue(hashMap, connection);
        return this.fill(hashMap);
    }

    protected void setConnectionParameterValue(Map map, Connection connection) {
        this.mainDataset.setConnectionParameterValue(map, connection);
    }

    public JasperPrint fill(Map hashMap, JRDataSource jRDataSource) throws JRException {
        if (hashMap == null) {
            hashMap = new HashMap();
        }
        this.setDatasourceParameterValue(hashMap, jRDataSource);
        return this.fill(hashMap);
    }

    protected void setDatasourceParameterValue(Map map, JRDataSource jRDataSource) {
        this.mainDataset.setDatasourceParameterValue(map, jRDataSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JasperPrint fill(Map hashMap) throws JRException {
        Object object;
        boolean bl;
        block18: {
            if (hashMap == null) {
                hashMap = new HashMap();
            }
            this.fillingThread = Thread.currentThread();
            bl = false;
            boolean bl2 = false;
            try {
                int n;
                this.setParameters(hashMap);
                bl2 = this.setClassLoader(hashMap);
                bl = this.setUrlHandlerFactory(hashMap);
                if (this.parentFiller != null) {
                    this.parentFiller.registerSubfiller(this);
                }
                this.jasperPrint.setName(this.name);
                this.jasperPrint.setPageWidth(this.pageWidth);
                this.jasperPrint.setPageHeight(this.pageHeight);
                this.jasperPrint.setOrientation(this.orientation);
                this.jasperPrint.setDefaultFont(this.defaultFont);
                if (this.fonts != null && this.fonts.length > 0) {
                    for (n = 0; n < this.fonts.length; ++n) {
                        try {
                            this.jasperPrint.addFont(this.fonts[n]);
                            continue;
                        }
                        catch (JRException jRException) {
                            // empty catch block
                        }
                    }
                }
                this.jasperPrint.setDefaultStyle(this.defaultStyle);
                if (this.styles != null && this.styles.length > 0) {
                    for (n = 0; n < this.styles.length; ++n) {
                        try {
                            this.jasperPrint.addStyle(this.styles[n]);
                            continue;
                        }
                        catch (JRException jRException) {
                            // empty catch block
                        }
                    }
                }
                this.setTextFieldsFormats();
                this.loadedSubreports = new HashMap();
                this.createBoundElemementMaps();
                this.mainDataset.start();
                this.fillReport();
                Set set = this.consolidatedStyles.keySet();
                object = set.iterator();
                while (object.hasNext()) {
                    JRStyle jRStyle = (JRStyle)object.next();
                    Map map = (Map)this.consolidatedStyles.get(jRStyle);
                    Collection collection = map.values();
                    Iterator iterator = collection.iterator();
                    while (iterator.hasNext()) {
                        this.jasperPrint.addStyle((JRStyle)iterator.next());
                    }
                }
                object = this.jasperPrint;
                Object var11_13 = null;
                this.mainDataset.closeDatasource();
                if (this.parentFiller != null) {
                    this.parentFiller.unregisterSubfiller(this);
                }
                this.fillingThread = null;
                this.killSubfillerThreads();
                if (!bl2) break block18;
            }
            catch (Throwable throwable) {
                block19: {
                    Object var11_14 = null;
                    this.mainDataset.closeDatasource();
                    if (this.parentFiller != null) {
                        this.parentFiller.unregisterSubfiller(this);
                    }
                    this.fillingThread = null;
                    this.killSubfillerThreads();
                    if (bl2) {
                        JRResourcesUtil.resetClassLoader();
                    }
                    if (!bl) break block19;
                    JRResourcesUtil.resetThreadURLHandlerFactory();
                }
                throw throwable;
            }
            JRResourcesUtil.resetClassLoader();
        }
        if (bl) {
            JRResourcesUtil.resetThreadURLHandlerFactory();
        }
        return object;
    }

    private void createBoundElemementMaps() {
        this.boundElements = new HashMap();
        this.createBoundElementMaps(JREvaluationTime.EVALUATION_TIME_REPORT);
        this.createBoundElementMaps(JREvaluationTime.EVALUATION_TIME_PAGE);
        this.createBoundElementMaps(JREvaluationTime.EVALUATION_TIME_COLUMN);
        if (this.groups != null) {
            for (int i = 0; i < this.groups.length; ++i) {
                this.createBoundElementMaps(JREvaluationTime.getGroupEvaluationTime(this.groups[i].getName()));
            }
        }
        Iterator iterator = this.bands.iterator();
        while (iterator.hasNext()) {
            JRFillBand jRFillBand = (JRFillBand)iterator.next();
            this.createBoundElementMaps(JREvaluationTime.getBandEvaluationTime(jRFillBand));
        }
    }

    private void createBoundElementMaps(JREvaluationTime jREvaluationTime) {
        BoundElementMap boundElementMap = new BoundElementMap();
        this.boundElements.put(jREvaluationTime, boundElementMap);
    }

    private void killSubfillerThreads() {
        if (this.subfillers != null && !this.subfillers.isEmpty()) {
            Iterator iterator = this.subfillers.iterator();
            while (iterator.hasNext()) {
                JRBaseFiller jRBaseFiller = (JRBaseFiller)iterator.next();
                if (jRBaseFiller.fillingThread == null) continue;
                jRBaseFiller.fillingThread.interrupt();
            }
        }
    }

    protected void setTextFieldsFormats() {
        for (int i = 0; i < this.formattedTextFields.size(); ++i) {
            ((JRFillTextField)this.formattedTextFields.get(i)).setFormat();
        }
        this.formattedTextFields.clear();
    }

    protected abstract void fillReport() throws JRException;

    protected void setParameters(Map map) throws JRException {
        this.virtualizer = (JRVirtualizer)map.get("REPORT_VIRTUALIZER");
        if (this.virtualizer != null) {
            this.fillContext.setUsingVirtualizer(true);
            this.fillContext.setPerPageBoundElements(true);
        }
        this.isPerPageBoundElements = this.fillContext.isPerPageBoundElements();
        this.setIgnorePagination(map);
        this.mainDataset.setParameterValues(map);
    }

    private boolean setClassLoader(Map map) {
        boolean bl;
        this.reportClassLoader = (ClassLoader)map.get("REPORT_CLASS_LOADER");
        boolean bl2 = bl = this.reportClassLoader != null;
        if (bl) {
            JRResourcesUtil.setThreadClassLoader(this.reportClassLoader);
        }
        return bl;
    }

    private boolean setUrlHandlerFactory(Map map) {
        boolean bl;
        this.urlHandlerFactory = (URLStreamHandlerFactory)map.get("REPORT_URL_HANDLER_FACTORY");
        boolean bl2 = bl = this.urlHandlerFactory != null;
        if (bl) {
            JRResourcesUtil.setThreadURLHandlerFactory(this.urlHandlerFactory);
        }
        return bl;
    }

    private void setIgnorePagination(Map map) {
        if (this.parentFiller == null) {
            Boolean bl = (Boolean)map.get("IS_IGNORE_PAGINATION");
            if (bl != null) {
                this.fillContext.setIgnorePagination(bl);
            } else {
                boolean bl2 = this.jasperReport.isIgnorePagination();
                this.fillContext.setIgnorePagination(bl2);
                map.put("IS_IGNORE_PAGINATION", bl2 ? Boolean.TRUE : Boolean.FALSE);
            }
        } else {
            boolean bl = this.fillContext.isIgnorePagination();
            map.put("IS_IGNORE_PAGINATION", bl ? Boolean.TRUE : Boolean.FALSE);
        }
        if (this.fillContext.isIgnorePagination()) {
            this.isTitleNewPage = false;
            this.isSummaryNewPage = false;
            if (this.groups != null) {
                for (int i = 0; i < this.groups.length; ++i) {
                    this.groups[i].setStartNewPage(false);
                    this.groups[i].setResetPageNumber(false);
                    this.groups[i].setStartNewColumn(false);
                }
            }
            this.setPageHeight(Integer.MAX_VALUE);
        }
    }

    protected Locale getLocale() {
        return this.mainDataset.locale;
    }

    protected void setParameter(String string, Object object) throws JRException {
        this.mainDataset.setParameter(string, object);
    }

    protected void setParameter(JRFillParameter jRFillParameter, Object object) throws JRException {
        this.mainDataset.setParameter(jRFillParameter, object);
    }

    protected boolean next() throws JRException {
        return this.mainDataset.next();
    }

    private void resolveBoundElements(Map map, byte by, JREvaluationTime jREvaluationTime) throws JRException {
        if (map != null) {
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                JRPrintElement jRPrintElement = (JRPrintElement)entry.getKey();
                JRFillElement jRFillElement = (JRFillElement)entry.getValue();
                jRFillElement.resolveElement(jRPrintElement, by, jREvaluationTime);
            }
        }
    }

    protected void resolveBoundElements(JREvaluationTime jREvaluationTime, byte by) throws JRException {
        BoundElementMap boundElementMap = (BoundElementMap)this.boundElements.get(jREvaluationTime);
        if (this.isPerPageBoundElements) {
            Map map = boundElementMap.getMap();
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                JRPrintPage jRPrintPage = (JRPrintPage)entry.getKey();
                jRPrintPage.getElements();
                Map map2 = (Map)entry.getValue();
                this.resolveBoundElements(map2, by, jREvaluationTime);
            }
            boundElementMap.clear();
        } else {
            this.resolveBoundElements(boundElementMap.getMap(), by, jREvaluationTime);
            boundElementMap.clear();
        }
    }

    protected void resolveReportBoundElements() throws JRException {
        this.resolveBoundElements(JREvaluationTime.EVALUATION_TIME_REPORT, (byte)3);
    }

    protected void resolvePageBoundElements(byte by) throws JRException {
        this.resolveBoundElements(JREvaluationTime.EVALUATION_TIME_PAGE, by);
    }

    protected void resolveColumnBoundElements(byte by) throws JRException {
        this.resolveBoundElements(JREvaluationTime.EVALUATION_TIME_COLUMN, by);
    }

    protected void resolveGroupBoundElements(byte by, boolean bl) throws JRException {
        if (this.groups != null && this.groups.length > 0) {
            for (int i = 0; i < this.groups.length; ++i) {
                JRFillGroup jRFillGroup = this.groups[i];
                if ((!jRFillGroup.hasChanged() || !jRFillGroup.isFooterPrinted()) && !bl) continue;
                String string = jRFillGroup.getName();
                this.resolveBoundElements(JREvaluationTime.getGroupEvaluationTime(string), by);
            }
        }
    }

    protected JRPrintPage newPage() {
        Serializable serializable;
        if (this.virtualizer != null) {
            JRVirtualPrintPage jRVirtualPrintPage = new JRVirtualPrintPage(this.jasperPrint, this.virtualizer, this.fillContext.getVirtualizationContext());
            JRBaseFiller.addIdentityDataProviders(jRVirtualPrintPage, this);
            serializable = jRVirtualPrintPage;
        } else {
            serializable = new JRBasePrintPage();
        }
        return serializable;
    }

    protected Object getVariableValue(String string) {
        return this.mainDataset.getVariableValue(string);
    }

    protected void resolveBandBoundElements(JRFillBand jRFillBand, byte by) throws JRException {
        this.resolveBoundElements(JREvaluationTime.getBandEvaluationTime(jRFillBand), by);
    }

    protected void addVariableCalculationReq(String string, byte by) {
        this.mainDataset.addVariableCalculationReq(string, by);
    }

    public void cancelFill() throws JRException {
        Thread thread;
        if (!this.fillContext.cancelRunningQuery() && (thread = this.fillingThread) != null) {
            thread.interrupt();
        }
    }

    protected void registerSubfiller(JRBaseFiller jRBaseFiller) {
        if (this.subfillers == null) {
            this.subfillers = new HashSet();
        }
        if (this.subfillers.add(jRBaseFiller) && this.fillContext.isUsingVirtualizer()) {
            jRBaseFiller.identityPages = new ArrayList();
            JRVirtualPrintPage jRVirtualPrintPage = (JRVirtualPrintPage)this.fillContext.getPrintPage();
            jRBaseFiller.identityPages.add(jRVirtualPrintPage);
            JRBaseFiller.addIdentityDataProviders(jRVirtualPrintPage, jRBaseFiller);
        }
    }

    protected void unregisterSubfiller(JRBaseFiller jRBaseFiller) {
        if (this.subfillers != null && this.subfillers.remove(jRBaseFiller) && this.fillContext.isUsingVirtualizer()) {
            this.removeIdentityDataProviders(jRBaseFiller);
        }
    }

    private static void addIdentityDataProviders(JRVirtualPrintPage jRVirtualPrintPage, JRBaseFiller jRBaseFiller) {
        jRVirtualPrintPage.addIdentityDataProvider(jRBaseFiller);
        if (jRBaseFiller.subfillers != null) {
            Iterator iterator = jRBaseFiller.subfillers.iterator();
            while (iterator.hasNext()) {
                JRBaseFiller jRBaseFiller2 = (JRBaseFiller)iterator.next();
                jRBaseFiller2.identityPages.add(jRVirtualPrintPage);
                JRBaseFiller.addIdentityDataProviders(jRVirtualPrintPage, jRBaseFiller2);
            }
        }
    }

    private void removeIdentityDataProviders(JRBaseFiller jRBaseFiller) {
        if (jRBaseFiller.identityPages != null) {
            Iterator iterator = jRBaseFiller.identityPages.iterator();
            while (iterator.hasNext()) {
                JRVirtualPrintPage jRVirtualPrintPage = (JRVirtualPrintPage)iterator.next();
                jRVirtualPrintPage.removeIdentityDataProvider(jRBaseFiller);
            }
            jRBaseFiller.identityPages = null;
        }
    }

    protected void addPage(JRPrintPage jRPrintPage) {
        if (!this.isSubreport()) {
            this.jasperPrint.addPage(jRPrintPage);
            this.fillContext.setPrintPage(jRPrintPage);
        }
    }

    protected void addPageIdentityDataProvider() {
        JRVirtualPrintPage.IdentityDataProvider identityDataProvider = PageIdentityDataProvider.getIdentityDataProvider(this.printPage);
        JRVirtualPrintPage jRVirtualPrintPage = (JRVirtualPrintPage)this.fillContext.getPrintPage();
        jRVirtualPrintPage.addIdentityDataProvider(identityDataProvider);
    }

    protected void removePageIdentityDataProvider() {
        JRVirtualPrintPage.IdentityDataProvider identityDataProvider = PageIdentityDataProvider.removeIdentityDataProvider(this.printPage);
        if (identityDataProvider != null) {
            ((JRVirtualPrintPage)this.fillContext.getPrintPage()).removeIdentityDataProvider(identityDataProvider);
        }
    }

    protected Object evaluateExpression(JRExpression jRExpression, byte by) throws JRException {
        return this.mainDataset.calculator.evaluate(jRExpression, by);
    }

    private void createDatasets(JRFillObjectFactory jRFillObjectFactory) throws JRException {
        this.datasetMap = new HashMap();
        JRDataset[] jRDatasetArray = this.jasperReport.getDatasets();
        if (jRDatasetArray != null && jRDatasetArray.length > 0) {
            for (int i = 0; i < jRDatasetArray.length; ++i) {
                JRFillDataset jRFillDataset = jRFillObjectFactory.getDataset(jRDatasetArray[i]);
                jRFillDataset.createCalculator(this.jasperReport);
                jRFillDataset.initScriptlet();
                this.datasetMap.put(jRDatasetArray[i].getName(), jRFillDataset);
            }
        }
    }

    private void initDatasets(JRFillObjectFactory jRFillObjectFactory) {
        Iterator iterator = this.datasetMap.values().iterator();
        while (iterator.hasNext()) {
            JRFillDataset jRFillDataset = (JRFillDataset)iterator.next();
            jRFillDataset.inheritFromMain();
            jRFillDataset.initElementDatasets(jRFillObjectFactory);
        }
    }

    protected byte getWhenResourceMissingType() {
        return this.mainDataset.whenResourceMissingType;
    }

    protected JasperReport getJasperReport() {
        return this.jasperReport;
    }

    protected boolean isBandOverFlowAllowed() {
        return this.bandOverFlowAllowed;
    }

    protected void setBandOverFlowAllowed(boolean bl) {
        this.bandOverFlowAllowed = bl;
    }

    protected int getMasterColumnCount() {
        JRBaseFiller jRBaseFiller = this.parentFiller;
        int n = 1;
        while (jRBaseFiller != null) {
            n *= jRBaseFiller.columnCount;
            jRBaseFiller = jRBaseFiller.parentFiller;
        }
        return n;
    }

    public JRFillDataset getMainDataset() {
        return this.mainDataset;
    }

    protected void addBoundElement(JRFillElement jRFillElement, JRPrintElement jRPrintElement, byte by, JRGroup jRGroup, JRFillBand jRFillBand) {
        JREvaluationTime jREvaluationTime = JREvaluationTime.getEvaluationTime(by, jRGroup, jRFillBand);
        this.addBoundElement(jRFillElement, jRPrintElement, jREvaluationTime);
    }

    protected void addBoundElement(JRFillElement jRFillElement, JRPrintElement jRPrintElement, JREvaluationTime jREvaluationTime) {
        BoundElementMap boundElementMap = (BoundElementMap)this.boundElements.get(jREvaluationTime);
        boundElementMap.put(jRPrintElement, jRFillElement);
    }

    public JRVirtualPrintPage.ObjectIDPair[] getIdentityData(JRVirtualPrintPage jRVirtualPrintPage) {
        HashMap hashMap = new HashMap();
        ArrayList<JRVirtualPrintPage.ObjectIDPair> arrayList = new ArrayList<JRVirtualPrintPage.ObjectIDPair>();
        JRVirtualPrintPage.ObjectIDPair[] objectIDPairArray = this.boundElements.values().iterator();
        while (objectIDPairArray.hasNext()) {
            BoundElementMap boundElementMap = (BoundElementMap)objectIDPairArray.next();
            Map map = boundElementMap.getMap(jRVirtualPrintPage);
            if (map == null || map.isEmpty()) continue;
            HashMap hashMap2 = new HashMap();
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Object k = entry.getKey();
                Integer n = (Integer)hashMap.get(k);
                if (n == null) {
                    JRVirtualPrintPage.ObjectIDPair objectIDPair = new JRVirtualPrintPage.ObjectIDPair(k);
                    arrayList.add(objectIDPair);
                    n = new Integer(objectIDPair.getIdentity());
                    hashMap.put(k, n);
                }
                hashMap2.put(n, entry.getValue());
            }
            boundElementMap.putMap(jRVirtualPrintPage, hashMap2);
        }
        objectIDPairArray = null;
        if (!arrayList.isEmpty()) {
            objectIDPairArray = new JRVirtualPrintPage.ObjectIDPair[arrayList.size()];
            arrayList.toArray(objectIDPairArray);
        }
        return objectIDPairArray;
    }

    public void setIdentityData(JRVirtualPrintPage jRVirtualPrintPage, JRVirtualPrintPage.ObjectIDPair[] objectIDPairArray) {
        if (objectIDPairArray == null || objectIDPairArray.length == 0) {
            return;
        }
        Iterator iterator = this.boundElements.values().iterator();
        while (iterator.hasNext()) {
            BoundElementMap boundElementMap = (BoundElementMap)iterator.next();
            Map map = boundElementMap.getMap(jRVirtualPrintPage);
            if (map == null || map.isEmpty()) continue;
            HashMap hashMap = new HashMap();
            for (int i = 0; i < objectIDPairArray.length; ++i) {
                JRVirtualPrintPage.ObjectIDPair objectIDPair = objectIDPairArray[i];
                Integer n = new Integer(objectIDPair.getIdentity());
                Object v = map.get(n);
                if (v == null) continue;
                hashMap.put(objectIDPair.getObject(), v);
            }
            boundElementMap.putMap(jRVirtualPrintPage, hashMap);
        }
    }

    protected JRStyle getConditionalStyle(JRStyle jRStyle, String string) {
        JRStyle jRStyle2 = null;
        Map map = (Map)this.consolidatedStyles.get(jRStyle);
        if (map != null) {
            jRStyle2 = (JRStyle)map.get(string);
        }
        return jRStyle2;
    }

    protected void putConditionalStyle(JRStyle jRStyle, JRStyle jRStyle2) {
        HashMap<String, JRStyle> hashMap = (HashMap<String, JRStyle>)this.consolidatedStyles.get(jRStyle);
        if (hashMap == null) {
            hashMap = new HashMap<String, JRStyle>();
            this.consolidatedStyles.put(jRStyle, hashMap);
        }
        hashMap.put(jRStyle2.getName(), jRStyle2);
    }

    protected final boolean isEmpty(JRBand jRBand) {
        return jRBand == null || jRBand.getHeight() == 0 && (jRBand.getElements() == null || jRBand.getElements().length == 0) && jRBand.getPrintWhenExpression() == null;
    }

    protected static final class PageIdentityDataProvider
    implements JRVirtualPrintPage.IdentityDataProvider {
        private static final Map providers = new HashMap();
        private final JRPrintPage printPage;

        protected PageIdentityDataProvider(JRPrintPage jRPrintPage) {
            this.printPage = jRPrintPage;
        }

        public JRVirtualPrintPage.ObjectIDPair[] getIdentityData(JRVirtualPrintPage jRVirtualPrintPage) {
            return null;
        }

        public void setIdentityData(JRVirtualPrintPage jRVirtualPrintPage, JRVirtualPrintPage.ObjectIDPair[] objectIDPairArray) {
            if (objectIDPairArray != null && objectIDPairArray.length > 0) {
                HashMap<Integer, Object> hashMap = new HashMap<Integer, Object>();
                for (int i = 0; i < objectIDPairArray.length; ++i) {
                    hashMap.put(new Integer(objectIDPairArray[i].getIdentity()), objectIDPairArray[i].getObject());
                }
                ListIterator listIterator = this.printPage.getElements().listIterator();
                while (listIterator.hasNext()) {
                    Object e = listIterator.next();
                    Integer n = new Integer(System.identityHashCode(e));
                    Object v = hashMap.get(n);
                    if (v == null) continue;
                    listIterator.set(v);
                }
            }
        }

        public static JRVirtualPrintPage.IdentityDataProvider getIdentityDataProvider(JRPrintPage jRPrintPage) {
            JRVirtualPrintPage.IdentityDataProvider identityDataProvider = (JRVirtualPrintPage.IdentityDataProvider)providers.get(jRPrintPage);
            if (identityDataProvider == null) {
                identityDataProvider = new PageIdentityDataProvider(jRPrintPage);
                providers.put(jRPrintPage, identityDataProvider);
            }
            return identityDataProvider;
        }

        public static JRVirtualPrintPage.IdentityDataProvider removeIdentityDataProvider(JRPrintPage jRPrintPage) {
            JRVirtualPrintPage.IdentityDataProvider identityDataProvider = (JRVirtualPrintPage.IdentityDataProvider)providers.remove(jRPrintPage);
            return identityDataProvider;
        }
    }

    public class BoundElementMap {
        private static final long serialVersionUID = 10200L;
        private final Map map = new HashMap();

        BoundElementMap() {
        }

        public Object put(Object object, Object object2, JRPrintPage jRPrintPage) {
            HashMap<Object, Object> hashMap = (HashMap<Object, Object>)this.map.get(jRPrintPage);
            if (hashMap == null) {
                hashMap = new HashMap<Object, Object>();
                this.map.put(jRPrintPage, hashMap);
            }
            return hashMap.put(object, object2);
        }

        public Object put(Object object, Object object2) {
            if (JRBaseFiller.this.isPerPageBoundElements) {
                return this.put(object, object2, JRBaseFiller.this.fillContext.getPrintPage());
            }
            return this.map.put(object, object2);
        }

        public void clear() {
            this.map.clear();
        }

        public Map getMap() {
            return this.map;
        }

        public Map getMap(JRPrintPage jRPrintPage) {
            return (Map)this.map.get(jRPrintPage);
        }

        public Map putMap(JRPrintPage jRPrintPage, Map map) {
            return this.map.put(jRPrintPage, map);
        }
    }
}

