/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRVirtualizable;
import net.sf.jasperreports.engine.JRVirtualizer;
import org.apache.commons.collections.LRUMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class JRAbstractLRUVirtualizer
implements JRVirtualizer {
    private static final Log log = LogFactory.getLog((Class)(class$net$sf$jasperreports$engine$fill$JRAbstractLRUVirtualizer == null ? (class$net$sf$jasperreports$engine$fill$JRAbstractLRUVirtualizer = JRAbstractLRUVirtualizer.class$("net.sf.jasperreports.engine.fill.JRAbstractLRUVirtualizer")) : class$net$sf$jasperreports$engine$fill$JRAbstractLRUVirtualizer));
    protected final Cache pagedIn;
    protected final HashMap pagedOut;
    protected JRVirtualizable lastObject;
    protected boolean readOnly;
    static /* synthetic */ Class class$net$sf$jasperreports$engine$fill$JRAbstractLRUVirtualizer;

    protected JRAbstractLRUVirtualizer(int n) {
        this.pagedIn = new Cache(n, this);
        this.pagedOut = new HashMap();
        this.lastObject = null;
        this.readOnly = false;
    }

    public void setReadOnly(boolean bl) {
        this.readOnly = bl;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void registerObject(JRVirtualizable jRVirtualizable) {
        Object object = this.pagedIn.put(jRVirtualizable.getUID(), jRVirtualizable);
        if (object != null) {
            this.pagedIn.put(jRVirtualizable.getUID(), object);
            throw new IllegalStateException("Wrong object stored with UID \"" + jRVirtualizable.getUID() + "\"");
        }
        this.lastObject = jRVirtualizable;
    }

    public void deregisterObject(JRVirtualizable jRVirtualizable) {
        String string = jRVirtualizable.getUID();
        Object object = this.pagedIn.remove(string);
        if (object != null) {
            if (object != jRVirtualizable) {
                this.pagedIn.put(string, object);
                throw new IllegalStateException("Wrong object stored with UID \"" + jRVirtualizable.getUID() + "\"");
            }
        } else {
            object = this.pagedOut.remove(string);
            if (object != null && object != jRVirtualizable) {
                this.pagedOut.put(string, object);
                throw new IllegalStateException("Wrong object stored with UID \"" + jRVirtualizable.getUID() + "\"");
            }
        }
    }

    public void touch(JRVirtualizable jRVirtualizable) {
        if (this.lastObject != jRVirtualizable) {
            this.lastObject = (JRVirtualizable)this.pagedIn.get(jRVirtualizable.getUID());
        }
    }

    public void requestData(JRVirtualizable jRVirtualizable) {
        String string = jRVirtualizable.getUID();
        if (this.pagedOut.containsKey(string)) {
            try {
                this.pageIn(jRVirtualizable);
            }
            catch (IOException iOException) {
                log.error((Object)"Error devirtualizing object", (Throwable)iOException);
                throw new JRRuntimeException(iOException);
            }
            jRVirtualizable.afterInternalization();
            this.pagedOut.remove(string);
            this.pagedIn.put(string, jRVirtualizable);
            this.lastObject = jRVirtualizable;
        }
    }

    public void clearData(JRVirtualizable jRVirtualizable) {
        String string = jRVirtualizable.getUID();
        if (this.pagedOut.containsKey(string)) {
            this.dispose(jRVirtualizable);
            this.pagedOut.remove(string);
        }
    }

    public void virtualizeData(JRVirtualizable jRVirtualizable) {
        String string = jRVirtualizable.getUID();
        if (!this.pagedOut.containsKey(string)) {
            jRVirtualizable.beforeExternalization();
            try {
                this.pageOut(jRVirtualizable);
            }
            catch (IOException iOException) {
                log.error((Object)"Error virtualizing object", (Throwable)iOException);
                throw new JRRuntimeException(iOException);
            }
            jRVirtualizable.removeVirtualData();
            this.pagedOut.put(string, jRVirtualizable);
        }
    }

    protected void finalize() throws Throwable {
        this.cleanup();
        super.finalize();
    }

    protected final void writeData(JRVirtualizable jRVirtualizable, OutputStream outputStream) throws JRRuntimeException {
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
            objectOutputStream.writeObject(jRVirtualizable.getIdentityData());
            objectOutputStream.writeObject(jRVirtualizable.getVirtualData());
            objectOutputStream.flush();
        }
        catch (IOException iOException) {
            log.error((Object)"Error virtualizing object", (Throwable)iOException);
            throw new JRRuntimeException(iOException);
        }
    }

    protected final void readData(JRVirtualizable jRVirtualizable, InputStream inputStream) throws JRRuntimeException {
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
            jRVirtualizable.setIdentityData(objectInputStream.readObject());
            jRVirtualizable.setVirtualData(objectInputStream.readObject());
        }
        catch (IOException iOException) {
            log.error((Object)"Error devirtualizing object", (Throwable)iOException);
            throw new JRRuntimeException(iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            log.error((Object)"Error devirtualizing object", (Throwable)classNotFoundException);
            throw new JRRuntimeException(classNotFoundException);
        }
    }

    protected abstract void pageOut(JRVirtualizable var1) throws IOException;

    protected abstract void pageIn(JRVirtualizable var1) throws IOException;

    protected abstract void dispose(JRVirtualizable var1);

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected static class Cache
    extends LRUMap {
        private static final long serialVersionUID = 10200L;
        private final JRVirtualizer virt;

        Cache(int n, JRVirtualizer jRVirtualizer) {
            super(n);
            this.virt = jRVirtualizer;
        }

        protected void processRemovedLRU(Object object, Object object2) {
            this.virt.virtualizeData((JRVirtualizable)object2);
        }
    }
}

