/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.fill.AsynchronousFilllListener;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JRFiller;

public class AsynchronousFillHandle {
    protected final JasperReport jasperReport;
    protected final Map parameters;
    protected final JRDataSource dataSource;
    protected final Connection conn;
    protected final JRBaseFiller filler;
    protected final List listeners;
    protected Thread fillThread;
    protected boolean started = false;
    protected boolean running = false;
    protected boolean cancelled = false;
    protected final Object lock;
    protected Integer priority = null;

    protected AsynchronousFillHandle(JasperReport jasperReport, Map map, JRDataSource jRDataSource) throws JRException {
        this(jasperReport, map, jRDataSource, null);
    }

    protected AsynchronousFillHandle(JasperReport jasperReport, Map map, Connection connection) throws JRException {
        this(jasperReport, map, null, connection);
    }

    protected AsynchronousFillHandle(JasperReport jasperReport, Map map) throws JRException {
        this(jasperReport, map, null, null);
    }

    protected AsynchronousFillHandle(JasperReport jasperReport, Map map, JRDataSource jRDataSource, Connection connection) throws JRException {
        this.jasperReport = jasperReport;
        this.parameters = map;
        this.dataSource = jRDataSource;
        this.conn = connection;
        this.filler = JRFiller.createFiller(jasperReport);
        this.listeners = new ArrayList();
        this.lock = this;
    }

    public void addListener(AsynchronousFilllListener asynchronousFilllListener) {
        this.listeners.add(asynchronousFilllListener);
    }

    public boolean removeListener(AsynchronousFilllListener asynchronousFilllListener) {
        return this.listeners.remove(asynchronousFilllListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startFill() {
        Object object = this.lock;
        synchronized (object) {
            if (this.started) {
                throw new IllegalStateException("Fill already started.");
            }
            this.started = true;
        }
        this.fillThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                Object object;
                Object object2 = AsynchronousFillHandle.this.lock;
                synchronized (object2) {
                    AsynchronousFillHandle.this.running = true;
                }
                try {
                    try {
                        object2 = AsynchronousFillHandle.this.conn != null ? AsynchronousFillHandle.this.filler.fill(AsynchronousFillHandle.this.parameters, AsynchronousFillHandle.this.conn) : (AsynchronousFillHandle.this.dataSource != null ? AsynchronousFillHandle.this.filler.fill(AsynchronousFillHandle.this.parameters, AsynchronousFillHandle.this.dataSource) : AsynchronousFillHandle.this.filler.fill(AsynchronousFillHandle.this.parameters));
                        AsynchronousFillHandle.this.notifyFinish((JasperPrint)object2);
                    }
                    catch (Exception exception) {
                        Object object3 = AsynchronousFillHandle.this.lock;
                        synchronized (object3) {
                            if (AsynchronousFillHandle.this.cancelled) {
                                AsynchronousFillHandle.this.notifyCancel();
                            } else {
                                AsynchronousFillHandle.this.notifyError(exception);
                            }
                        }
                        Object var5_4 = null;
                        Object object4 = AsynchronousFillHandle.this.lock;
                        synchronized (object4) {
                            AsynchronousFillHandle.this.running = false;
                            return;
                        }
                    }
                    Object var5_3 = null;
                    object = AsynchronousFillHandle.this.lock;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    Object object5 = AsynchronousFillHandle.this.lock;
                    synchronized (object5) {
                        AsynchronousFillHandle.this.running = false;
                        throw throwable;
                    }
                }
                synchronized (object) {
                    AsynchronousFillHandle.this.running = false;
                    return;
                }
            }
        });
        if (this.priority != null) {
            this.fillThread.setPriority(this.priority);
        }
        this.fillThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancellFill() throws JRException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.running) {
                throw new IllegalStateException("Fill not running.");
            }
            this.filler.cancelFill();
            this.cancelled = true;
        }
    }

    protected void notifyFinish(JasperPrint jasperPrint) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            AsynchronousFilllListener asynchronousFilllListener = (AsynchronousFilllListener)iterator.next();
            asynchronousFilllListener.reportFinished(jasperPrint);
        }
    }

    protected void notifyCancel() {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            AsynchronousFilllListener asynchronousFilllListener = (AsynchronousFilllListener)iterator.next();
            asynchronousFilllListener.reportCancelled();
        }
    }

    protected void notifyError(Throwable throwable) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            AsynchronousFilllListener asynchronousFilllListener = (AsynchronousFilllListener)iterator.next();
            asynchronousFilllListener.reportFillError(throwable);
        }
    }

    public static AsynchronousFillHandle createHandle(JasperReport jasperReport, Map map, JRDataSource jRDataSource) throws JRException {
        AsynchronousFillHandle asynchronousFillHandle = new AsynchronousFillHandle(jasperReport, map, jRDataSource);
        return asynchronousFillHandle;
    }

    public static AsynchronousFillHandle createHandle(JasperReport jasperReport, Map map, Connection connection) throws JRException {
        AsynchronousFillHandle asynchronousFillHandle = new AsynchronousFillHandle(jasperReport, map, connection);
        return asynchronousFillHandle;
    }

    public static AsynchronousFillHandle createHandle(JasperReport jasperReport, Map map) throws JRException {
        AsynchronousFillHandle asynchronousFillHandle = new AsynchronousFillHandle(jasperReport, map);
        return asynchronousFillHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPriority(int n) {
        Object object = this.lock;
        synchronized (object) {
            this.priority = new Integer(n);
            if (this.fillThread != null) {
                this.fillThread.setPriority(n);
            }
        }
    }
}

