/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextLayout;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.StringTokenizer;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.engine.util.MaxFontSizeFinder;

public class TextRenderer {
    public static final FontRenderContext LINE_BREAK_FONT_RENDER_CONTEXT = new FontRenderContext(null, true, true);
    private Graphics2D grx = null;
    private int x = 0;
    private int y = 0;
    private int topPadding = 0;
    private int leftPadding = 0;
    private float formatWidth = 0.0f;
    private float verticalOffset = 0.0f;
    private float lineSpacingFactor = 0.0f;
    private float leadingOffset = 0.0f;
    private float textHeight = 0.0f;
    private float drawPosY = 0.0f;
    private float drawPosX = 0.0f;
    private boolean isMaxHeightReached = false;
    private byte horizontalAlignment = 0;
    private int fontSize = 0;
    private MaxFontSizeFinder maxFontSizeFinder = null;

    public void render(Graphics2D graphics2D, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, float f, byte by, byte by2, float f2, float f3, int n9, boolean bl, JRStyledText jRStyledText, String string) {
        this.initialize(graphics2D, n, n2, n3, n4, n5, n6, n7, n8, f, by, by2, f2, f3, n9, bl);
        AttributedCharacterIterator attributedCharacterIterator = jRStyledText.getAttributedString().getIterator();
        int n10 = 0;
        int n11 = 0;
        String string2 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n", true);
        while (stringTokenizer.hasMoreTokens() && !this.isMaxHeightReached) {
            String string3 = stringTokenizer.nextToken();
            if ("\n".equals(string3)) {
                this.renderParagraph(attributedCharacterIterator, n11, string2);
                n11 = n10;
                string2 = null;
            } else {
                n11 = n10;
                string2 = string3;
            }
            n10 += string3.length();
        }
        if (!this.isMaxHeightReached && n11 < string.length()) {
            this.renderParagraph(attributedCharacterIterator, n11, string2);
        }
    }

    private void initialize(Graphics2D graphics2D, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, float f, byte by, byte by2, float f2, float f3, int n9, boolean bl) {
        this.grx = graphics2D;
        this.horizontalAlignment = by;
        this.verticalOffset = 0.0f;
        switch (by2) {
            case 1: {
                this.verticalOffset = 0.0f;
                break;
            }
            case 2: {
                this.verticalOffset = ((float)(n4 - n5 - n7) - f) / 2.0f;
                break;
            }
            case 3: {
                this.verticalOffset = (float)(n4 - n5 - n7) - f;
                break;
            }
            default: {
                this.verticalOffset = 0.0f;
            }
        }
        this.lineSpacingFactor = f2;
        this.leadingOffset = f3;
        this.x = n;
        this.y = n2;
        this.topPadding = n5;
        this.leftPadding = n6;
        this.formatWidth = n3 - n6 - n8;
        this.formatWidth = this.formatWidth < 0.0f ? 0.0f : this.formatWidth;
        this.textHeight = f;
        this.drawPosY = 0.0f;
        this.drawPosX = 0.0f;
        this.isMaxHeightReached = false;
        this.fontSize = n9;
        this.maxFontSizeFinder = MaxFontSizeFinder.getInstance(bl);
    }

    private void renderParagraph(AttributedCharacterIterator attributedCharacterIterator, int n, String string) {
        AttributedCharacterIterator attributedCharacterIterator2 = null;
        attributedCharacterIterator2 = string == null ? new AttributedString(" ", new AttributedString(attributedCharacterIterator, n, n + 1).getIterator().getAttributes()).getIterator() : new AttributedString(attributedCharacterIterator, n, n + string.length()).getIterator();
        LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(attributedCharacterIterator2, LINE_BREAK_FONT_RENDER_CONTEXT);
        while (lineBreakMeasurer.getPosition() < attributedCharacterIterator2.getEndIndex() && !this.isMaxHeightReached) {
            int n2 = lineBreakMeasurer.getPosition();
            TextLayout textLayout = lineBreakMeasurer.nextLayout(this.formatWidth);
            AttributedString attributedString = new AttributedString(attributedCharacterIterator2, n2, n2 + textLayout.getCharacterCount());
            float f = this.lineSpacingFactor * (float)this.maxFontSizeFinder.findMaxFontSize(new AttributedString(attributedCharacterIterator2, n2, n2 + (textLayout = new TextLayout(attributedString.getIterator(), LINE_BREAK_FONT_RENDER_CONTEXT)).getCharacterCount()).getIterator(), this.fontSize);
            if (this.drawPosY + f <= this.textHeight) {
                this.drawPosY += f;
                switch (this.horizontalAlignment) {
                    case 4: {
                        this.drawPosX = textLayout.isLeftToRight() ? 0.0f : this.formatWidth - textLayout.getAdvance();
                        if (lineBreakMeasurer.getPosition() >= attributedCharacterIterator2.getEndIndex()) break;
                        textLayout = textLayout.getJustifiedLayout(this.formatWidth);
                        break;
                    }
                    case 3: {
                        this.drawPosX = this.formatWidth - textLayout.getAdvance();
                        break;
                    }
                    case 2: {
                        this.drawPosX = (this.formatWidth - textLayout.getAdvance()) / 2.0f;
                        break;
                    }
                    default: {
                        this.drawPosX = 0.0f;
                    }
                }
                this.draw(textLayout);
                continue;
            }
            this.isMaxHeightReached = true;
        }
    }

    public void draw(TextLayout textLayout) {
        textLayout.draw(this.grx, this.drawPosX + (float)this.x + (float)this.leftPadding, this.drawPosY + (float)this.y + (float)this.topPadding + this.verticalOffset + this.leadingOffset);
    }
}

