/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.awt.Color;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.engine.JRBox;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRPrintLine;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.export.JRExporterGridCell;
import net.sf.jasperreports.engine.export.JRGridLayout;
import net.sf.jasperreports.engine.export.JRXlsAbstractExporter;
import net.sf.jasperreports.engine.util.JRStringUtil;
import net.sf.jasperreports.engine.util.JRStyledText;
import org.apache.commons.collections.ReferenceMap;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.hssf.util.Region;

public class JRXlsExporter
extends JRXlsAbstractExporter {
    private static Map hssfColorsCache = new ReferenceMap();
    protected List loadedCellStyles = new ArrayList();
    protected HSSFWorkbook workbook = null;
    protected HSSFSheet sheet = null;
    protected HSSFRow row = null;
    protected HSSFCell cell = null;
    protected HSSFCellStyle emptyCellStyle = null;
    protected short whiteIndex = new HSSFColor.WHITE().getIndex();
    protected short blackIndex = new HSSFColor.BLACK().getIndex();
    protected short backgroundMode = 1;

    protected void setBackground() {
        if (!this.isWhitePageBackground) {
            this.backgroundMode = 0;
        }
    }

    protected void openWorkbook(OutputStream outputStream) {
        this.workbook = new HSSFWorkbook();
        this.emptyCellStyle = this.workbook.createCellStyle();
        this.emptyCellStyle.setFillForegroundColor(new HSSFColor.WHITE().getIndex());
        this.emptyCellStyle.setFillPattern(this.backgroundMode);
    }

    protected void createSheet(String string) {
        this.sheet = this.workbook.createSheet(string);
    }

    protected void closeWorkbook(OutputStream outputStream) throws JRException {
        try {
            this.workbook.write(outputStream);
        }
        catch (IOException iOException) {
            throw new JRException("Error generating XLS report : " + this.jasperPrint.getName(), iOException);
        }
    }

    protected void setColumnWidth(short s, short s2) {
        this.sheet.setColumnWidth(s, s2);
    }

    protected void setRowHeight(int n, int n2) {
        this.row = this.sheet.getRow((int)((short)n));
        if (this.row == null) {
            this.row = this.sheet.createRow((int)((short)n));
        }
        this.row.setHeightInPoints((float)((short)n2));
    }

    protected void setCell(int n, int n2) {
        HSSFCell hSSFCell = this.row.getCell((short)n);
        if (hSSFCell == null) {
            hSSFCell = this.row.createCell((short)n);
            hSSFCell.setCellStyle(this.emptyCellStyle);
        }
    }

    protected void addBlankCell(JRExporterGridCell jRExporterGridCell, int n, int n2) {
        this.cell = this.row.createCell((short)n);
        short s = this.backgroundMode;
        short s2 = this.whiteIndex;
        if (jRExporterGridCell.getBackcolor() != null) {
            s = 1;
            s2 = JRXlsExporter.getNearestColor(jRExporterGridCell.getBackcolor()).getIndex();
        }
        short s3 = this.blackIndex;
        if (jRExporterGridCell.getForecolor() != null) {
            s3 = JRXlsExporter.getNearestColor(jRExporterGridCell.getForecolor()).getIndex();
        }
        HSSFCellStyle hSSFCellStyle = this.getLoadedCellStyle(s, s2, (short)1, (short)0, (short)0, this.getLoadedFont(this.getDefaultFont(), s3), jRExporterGridCell);
        this.cell.setCellStyle(hSSFCellStyle);
    }

    protected void exportLine(JRPrintLine jRPrintLine, JRExporterGridCell jRExporterGridCell, int n, int n2) {
        short s = JRXlsExporter.getNearestColor(jRPrintLine.getForecolor()).getIndex();
        HSSFFont hSSFFont = this.getLoadedFont(this.getDefaultFont(), s);
        HSSFCellStyle hSSFCellStyle = this.getLoadedCellStyle((short)1, s, (short)1, (short)0, (short)0, hSSFFont, jRExporterGridCell);
        this.createMergeRegion(jRExporterGridCell, n, n2, hSSFCellStyle);
        this.cell = this.row.createCell((short)n);
        this.cell.setEncoding((short)1);
        this.cell.setCellValue("");
        this.cell.setCellStyle(hSSFCellStyle);
    }

    protected void exportRectangle(JRPrintElement jRPrintElement, JRExporterGridCell jRExporterGridCell, int n, int n2) {
        short s = JRXlsExporter.getNearestColor(jRPrintElement.getForecolor()).getIndex();
        short s2 = this.backgroundMode;
        short s3 = this.whiteIndex;
        if (jRPrintElement.getMode() == 1) {
            s2 = 1;
            s3 = JRXlsExporter.getNearestColor(jRPrintElement.getBackcolor()).getIndex();
        } else if (jRExporterGridCell.getBackcolor() != null) {
            s2 = 1;
            s3 = JRXlsExporter.getNearestColor(jRExporterGridCell.getBackcolor()).getIndex();
        }
        HSSFFont hSSFFont = this.getLoadedFont(this.getDefaultFont(), s);
        HSSFCellStyle hSSFCellStyle = this.getLoadedCellStyle(s2, s3, (short)1, (short)0, (short)0, hSSFFont, jRExporterGridCell);
        this.createMergeRegion(jRExporterGridCell, n, n2, hSSFCellStyle);
        this.cell = this.row.createCell((short)n);
        this.cell.setEncoding((short)1);
        this.cell.setCellValue("");
        this.cell.setCellStyle(hSSFCellStyle);
    }

    protected void exportText(JRPrintText jRPrintText, JRExporterGridCell jRExporterGridCell, int n, int n2) {
        JRStyledText jRStyledText = this.getStyledText(jRPrintText);
        if (jRStyledText == null) {
            return;
        }
        short s = JRXlsExporter.getNearestColor(jRPrintText.getForecolor()).getIndex();
        HSSFFont hSSFFont = this.getLoadedFont(jRPrintText, s);
        JRXlsAbstractExporter.TextAlignHolder textAlignHolder = JRXlsExporter.getTextAlignHolder(jRPrintText);
        short s2 = this.getHorizontalAlignment(textAlignHolder);
        short s3 = this.getVerticalAlignment(textAlignHolder);
        short s4 = this.getRotation(textAlignHolder);
        short s5 = this.backgroundMode;
        short s6 = this.whiteIndex;
        if (jRPrintText.getMode() == 1) {
            s5 = 1;
            s6 = JRXlsExporter.getNearestColor(jRPrintText.getBackcolor()).getIndex();
        } else if (jRExporterGridCell.getBackcolor() != null) {
            s5 = 1;
            s6 = JRXlsExporter.getNearestColor(jRExporterGridCell.getBackcolor()).getIndex();
        }
        HSSFCellStyle hSSFCellStyle = this.getLoadedCellStyle(s5, s6, s2, s3, s4, hSSFFont, jRExporterGridCell);
        this.createMergeRegion(jRExporterGridCell, n, n2, hSSFCellStyle);
        this.cell = this.row.createCell((short)n);
        this.cell.setEncoding((short)1);
        if (this.isAutoDetectCellType) {
            try {
                this.cell.setCellValue(Double.parseDouble(jRStyledText.getText()));
            }
            catch (NumberFormatException numberFormatException) {
                this.cell.setCellValue(JRStringUtil.replaceDosEOL(jRStyledText.getText()));
            }
        } else {
            this.cell.setCellValue(JRStringUtil.replaceDosEOL(jRStyledText.getText()));
        }
        this.cell.setCellStyle(hSSFCellStyle);
    }

    protected void createMergeRegion(JRExporterGridCell jRExporterGridCell, int n, int n2, HSSFCellStyle hSSFCellStyle) {
        if (jRExporterGridCell.colSpan > 1 || jRExporterGridCell.rowSpan > 1) {
            this.sheet.addMergedRegion(new Region(n2, (short)n, n2 + jRExporterGridCell.rowSpan - 1, (short)(n + jRExporterGridCell.colSpan - 1)));
            for (int i = 0; i < jRExporterGridCell.rowSpan; ++i) {
                HSSFRow hSSFRow = this.sheet.getRow(n2 + i);
                if (hSSFRow == null) {
                    hSSFRow = this.sheet.createRow(n2 + i);
                }
                for (int j = 0; j < jRExporterGridCell.colSpan; ++j) {
                    HSSFCell hSSFCell = hSSFRow.getCell((short)(n + j));
                    if (hSSFCell == null) {
                        hSSFCell = hSSFRow.createCell((short)(n + j));
                    }
                    hSSFCell.setCellStyle(hSSFCellStyle);
                }
            }
        }
    }

    private short getHorizontalAlignment(JRXlsAbstractExporter.TextAlignHolder textAlignHolder) {
        switch (textAlignHolder.horizontalAlignment) {
            case 3: {
                return 3;
            }
            case 2: {
                return 2;
            }
            case 4: {
                return 5;
            }
        }
        return 1;
    }

    private short getVerticalAlignment(JRXlsAbstractExporter.TextAlignHolder textAlignHolder) {
        switch (textAlignHolder.verticalAlignment) {
            case 3: {
                return 2;
            }
            case 2: {
                return 1;
            }
            case 4: {
                return 3;
            }
        }
        return 0;
    }

    private short getRotation(JRXlsAbstractExporter.TextAlignHolder textAlignHolder) {
        switch (textAlignHolder.rotation) {
            case 1: {
                return 90;
            }
            case 2: {
                return -90;
            }
        }
        return 0;
    }

    protected static HSSFColor getNearestColor(Color color) {
        HSSFColor hSSFColor = (HSSFColor)hssfColorsCache.get(color);
        if (hSSFColor == null) {
            Set set;
            Hashtable hashtable = HSSFColor.getTripletHash();
            if (hashtable != null && (set = hashtable.keySet()) != null && set.size() > 0) {
                Object var4_4 = null;
                HSSFColor hSSFColor2 = null;
                short[] sArray = null;
                int n = 0;
                int n2 = 999;
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    var4_4 = iterator.next();
                    hSSFColor2 = (HSSFColor)hashtable.get(var4_4);
                    sArray = hSSFColor2.getTriplet();
                    n = Math.abs(sArray[0] - color.getRed()) + Math.abs(sArray[1] - color.getGreen()) + Math.abs(sArray[2] - color.getBlue());
                    if (n >= n2) continue;
                    n2 = n;
                    hSSFColor = hSSFColor2;
                }
            }
            hssfColorsCache.put(color, hSSFColor);
        }
        return hSSFColor;
    }

    protected HSSFFont getLoadedFont(JRFont jRFont, short s) {
        HSSFFont hSSFFont = null;
        String string = jRFont.getFontName();
        if (this.fontMap != null && this.fontMap.containsKey(string)) {
            string = (String)this.fontMap.get(string);
        }
        for (int i = 0; i < this.loadedFonts.size(); ++i) {
            HSSFFont hSSFFont2 = (HSSFFont)this.loadedFonts.get(i);
            if (!hSSFFont2.getFontName().equals(string) || hSSFFont2.getColor() != s || hSSFFont2.getFontHeightInPoints() != (short)jRFont.getFontSize() || !(hSSFFont2.getUnderline() == 1 ? jRFont.isUnderline() : !jRFont.isUnderline()) || hSSFFont2.getStrikeout() != jRFont.isStrikeThrough() || !(hSSFFont2.getBoldweight() == 700 ? jRFont.isBold() : !jRFont.isBold()) || hSSFFont2.getItalic() != jRFont.isItalic()) continue;
            hSSFFont = hSSFFont2;
            break;
        }
        if (hSSFFont == null) {
            hSSFFont = this.workbook.createFont();
            hSSFFont.setFontName(string);
            hSSFFont.setColor(s);
            hSSFFont.setFontHeightInPoints((short)jRFont.getFontSize());
            if (jRFont.isUnderline()) {
                hSSFFont.setUnderline((byte)1);
            }
            if (jRFont.isStrikeThrough()) {
                hSSFFont.setStrikeout(true);
            }
            if (jRFont.isBold()) {
                hSSFFont.setBoldweight((short)700);
            }
            if (jRFont.isItalic()) {
                hSSFFont.setItalic(true);
            }
            this.loadedFonts.add(hSSFFont);
        }
        return hSSFFont;
    }

    protected HSSFCellStyle getLoadedCellStyle(short s, short s2, short s3, short s4, short s5, HSSFFont hSSFFont, short s6, short s7, short s8, short s9, short s10, short s11, short s12, short s13) {
        HSSFCellStyle hSSFCellStyle = null;
        if (this.loadedCellStyles != null && this.loadedCellStyles.size() > 0) {
            HSSFCellStyle hSSFCellStyle2 = null;
            for (int i = 0; i < this.loadedCellStyles.size(); ++i) {
                hSSFCellStyle2 = (HSSFCellStyle)this.loadedCellStyles.get(i);
                if (hSSFCellStyle2.getFillPattern() != s || hSSFCellStyle2.getFillForegroundColor() != s2 || hSSFCellStyle2.getAlignment() != s3 || hSSFCellStyle2.getVerticalAlignment() != s4 || hSSFCellStyle2.getRotation() != s5 || hSSFCellStyle2.getFontIndex() != hSSFFont.getIndex() || hSSFCellStyle2.getBorderTop() != s6 || hSSFCellStyle2.getTopBorderColor() != s7 || hSSFCellStyle2.getBorderLeft() != s8 || hSSFCellStyle2.getLeftBorderColor() != s9 || hSSFCellStyle2.getBorderBottom() != s10 || hSSFCellStyle2.getBottomBorderColor() != s11 || hSSFCellStyle2.getBorderRight() != s12 || hSSFCellStyle2.getRightBorderColor() != s13) continue;
                hSSFCellStyle = hSSFCellStyle2;
                break;
            }
        }
        if (hSSFCellStyle == null) {
            hSSFCellStyle = this.workbook.createCellStyle();
            hSSFCellStyle.setFillForegroundColor(s2);
            hSSFCellStyle.setFillPattern(s);
            hSSFCellStyle.setAlignment(s3);
            hSSFCellStyle.setVerticalAlignment(s4);
            hSSFCellStyle.setRotation(s5);
            hSSFCellStyle.setFont(hSSFFont);
            hSSFCellStyle.setWrapText(true);
            hSSFCellStyle.setBorderTop(s6);
            hSSFCellStyle.setTopBorderColor(s7);
            hSSFCellStyle.setBorderLeft(s8);
            hSSFCellStyle.setLeftBorderColor(s9);
            hSSFCellStyle.setBorderBottom(s10);
            hSSFCellStyle.setBottomBorderColor(s11);
            hSSFCellStyle.setBorderRight(s12);
            hSSFCellStyle.setRightBorderColor(s13);
            this.loadedCellStyles.add(hSSFCellStyle);
        }
        return hSSFCellStyle;
    }

    protected HSSFCellStyle getLoadedCellStyle(short s, short s2, short s3, short s4, short s5, HSSFFont hSSFFont, JRExporterGridCell jRExporterGridCell) {
        short s6 = 0;
        short s7 = s2;
        short s8 = 0;
        short s9 = s2;
        short s10 = 0;
        short s11 = s2;
        short s12 = 0;
        short s13 = s2;
        JRBox jRBox = jRExporterGridCell.getBox();
        if (jRBox != null) {
            short s14 = jRExporterGridCell.getForecolor() == null ? this.blackIndex : JRXlsExporter.getNearestColor(jRExporterGridCell.getForecolor()).getIndex();
            s6 = JRXlsExporter.getBorder(jRBox.getTopBorder());
            s7 = jRBox.getTopBorderColor() == null ? s14 : JRXlsExporter.getNearestColor(jRBox.getTopBorderColor()).getIndex();
            s8 = JRXlsExporter.getBorder(jRBox.getLeftBorder());
            s9 = jRBox.getLeftBorderColor() == null ? s14 : JRXlsExporter.getNearestColor(jRBox.getLeftBorderColor()).getIndex();
            s10 = JRXlsExporter.getBorder(jRBox.getBottomBorder());
            s11 = jRBox.getBottomBorderColor() == null ? s14 : JRXlsExporter.getNearestColor(jRBox.getBottomBorderColor()).getIndex();
            s12 = JRXlsExporter.getBorder(jRBox.getRightBorder());
            s13 = jRBox.getRightBorderColor() == null ? s14 : JRXlsExporter.getNearestColor(jRBox.getRightBorderColor()).getIndex();
        }
        return this.getLoadedCellStyle(s, s2, s3, s4, s5, hSSFFont, s6, s7, s8, s9, s10, s11, s12, s13);
    }

    private static short getBorder(byte by) {
        short s = 0;
        switch (by) {
            case 4: {
                s = 3;
                break;
            }
            case 3: {
                s = 5;
                break;
            }
            case 2: {
                s = 5;
                break;
            }
            case 5: {
                s = 1;
                break;
            }
            case 0: {
                s = 0;
                break;
            }
            default: {
                s = 2;
            }
        }
        return s;
    }

    protected void exportImage(JRPrintImage jRPrintImage, JRExporterGridCell jRExporterGridCell, int n, int n2) {
    }

    protected JRGridLayout.ExporterElements getExporterElements() {
        return JRGridLayout.NO_IMAGES_EXPORTER;
    }

    protected void exportFrame(JRPrintFrame jRPrintFrame, JRExporterGridCell jRExporterGridCell, int n, int n2) {
        short s = this.backgroundMode;
        short s2 = this.whiteIndex;
        if (jRPrintFrame.getMode() == 1) {
            s = 1;
            s2 = JRXlsExporter.getNearestColor(jRPrintFrame.getBackcolor()).getIndex();
        }
        short s3 = JRXlsExporter.getNearestColor(jRPrintFrame.getForecolor()).getIndex();
        HSSFCellStyle hSSFCellStyle = this.getLoadedCellStyle(s, s2, (short)1, (short)0, (short)0, this.getLoadedFont(this.getDefaultFont(), s3), jRExporterGridCell);
        this.createMergeRegion(jRExporterGridCell, n, n2, hSSFCellStyle);
        this.cell = this.row.createCell((short)n);
        this.cell.setCellStyle(hSSFCellStyle);
    }
}

