/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintEllipse;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRPrintLine;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRPrintRectangle;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.base.JRBaseFont;
import net.sf.jasperreports.engine.base.JRBasePrintPage;
import net.sf.jasperreports.engine.export.JRExportProgressMonitor;
import net.sf.jasperreports.engine.export.JRExporterGridCell;
import net.sf.jasperreports.engine.export.JRGridLayout;
import net.sf.jasperreports.engine.export.JRXlsExporterParameter;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.engine.util.JRStyledTextParser;
import org.xml.sax.SAXException;

public abstract class JRXlsAbstractExporter
extends JRAbstractExporter {
    protected int pageHeight = 0;
    protected JRFont defaultFont = null;
    protected List loadedFonts = new ArrayList();
    protected boolean isOnePagePerSheet = false;
    protected boolean isRemoveEmptySpace = false;
    protected boolean isWhitePageBackground = true;
    protected boolean isAutoDetectCellType = true;
    protected String[] sheetNames = null;
    protected JRStyledTextParser styledTextParser = new JRStyledTextParser();
    protected JRExportProgressMonitor progressMonitor = null;
    protected int reportIndex = 0;
    protected Map fontMap = null;
    private int skippedRows = 0;

    protected JRFont getDefaultFont() {
        if (this.defaultFont == null) {
            this.defaultFont = this.jasperPrint.getDefaultFont();
            if (this.defaultFont == null) {
                this.defaultFont = new JRBaseFont();
            }
        }
        return this.defaultFont;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void exportReport() throws JRException {
        this.progressMonitor = (JRExportProgressMonitor)this.parameters.get(JRExporterParameter.PROGRESS_MONITOR);
        this.setOffset();
        try {
            this.setExportContext();
            this.setInput();
            if (!this.isModeBatch) {
                this.setPageRange();
            }
            this.setParameters();
            OutputStream outputStream = (OutputStream)this.parameters.get(JRExporterParameter.OUTPUT_STREAM);
            if (outputStream != null) {
                this.exportReportToStream(outputStream);
                return;
            }
            File file = (File)this.parameters.get(JRExporterParameter.OUTPUT_FILE);
            if (file == null) {
                String string = (String)this.parameters.get(JRExporterParameter.OUTPUT_FILE_NAME);
                if (string == null) throw new JRException("No output specified for the exporter.");
                file = new File(string);
            }
            try {
                try {
                    outputStream = new FileOutputStream(file);
                    this.exportReportToStream(outputStream);
                    outputStream.flush();
                }
                catch (IOException iOException) {
                    throw new JRException("Error trying to export to file : " + file, iOException);
                }
                Object var5_5 = null;
                if (outputStream == null) return;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                if (outputStream == null) throw throwable;
                try {
                    outputStream.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (IOException iOException) {}
            outputStream.close();
            return;
        }
        finally {
            this.resetExportContext();
        }
    }

    protected void setParameters() {
        Boolean bl;
        Boolean bl2;
        Boolean bl3;
        Boolean bl4 = (Boolean)this.parameters.get(JRXlsExporterParameter.IS_ONE_PAGE_PER_SHEET);
        if (bl4 != null) {
            this.isOnePagePerSheet = bl4;
        }
        if ((bl3 = (Boolean)this.parameters.get(JRXlsExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_ROWS)) != null) {
            this.isRemoveEmptySpace = bl3;
        }
        if ((bl2 = (Boolean)this.parameters.get(JRXlsExporterParameter.IS_WHITE_PAGE_BACKGROUND)) != null) {
            this.isWhitePageBackground = bl2;
            this.setBackground();
        }
        if ((bl = (Boolean)this.parameters.get(JRXlsExporterParameter.IS_AUTO_DETECT_CELL_TYPE)) != null) {
            this.isAutoDetectCellType = bl;
        }
        this.sheetNames = (String[])this.parameters.get(JRXlsExporterParameter.SHEET_NAMES);
        this.fontMap = (Map)this.parameters.get(JRExporterParameter.FONT_MAP);
    }

    protected abstract void setBackground();

    protected void exportReportToStream(OutputStream outputStream) throws JRException {
        this.openWorkbook(outputStream);
        this.reportIndex = 0;
        while (this.reportIndex < this.jasperPrintList.size()) {
            this.jasperPrint = (JasperPrint)this.jasperPrintList.get(this.reportIndex);
            this.defaultFont = null;
            List list = this.jasperPrint.getPages();
            if (list != null && list.size() > 0) {
                JRPrintPage jRPrintPage;
                if (this.isModeBatch) {
                    this.startPageIndex = 0;
                    this.endPageIndex = list.size() - 1;
                }
                if (this.isOnePagePerSheet) {
                    this.pageHeight = this.jasperPrint.getPageHeight();
                    for (int i = this.startPageIndex; i <= this.endPageIndex; ++i) {
                        if (Thread.currentThread().isInterrupted()) {
                            throw new JRException("Current thread interrupted.");
                        }
                        jRPrintPage = (JRPrintPage)list.get(i);
                        if (this.sheetNames != null && i < this.sheetNames.length) {
                            this.createSheet(this.sheetNames[i]);
                        } else {
                            this.createSheet("Page " + (i + 1));
                        }
                        this.exportPage(null, jRPrintPage);
                    }
                } else {
                    this.pageHeight = this.jasperPrint.getPageHeight() * (this.endPageIndex - this.startPageIndex + 1);
                    ArrayList<Integer> arrayList = new ArrayList<Integer>();
                    jRPrintPage = new JRBasePrintPage();
                    List list2 = null;
                    JRPrintElement jRPrintElement = null;
                    for (int i = this.startPageIndex; i <= this.endPageIndex; ++i) {
                        if (Thread.currentThread().isInterrupted()) {
                            throw new JRException("Current thread interrupted.");
                        }
                        JRPrintPage jRPrintPage2 = (JRPrintPage)list.get(i);
                        list2 = jRPrintPage2.getElements();
                        if (list2 == null || list2.size() <= 0) continue;
                        Iterator iterator = list2.iterator();
                        while (iterator.hasNext()) {
                            jRPrintElement = (JRPrintElement)iterator.next();
                            jRPrintPage.addElement(jRPrintElement);
                            arrayList.add(new Integer(jRPrintElement.getY() + this.jasperPrint.getPageHeight() * i));
                        }
                    }
                    this.createSheet(this.jasperPrint.getName());
                    this.exportPage(arrayList, jRPrintPage);
                }
            }
            ++this.reportIndex;
        }
        this.closeWorkbook(outputStream);
    }

    protected void exportPage(List list, JRPrintPage jRPrintPage) throws JRException {
        int n;
        JRGridLayout jRGridLayout = new JRGridLayout(jRPrintPage.getElements(), list, this.jasperPrint.getPageWidth(), this.pageHeight, this.globalOffsetX, this.globalOffsetY, this.getExporterElements(), true, true, false, null);
        JRExporterGridCell[][] jRExporterGridCellArray = jRGridLayout.getGrid();
        boolean[] blArray = jRGridLayout.getIsRowNotEmpty();
        List list2 = jRGridLayout.getXCuts();
        int n2 = 0;
        for (n = 1; n < list2.size(); ++n) {
            n2 = (Integer)list2.get(n) - (Integer)list2.get(n - 1);
            this.setColumnWidth((short)(n - 1), (short)(n2 * 43));
        }
        this.skippedRows = 0;
        for (n = 0; n < jRExporterGridCellArray.length; ++n) {
            int n3 = n - this.skippedRows;
            if (blArray[n] || !this.isRemoveEmptySpace) {
                JRExporterGridCell[] jRExporterGridCellArray2 = jRExporterGridCellArray[n];
                int n4 = 0;
                int n5 = 0;
                int n6 = JRGridLayout.getRowHeight(jRExporterGridCellArray2);
                this.setRowHeight(n3, n6);
                for (int i = 0; i < jRExporterGridCellArray2.length; ++i) {
                    this.setCell(i, n3);
                    JRExporterGridCell jRExporterGridCell = jRExporterGridCellArray2[i];
                    if (jRExporterGridCell.element != null) {
                        JRPrintElement jRPrintElement;
                        if (n4 > 0) {
                            if (n4 > 1) {
                                // empty if block
                            }
                            n4 = 0;
                            n5 = 0;
                        }
                        if ((jRPrintElement = jRExporterGridCell.element) instanceof JRPrintLine) {
                            this.exportLine((JRPrintLine)jRPrintElement, jRExporterGridCell, i, n3);
                        } else if (jRPrintElement instanceof JRPrintRectangle) {
                            this.exportRectangle(jRPrintElement, jRExporterGridCell, i, n3);
                        } else if (jRPrintElement instanceof JRPrintEllipse) {
                            this.exportRectangle(jRPrintElement, jRExporterGridCell, i, n3);
                        } else if (jRPrintElement instanceof JRPrintImage) {
                            this.exportImage((JRPrintImage)jRPrintElement, jRExporterGridCell, i, n3);
                        } else if (jRPrintElement instanceof JRPrintText) {
                            this.exportText((JRPrintText)jRPrintElement, jRExporterGridCell, i, n3);
                        } else if (jRPrintElement instanceof JRPrintFrame) {
                            this.exportFrame((JRPrintFrame)jRPrintElement, jRExporterGridCell, i, n);
                        }
                        i += jRExporterGridCell.colSpan - 1;
                        continue;
                    }
                    ++n4;
                    n5 += jRExporterGridCell.width;
                    this.addBlankCell(jRExporterGridCell, i, n3);
                }
                if (n4 <= 0 || n4 <= 1) continue;
                continue;
            }
            ++this.skippedRows;
        }
        if (this.progressMonitor != null) {
            this.progressMonitor.afterPageExport();
        }
    }

    protected JRStyledText getStyledText(JRPrintText jRPrintText) {
        JRStyledText jRStyledText = null;
        String string = jRPrintText.getText();
        if (string != null) {
            if (jRPrintText.isStyledText()) {
                try {
                    jRStyledText = this.styledTextParser.parse(null, string);
                }
                catch (SAXException sAXException) {
                    // empty catch block
                }
            }
            if (jRStyledText == null) {
                jRStyledText = new JRStyledText();
                jRStyledText.append(string);
                jRStyledText.addRun(new JRStyledText.Run(null, 0, string.length()));
            }
        }
        return jRStyledText;
    }

    protected static TextAlignHolder getTextAlignHolder(JRPrintText jRPrintText) {
        short s;
        short s2;
        short s3 = jRPrintText.getRotation();
        block0 : switch (jRPrintText.getRotation()) {
            case 1: {
                switch (jRPrintText.getHorizontalAlignment()) {
                    case 1: {
                        s2 = 3;
                        break;
                    }
                    case 2: {
                        s2 = 2;
                        break;
                    }
                    case 3: {
                        s2 = 1;
                        break;
                    }
                    case 4: {
                        s2 = 4;
                        break;
                    }
                    default: {
                        s2 = 3;
                    }
                }
                switch (jRPrintText.getVerticalAlignment()) {
                    case 1: {
                        s = 1;
                        break block0;
                    }
                    case 2: {
                        s = 2;
                        break block0;
                    }
                    case 3: {
                        s = 3;
                        break block0;
                    }
                }
                s = 1;
                break;
            }
            case 2: {
                switch (jRPrintText.getHorizontalAlignment()) {
                    case 1: {
                        s2 = 1;
                        break;
                    }
                    case 2: {
                        s2 = 2;
                        break;
                    }
                    case 3: {
                        s2 = 3;
                        break;
                    }
                    case 4: {
                        s2 = 4;
                        break;
                    }
                    default: {
                        s2 = 1;
                    }
                }
                switch (jRPrintText.getVerticalAlignment()) {
                    case 1: {
                        s = 3;
                        break block0;
                    }
                    case 2: {
                        s = 2;
                        break block0;
                    }
                    case 3: {
                        s = 1;
                        break block0;
                    }
                }
                s = 3;
                break;
            }
            default: {
                s = jRPrintText.getHorizontalAlignment();
                s2 = jRPrintText.getVerticalAlignment();
            }
        }
        return new TextAlignHolder(s, s2, s3);
    }

    protected abstract JRGridLayout.ExporterElements getExporterElements();

    protected abstract void openWorkbook(OutputStream var1) throws JRException;

    protected abstract void createSheet(String var1);

    protected abstract void closeWorkbook(OutputStream var1) throws JRException;

    protected abstract void setColumnWidth(short var1, short var2);

    protected abstract void setRowHeight(int var1, int var2) throws JRException;

    protected abstract void setCell(int var1, int var2);

    protected abstract void addBlankCell(JRExporterGridCell var1, int var2, int var3) throws JRException;

    protected abstract void exportText(JRPrintText var1, JRExporterGridCell var2, int var3, int var4) throws JRException;

    protected abstract void exportImage(JRPrintImage var1, JRExporterGridCell var2, int var3, int var4) throws JRException;

    protected abstract void exportRectangle(JRPrintElement var1, JRExporterGridCell var2, int var3, int var4) throws JRException;

    protected abstract void exportLine(JRPrintLine var1, JRExporterGridCell var2, int var3, int var4) throws JRException;

    protected abstract void exportFrame(JRPrintFrame var1, JRExporterGridCell var2, int var3, int var4) throws JRException;

    protected static class TextAlignHolder {
        public final short horizontalAlignment;
        public final short verticalAlignment;
        public final short rotation;

        public TextAlignHolder(short s, short s2, short s3) {
            this.horizontalAlignment = s;
            this.verticalAlignment = s2;
            this.rotation = s3;
        }
    }
}

