/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.JRExportProgressMonitor;
import net.sf.jasperreports.engine.export.JRTextExporterParameter;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.engine.util.JRStyledTextParser;
import org.xml.sax.SAXException;

public class JRTextExporter
extends JRAbstractExporter {
    protected int pageWidth;
    protected int pageHeight;
    protected int characterHeight;
    protected int characterWidth;
    protected JRExportProgressMonitor progressMonitor;
    protected Writer writer;
    char[][] pageData;
    protected String betweenPagesText;
    protected String lineSeparator;
    protected static final String systemLineSeparator = System.getProperty("line.separator");
    protected JRStyledTextParser styledTextParser = new JRStyledTextParser();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void exportReport() throws JRException {
        Comparable<Integer> comparable;
        Integer n;
        Integer n2;
        String string;
        this.progressMonitor = (JRExportProgressMonitor)this.parameters.get(JRExporterParameter.PROGRESS_MONITOR);
        this.setOffset();
        this.setInput();
        if (!this.isModeBatch) {
            this.setPageRange();
        }
        if ((string = (String)this.parameters.get(JRExporterParameter.CHARACTER_ENCODING)) == null) {
            string = "ISO-8859-1";
        }
        if ((n2 = (Integer)this.parameters.get(JRTextExporterParameter.CHARACTER_WIDTH)) != null) {
            this.characterWidth = n2;
            if (this.characterWidth < 0) {
                throw new JRException("Character width must be greater than 0");
            }
        } else {
            n = (Integer)this.parameters.get(JRTextExporterParameter.PAGE_WIDTH);
            if (n == null) throw new JRException("Character or page width must be specified");
            this.pageWidth = n;
            if (this.pageWidth <= 0) {
                throw new JRException("Page width must be greater than 0");
            }
        }
        if ((n = (Integer)this.parameters.get(JRTextExporterParameter.CHARACTER_HEIGHT)) != null) {
            this.characterHeight = n;
            if (this.characterHeight < 0) {
                throw new JRException("Character height must be greater than 0");
            }
        } else {
            comparable = (Integer)this.parameters.get(JRTextExporterParameter.PAGE_HEIGHT);
            if (comparable == null) throw new JRException("Character or page height must be specified");
            this.pageHeight = (Integer)comparable;
            if (this.pageHeight <= 0) {
                throw new JRException("Page height must be greater than 0");
            }
        }
        this.betweenPagesText = (String)this.parameters.get(JRTextExporterParameter.BETWEEN_PAGES_TEXT);
        if (this.betweenPagesText == null) {
            this.betweenPagesText = systemLineSeparator + systemLineSeparator;
        }
        this.lineSeparator = (String)this.parameters.get(JRTextExporterParameter.LINE_SEPARATOR);
        if (this.lineSeparator == null) {
            this.lineSeparator = systemLineSeparator;
        }
        if ((comparable = (StringBuffer)this.parameters.get(JRExporterParameter.OUTPUT_STRING_BUFFER)) != null) {
            try {
                try {
                    this.writer = new StringWriter();
                    this.exportReportToWriter();
                    ((StringBuffer)comparable).append(this.writer.toString());
                }
                catch (IOException iOException) {
                    throw new JRException("Error writing to StringBuffer writer : " + this.jasperPrint.getName(), iOException);
                }
                Object var7_5 = null;
                if (this.writer == null) return;
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                if (this.writer == null) throw throwable;
                try {
                    this.writer.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (IOException iOException) {}
            this.writer.close();
            return;
        }
        this.writer = (Writer)this.parameters.get(JRExporterParameter.OUTPUT_WRITER);
        if (this.writer != null) {
            try {
                this.exportReportToWriter();
                return;
            }
            catch (IOException iOException) {
                throw new JRException("Error writing to writer : " + this.jasperPrint.getName(), iOException);
            }
        }
        OutputStream outputStream = (OutputStream)this.parameters.get(JRExporterParameter.OUTPUT_STREAM);
        if (outputStream != null) {
            try {
                this.writer = new OutputStreamWriter(outputStream, string);
                this.exportReportToWriter();
                return;
            }
            catch (IOException iOException) {
                throw new JRException("Error writing to OutputStream writer : " + this.jasperPrint.getName(), iOException);
            }
        }
        File file = (File)this.parameters.get(JRExporterParameter.OUTPUT_FILE);
        if (file == null) {
            String string2 = (String)this.parameters.get(JRExporterParameter.OUTPUT_FILE_NAME);
            if (string2 == null) throw new JRException("No output specified for the exporter.");
            file = new File(string2);
        }
        try {
            try {
                outputStream = new FileOutputStream(file);
                this.writer = new OutputStreamWriter(outputStream, string);
                this.exportReportToWriter();
            }
            catch (IOException iOException) {
                throw new JRException("Error writing to file writer : " + this.jasperPrint.getName(), iOException);
            }
            Object var10_17 = null;
            if (this.writer == null) return;
        }
        catch (Throwable throwable) {
            Object var10_18 = null;
            if (this.writer == null) throw throwable;
            try {
                this.writer.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        this.writer.close();
        return;
    }

    protected void exportReportToWriter() throws JRException, IOException {
        for (int i = 0; i < this.jasperPrintList.size(); ++i) {
            this.jasperPrint = (JasperPrint)this.jasperPrintList.get(i);
            List list = this.jasperPrint.getPages();
            if (list == null || list.size() <= 0) continue;
            if (this.isModeBatch) {
                this.startPageIndex = 0;
                this.endPageIndex = list.size() - 1;
            }
            if (this.characterWidth > 0) {
                this.pageWidth = this.jasperPrint.getPageWidth() / this.characterWidth;
            }
            if (this.characterHeight > 0) {
                this.pageHeight = this.jasperPrint.getPageHeight() / this.characterHeight;
            }
            for (int j = this.startPageIndex; j <= this.endPageIndex; ++j) {
                if (Thread.currentThread().isInterrupted()) {
                    throw new JRException("Current thread interrupted.");
                }
                JRPrintPage jRPrintPage = (JRPrintPage)list.get(j);
                this.exportPage(jRPrintPage);
            }
        }
        this.writer.flush();
    }

    protected void exportPage(JRPrintPage jRPrintPage) throws IOException {
        int n;
        List list = jRPrintPage.getElements();
        this.pageData = new char[this.pageHeight][];
        for (n = 0; n < this.pageHeight; ++n) {
            this.pageData[n] = new char[this.pageWidth];
            Arrays.fill(this.pageData[n], ' ');
        }
        this.exportElements(list);
        for (n = 0; n < this.pageHeight; ++n) {
            this.writer.write(this.pageData[n]);
            this.writer.write(this.lineSeparator);
        }
        this.writer.write(this.betweenPagesText);
        if (this.progressMonitor != null) {
            this.progressMonitor.afterPageExport();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exportElements(List list) {
        for (int i = 0; i < list.size(); ++i) {
            Object e = list.get(i);
            if (e instanceof JRPrintText) {
                this.exportText((JRPrintText)e);
                continue;
            }
            if (!(e instanceof JRPrintFrame)) continue;
            JRPrintFrame jRPrintFrame = (JRPrintFrame)e;
            this.setFrameElementsOffset(jRPrintFrame, false);
            try {
                this.exportElements(jRPrintFrame.getElements());
                continue;
            }
            finally {
                this.restoreElementOffsets();
            }
        }
    }

    protected void exportText(JRPrintText jRPrintText) {
        int n = this.calculateYCoord(jRPrintText.getHeight());
        int n2 = this.calculateXCoord(jRPrintText.getWidth());
        int n3 = this.calculateXCoord(jRPrintText.getX() + this.getOffsetX());
        int n4 = this.calculateYCoord(jRPrintText.getY() + this.getOffsetY());
        JRStyledText jRStyledText = this.getStyledText(jRPrintText);
        String string = jRStyledText == null ? "" : jRStyledText.getText();
        if (n <= 0 || n2 <= 0) {
            return;
        }
        if (string != null && string.length() == 0) {
            return;
        }
        StringBuffer[] stringBufferArray = new StringBuffer[n];
        stringBufferArray[0] = new StringBuffer();
        int n5 = 0;
        int n6 = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        block0: while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            StringTokenizer stringTokenizer2 = new StringTokenizer(string2, " ", true);
            while (stringTokenizer2.hasMoreTokens()) {
                String string3 = stringTokenizer2.nextToken();
                while (string3.length() > n2) {
                    stringBufferArray[n5].append(string3.substring(0, n2 - n6));
                    string3 = string3.substring(n2 - n6, string3.length());
                    if (++n5 == n) break block0;
                    n6 = 0;
                    stringBufferArray[n5] = new StringBuffer();
                }
                if (n6 + string3.length() > n2) {
                    if (++n5 == n) break block0;
                    n6 = 0;
                    stringBufferArray[n5] = new StringBuffer();
                }
                if (n5 > 9 && n6 == 0 && string3.equals(" ")) break;
                stringBufferArray[n5].append(string3);
                n6 += string3.length();
            }
            if (++n5 == n) break;
            n6 = 0;
            stringBufferArray[n5] = new StringBuffer();
        }
        int n7 = 0;
        int n8 = 0;
        if (jRPrintText.getVerticalAlignment() == 3) {
            n8 = n - n5;
        }
        if (jRPrintText.getVerticalAlignment() == 2) {
            n8 = (n - n5) / 2;
        }
        for (int i = 0; i < n5; ++i) {
            int n9;
            String string4 = stringBufferArray[i].toString();
            for (n9 = string4.length() - 1; n9 >= 0 && string4.charAt(n9) == ' '; --n9) {
            }
            string4 = string4.substring(0, n9 + 1);
            if (jRPrintText.getHorizontalAlignment() == 3) {
                n7 = n2 - string4.length();
            }
            if (jRPrintText.getHorizontalAlignment() == 2) {
                n7 = (n2 - string4.length()) / 2;
            }
            if (jRPrintText.getHorizontalAlignment() == 4 && i < n5 - 1) {
                string4 = this.justifyText(string4, n2);
            }
            char[] cArray = string4.toCharArray();
            System.arraycopy(cArray, 0, this.pageData[n4 + n8 + i], n3 + n7, cArray.length);
        }
    }

    private String justifyText(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        int n2 = stringTokenizer.countTokens();
        if (n2 <= 1) {
            return string;
        }
        String[] stringArray = new String[n2];
        int n3 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n3++] = stringTokenizer.nextToken();
        }
        int n4 = n - string.length() + (stringArray.length - 1);
        int n5 = n4 / (stringArray.length - 1);
        int n6 = n4 % (stringArray.length - 1);
        char[] cArray = new char[n5];
        Arrays.fill(cArray, ' ');
        for (n3 = 0; n3 < stringArray.length - 1; ++n3) {
            stringBuffer.append(stringArray[n3]);
            stringBuffer.append(cArray);
            if (n3 >= n6) continue;
            stringBuffer.append(' ');
        }
        stringBuffer.append(stringArray[stringArray.length - 1]);
        return stringBuffer.toString();
    }

    protected int calculateYCoord(int n) {
        return this.pageHeight * n / this.jasperPrint.getPageHeight();
    }

    protected int calculateXCoord(int n) {
        return this.pageWidth * n / this.jasperPrint.getPageWidth();
    }

    protected JRStyledText getStyledText(JRPrintText jRPrintText) {
        JRStyledText jRStyledText = null;
        String string = jRPrintText.getText();
        if (string != null) {
            if (jRPrintText.isStyledText()) {
                try {
                    jRStyledText = this.styledTextParser.parse(null, string);
                }
                catch (SAXException sAXException) {
                    // empty catch block
                }
            }
            if (jRStyledText == null) {
                jRStyledText = new JRStyledText();
                jRStyledText.append(string);
                jRStyledText.addRun(new JRStyledText.Run(null, 0, string.length()));
            }
        }
        return jRStyledText;
    }
}

