/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.font.TextAttribute;
import java.awt.geom.Dimension2D;
import java.awt.image.BufferedImage;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRBox;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintEllipse;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintGraphicElement;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRPrintLine;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRPrintRectangle;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRRenderable;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.base.JRBaseFont;
import net.sf.jasperreports.engine.export.JRExportProgressMonitor;
import net.sf.jasperreports.engine.util.JRImageLoader;
import net.sf.jasperreports.engine.util.JRStyledText;

public class JRRtfExporter
extends JRAbstractExporter {
    protected JRExportProgressMonitor progressMonitor = null;
    protected Writer writer = null;
    protected File destFile = null;
    protected int reportIndex = 0;
    private StringBuffer colorBuffer = null;
    private StringBuffer fontBuffer = null;
    protected List colors = null;
    protected List fonts = null;
    private int zorder = 1;
    private boolean isUnicode = false;
    private Map fontMap = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportReport() throws JRException {
        block14: {
            this.progressMonitor = (JRExportProgressMonitor)this.parameters.get(JRExporterParameter.PROGRESS_MONITOR);
            if (!this.isModeBatch) {
                this.setPageRange();
            }
            try {
                this.setExportContext();
                this.setInput();
                this.fonts = new ArrayList();
                this.fontBuffer = new StringBuffer();
                this.colors = new ArrayList();
                this.colors.add(null);
                this.colorBuffer = new StringBuffer(";");
                this.fontMap = (Map)this.parameters.get(JRExporterParameter.FONT_MAP);
                this.getDefaultFont();
                this.getFontIndex(this.defaultFont);
                StringBuffer stringBuffer = (StringBuffer)this.parameters.get(JRExporterParameter.OUTPUT_STRING_BUFFER);
                if (stringBuffer != null) {
                    StringBuffer stringBuffer2 = this.exportReportToBuffer();
                    stringBuffer.append(stringBuffer2.toString());
                    break block14;
                }
                Writer writer = (Writer)this.parameters.get(JRExporterParameter.OUTPUT_WRITER);
                if (writer != null) {
                    try {
                        this.writer = writer;
                        this.exportReportToStream();
                        break block14;
                    }
                    catch (IOException iOException) {
                        throw new JRException("Error writing to writer : " + this.jasperPrint.getName(), iOException);
                    }
                }
                OutputStream outputStream = (OutputStream)this.parameters.get(JRExporterParameter.OUTPUT_STREAM);
                if (outputStream != null) {
                    try {
                        this.writer = new OutputStreamWriter(outputStream);
                        this.exportReportToStream();
                        break block14;
                    }
                    catch (Exception exception) {
                        throw new JRException("Error writing to output stream : " + this.jasperPrint.getName(), exception);
                    }
                }
                this.destFile = (File)this.parameters.get(JRExporterParameter.OUTPUT_FILE);
                if (this.destFile == null) {
                    String string = (String)this.parameters.get(JRExporterParameter.OUTPUT_FILE_NAME);
                    if (string != null) {
                        this.destFile = new File(string);
                    } else {
                        throw new JRException("No output specified for the exporter");
                    }
                }
                this.exportReportToFile();
            }
            finally {
                this.resetExportContext();
            }
        }
    }

    protected StringBuffer exportReportToBuffer() throws JRException {
        StringWriter stringWriter = new StringWriter();
        this.writer = stringWriter;
        try {
            this.exportReportToStream();
        }
        catch (IOException iOException) {
            throw new JRException("Error while exporting report to the buffer");
        }
        return stringWriter.getBuffer();
    }

    protected void exportReportToStream() throws JRException, IOException {
        this.writer.write("{\\rtf1\\ansi\\deff0\n");
        this.createColorAndFontEntries();
        this.writer.write("{\\fonttbl ");
        this.writer.write(this.fontBuffer.toString());
        this.writer.write("}\n");
        this.writer.write("{\\colortbl ");
        this.writer.write(this.colorBuffer.toString());
        this.writer.write("}\n");
        this.reportIndex = 0;
        while (this.reportIndex < this.jasperPrintList.size()) {
            this.jasperPrint = (JasperPrint)this.jasperPrintList.get(this.reportIndex);
            this.setPageRange();
            this.defaultFont = null;
            List list = this.jasperPrint.getPages();
            if (list != null && list.size() > 0) {
                this.startPageIndex = 0;
                this.endPageIndex = list.size() - 1;
                JRPrintPage jRPrintPage = null;
                this.writer.write("{\\info{\\nofpages" + list.size() + "}}\n");
                this.writer.write("\\viewkind1");
                this.writer.write("\\paperw" + this.twip(this.jasperPrint.getPageWidth()));
                this.writer.write("\\paperh" + this.twip(this.jasperPrint.getPageHeight()));
                this.writer.write("\\marglsxn0");
                this.writer.write("\\margrsxn0");
                this.writer.write("\\margtsxn0");
                this.writer.write("\\margbsxn0");
                if (this.jasperPrint.getOrientation() == 2) {
                    this.writer.write("\\lndscpsxn");
                }
                for (int i = this.startPageIndex; i <= this.endPageIndex; ++i) {
                    this.writer.write("\n");
                    if (Thread.currentThread().isInterrupted()) {
                        throw new JRException("Current thread intrerrupted");
                    }
                    jRPrintPage = (JRPrintPage)list.get(i);
                    boolean bl = false;
                    if (i == this.endPageIndex && this.reportIndex == this.jasperPrintList.size() - 1) {
                        bl = true;
                    }
                    this.exportPage(jRPrintPage, bl);
                }
            }
            ++this.reportIndex;
        }
        this.writer.write("}\n");
        this.writer.flush();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void exportReportToFile() throws JRException {
        try {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(this.destFile);
                this.writer = new BufferedWriter(new OutputStreamWriter(fileOutputStream));
                this.exportReportToStream();
            }
            catch (IOException iOException) {
                throw new JRException("Error writing to the file : " + this.destFile, iOException);
            }
            Object var3_3 = null;
            if (this.writer == null) return;
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            if (this.writer == null) throw throwable;
            try {
                this.writer.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        this.writer.close();
        return;
    }

    protected void createColorAndFontEntries() throws JRException {
        this.reportIndex = 0;
        while (this.reportIndex < this.jasperPrintList.size()) {
            this.jasperPrint = (JasperPrint)this.jasperPrintList.get(this.reportIndex);
            this.setPageRange();
            this.defaultFont = null;
            List list = this.jasperPrint.getPages();
            if (list != null && list.size() > 0) {
                this.startPageIndex = 0;
                this.endPageIndex = list.size() - 1;
            }
            for (int i = this.startPageIndex; i <= this.endPageIndex; ++i) {
                if (Thread.currentThread().isInterrupted()) {
                    throw new JRException("Current thread interrupted");
                }
                JRPrintPage jRPrintPage = (JRPrintPage)list.get(i);
                JRPrintElement jRPrintElement = null;
                List list2 = jRPrintPage.getElements();
                if (list2 == null || list2.size() <= 0) continue;
                Iterator iterator = list2.iterator();
                while (iterator.hasNext()) {
                    Object object;
                    int n;
                    jRPrintElement = (JRPrintElement)iterator.next();
                    this.getColorIndex(jRPrintElement.getForecolor());
                    this.getColorIndex(jRPrintElement.getBackcolor());
                    if (!(jRPrintElement instanceof JRPrintText)) continue;
                    JRPrintText jRPrintText = (JRPrintText)jRPrintElement;
                    this.getColorIndex(jRPrintText.getBorderColor());
                    this.getColorIndex(jRPrintText.getTopBorderColor());
                    this.getColorIndex(jRPrintText.getBottomBorderColor());
                    this.getColorIndex(jRPrintText.getLeftBorderColor());
                    this.getColorIndex(jRPrintText.getRightBorderColor());
                    for (n = 0; n < jRPrintText.getText().length(); ++n) {
                        if (jRPrintText.getText().charAt(n) <= '\u00ff') continue;
                        this.isUnicode = true;
                    }
                    n = 0;
                    JRStyledText jRStyledText = this.getStyledText((JRPrintText)jRPrintElement);
                    AttributedCharacterIterator attributedCharacterIterator = jRStyledText.getAttributedString().getIterator();
                    while (n < jRStyledText.length() && (n = attributedCharacterIterator.getRunLimit()) <= jRStyledText.length()) {
                        object = attributedCharacterIterator.getAttributes();
                        JRBaseFont jRBaseFont = new JRBaseFont((Map)object);
                        String string = jRBaseFont.getFontName();
                        if (this.fontMap != null && this.fontMap.containsKey(string)) {
                            string = (String)this.fontMap.get(string);
                        }
                        this.getFontIndex(string);
                        this.getColorIndex((Color)object.get(TextAttribute.FOREGROUND));
                        this.getColorIndex((Color)object.get(TextAttribute.BACKGROUND));
                        attributedCharacterIterator.setIndex(n);
                    }
                    object = ((JRPrintText)jRPrintElement).getFontName();
                    if (this.fontMap != null && this.fontMap.containsKey(object)) {
                        object = (String)this.fontMap.get(object);
                    }
                    this.getFontIndex((String)object);
                }
            }
            ++this.reportIndex;
        }
    }

    private int getColorIndex(Color color) {
        int n = this.colors.indexOf(color);
        if (n < 0) {
            n = this.colors.size();
            this.colors.add(color);
            this.colorBuffer.append("\\red").append(color.getRed()).append("\\green").append(color.getGreen()).append("\\blue").append(color.getBlue()).append(";");
        }
        return n;
    }

    private int getFontIndex(JRFont jRFont) {
        String string = jRFont.getFontName();
        return this.getFontIndex(string);
    }

    private int getFontIndex(String string) {
        int n = this.fonts.indexOf(string);
        if (n < 0) {
            n = this.fonts.size();
            this.fonts.add(string);
            this.fontBuffer.append("{\\f").append(n).append("\\fnil ").append(string).append(";}");
        }
        return n;
    }

    private int twip(int n) {
        return n * 20;
    }

    private int twip(float f) {
        return (int)(f * 20.0f);
    }

    protected void exportPage(JRPrintPage jRPrintPage, boolean bl) throws JRException, IOException {
        JRPrintElement jRPrintElement = null;
        List list = jRPrintPage.getElements();
        if (list != null && list.size() > 0) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                jRPrintElement = (JRPrintElement)iterator.next();
                if (jRPrintElement instanceof JRPrintLine) {
                    this.exportLine((JRPrintLine)jRPrintElement, 0, 0);
                    continue;
                }
                if (jRPrintElement instanceof JRPrintRectangle) {
                    this.exportRectangle((JRPrintRectangle)jRPrintElement, 0, 0);
                    continue;
                }
                if (jRPrintElement instanceof JRPrintEllipse) {
                    this.exportEllipse((JRPrintEllipse)jRPrintElement, 0, 0);
                    continue;
                }
                if (jRPrintElement instanceof JRPrintImage) {
                    this.exportImage((JRPrintImage)jRPrintElement, 0, 0);
                    continue;
                }
                if (jRPrintElement instanceof JRPrintText) {
                    this.exportText((JRPrintText)jRPrintElement, 0, 0);
                    continue;
                }
                if (!(jRPrintElement instanceof JRPrintFrame)) continue;
                this.exportFrame((JRPrintFrame)jRPrintElement, 0, 0);
            }
        }
        if (!bl) {
            if (this.isUnicode) {
                this.writer.write("{\\pard\\pagebb\\par}\n");
            } else {
                this.writer.write("\\page\n");
            }
        }
    }

    private void startGraphic(String string, int n, int n2, int n3, int n4) throws IOException {
        this.writer.write("{\\*\\do\\dobxpage\\dobypage");
        this.writer.write("\\dodhgt" + this.zorder++);
        this.writer.write("\\" + string);
        this.writer.write("\\dpx" + n);
        this.writer.write("\\dpy" + n2);
        this.writer.write("\\dpxsize" + n3);
        this.writer.write("\\dpysize" + n4);
    }

    private void finishGraphic(JRPrintGraphicElement jRPrintGraphicElement) throws IOException {
        int n = 0;
        if (jRPrintGraphicElement.getMode() == 1) {
            n = 1;
        }
        this.finishGraphic(jRPrintGraphicElement.getPen(), jRPrintGraphicElement.getForecolor(), jRPrintGraphicElement.getBackcolor(), n);
    }

    private void finishGraphic(byte by, Color color, Color color2, int n) throws IOException {
        switch (by) {
            case 5: {
                this.writer.write("\\dplinew10");
                break;
            }
            case 1: {
                this.writer.write("\\dplinew20");
                break;
            }
            case 2: {
                this.writer.write("\\dplinew40");
                break;
            }
            case 3: {
                this.writer.write("\\dplinew80");
                break;
            }
            case 4: {
                this.writer.write("\\dplinedash");
                break;
            }
            case 0: {
                this.writer.write("\\dplinehollow");
                break;
            }
            default: {
                this.writer.write("\\dplinew20");
            }
        }
        this.writer.write("\\dplinecor" + color.getRed());
        this.writer.write("\\dplinecob" + color.getBlue());
        this.writer.write("\\dplinecog" + color.getGreen());
        this.writer.write("\\dpfillfgcr" + color.getRed());
        this.writer.write("\\dplinefgcb" + color.getBlue());
        this.writer.write("\\dpfillfgcg" + color.getGreen());
        this.writer.write("\\dpfillbgcr" + color2.getRed());
        this.writer.write("\\dpfillbgcg" + color2.getGreen());
        this.writer.write("\\dpfillbgcb" + color2.getBlue());
        this.writer.write("\\dpfillpat" + n);
        this.writer.write("}\n");
    }

    protected int getAdjustment(byte by) {
        switch (by) {
            case 5: {
                return 0;
            }
            case 1: {
                return 10;
            }
            case 2: {
                return 20;
            }
            case 3: {
                return 40;
            }
            case 4: {
                return 0;
            }
            case 0: {
                return 0;
            }
        }
        return 0;
    }

    protected void exportLine(JRPrintLine jRPrintLine, int n, int n2) throws IOException {
        int n3 = this.twip(jRPrintLine.getX());
        n3 += n;
        int n4 = this.twip(jRPrintLine.getY());
        n4 += n2;
        int n5 = this.twip(jRPrintLine.getHeight());
        int n6 = this.twip(jRPrintLine.getWidth());
        if (n6 <= 20 || n5 <= 20) {
            if (n6 > 20) {
                n5 = 0;
            } else {
                n6 = 0;
            }
        }
        this.startGraphic("dpline", n3, n4, n6, n5);
        if (jRPrintLine.getDirection() == 1) {
            this.writer.write("\\dpptx" + n3);
            this.writer.write("\\dppty" + n4);
            this.writer.write("\\dpptx" + (n3 + n6));
            this.writer.write("\\dppty" + (n4 + n5));
        } else {
            this.writer.write("\\dpptx" + n3);
            this.writer.write("\\dppty" + (n4 + n5));
            this.writer.write("\\dpptx" + (n3 + n6));
            this.writer.write("\\dppty" + (n4 - n5));
        }
        this.finishGraphic(jRPrintLine);
    }

    protected void exportRectangle(JRPrintRectangle jRPrintRectangle, int n, int n2) throws IOException {
        this.startGraphic("dprect" + (jRPrintRectangle.getRadius() > 0 ? "\\dproundr" : ""), this.twip(jRPrintRectangle.getX() + n), this.twip(jRPrintRectangle.getY() + n2), this.twip(jRPrintRectangle.getWidth()), this.twip(jRPrintRectangle.getHeight()));
        this.finishGraphic(jRPrintRectangle);
    }

    protected void exportEllipse(JRPrintEllipse jRPrintEllipse, int n, int n2) throws IOException {
        this.startGraphic("dpellipse", this.twip(jRPrintEllipse.getX() + n), this.twip(jRPrintEllipse.getY() + n2), this.twip(jRPrintEllipse.getWidth()), this.twip(jRPrintEllipse.getHeight()));
        this.finishGraphic(jRPrintEllipse);
    }

    protected void exportText(JRPrintText jRPrintText, int n, int n2) throws IOException, JRException {
        JRStyledText jRStyledText = this.getStyledText(jRPrintText);
        if (jRStyledText == null) {
            return;
        }
        int n3 = this.twip(jRPrintText.getX() + n);
        int n4 = this.twip(jRPrintText.getY() + n2);
        int n5 = this.twip(jRPrintText.getWidth());
        int n6 = this.twip(jRPrintText.getHeight());
        int n7 = 20;
        int n8 = this.twip(jRPrintText.getTextHeight());
        if (n8 <= 0) {
            if (n6 <= 0) {
                throw new JRException("Invalid text height");
            }
            n8 = n6;
        }
        int n9 = this.twip(jRPrintText.getTopPadding());
        int n10 = this.twip(jRPrintText.getLeftPadding());
        int n11 = this.twip(jRPrintText.getBottomPadding());
        int n12 = this.twip(jRPrintText.getRightPadding());
        if (jRPrintText.getMode() == 1) {
            this.startGraphic("dprect", n3, n4, n5, n6);
            this.finishGraphic((byte)0, jRPrintText.getForecolor(), jRPrintText.getBackcolor(), 1);
        }
        int n13 = n9;
        switch (jRPrintText.getVerticalAlignment()) {
            case 1: {
                n13 = 0;
                break;
            }
            case 2: {
                n13 = (n6 - n9 - n11 - this.twip(jRPrintText.getTextHeight())) / 2;
                break;
            }
            case 3: {
                n13 = n6 - n9 - n11 - this.twip(jRPrintText.getTextHeight());
            }
        }
        if (this.isUnicode) {
            this.writer.write("{\\pard");
            this.writer.write("\\absw" + n5);
            this.writer.write("\\absh" + n8);
            this.writer.write("\\phpg\\posx" + n3);
            this.writer.write("\\pvpg\\posy" + (n4 + n13 + n9));
        } else {
            this.writer.write("{\\*\\do\\dobxpage\\dobypage");
            this.writer.write("\\dodhgt" + this.zorder++);
            this.writer.write("\\dptxbx");
            this.writer.write("\\dpx" + (n3 + n7));
            this.writer.write("\\dpxsize" + (n5 - n7));
            this.writer.write("\\dpy" + (n4 + n13 + n9 + n7));
            this.writer.write("\\dpysize" + (n8 + n11 - n7));
            this.writer.write("\\dpfillpat0");
            this.writer.write("\\dplinehollow");
            this.writer.write("{\\dptxbxtext ");
            this.writer.write("{\\pard");
        }
        JRPrintText jRPrintText2 = jRPrintText;
        String string = jRPrintText2.getFontName();
        if (this.fontMap != null && this.fontMap.containsKey(string)) {
            string = (String)this.fontMap.get(string);
        }
        this.writer.write("\\f" + this.getFontIndex(string));
        this.writer.write("\\cf" + this.getColorIndex(jRPrintText.getForecolor()));
        this.writer.write("\\cb" + this.getColorIndex(jRPrintText.getBackcolor()));
        if (n10 > 0) {
            this.writer.write("\\li" + n10);
        }
        if (n12 > 0) {
            this.writer.write("\\ri" + n12);
        }
        if (jRPrintText2.isBold()) {
            this.writer.write("\\b");
        }
        if (jRPrintText2.isItalic()) {
            this.writer.write("\\i");
        }
        if (jRPrintText2.isStrikeThrough()) {
            this.writer.write("\\strike");
        }
        if (jRPrintText2.isUnderline()) {
            this.writer.write("\\ul");
        }
        this.writer.write("\\fs" + jRPrintText2.getFontSize() * 2);
        switch (jRPrintText.getHorizontalAlignment()) {
            case 1: {
                this.writer.write("\\ql");
                break;
            }
            case 2: {
                this.writer.write("\\qc");
                break;
            }
            case 3: {
                this.writer.write("\\qr");
                break;
            }
            case 4: {
                this.writer.write("\\qj");
                break;
            }
            default: {
                this.writer.write("\\ql");
            }
        }
        switch (jRPrintText.getLineSpacing()) {
            case 0: {
                break;
            }
            case 1: {
                this.writer.write("\\sl360\\slmulti1");
                break;
            }
            case 2: {
                this.writer.write("\\sl480\\slmulti1");
            }
        }
        this.writer.write(" ");
        String string2 = jRStyledText.getText();
        int n14 = 0;
        AttributedCharacterIterator attributedCharacterIterator = jRStyledText.getAttributedString().getIterator();
        while (n14 < jRStyledText.length() && (n14 = attributedCharacterIterator.getRunLimit()) <= jRStyledText.length()) {
            Map<AttributedCharacterIterator.Attribute, Object> map = attributedCharacterIterator.getAttributes();
            JRBaseFont jRBaseFont = new JRBaseFont(map);
            Color color = (Color)map.get(TextAttribute.FOREGROUND);
            Color color2 = (Color)map.get(TextAttribute.BACKGROUND);
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            if (jRBaseFont.isBold()) {
                bl = true;
            }
            if (jRBaseFont.isItalic()) {
                bl2 = true;
            }
            if (jRBaseFont.isUnderline()) {
                bl3 = true;
            }
            if (jRBaseFont.isStrikeThrough()) {
                bl4 = true;
            }
            string = jRBaseFont.getFontName();
            if (this.fontMap != null && this.fontMap.containsKey(string)) {
                string = (String)this.fontMap.get(string);
            }
            int n15 = this.getFontIndex(string);
            this.writer.write("\\f" + n15);
            int n16 = jRBaseFont.getFontSize();
            this.writer.write("\\fs" + 2 * n16 + " ");
            if (bl) {
                this.writer.write("\\b ");
            }
            if (bl2) {
                this.writer.write("\\i ");
            }
            if (bl3) {
                this.writer.write("\\ul ");
            }
            if (bl4) {
                this.writer.write("\\strike ");
            }
            this.writer.write("\\cb" + this.getColorIndex(color2) + " ");
            this.writer.write("\\cf" + this.getColorIndex(color) + " ");
            int n17 = 0;
            int n18 = 0;
            String string3 = string2.substring(attributedCharacterIterator.getIndex(), n14);
            String string4 = "\n";
            String string5 = "\\line ";
            StringBuffer stringBuffer = new StringBuffer();
            while ((n18 = string3.indexOf(string4, n17)) >= 0) {
                stringBuffer.append(string3.substring(n17, n18));
                stringBuffer.append(string5);
                n17 = n18 + string4.length();
            }
            stringBuffer.append(string3.substring(n17));
            this.writer.write(this.handleUnicodeText(stringBuffer, jRPrintText.getRunDirection() == 1));
            this.writer.write("\\plain");
            attributedCharacterIterator.setIndex(n14);
        }
        if (this.isUnicode) {
            this.writer.write("\\par}\n");
        } else {
            this.writer.write("\\par}}}\n");
        }
        this.exportBox(jRPrintText, n3, n4, n5, n6, jRPrintText.getForecolor(), jRPrintText.getBackcolor());
    }

    private String handleUnicodeText(StringBuffer stringBuffer, boolean bl) {
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer();
        for (int i = 0; i < stringBuffer.length(); ++i) {
            long l = stringBuffer.charAt(i);
            if (l > 255L) {
                if (bl) {
                    stringBuffer2.insert(0, stringBuffer3.toString());
                    stringBuffer3 = new StringBuffer();
                    stringBuffer2.insert(0, "\\u" + l + '?');
                    continue;
                }
                stringBuffer3.append("\\u" + l + '?');
                continue;
            }
            stringBuffer3.append((char)l);
        }
        if (stringBuffer3 != null && stringBuffer3.length() > 0) {
            if (bl) {
                stringBuffer2.insert(0, stringBuffer3.toString());
            } else {
                stringBuffer2.append(stringBuffer3.toString());
            }
        }
        return stringBuffer2.toString();
    }

    protected void exportImage(JRPrintImage jRPrintImage, int n, int n2) throws JRException, IOException {
        int n3 = this.twip(jRPrintImage.getX() + this.globalOffsetX);
        int n4 = this.twip(jRPrintImage.getY() + this.globalOffsetY);
        int n5 = this.twip(jRPrintImage.getWidth());
        int n6 = this.twip(jRPrintImage.getHeight());
        if (jRPrintImage.getMode() == 1) {
            this.startGraphic("dprect", n3, n4, n5, n6);
            this.finishGraphic((byte)0, jRPrintImage.getForecolor(), jRPrintImage.getBackcolor(), 1);
        }
        int n7 = jRPrintImage.getLeftPadding();
        int n8 = jRPrintImage.getTopPadding();
        int n9 = jRPrintImage.getRightPadding();
        int n10 = jRPrintImage.getBottomPadding();
        int n11 = jRPrintImage.getWidth() - n7 - n9;
        n11 = n11 < 0 ? 0 : n11;
        int n12 = jRPrintImage.getHeight() - n8 - n10;
        n12 = n12 < 0 ? 0 : n12;
        JRRenderable jRRenderable = jRPrintImage.getRenderer();
        if (n11 > 0 && n12 > 0 && jRRenderable != null) {
            int n13;
            int n14;
            int n15 = n11;
            int n16 = n12;
            Dimension2D dimension2D = jRRenderable.getDimension();
            if (dimension2D != null) {
                n15 = (int)dimension2D.getWidth();
                n16 = (int)dimension2D.getHeight();
            }
            float f = 0.0f;
            switch (jRPrintImage.getHorizontalAlignment()) {
                case 3: {
                    f = 1.0f;
                    break;
                }
                case 2: {
                    f = 0.5f;
                    break;
                }
                default: {
                    f = 0.0f;
                }
            }
            float f2 = 0.0f;
            switch (jRPrintImage.getVerticalAlignment()) {
                case 3: {
                    f2 = 1.0f;
                    break;
                }
                case 2: {
                    f2 = 0.5f;
                    break;
                }
                default: {
                    f2 = 0.0f;
                }
            }
            BufferedImage bufferedImage = new BufferedImage(n11, n12, 1);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.setColor(jRPrintImage.getBackcolor());
            graphics2D.fillRect(0, 0, n11, n12);
            switch (jRPrintImage.getScaleImage()) {
                case 1: {
                    int n17 = (int)(f * (float)(n11 - n15));
                    n14 = (int)(f2 * (float)(n12 - n16));
                    jRRenderable.render(graphics2D, new Rectangle(n17, n14, n15, n16));
                    break;
                }
                case 2: {
                    jRRenderable.render(graphics2D, new Rectangle(0, 0, n11, n12));
                    break;
                }
                default: {
                    if (jRPrintImage.getHeight() <= 0) break;
                    double d = (double)n15 / (double)n16;
                    if (d > (double)n11 / (double)n12) {
                        n15 = n11;
                        n16 = (int)((double)n11 / d);
                    } else {
                        n15 = (int)((double)n12 * d);
                        n16 = n12;
                    }
                    n13 = (int)(f * (float)(n11 - n15));
                    int n18 = (int)(f2 * (float)(n12 - n16));
                    jRRenderable.render(graphics2D, new Rectangle(n13, n18, n15, n16));
                }
            }
            this.writer.write("{\\*\\do\\dobxpage\\dobypage");
            this.writer.write("\\dodhgt" + this.zorder++);
            this.writer.write("\\dptxbx");
            this.writer.write("\\dpx" + this.twip(jRPrintImage.getX() + n7 + this.globalOffsetX + n));
            this.writer.write("\\dpxsize" + this.twip(n11));
            this.writer.write("\\dpy" + this.twip(jRPrintImage.getY() + n8 + this.globalOffsetY + n2));
            this.writer.write("\\dpysize" + this.twip(n12));
            this.writer.write("\\dpfillpat0");
            this.writer.write("\\dplinehollow");
            this.writer.write("{\\dptxbxtext ");
            this.writer.write("{\\pict\\jpegblip");
            this.writer.write("\\picwgoal");
            this.writer.write(this.twip(n11) + "");
            this.writer.write("\\pichgoal");
            this.writer.write(this.twip(n12) + "");
            this.writer.write("\n");
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(JRImageLoader.loadImageDataFromAWTImage(bufferedImage));
            n14 = 0;
            n13 = 0;
            while ((n13 = byteArrayInputStream.read()) != -1) {
                String string = Integer.toHexString(n13);
                if (string.length() < 2) {
                    string = "0" + string;
                }
                this.writer.write(string);
                if (++n14 != 64) continue;
                this.writer.write("\n");
                n14 = 0;
            }
            this.writer.write("\n}}}\n");
        }
        if (jRPrintImage.getTopBorder() == 0 && jRPrintImage.getLeftBorder() == 0 && jRPrintImage.getBottomBorder() == 0 && jRPrintImage.getRightBorder() == 0) {
            if (jRPrintImage.getPen() != 0) {
                this.startGraphic("dprect", n3, n4, n5, n6);
                this.finishGraphic(jRPrintImage);
            }
        } else {
            this.exportBox(jRPrintImage, n3, n4, n5, n6, jRPrintImage.getForecolor(), jRPrintImage.getBackcolor());
        }
    }

    protected void exportFrame(JRPrintFrame jRPrintFrame, int n, int n2) throws JRException, IOException {
        int n3 = this.twip(jRPrintFrame.getX() + n);
        int n4 = this.twip(jRPrintFrame.getY() + n2);
        int n5 = this.twip(jRPrintFrame.getWidth());
        int n6 = this.twip(jRPrintFrame.getHeight());
        if (jRPrintFrame.getMode() == 1) {
            this.startGraphic("dprect", n3, n4, n5, n6);
            this.finishGraphic((byte)0, jRPrintFrame.getForecolor(), jRPrintFrame.getBackcolor(), 1);
        }
        this.exportElements(jRPrintFrame.getElements(), jRPrintFrame.getX(), jRPrintFrame.getY());
        this.exportBox(jRPrintFrame, n3, n4, n5, n6, jRPrintFrame.getForecolor(), jRPrintFrame.getBackcolor());
    }

    protected void exportElements(Collection collection, int n, int n2) throws JRException, IOException {
        if (collection != null && collection.size() > 0) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                JRPrintElement jRPrintElement = (JRPrintElement)iterator.next();
                if (jRPrintElement instanceof JRPrintLine) {
                    this.exportLine((JRPrintLine)jRPrintElement, n, n2);
                    continue;
                }
                if (jRPrintElement instanceof JRPrintRectangle) {
                    this.exportRectangle((JRPrintRectangle)jRPrintElement, n, n2);
                    continue;
                }
                if (jRPrintElement instanceof JRPrintEllipse) {
                    this.exportEllipse((JRPrintEllipse)jRPrintElement, n, n2);
                    continue;
                }
                if (jRPrintElement instanceof JRPrintImage) {
                    this.exportImage((JRPrintImage)jRPrintElement, n, n2);
                    continue;
                }
                if (jRPrintElement instanceof JRPrintText) {
                    this.exportText((JRPrintText)jRPrintElement, n, n2);
                    continue;
                }
                if (!(jRPrintElement instanceof JRPrintFrame)) continue;
                this.exportFrame((JRPrintFrame)jRPrintElement, n, n2);
            }
        }
    }

    private void exportBox(JRBox jRBox, int n, int n2, int n3, int n4, Color color, Color color2) throws IOException {
        int n5;
        byte by;
        Color color3;
        if (jRBox.getTopBorder() != 0) {
            color3 = jRBox.getTopBorderColor();
            by = jRBox.getTopBorder();
            n5 = this.getAdjustment(jRBox.getTopBorder());
            if (color3 == null) {
                color3 = color;
            }
            this.startGraphic("dpline", n, n2 + n5, n3, 0);
            this.finishGraphic(by, color3, color2, 1);
        }
        if (jRBox.getLeftBorder() != 0) {
            color3 = jRBox.getLeftBorderColor();
            by = jRBox.getLeftBorder();
            n5 = this.getAdjustment(by);
            if (color3 == null) {
                color3 = color;
            }
            this.startGraphic("dpline", n + n5, n2, 0, n4);
            this.finishGraphic(by, color3, color2, 1);
        }
        if (jRBox.getBottomBorder() != 0) {
            color3 = jRBox.getBottomBorderColor();
            by = jRBox.getBottomBorder();
            n5 = this.getAdjustment(by);
            if (color3 == null) {
                color3 = color;
            }
            this.startGraphic("dpline", n, n2 + n4 - n5, n3, 0);
            this.finishGraphic(by, color3, color2, 1);
        }
        if (jRBox.getRightBorder() != 0) {
            color3 = jRBox.getRightBorderColor();
            by = jRBox.getRightBorder();
            n5 = this.getAdjustment(by);
            if (color3 == null) {
                color3 = color;
            }
            this.startGraphic("dpline", n + n3 - n5, n2, 0, n4);
            this.finishGraphic(by, color3, color2, 1);
        }
    }
}

