/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.font.TextAttribute;
import java.awt.geom.Dimension2D;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRBox;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JRImageRenderer;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintElementIndex;
import net.sf.jasperreports.engine.JRPrintEllipse;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRPrintLine;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRPrintRectangle;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRRenderable;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRWrappingSvgRenderer;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.JRExportProgressMonitor;
import net.sf.jasperreports.engine.export.JRExporterGridCell;
import net.sf.jasperreports.engine.export.JRGridLayout;
import net.sf.jasperreports.engine.export.JRHtmlExporterParameter;
import net.sf.jasperreports.engine.util.JRStringUtil;
import net.sf.jasperreports.engine.util.JRStyledText;

public class JRHtmlExporter
extends JRAbstractExporter {
    protected static final String JR_PAGE_ANCHOR_PREFIX = "JR_PAGE_ANCHOR_";
    protected static final String CSS_TEXT_ALIGN_LEFT = "left";
    protected static final String CSS_TEXT_ALIGN_RIGHT = "right";
    protected static final String CSS_TEXT_ALIGN_CENTER = "center";
    protected static final String CSS_TEXT_ALIGN_JUSTIFY = "justify";
    protected static final String HTML_VERTICAL_ALIGN_TOP = "top";
    protected static final String HTML_VERTICAL_ALIGN_MIDDLE = "middle";
    protected static final String HTML_VERTICAL_ALIGN_BOTTOM = "bottom";
    protected Writer writer = null;
    protected JRExportProgressMonitor progressMonitor = null;
    protected Map rendererToImagePathMap = null;
    protected Map imageNameToImageDataMap = null;
    protected List imagesToProcess = null;
    protected boolean isPxImageLoaded = false;
    protected int reportIndex = 0;
    protected int pageIndex = 0;
    protected File imagesDir = null;
    protected String imagesURI = null;
    protected boolean isOutputImagesToDir = false;
    protected boolean isRemoveEmptySpace = false;
    protected boolean isWhitePageBackground = true;
    protected String encoding = null;
    protected String sizeUnit = null;
    protected String htmlHeader = null;
    protected String betweenPagesHtml = null;
    protected String htmlFooter = null;
    protected StringProvider emptyCellStringProvider = null;
    protected static final int colorMask = Integer.parseInt("FFFFFF", 16);
    protected boolean isWrapBreakWord = false;
    protected Map fontMap = null;
    private LinkedList backcolorStack = new LinkedList();
    private Color backcolor = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void exportReport() throws JRException {
        this.progressMonitor = (JRExportProgressMonitor)this.parameters.get(JRExporterParameter.PROGRESS_MONITOR);
        this.setOffset();
        try {
            Object object7;
            File file;
            Object object2;
            Object object3;
            Object object42;
            Object object5;
            block64: {
                block63: {
                    Boolean bl;
                    String string;
                    Boolean bl2;
                    Boolean bl3;
                    Object object6;
                    this.setExportContext();
                    this.setInput();
                    if (!this.isModeBatch) {
                        this.setPageRange();
                    }
                    this.htmlHeader = (String)this.parameters.get(JRHtmlExporterParameter.HTML_HEADER);
                    this.betweenPagesHtml = (String)this.parameters.get(JRHtmlExporterParameter.BETWEEN_PAGES_HTML);
                    this.htmlFooter = (String)this.parameters.get(JRHtmlExporterParameter.HTML_FOOTER);
                    this.imagesDir = (File)this.parameters.get(JRHtmlExporterParameter.IMAGES_DIR);
                    if (this.imagesDir == null && (object6 = (String)this.parameters.get(JRHtmlExporterParameter.IMAGES_DIR_NAME)) != null) {
                        this.imagesDir = new File((String)object6);
                    }
                    if ((object6 = (Boolean)this.parameters.get(JRHtmlExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_ROWS)) != null) {
                        this.isRemoveEmptySpace = (Boolean)object6;
                    }
                    if ((bl3 = (Boolean)this.parameters.get(JRHtmlExporterParameter.IS_WHITE_PAGE_BACKGROUND)) != null) {
                        this.isWhitePageBackground = bl3;
                    }
                    if ((bl2 = (Boolean)this.parameters.get(JRHtmlExporterParameter.IS_OUTPUT_IMAGES_TO_DIR)) != null) {
                        this.isOutputImagesToDir = bl2;
                    }
                    if ((string = (String)this.parameters.get(JRHtmlExporterParameter.IMAGES_URI)) != null) {
                        this.imagesURI = string;
                    }
                    this.encoding = (String)this.parameters.get(JRExporterParameter.CHARACTER_ENCODING);
                    if (this.encoding == null) {
                        this.encoding = "UTF-8";
                    }
                    this.rendererToImagePathMap = new HashMap();
                    this.imagesToProcess = new ArrayList();
                    this.isPxImageLoaded = false;
                    this.imageNameToImageDataMap = (Map)this.parameters.get(JRHtmlExporterParameter.IMAGES_MAP);
                    Boolean bl4 = (Boolean)this.parameters.get(JRHtmlExporterParameter.IS_WRAP_BREAK_WORD);
                    if (bl4 != null) {
                        this.isWrapBreakWord = bl4;
                    }
                    this.sizeUnit = (String)this.parameters.get(JRHtmlExporterParameter.SIZE_UNIT);
                    if (this.sizeUnit == null) {
                        this.sizeUnit = "px";
                    }
                    if ((bl = (Boolean)this.parameters.get(JRHtmlExporterParameter.IS_USING_IMAGES_TO_ALIGN)) == null) {
                        bl = Boolean.TRUE;
                    }
                    if (bl.booleanValue()) {
                        this.emptyCellStringProvider = new StringProvider(){

                            public String getStringForCollapsedTD(Object object) {
                                return "><img src=\"" + object + "px\"";
                            }

                            public String getStringForEmptyTD(Object object) {
                                return "<img src=\"" + object + "px\" border=\"0\"/>";
                            }
                        };
                        this.loadPxImage();
                    } else {
                        this.emptyCellStringProvider = new StringProvider(){

                            public String getStringForCollapsedTD(Object object) {
                                return "";
                            }

                            public String getStringForEmptyTD(Object object) {
                                return "";
                            }
                        };
                    }
                    this.fontMap = (Map)this.parameters.get(JRExporterParameter.FONT_MAP);
                    StringBuffer stringBuffer = (StringBuffer)this.parameters.get(JRExporterParameter.OUTPUT_STRING_BUFFER);
                    if (stringBuffer != null) {
                        try {
                            try {
                                this.writer = new StringWriter();
                                this.exportReportToWriter();
                                stringBuffer.append(this.writer.toString());
                            }
                            catch (IOException iOException) {
                                throw new JRException("Error writing to StringBuffer writer : " + this.jasperPrint.getName(), iOException);
                            }
                            object5 = null;
                            if (this.writer == null) break block63;
                        }
                        catch (Throwable throwable) {
                            Object var10_9 = null;
                            if (this.writer == null) throw throwable;
                            try {
                                this.writer.close();
                                throw throwable;
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            throw throwable;
                        }
                        try {}
                        catch (IOException object42) {}
                        this.writer.close();
                    } else {
                        this.writer = (Writer)this.parameters.get(JRExporterParameter.OUTPUT_WRITER);
                        if (this.writer != null) {
                            try {
                                this.exportReportToWriter();
                            }
                            catch (IOException iOException) {
                                throw new JRException("Error writing to writer : " + this.jasperPrint.getName(), iOException);
                            }
                        }
                        object3 = (OutputStream)this.parameters.get(JRExporterParameter.OUTPUT_STREAM);
                        if (object3 != null) {
                            try {
                                this.writer = new OutputStreamWriter((OutputStream)object3, this.encoding);
                                this.exportReportToWriter();
                            }
                            catch (IOException iOException) {
                                throw new JRException("Error writing to OutputStream writer : " + this.jasperPrint.getName(), iOException);
                            }
                        }
                        object2 = (File)this.parameters.get(JRExporterParameter.OUTPUT_FILE);
                        if (object2 == null) {
                            object5 = (String)this.parameters.get(JRExporterParameter.OUTPUT_FILE_NAME);
                            if (object5 == null) throw new JRException("No output specified for the exporter.");
                            object2 = new File((String)object5);
                        }
                        try {
                            object3 = new FileOutputStream((File)object2);
                            this.writer = new OutputStreamWriter((OutputStream)object3, this.encoding);
                        }
                        catch (IOException iOException) {
                            throw new JRException("Error creating to file writer : " + this.jasperPrint.getName(), iOException);
                        }
                        if (this.imagesDir == null) {
                            this.imagesDir = new File(((File)object2).getParent(), ((File)object2).getName() + "_files");
                        }
                        if (bl2 == null) {
                            this.isOutputImagesToDir = true;
                        }
                        if (this.imagesURI == null) {
                            this.imagesURI = this.imagesDir.getName() + "/";
                        }
                        try {
                            try {
                                this.exportReportToWriter();
                            }
                            catch (IOException iOException) {
                                throw new JRException("Error writing to file writer : " + this.jasperPrint.getName(), iOException);
                            }
                            file = null;
                            if (this.writer == null) break block63;
                        }
                        catch (Throwable throwable) {
                            Object var13_21 = null;
                            if (this.writer == null) throw throwable;
                            try {
                                this.writer.close();
                                throw throwable;
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            throw throwable;
                        }
                        try {}
                        catch (IOException object7) {}
                        this.writer.close();
                    }
                }
                if (!this.isOutputImagesToDir) return;
                if (this.imagesDir == null) {
                    throw new JRException("The images directory was not specified for the exporter.");
                }
                if (!this.isPxImageLoaded) {
                    if (this.imagesToProcess == null) return;
                    if (this.imagesToProcess.size() <= 0) return;
                }
                if (!this.imagesDir.exists()) {
                    this.imagesDir.mkdir();
                }
                if (this.isPxImageLoaded) {
                    object3 = JRImageRenderer.getInstance("net/sf/jasperreports/engine/images/pixel.GIF", (byte)1);
                    object2 = object3.getImageData();
                    object5 = new File(this.imagesDir, "px");
                    object42 = null;
                    try {
                        try {
                            object42 = new FileOutputStream((File)object5);
                            ((FileOutputStream)object42).write((byte[])object2, 0, ((Object)object2).length);
                        }
                        catch (IOException iOException) {
                            throw new JRException("Error writing to image file : " + object5, iOException);
                        }
                        Object var16_27 = null;
                        if (object42 == null) break block64;
                    }
                    catch (Throwable throwable) {
                        Object var16_28 = null;
                        if (object42 == null) throw throwable;
                        try {
                            ((FileOutputStream)object42).close();
                            throw throwable;
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                    try {}
                    catch (IOException iOException) {}
                    ((FileOutputStream)object42).close();
                }
            }
            object3 = this.imagesToProcess.iterator();
            while (object3.hasNext()) {
                IOException iOException3;
                Object var19_33;
                object2 = (JRPrintElementIndex)object3.next();
                object5 = JRHtmlExporter.getImage(this.jasperPrintList, (JRPrintElementIndex)object2);
                object42 = object5.getRenderer();
                if (object42.getType() == 1) {
                    object42 = new JRWrappingSvgRenderer((JRRenderable)object42, new Dimension(object5.getWidth(), object5.getHeight()), object5.getBackcolor());
                }
                byte[] byArray = object42.getImageData();
                file = new File(this.imagesDir, JRHtmlExporter.getImageName((JRPrintElementIndex)object2));
                object7 = null;
                try {
                    try {
                        object7 = new FileOutputStream(file);
                        ((FileOutputStream)object7).write(byArray, 0, byArray.length);
                    }
                    catch (IOException iOException2) {
                        throw new JRException("Error writing to image file : " + file, iOException2);
                    }
                    var19_33 = null;
                    if (object7 == null) continue;
                    {
                    }
                }
                catch (Throwable throwable) {
                    var19_33 = null;
                    if (object7 == null) throw throwable;
                    try {
                        ((FileOutputStream)object7).close();
                        throw throwable;
                    }
                    catch (IOException iOException3) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {}
                catch (IOException iOException3) {}
                ((FileOutputStream)object7).close();
            }
            return;
        }
        finally {
            this.resetExportContext();
        }
    }

    public static JRPrintImage getImage(List list, String string) {
        return JRHtmlExporter.getImage(list, JRHtmlExporter.getPrintElementIndex(string));
    }

    public static JRPrintImage getImage(List list, JRPrintElementIndex jRPrintElementIndex) {
        JasperPrint jasperPrint = (JasperPrint)list.get(jRPrintElementIndex.getReportIndex());
        JRPrintPage jRPrintPage = (JRPrintPage)jasperPrint.getPages().get(jRPrintElementIndex.getPageIndex());
        Integer[] integerArray = jRPrintElementIndex.getElementIndexes();
        Object e = jRPrintPage.getElements().get(integerArray[0]);
        for (int i = 1; i < integerArray.length; ++i) {
            JRPrintFrame jRPrintFrame = (JRPrintFrame)e;
            e = jRPrintFrame.getElements().get(integerArray[i]);
        }
        return (JRPrintImage)e;
    }

    protected void exportReportToWriter() throws JRException, IOException {
        if (this.htmlHeader == null) {
            this.writer.write("<html>\n");
            this.writer.write("<head>\n");
            this.writer.write("  <meta http-equiv=\"Content-Type\" content=\"text/html; charset=" + this.encoding + "\"/>\n");
            this.writer.write("  <style type=\"text/css\">\n");
            this.writer.write("    a {text-decoration: none}\n");
            this.writer.write("  </style>\n");
            this.writer.write("</head>\n");
            this.writer.write("<body text=\"#000000\" link=\"#000000\" alink=\"#000000\" vlink=\"#000000\">\n");
            this.writer.write("<table width=\"100%\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\">\n");
            this.writer.write("<tr><td width=\"50%\">&nbsp;</td><td align=\"center\">\n");
            this.writer.write("\n");
        } else {
            this.writer.write(this.htmlHeader);
        }
        this.reportIndex = 0;
        while (this.reportIndex < this.jasperPrintList.size()) {
            this.jasperPrint = (JasperPrint)this.jasperPrintList.get(this.reportIndex);
            this.defaultFont = null;
            List list = this.jasperPrint.getPages();
            if (list != null && list.size() > 0) {
                if (this.isModeBatch) {
                    this.startPageIndex = 0;
                    this.endPageIndex = list.size() - 1;
                }
                JRPrintPage jRPrintPage = null;
                this.pageIndex = this.startPageIndex;
                while (this.pageIndex <= this.endPageIndex) {
                    if (Thread.currentThread().isInterrupted()) {
                        throw new JRException("Current thread interrupted.");
                    }
                    jRPrintPage = (JRPrintPage)list.get(this.pageIndex);
                    this.writer.write("<a name=\"JR_PAGE_ANCHOR_" + this.reportIndex + "_" + (this.pageIndex + 1) + "\"/>\n");
                    this.exportPage(jRPrintPage);
                    if (this.reportIndex < this.jasperPrintList.size() - 1 || this.pageIndex < this.endPageIndex) {
                        if (this.betweenPagesHtml == null) {
                            this.writer.write("<br/>\n<br/>\n");
                        } else {
                            this.writer.write(this.betweenPagesHtml);
                        }
                    }
                    this.writer.write("\n");
                    ++this.pageIndex;
                }
            }
            ++this.reportIndex;
        }
        if (this.htmlFooter == null) {
            this.writer.write("</td><td width=\"50%\">&nbsp;</td></tr>\n");
            this.writer.write("</table>\n");
            this.writer.write("</body>\n");
            this.writer.write("</html>\n");
        } else {
            this.writer.write(this.htmlFooter);
        }
        this.writer.flush();
    }

    protected void exportPage(JRPrintPage jRPrintPage) throws JRException, IOException {
        JRGridLayout jRGridLayout = this.getPageGridLayout(jRPrintPage);
        this.exportGrid(jRGridLayout, this.isWhitePageBackground);
        if (this.progressMonitor != null) {
            this.progressMonitor.afterPageExport();
        }
    }

    protected void exportGrid(JRGridLayout jRGridLayout, boolean bl) throws IOException, JRException {
        List list = jRGridLayout.getXCuts();
        JRExporterGridCell[][] jRExporterGridCellArray = jRGridLayout.getGrid();
        boolean[] blArray = jRGridLayout.getIsRowNotEmpty();
        this.writer.write("<table style=\"width: " + jRGridLayout.getWidth() + this.sizeUnit + "\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"");
        if (bl) {
            this.writer.write(" bgcolor=\"white\"");
        }
        this.writer.write(">\n");
        if (bl) {
            this.setBackcolor(Color.white);
        }
        this.writer.write("<tr>\n");
        int n = 0;
        for (int i = 1; i < list.size(); ++i) {
            n = (Integer)list.get(i) - (Integer)list.get(i - 1);
            this.writer.write("  <td" + this.emptyCellStringProvider.getStringForCollapsedTD(this.imagesURI) + " style=\"width: " + n + this.sizeUnit + "; height: 1" + this.sizeUnit + "\"/></td>\n");
        }
        this.writer.write("</tr>\n");
        JRPrintElement jRPrintElement = null;
        for (int i = 0; i < jRExporterGridCellArray.length; ++i) {
            if (!blArray[i] && this.isRemoveEmptySpace) continue;
            JRExporterGridCell[] jRExporterGridCellArray2 = jRExporterGridCellArray[i];
            int n2 = 0;
            int n3 = 0;
            int n4 = JRGridLayout.getRowHeight(jRExporterGridCellArray2);
            boolean bl2 = this.hasEmptyCell(jRExporterGridCellArray2);
            this.writer.write("<tr valign=\"top\"");
            if (!bl2) {
                this.writer.write(" style=\"height:" + n4 + this.sizeUnit + "\"");
            }
            this.writer.write(">\n");
            for (int j = 0; j < jRExporterGridCellArray2.length; ++j) {
                JRExporterGridCell jRExporterGridCell = jRExporterGridCellArray2[j];
                if (jRExporterGridCell.element != null) {
                    if (n2 > 0) {
                        this.writeEmptyCell(n2, n3, n4);
                        n2 = 0;
                        n3 = 0;
                    }
                    if ((jRPrintElement = jRExporterGridCell.element) instanceof JRPrintLine) {
                        this.exportLine((JRPrintLine)jRPrintElement, jRExporterGridCell);
                    } else if (jRPrintElement instanceof JRPrintRectangle) {
                        this.exportRectangle(jRPrintElement, jRExporterGridCell);
                    } else if (jRPrintElement instanceof JRPrintEllipse) {
                        this.exportRectangle(jRPrintElement, jRExporterGridCell);
                    } else if (jRPrintElement instanceof JRPrintImage) {
                        this.exportImage((JRPrintImage)jRPrintElement, jRExporterGridCell);
                    } else if (jRPrintElement instanceof JRPrintText) {
                        this.exportText((JRPrintText)jRPrintElement, jRExporterGridCell);
                    } else if (jRPrintElement instanceof JRPrintFrame) {
                        this.exportFrame((JRPrintFrame)jRPrintElement, jRExporterGridCell);
                    }
                    j += jRExporterGridCell.colSpan - 1;
                    continue;
                }
                ++n2;
                n3 += jRExporterGridCell.width;
            }
            if (n2 > 0) {
                this.writeEmptyCell(n2, n3, n4);
            }
            this.writer.write("</tr>\n");
        }
        if (bl) {
            this.restoreBackcolor();
        }
        this.writer.write("</table>\n");
    }

    private boolean hasEmptyCell(JRExporterGridCell[] jRExporterGridCellArray) {
        if (jRExporterGridCellArray[0].element == null) {
            return true;
        }
        boolean bl = false;
        for (int i = 1; i < jRExporterGridCellArray.length; ++i) {
            if (jRExporterGridCellArray[i].element != null) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private void writeEmptyCell(int n, int n2, int n3) throws IOException {
        this.writer.write("  <td");
        if (n > 1) {
            this.writer.write(" colspan=\"" + n + "\"");
        }
        this.writer.write(this.emptyCellStringProvider.getStringForCollapsedTD(this.imagesURI) + " style=\"width: " + n2 + this.sizeUnit + "; height: " + n3 + this.sizeUnit + "\"/></td>\n");
    }

    protected void exportLine(JRPrintLine jRPrintLine, JRExporterGridCell jRExporterGridCell) throws IOException {
        this.writeCellTDStart(jRExporterGridCell);
        if (jRPrintLine.getForecolor().getRGB() != Color.white.getRGB()) {
            this.writer.write(" bgcolor=\"#");
            String string = Integer.toHexString(jRPrintLine.getForecolor().getRGB() & colorMask).toUpperCase();
            string = ("000000" + string).substring(string.length());
            this.writer.write(string);
        }
        this.writer.write("\">");
        this.writer.write(this.emptyCellStringProvider.getStringForEmptyTD(this.imagesURI));
        this.writer.write("</td>\n");
    }

    protected void writeCellTDStart(JRExporterGridCell jRExporterGridCell) throws IOException {
        this.writer.write("  <td");
        if (jRExporterGridCell.colSpan > 1) {
            this.writer.write(" colspan=\"" + jRExporterGridCell.colSpan + "\"");
        }
        if (jRExporterGridCell.rowSpan > 1) {
            this.writer.write(" rowspan=\"" + jRExporterGridCell.rowSpan + "\"");
        }
    }

    protected void exportRectangle(JRPrintElement jRPrintElement, JRExporterGridCell jRExporterGridCell) throws IOException {
        this.writeCellTDStart(jRExporterGridCell);
        if ((this.backcolor == null || jRPrintElement.getBackcolor().getRGB() != this.backcolor.getRGB()) && jRPrintElement.getMode() == 1) {
            this.writer.write(" bgcolor=\"#");
            String string = Integer.toHexString(jRPrintElement.getBackcolor().getRGB() & colorMask).toUpperCase();
            string = ("000000" + string).substring(string.length());
            this.writer.write(string);
        }
        this.writer.write("\">");
        this.writer.write(this.emptyCellStringProvider.getStringForEmptyTD(this.imagesURI));
        this.writer.write("</td>\n");
    }

    protected void exportStyledText(JRStyledText jRStyledText) throws IOException {
        String string = jRStyledText.getText();
        int n = 0;
        AttributedCharacterIterator attributedCharacterIterator = jRStyledText.getAttributedString().getIterator();
        while (n < jRStyledText.length() && (n = attributedCharacterIterator.getRunLimit()) <= jRStyledText.length()) {
            this.exportStyledTextRun(attributedCharacterIterator.getAttributes(), string.substring(attributedCharacterIterator.getIndex(), n));
            attributedCharacterIterator.setIndex(n);
        }
    }

    protected void exportStyledTextRun(Map map, String string) throws IOException {
        Object object;
        String string2 = (String)map.get(TextAttribute.FAMILY);
        String string3 = this.fontMap != null && this.fontMap.containsKey(string2) ? (String)this.fontMap.get(string2) : string2;
        this.writer.write("<span style=\"font-family: ");
        this.writer.write(string3);
        this.writer.write("; ");
        Color color = (Color)map.get(TextAttribute.FOREGROUND);
        if (!Color.black.equals(color)) {
            this.writer.write("color: #");
            object = Integer.toHexString(color.getRGB() & colorMask).toUpperCase();
            object = ("000000" + (String)object).substring(((String)object).length());
            this.writer.write((String)object);
            this.writer.write("; ");
        }
        if ((object = (Color)map.get(TextAttribute.BACKGROUND)) != null) {
            this.writer.write("background-color: #");
            String string4 = Integer.toHexString(((Color)object).getRGB() & colorMask).toUpperCase();
            string4 = ("000000" + string4).substring(string4.length());
            this.writer.write(string4);
            this.writer.write("; ");
        }
        this.writer.write("font-size: ");
        this.writer.write(String.valueOf(map.get(TextAttribute.SIZE)));
        this.writer.write(this.sizeUnit);
        this.writer.write(";");
        if (TextAttribute.WEIGHT_BOLD.equals(map.get(TextAttribute.WEIGHT))) {
            this.writer.write(" font-weight: bold;");
        }
        if (TextAttribute.POSTURE_OBLIQUE.equals(map.get(TextAttribute.POSTURE))) {
            this.writer.write(" font-style: italic;");
        }
        if (TextAttribute.UNDERLINE_ON.equals(map.get(TextAttribute.UNDERLINE))) {
            this.writer.write(" text-decoration: underline;");
        }
        if (TextAttribute.STRIKETHROUGH_ON.equals(map.get(TextAttribute.STRIKETHROUGH))) {
            this.writer.write(" text-decoration: line-through;");
        }
        this.writer.write("\">");
        this.writer.write(JRStringUtil.htmlEncode(string));
        this.writer.write("</span>");
    }

    protected void exportText(JRPrintText jRPrintText, JRExporterGridCell jRExporterGridCell) throws IOException {
        JRStyledText jRStyledText = this.getStyledText(jRPrintText);
        int n = 0;
        if (jRStyledText != null) {
            n = jRStyledText.length();
        }
        this.writeCellTDStart(jRExporterGridCell);
        String string = HTML_VERTICAL_ALIGN_TOP;
        switch (jRPrintText.getVerticalAlignment()) {
            case 3: {
                string = HTML_VERTICAL_ALIGN_BOTTOM;
                break;
            }
            case 2: {
                string = HTML_VERTICAL_ALIGN_MIDDLE;
                break;
            }
            default: {
                string = HTML_VERTICAL_ALIGN_TOP;
            }
        }
        if (!string.equals(HTML_VERTICAL_ALIGN_TOP)) {
            this.writer.write(" valign=\"");
            this.writer.write(string);
            this.writer.write("\"");
        }
        if (jRPrintText.getRunDirection() == 1) {
            this.writer.write(" dir=\"rtl\"");
        }
        StringBuffer stringBuffer = new StringBuffer();
        this.appendBackcolorStyle(jRPrintText, stringBuffer);
        this.appendBorderStyle(jRPrintText, jRPrintText, stringBuffer);
        String string2 = CSS_TEXT_ALIGN_LEFT;
        if (n > 0) {
            switch (jRPrintText.getHorizontalAlignment()) {
                case 3: {
                    string2 = CSS_TEXT_ALIGN_RIGHT;
                    break;
                }
                case 2: {
                    string2 = CSS_TEXT_ALIGN_CENTER;
                    break;
                }
                case 4: {
                    string2 = CSS_TEXT_ALIGN_JUSTIFY;
                    break;
                }
                default: {
                    string2 = CSS_TEXT_ALIGN_LEFT;
                }
            }
            if (jRPrintText.getRunDirection() == 0 && !string2.equals(CSS_TEXT_ALIGN_LEFT) || jRPrintText.getRunDirection() == 1 && !string2.equals(CSS_TEXT_ALIGN_RIGHT)) {
                stringBuffer.append("text-align: ");
                stringBuffer.append(string2);
                stringBuffer.append(";");
            }
        }
        if (this.isWrapBreakWord) {
            stringBuffer.append("width: " + jRExporterGridCell.width + this.sizeUnit + "; ");
            stringBuffer.append("word-wrap: break-word; ");
        }
        if (stringBuffer.length() > 0) {
            this.writer.write(" style=\"");
            this.writer.write(stringBuffer.toString());
            this.writer.write("\"");
        }
        this.writer.write(">");
        if (jRPrintText.getAnchorName() != null) {
            this.writer.write("<a name=\"");
            this.writer.write(jRPrintText.getAnchorName());
            this.writer.write("\"/>");
        }
        String string3 = null;
        switch (jRPrintText.getHyperlinkType()) {
            case 2: {
                if (jRPrintText.getHyperlinkReference() == null) break;
                string3 = jRPrintText.getHyperlinkReference();
                break;
            }
            case 3: {
                if (jRPrintText.getHyperlinkAnchor() == null) break;
                string3 = "#" + jRPrintText.getHyperlinkAnchor();
                break;
            }
            case 4: {
                if (jRPrintText.getHyperlinkPage() == null) break;
                string3 = "#JR_PAGE_ANCHOR_" + this.reportIndex + "_" + jRPrintText.getHyperlinkPage().toString();
                break;
            }
            case 5: {
                if (jRPrintText.getHyperlinkReference() == null || jRPrintText.getHyperlinkAnchor() == null) break;
                string3 = jRPrintText.getHyperlinkReference() + "#" + jRPrintText.getHyperlinkAnchor();
                break;
            }
            case 6: {
                if (jRPrintText.getHyperlinkReference() == null || jRPrintText.getHyperlinkPage() == null) break;
                string3 = jRPrintText.getHyperlinkReference() + "#" + JR_PAGE_ANCHOR_PREFIX + "0_" + jRPrintText.getHyperlinkPage().toString();
                break;
            }
        }
        String string4 = null;
        switch (jRPrintText.getHyperlinkTarget()) {
            case 2: {
                string4 = "_blank";
                break;
            }
        }
        if (string3 != null) {
            this.writer.write("<a href=\"");
            this.writer.write(string3);
            this.writer.write("\"");
            if (string4 != null) {
                this.writer.write(" target=\"");
                this.writer.write(string4);
                this.writer.write("\"");
            }
            this.writer.write(">");
        }
        if (n > 0) {
            this.exportStyledText(jRStyledText);
        } else {
            this.writer.write(this.emptyCellStringProvider.getStringForEmptyTD(this.imagesURI));
        }
        if (string3 != null) {
            this.writer.write("</a>");
        }
        this.writer.write("</td>\n");
    }

    protected void appendBorderStyle(JRPrintElement jRPrintElement, JRBox jRBox, StringBuffer stringBuffer) {
        if (jRBox != null) {
            this.appendBorder(stringBuffer, jRBox.getTopBorder(), jRBox.getTopBorderColor() == null ? jRPrintElement.getForecolor() : jRBox.getTopBorderColor(), jRBox.getTopPadding(), HTML_VERTICAL_ALIGN_TOP);
            this.appendBorder(stringBuffer, jRBox.getLeftBorder(), jRBox.getLeftBorderColor() == null ? jRPrintElement.getForecolor() : jRBox.getLeftBorderColor(), jRBox.getLeftPadding(), CSS_TEXT_ALIGN_LEFT);
            this.appendBorder(stringBuffer, jRBox.getBottomBorder(), jRBox.getBottomBorderColor() == null ? jRPrintElement.getForecolor() : jRBox.getBottomBorderColor(), jRBox.getBottomPadding(), HTML_VERTICAL_ALIGN_BOTTOM);
            this.appendBorder(stringBuffer, jRBox.getRightBorder(), jRBox.getRightBorderColor() == null ? jRPrintElement.getForecolor() : jRBox.getRightBorderColor(), jRBox.getRightPadding(), CSS_TEXT_ALIGN_RIGHT);
        }
    }

    protected Color appendBackcolorStyle(JRPrintElement jRPrintElement, StringBuffer stringBuffer) {
        if (jRPrintElement.getMode() == 1 && (this.backcolor == null || jRPrintElement.getBackcolor().getRGB() != this.backcolor.getRGB())) {
            stringBuffer.append("background-color: #");
            String string = Integer.toHexString(jRPrintElement.getBackcolor().getRGB() & colorMask).toUpperCase();
            string = ("000000" + string).substring(string.length());
            stringBuffer.append(string);
            stringBuffer.append("; ");
            return jRPrintElement.getBackcolor();
        }
        return null;
    }

    protected void exportImage(JRPrintImage jRPrintImage, JRExporterGridCell jRExporterGridCell) throws JRException, IOException {
        int n;
        this.writeCellTDStart(jRExporterGridCell);
        String string = CSS_TEXT_ALIGN_LEFT;
        switch (jRPrintImage.getHorizontalAlignment()) {
            case 3: {
                string = CSS_TEXT_ALIGN_RIGHT;
                break;
            }
            case 2: {
                string = CSS_TEXT_ALIGN_CENTER;
                break;
            }
            default: {
                string = CSS_TEXT_ALIGN_LEFT;
            }
        }
        if (!string.equals(CSS_TEXT_ALIGN_LEFT)) {
            this.writer.write(" align=\"");
            this.writer.write(string);
            this.writer.write("\"");
        }
        String string2 = HTML_VERTICAL_ALIGN_TOP;
        switch (jRPrintImage.getVerticalAlignment()) {
            case 3: {
                string2 = HTML_VERTICAL_ALIGN_BOTTOM;
                break;
            }
            case 2: {
                string2 = HTML_VERTICAL_ALIGN_MIDDLE;
                break;
            }
            default: {
                string2 = HTML_VERTICAL_ALIGN_TOP;
            }
        }
        if (!string2.equals(HTML_VERTICAL_ALIGN_TOP)) {
            this.writer.write(" valign=\"");
            this.writer.write(string2);
            this.writer.write("\"");
        }
        StringBuffer stringBuffer = new StringBuffer();
        this.appendBackcolorStyle(jRPrintImage, stringBuffer);
        this.appendBorderStyle(jRPrintImage, jRPrintImage, stringBuffer);
        if (stringBuffer.length() > 0) {
            this.writer.write(" style=\"");
            this.writer.write(stringBuffer.toString());
            this.writer.write("\"");
        }
        this.writer.write(">");
        if (jRPrintImage.getAnchorName() != null) {
            this.writer.write("<a name=\"");
            this.writer.write(jRPrintImage.getAnchorName());
            this.writer.write("\"/>");
        }
        String string3 = null;
        switch (jRPrintImage.getHyperlinkType()) {
            case 2: {
                if (jRPrintImage.getHyperlinkReference() == null) break;
                string3 = jRPrintImage.getHyperlinkReference();
                break;
            }
            case 3: {
                if (jRPrintImage.getHyperlinkAnchor() == null) break;
                string3 = "#" + jRPrintImage.getHyperlinkAnchor();
                break;
            }
            case 4: {
                if (jRPrintImage.getHyperlinkPage() == null) break;
                string3 = "#JR_PAGE_ANCHOR_" + this.reportIndex + "_" + jRPrintImage.getHyperlinkPage().toString();
                break;
            }
            case 5: {
                if (jRPrintImage.getHyperlinkReference() == null || jRPrintImage.getHyperlinkAnchor() == null) break;
                string3 = jRPrintImage.getHyperlinkReference() + "#" + jRPrintImage.getHyperlinkAnchor();
                break;
            }
            case 6: {
                if (jRPrintImage.getHyperlinkReference() == null || jRPrintImage.getHyperlinkPage() == null) break;
                string3 = jRPrintImage.getHyperlinkReference() + "#" + JR_PAGE_ANCHOR_PREFIX + "0_" + jRPrintImage.getHyperlinkPage().toString();
                break;
            }
        }
        String string4 = null;
        switch (jRPrintImage.getHyperlinkTarget()) {
            case 2: {
                string4 = "_blank";
                break;
            }
        }
        if (string3 != null) {
            this.writer.write("<a href=\"");
            this.writer.write(string3);
            this.writer.write("\"");
            if (string4 != null) {
                this.writer.write(" target=\"");
                this.writer.write(string4);
                this.writer.write("\"");
            }
            this.writer.write(">");
        }
        this.writer.write("<img");
        String string5 = null;
        int n2 = jRPrintImage.getScaleImage();
        JRRenderable jRRenderable = jRPrintImage.getRenderer();
        if (jRRenderable != null) {
            if (jRRenderable.getType() == 0 && this.rendererToImagePathMap.containsKey(jRRenderable.getId())) {
                string5 = (String)this.rendererToImagePathMap.get(jRRenderable.getId());
            } else {
                if (jRPrintImage.isLazy()) {
                    string5 = ((JRImageRenderer)jRRenderable).getImageLocation();
                } else {
                    JRPrintElementIndex jRPrintElementIndex = new JRPrintElementIndex(this.reportIndex, this.pageIndex, jRExporterGridCell.elementIndex);
                    this.imagesToProcess.add(jRPrintElementIndex);
                    String string6 = JRHtmlExporter.getImageName(jRPrintElementIndex);
                    string5 = this.imagesURI + string6;
                    if (this.imageNameToImageDataMap != null) {
                        if (jRRenderable.getType() == 1) {
                            jRRenderable = new JRWrappingSvgRenderer(jRRenderable, new Dimension(jRPrintImage.getWidth(), jRPrintImage.getHeight()), jRPrintImage.getBackcolor());
                        }
                        this.imageNameToImageDataMap.put(string6, jRRenderable.getImageData());
                    }
                }
                this.rendererToImagePathMap.put(jRRenderable.getId(), string5);
            }
        } else {
            this.loadPxImage();
            string5 = this.imagesURI + "px";
            n2 = 2;
        }
        this.writer.write(" src=\"");
        if (string5 != null) {
            this.writer.write(string5);
        }
        this.writer.write("\"");
        int n3 = 0;
        switch (jRPrintImage.getPen()) {
            case 4: {
                n3 = 1;
                break;
            }
            case 3: {
                n3 = 4;
                break;
            }
            case 2: {
                n3 = 2;
                break;
            }
            case 0: {
                n3 = 0;
                break;
            }
            case 5: {
                n3 = 1;
                break;
            }
            default: {
                n3 = 1;
            }
        }
        this.writer.write(" border=\"");
        this.writer.write(String.valueOf(n3));
        this.writer.write("\"");
        int n4 = jRPrintImage.getWidth() - jRPrintImage.getLeftPadding() - jRPrintImage.getRightPadding();
        if (n4 < 0) {
            n4 = 0;
        }
        if ((n = jRPrintImage.getHeight() - jRPrintImage.getTopPadding() - jRPrintImage.getBottomPadding()) < 0) {
            n = 0;
        }
        switch (n2) {
            case 2: {
                this.writer.write(" style=\"width: ");
                this.writer.write(String.valueOf(n4));
                this.writer.write(this.sizeUnit);
                this.writer.write("; height: ");
                this.writer.write(String.valueOf(n));
                this.writer.write(this.sizeUnit);
                this.writer.write("\"");
                break;
            }
            default: {
                Dimension2D dimension2D;
                double d = n4;
                double d2 = n;
                if (!jRPrintImage.isLazy() && (dimension2D = jRRenderable.getDimension()) != null) {
                    d = dimension2D.getWidth();
                    d2 = dimension2D.getHeight();
                }
                if (n <= 0) break;
                double d3 = d / d2;
                if (d3 > (double)n4 / (double)n) {
                    this.writer.write(" style=\"width: ");
                    this.writer.write(String.valueOf(n4));
                    this.writer.write(this.sizeUnit);
                    this.writer.write("\"");
                    break;
                }
                this.writer.write(" style=\"height: ");
                this.writer.write(String.valueOf(n));
                this.writer.write(this.sizeUnit);
                this.writer.write("\"");
            }
        }
        this.writer.write("/>");
        if (string3 != null) {
            this.writer.write("</a>");
        }
        this.writer.write("</td>\n");
    }

    protected JRGridLayout getPageGridLayout(JRPrintPage jRPrintPage) {
        JRGridLayout jRGridLayout = new JRGridLayout(jRPrintPage.getElements(), null, this.jasperPrint.getPageWidth(), this.jasperPrint.getPageHeight(), this.globalOffsetX, this.globalOffsetY, JRGridLayout.UNIVERSAL_EXPORTER, false, true, true, null);
        return jRGridLayout;
    }

    protected void loadPxImage() throws JRException {
        this.isPxImageLoaded = true;
        if (this.imageNameToImageDataMap != null && !this.imageNameToImageDataMap.containsKey("px")) {
            JRRenderable jRRenderable = JRImageRenderer.getInstance("net/sf/jasperreports/engine/images/pixel.GIF", (byte)1);
            this.rendererToImagePathMap.put(jRRenderable.getId(), this.imagesURI + "px");
            this.imageNameToImageDataMap.put("px", jRRenderable.getImageData());
        }
    }

    private void appendBorder(StringBuffer stringBuffer, byte by, Color color, int n, String string) {
        String string2 = null;
        String string3 = null;
        switch (by) {
            case 4: {
                string2 = "dashed";
                string3 = "1";
                break;
            }
            case 3: {
                string2 = "solid";
                string3 = "4";
                break;
            }
            case 2: {
                string2 = "solid";
                string3 = "2";
                break;
            }
            case 5: {
                string2 = "solid";
                string3 = "1";
                break;
            }
            case 0: {
                break;
            }
            default: {
                string2 = "solid";
                string3 = "1";
            }
        }
        if (string3 != null) {
            stringBuffer.append("border-");
            stringBuffer.append(string);
            stringBuffer.append("-style: ");
            stringBuffer.append(string2);
            stringBuffer.append("; ");
            stringBuffer.append("border-");
            stringBuffer.append(string);
            stringBuffer.append("-width: ");
            stringBuffer.append(string3);
            stringBuffer.append(this.sizeUnit);
            stringBuffer.append("; ");
            stringBuffer.append("border-");
            stringBuffer.append(string);
            stringBuffer.append("-color: #");
            String string4 = Integer.toHexString(color.getRGB() & colorMask).toUpperCase();
            string4 = ("000000" + string4).substring(string4.length());
            stringBuffer.append(string4);
            stringBuffer.append("; ");
        }
        if (n > 0) {
            stringBuffer.append("padding-");
            stringBuffer.append(string);
            stringBuffer.append(": ");
            stringBuffer.append(n);
            stringBuffer.append(this.sizeUnit);
            stringBuffer.append("; ");
        }
    }

    public static String getImageName(JRPrintElementIndex jRPrintElementIndex) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("img_");
        stringBuffer.append(jRPrintElementIndex.getReportIndex());
        stringBuffer.append('_');
        stringBuffer.append(jRPrintElementIndex.getPageIndex());
        Integer[] integerArray = jRPrintElementIndex.getElementIndexes();
        for (int i = 0; i < integerArray.length; ++i) {
            stringBuffer.append('_');
            stringBuffer.append(integerArray[i]);
        }
        return stringBuffer.toString();
    }

    public static JRPrintElementIndex getPrintElementIndex(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "_");
        if (!"img".equals(stringTokenizer.nextElement())) {
            throw new JRRuntimeException("Invalid image name: " + string);
        }
        int n = Integer.parseInt(stringTokenizer.nextToken());
        int n2 = Integer.parseInt(stringTokenizer.nextToken());
        Integer[] integerArray = new Integer[stringTokenizer.countTokens()];
        int n3 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            integerArray[n3++] = Integer.valueOf(stringTokenizer.nextToken());
        }
        return new JRPrintElementIndex(n, n2, integerArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exportFrame(JRPrintFrame jRPrintFrame, JRExporterGridCell jRExporterGridCell) throws IOException, JRException {
        this.writeCellTDStart(jRExporterGridCell);
        StringBuffer stringBuffer = new StringBuffer();
        Color color = this.appendBackcolorStyle(jRPrintFrame, stringBuffer);
        this.appendBorderStyle(jRPrintFrame, jRPrintFrame, stringBuffer);
        if (stringBuffer.length() > 0) {
            this.writer.write(" style=\"");
            this.writer.write(stringBuffer.toString());
            this.writer.write("\"");
        }
        this.writer.write(">\n");
        if (color != null) {
            this.setBackcolor(color);
        }
        try {
            JRGridLayout jRGridLayout = new JRGridLayout(jRPrintFrame.getElements(), null, jRPrintFrame.getWidth(), jRPrintFrame.getHeight(), 0, 0, JRGridLayout.UNIVERSAL_EXPORTER, false, true, true, jRExporterGridCell.elementIndex);
            this.exportGrid(jRGridLayout, false);
        }
        finally {
            if (color != null) {
                this.restoreBackcolor();
            }
        }
        this.writer.write("</td>\n");
    }

    protected void setBackcolor(Color color) {
        this.backcolorStack.addLast(this.backcolor);
        this.backcolor = color;
    }

    protected void restoreBackcolor() {
        this.backcolor = (Color)this.backcolorStack.removeLast();
    }

    protected static interface StringProvider {
        public String getStringForCollapsedTD(Object var1);

        public String getStringForEmptyTD(Object var1);
    }
}

