/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.StringTokenizer;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.JRCsvExporterParameter;
import net.sf.jasperreports.engine.export.JRExportProgressMonitor;
import net.sf.jasperreports.engine.export.JRExporterGridCell;
import net.sf.jasperreports.engine.export.JRGridLayout;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.engine.util.JRStyledTextParser;
import org.xml.sax.SAXException;

public class JRCsvExporter
extends JRAbstractExporter {
    protected JRStyledTextParser styledTextParser = new JRStyledTextParser();
    protected String delimiter = null;
    protected String recordDelimiter = null;
    protected Writer writer = null;
    protected JRExportProgressMonitor progressMonitor = null;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void exportReport() throws JRException {
        StringBuffer stringBuffer;
        String string;
        this.progressMonitor = (JRExportProgressMonitor)this.parameters.get(JRExporterParameter.PROGRESS_MONITOR);
        this.setOffset();
        this.setInput();
        if (!this.isModeBatch) {
            this.setPageRange();
        }
        if ((string = (String)this.parameters.get(JRExporterParameter.CHARACTER_ENCODING)) == null) {
            string = "ISO-8859-1";
        }
        this.delimiter = (String)this.parameters.get(JRCsvExporterParameter.FIELD_DELIMITER);
        if (this.delimiter == null) {
            this.delimiter = ",";
        }
        this.recordDelimiter = (String)this.parameters.get(JRCsvExporterParameter.RECORD_DELIMITER);
        if (this.recordDelimiter == null) {
            this.recordDelimiter = "\n";
        }
        if ((stringBuffer = (StringBuffer)this.parameters.get(JRExporterParameter.OUTPUT_STRING_BUFFER)) != null) {
            try {
                try {
                    this.writer = new StringWriter();
                    this.exportReportToWriter();
                    stringBuffer.append(this.writer.toString());
                }
                catch (IOException iOException) {
                    throw new JRException("Error writing to StringBuffer writer : " + this.jasperPrint.getName(), iOException);
                }
                Object var5_3 = null;
                if (this.writer == null) return;
            }
            catch (Throwable throwable) {
                Object var5_4 = null;
                if (this.writer == null) throw throwable;
                try {
                    this.writer.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (IOException iOException) {}
            this.writer.close();
            return;
        }
        this.writer = (Writer)this.parameters.get(JRExporterParameter.OUTPUT_WRITER);
        if (this.writer != null) {
            try {
                this.exportReportToWriter();
                return;
            }
            catch (IOException iOException) {
                throw new JRException("Error writing to writer : " + this.jasperPrint.getName(), iOException);
            }
        }
        OutputStream outputStream = (OutputStream)this.parameters.get(JRExporterParameter.OUTPUT_STREAM);
        if (outputStream != null) {
            try {
                this.writer = new OutputStreamWriter(outputStream, string);
                this.exportReportToWriter();
                return;
            }
            catch (IOException iOException) {
                throw new JRException("Error writing to OutputStream writer : " + this.jasperPrint.getName(), iOException);
            }
        }
        File file = (File)this.parameters.get(JRExporterParameter.OUTPUT_FILE);
        if (file == null) {
            String string2 = (String)this.parameters.get(JRExporterParameter.OUTPUT_FILE_NAME);
            if (string2 == null) throw new JRException("No output specified for the exporter.");
            file = new File(string2);
        }
        try {
            try {
                outputStream = new FileOutputStream(file);
                this.writer = new OutputStreamWriter(outputStream, string);
                this.exportReportToWriter();
            }
            catch (IOException iOException) {
                throw new JRException("Error writing to file writer : " + this.jasperPrint.getName(), iOException);
            }
            Object var8_15 = null;
            if (this.writer == null) return;
        }
        catch (Throwable throwable) {
            Object var8_16 = null;
            if (this.writer == null) throw throwable;
            try {
                this.writer.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        this.writer.close();
        return;
    }

    protected void exportReportToWriter() throws JRException, IOException {
        for (int i = 0; i < this.jasperPrintList.size(); ++i) {
            this.jasperPrint = (JasperPrint)this.jasperPrintList.get(i);
            List list = this.jasperPrint.getPages();
            if (list == null || list.size() <= 0) continue;
            if (this.isModeBatch) {
                this.startPageIndex = 0;
                this.endPageIndex = list.size() - 1;
            }
            for (int j = this.startPageIndex; j <= this.endPageIndex; ++j) {
                if (Thread.currentThread().isInterrupted()) {
                    throw new JRException("Current thread interrupted.");
                }
                JRPrintPage jRPrintPage = (JRPrintPage)list.get(j);
                this.exportPage(jRPrintPage);
            }
        }
        this.writer.flush();
    }

    protected void exportPage(JRPrintPage jRPrintPage) throws IOException {
        JRGridLayout jRGridLayout = new JRGridLayout(jRPrintPage.getElements(), null, this.jasperPrint.getPageWidth(), this.jasperPrint.getPageHeight(), this.globalOffsetX, this.globalOffsetY, JRGridLayout.TEXT_EXPORTER, true, false, false, null);
        JRExporterGridCell[][] jRExporterGridCellArray = jRGridLayout.getGrid();
        boolean[] blArray = jRGridLayout.getIsRowNotEmpty();
        boolean[] blArray2 = jRGridLayout.getIsColumnNotEmpty();
        StringBuffer stringBuffer = null;
        JRPrintElement jRPrintElement = null;
        String string = null;
        boolean bl = true;
        for (int i = 0; i < jRExporterGridCellArray.length; ++i) {
            stringBuffer = new StringBuffer();
            if (!blArray[i]) continue;
            bl = true;
            for (int j = 0; j < jRExporterGridCellArray[i].length; ++j) {
                if (jRExporterGridCellArray[i][j].element != null) {
                    jRPrintElement = jRExporterGridCellArray[i][j].element;
                    if (!(jRPrintElement instanceof JRPrintText)) continue;
                    JRStyledText jRStyledText = this.getStyledText((JRPrintText)jRPrintElement);
                    string = jRStyledText == null ? "" : jRStyledText.getText();
                    if (!bl) {
                        stringBuffer.append(this.delimiter);
                    }
                    stringBuffer.append(this.prepareText(string));
                    bl = false;
                    continue;
                }
                if (!blArray2[j]) continue;
                if (!bl) {
                    stringBuffer.append(this.delimiter);
                }
                bl = false;
            }
            if (stringBuffer.length() <= 0) continue;
            this.writer.write(stringBuffer.toString());
            this.writer.write(this.recordDelimiter);
        }
        if (this.progressMonitor != null) {
            this.progressMonitor.afterPageExport();
        }
    }

    protected JRStyledText getStyledText(JRPrintText jRPrintText) {
        JRStyledText jRStyledText = null;
        String string = jRPrintText.getText();
        if (string != null) {
            if (jRPrintText.isStyledText()) {
                try {
                    jRStyledText = this.styledTextParser.parse(null, string);
                }
                catch (SAXException sAXException) {
                    // empty catch block
                }
            }
            if (jRStyledText == null) {
                jRStyledText = new JRStyledText();
                jRStyledText.append(string);
                jRStyledText.addRun(new JRStyledText.Run(null, 0, string.length()));
            }
        }
        return jRStyledText;
    }

    protected String prepareText(String string) {
        String string2 = null;
        if (string != null) {
            boolean bl = false;
            if (string.indexOf(this.delimiter) >= 0) {
                bl = true;
            }
            StringBuffer stringBuffer = new StringBuffer();
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",\"\n", true);
            String string3 = null;
            while (stringTokenizer.hasMoreTokens()) {
                string3 = stringTokenizer.nextToken();
                if (",".equals(string3)) {
                    bl = true;
                    stringBuffer.append(",");
                    continue;
                }
                if ("\"".equals(string3)) {
                    bl = true;
                    stringBuffer.append("\"\"");
                    continue;
                }
                if ("\n".equals(string3)) {
                    bl = true;
                    stringBuffer.append("\n");
                    continue;
                }
                stringBuffer.append(string3);
            }
            string2 = stringBuffer.toString();
            if (bl) {
                string2 = "\"" + string2 + "\"";
            }
        }
        return string2;
    }
}

