/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import com.keypoint.PngEncoderB;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Dimension2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import jxl.CellView;
import jxl.JXLException;
import jxl.SheetSettings;
import jxl.Workbook;
import jxl.format.Alignment;
import jxl.format.BoldStyle;
import jxl.format.Border;
import jxl.format.BorderLineStyle;
import jxl.format.CellFormat;
import jxl.format.Colour;
import jxl.format.Orientation;
import jxl.format.PageOrientation;
import jxl.format.PaperSize;
import jxl.format.Pattern;
import jxl.format.UnderlineStyle;
import jxl.format.VerticalAlignment;
import jxl.write.Blank;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableCell;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import jxl.write.WritableHyperlink;
import jxl.write.WritableImage;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;
import net.sf.jasperreports.engine.JRBox;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRPrintLine;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRRenderable;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.JExcelApiExporterParameter;
import net.sf.jasperreports.engine.export.JRExporterGridCell;
import net.sf.jasperreports.engine.export.JRGridLayout;
import net.sf.jasperreports.engine.export.JRXlsAbstractExporter;
import net.sf.jasperreports.engine.util.JRStyledText;
import org.apache.commons.collections.ReferenceMap;

public class JExcelApiExporter
extends JRXlsAbstractExporter {
    private static final Colour WHITE = Colour.WHITE;
    private static final Colour BLACK = Colour.BLACK;
    private static Map colorsCache = new ReferenceMap();
    private Map loadedCellStyles = new HashMap();
    private WritableWorkbook workbook = null;
    private WritableSheet sheet = null;
    private WritableCellFormat emptyCellStyle = null;
    private boolean isFontSizeFixEnabled = false;
    private Pattern backgroundMode = Pattern.SOLID;

    protected void setParameters() {
        super.setParameters();
        Boolean bl = (Boolean)this.parameters.get(JExcelApiExporterParameter.IS_FONT_SIZE_FIX_ENABLED);
        if (bl != null) {
            this.isFontSizeFixEnabled = bl;
        }
    }

    protected void setBackground() {
        this.backgroundMode = Pattern.SOLID;
    }

    protected void openWorkbook(OutputStream outputStream) throws JRException {
        try {
            this.workbook = Workbook.createWorkbook((OutputStream)outputStream);
            this.emptyCellStyle = new WritableCellFormat();
            this.emptyCellStyle.setBackground(WHITE, this.backgroundMode);
        }
        catch (IOException iOException) {
            throw new JRException("Error generating XLS report : " + this.jasperPrint.getName(), iOException);
        }
        catch (WriteException writeException) {
            throw new JRException("Error generating XLS report : " + this.jasperPrint.getName(), writeException);
        }
    }

    protected void createSheet(String string) {
        this.sheet = this.workbook.createSheet(string, Integer.MAX_VALUE);
        this.setSheetSettings(this.sheet);
    }

    protected void closeWorkbook(OutputStream outputStream) throws JRException {
        try {
            this.workbook.write();
            this.workbook.close();
        }
        catch (IOException iOException) {
            throw new JRException("Error generating XLS report : " + this.jasperPrint.getName(), iOException);
        }
        catch (WriteException writeException) {
            throw new JRException("Error generating XLS report : " + this.jasperPrint.getName(), writeException);
        }
    }

    protected void setColumnWidth(short s, short s2) {
        CellView cellView = new CellView();
        cellView.setSize((int)s2);
        this.sheet.setColumnView((int)s, cellView);
    }

    protected void setRowHeight(int n, int n2) throws JRException {
        try {
            this.sheet.setRowView(n, n2 * 20);
        }
        catch (RowsExceededException rowsExceededException) {
            throw new JRException("Error generating XLS report : " + this.jasperPrint.getName(), rowsExceededException);
        }
    }

    protected void setCell(int n, int n2) {
    }

    protected void addBlankCell(JRExporterGridCell jRExporterGridCell, int n, int n2) throws JRException {
        try {
            Colour colour = BLACK;
            if (jRExporterGridCell.getForecolor() != null) {
                colour = JExcelApiExporter.getNearestColour(jRExporterGridCell.getForecolor());
            }
            Colour colour2 = WHITE;
            if (jRExporterGridCell.getBackcolor() != null) {
                colour2 = JExcelApiExporter.getNearestColour(jRExporterGridCell.getBackcolor());
            }
            Pattern pattern = this.backgroundMode;
            WritableFont writableFont = this.getLoadedFont(this.getDefaultFont(), colour.getValue());
            WritableCellFormat writableCellFormat = this.getLoadedCellStyle(pattern, colour2, Alignment.LEFT.getValue(), VerticalAlignment.TOP.getValue(), Orientation.HORIZONTAL.getValue(), writableFont, jRExporterGridCell);
            this.sheet.addCell((WritableCell)new Blank(n, n2, (CellFormat)writableCellFormat));
        }
        catch (RowsExceededException rowsExceededException) {
            throw new JRException("Error generating XLS report : " + this.jasperPrint.getName(), rowsExceededException);
        }
        catch (WriteException writeException) {
            throw new JRException("Error generating XLS report : " + this.jasperPrint.getName(), writeException);
        }
    }

    protected void exportLine(JRPrintLine jRPrintLine, JRExporterGridCell jRExporterGridCell, int n, int n2) throws JRException {
        this.addMergeRegion(jRExporterGridCell, n, n2);
        Colour colour = JExcelApiExporter.getNearestColour(jRPrintLine.getForecolor());
        WritableFont writableFont = this.getLoadedFont(this.getDefaultFont(), colour.getValue());
        WritableCellFormat writableCellFormat = this.getLoadedCellStyle(Pattern.SOLID, colour, Alignment.LEFT.getValue(), VerticalAlignment.TOP.getValue(), Orientation.HORIZONTAL.getValue(), writableFont, jRExporterGridCell);
        Blank blank = new Blank(n, n2, (CellFormat)writableCellFormat);
        try {
            this.sheet.addCell((WritableCell)blank);
        }
        catch (Exception exception) {
            throw new JRException("Can't add cell.", exception);
        }
    }

    protected void exportRectangle(JRPrintElement jRPrintElement, JRExporterGridCell jRExporterGridCell, int n, int n2) throws JRException {
        this.addMergeRegion(jRExporterGridCell, n, n2);
        Colour colour = JExcelApiExporter.getNearestColour(jRPrintElement.getForecolor());
        Colour colour2 = WHITE;
        Pattern pattern = this.backgroundMode;
        if (jRPrintElement.getMode() == 1) {
            pattern = Pattern.SOLID;
            colour2 = JExcelApiExporter.getNearestColour(jRPrintElement.getBackcolor());
        } else if (jRExporterGridCell.getBackcolor() != null) {
            pattern = Pattern.SOLID;
            colour2 = JExcelApiExporter.getNearestColour(jRExporterGridCell.getBackcolor());
        }
        WritableFont writableFont = this.getLoadedFont(this.getDefaultFont(), colour.getValue());
        WritableCellFormat writableCellFormat = this.getLoadedCellStyle(pattern, colour2, Alignment.LEFT.getValue(), VerticalAlignment.TOP.getValue(), Orientation.HORIZONTAL.getValue(), writableFont, jRExporterGridCell);
        Blank blank = new Blank(n, n2, (CellFormat)writableCellFormat);
        try {
            this.sheet.addCell((WritableCell)blank);
        }
        catch (Exception exception) {
            throw new JRException("Can't add cell.", exception);
        }
    }

    protected void exportText(JRPrintText jRPrintText, JRExporterGridCell jRExporterGridCell, int n, int n2) throws JRException {
        this.addMergeRegion(jRExporterGridCell, n, n2);
        JRStyledText jRStyledText = this.getStyledText(jRPrintText);
        if (jRStyledText != null) {
            Colour colour = JExcelApiExporter.getNearestColour(jRPrintText.getForecolor());
            WritableFont writableFont = this.getLoadedFont(jRPrintText, colour.getValue());
            JRXlsAbstractExporter.TextAlignHolder textAlignHolder = JExcelApiExporter.getTextAlignHolder(jRPrintText);
            int n3 = this.getHorizontalAlignment(textAlignHolder);
            int n4 = this.getVerticalAlignment(textAlignHolder);
            int n5 = this.getRotation(textAlignHolder);
            Pattern pattern = this.backgroundMode;
            Colour colour2 = WHITE;
            if (jRPrintText.getMode() == 1) {
                pattern = Pattern.SOLID;
                colour2 = JExcelApiExporter.getNearestColour(jRPrintText.getBackcolor());
            } else if (jRExporterGridCell.getBackcolor() != null) {
                pattern = Pattern.SOLID;
                colour2 = JExcelApiExporter.getNearestColour(jRExporterGridCell.getBackcolor());
            }
            WritableCellFormat writableCellFormat = this.getLoadedCellStyle(pattern, colour2, n3, n4, n5, writableFont, jRExporterGridCell);
            try {
                String string = jRStyledText.getText();
                switch (jRPrintText.getHyperlinkType()) {
                    case 2: {
                        if (jRPrintText.getHyperlinkReference() != null) {
                            URL uRL = new URL(jRPrintText.getHyperlinkReference());
                            WritableHyperlink writableHyperlink = new WritableHyperlink(n, n2, n, n2, uRL, string);
                            this.sheet.addHyperlink(writableHyperlink);
                            break;
                        }
                    }
                    default: {
                        if (this.isAutoDetectCellType) {
                            try {
                                double d = Double.parseDouble(string);
                                this.sheet.addCell((WritableCell)new Number(n, n2, d, (CellFormat)writableCellFormat));
                            }
                            catch (NumberFormatException numberFormatException) {
                                this.sheet.addCell((WritableCell)new Label(n, n2, string, (CellFormat)writableCellFormat));
                            }
                            break;
                        }
                        this.sheet.addCell((WritableCell)new Label(n, n2, string, (CellFormat)writableCellFormat));
                        break;
                    }
                }
            }
            catch (Exception exception) {
                throw new JRException("Can't add cell.", exception);
            }
        }
    }

    protected void addMergeRegion(JRExporterGridCell jRExporterGridCell, int n, int n2) throws JRException {
        if (jRExporterGridCell.colSpan > 1 || jRExporterGridCell.rowSpan > 1) {
            try {
                this.sheet.mergeCells(n, n2, n + jRExporterGridCell.colSpan - 1, n2 + jRExporterGridCell.rowSpan - 1);
            }
            catch (JXLException jXLException) {
                throw new JRException("Can't merge cells.", jXLException);
            }
        }
    }

    private int getHorizontalAlignment(JRXlsAbstractExporter.TextAlignHolder textAlignHolder) {
        switch (textAlignHolder.horizontalAlignment) {
            case 3: {
                return Alignment.RIGHT.getValue();
            }
            case 2: {
                return Alignment.CENTRE.getValue();
            }
            case 4: {
                return Alignment.JUSTIFY.getValue();
            }
        }
        return Alignment.LEFT.getValue();
    }

    private int getVerticalAlignment(JRXlsAbstractExporter.TextAlignHolder textAlignHolder) {
        switch (textAlignHolder.verticalAlignment) {
            case 3: {
                return VerticalAlignment.BOTTOM.getValue();
            }
            case 2: {
                return VerticalAlignment.CENTRE.getValue();
            }
            case 4: {
                return VerticalAlignment.JUSTIFY.getValue();
            }
        }
        return VerticalAlignment.TOP.getValue();
    }

    private int getRotation(JRXlsAbstractExporter.TextAlignHolder textAlignHolder) {
        switch (textAlignHolder.rotation) {
            case 1: {
                return Orientation.PLUS_90.getValue();
            }
            case 2: {
                return Orientation.MINUS_90.getValue();
            }
        }
        return Orientation.HORIZONTAL.getValue();
    }

    protected void exportImage(JRPrintImage jRPrintImage, JRExporterGridCell jRExporterGridCell, int n, int n2) throws JRException {
        this.addMergeRegion(jRExporterGridCell, n, n2);
        try {
            JRRenderable jRRenderable = jRPrintImage.getRenderer();
            int n3 = jRPrintImage.getLeftPadding();
            int n4 = jRPrintImage.getTopPadding();
            int n5 = jRPrintImage.getRightPadding();
            int n6 = jRPrintImage.getBottomPadding();
            int n7 = jRPrintImage.getWidth() - n3 - n5;
            n7 = n7 < 0 ? 0 : n7;
            int n8 = jRPrintImage.getHeight() - n4 - n6;
            int n9 = n8 = n8 < 0 ? 0 : n8;
            if (n7 > 0 && n8 > 0 && jRRenderable != null) {
                int n10 = n7;
                int n11 = n8;
                Dimension2D dimension2D = jRRenderable.getDimension();
                if (dimension2D != null) {
                    n10 = (int)dimension2D.getWidth();
                    n11 = (int)dimension2D.getHeight();
                }
                float f = 0.0f;
                switch (jRPrintImage.getHorizontalAlignment()) {
                    case 3: {
                        f = 1.0f;
                        break;
                    }
                    case 2: {
                        f = 0.5f;
                        break;
                    }
                    default: {
                        f = 0.0f;
                    }
                }
                float f2 = 0.0f;
                switch (jRPrintImage.getVerticalAlignment()) {
                    case 3: {
                        f2 = 1.0f;
                        break;
                    }
                    case 2: {
                        f2 = 0.5f;
                        break;
                    }
                    default: {
                        f2 = 0.0f;
                    }
                }
                BufferedImage bufferedImage = new BufferedImage(n7, n8, 1);
                Graphics2D graphics2D = bufferedImage.createGraphics();
                graphics2D.setColor(jRPrintImage.getBackcolor());
                graphics2D.fillRect(0, 0, n7, n8);
                switch (jRPrintImage.getScaleImage()) {
                    case 1: {
                        int n12 = (int)(f * (float)(n7 - n10));
                        int n13 = (int)(f2 * (float)(n8 - n11));
                        jRRenderable.render(graphics2D, new Rectangle(n12, n13, n10, n11));
                        break;
                    }
                    case 2: {
                        jRRenderable.render(graphics2D, new Rectangle(0, 0, n7, n8));
                        break;
                    }
                    default: {
                        if (jRPrintImage.getHeight() <= 0) break;
                        double d = (double)n10 / (double)n11;
                        if (d > (double)n7 / (double)n8) {
                            n10 = n7;
                            n11 = (int)((double)n7 / d);
                        } else {
                            n10 = (int)((double)n8 * d);
                            n11 = n8;
                        }
                        int n14 = (int)(f * (float)(n7 - n10));
                        int n15 = (int)(f2 * (float)(n8 - n11));
                        jRRenderable.render(graphics2D, new Rectangle(n14, n15, n10, n11));
                    }
                }
                Pattern pattern = this.backgroundMode;
                Colour colour = WHITE;
                Colour colour2 = JExcelApiExporter.getNearestColour(jRPrintImage.getForecolor());
                if (jRPrintImage.getBorderColor() != null) {
                    colour2 = JExcelApiExporter.getNearestColour(jRPrintImage.getBorderColor());
                }
                WritableFont writableFont = this.getLoadedFont(this.getDefaultFont(), colour2.getValue());
                if (jRPrintImage.getMode() == 1) {
                    pattern = Pattern.SOLID;
                    colour = JExcelApiExporter.getNearestColour(jRPrintImage.getBackcolor());
                }
                WritableCellFormat writableCellFormat = this.getLoadedCellStyle(pattern, colour, Alignment.LEFT.getValue(), VerticalAlignment.TOP.getValue(), Orientation.HORIZONTAL.getValue(), writableFont, jRExporterGridCell);
                this.sheet.addCell((WritableCell)new Blank(n, n2, (CellFormat)writableCellFormat));
                WritableImage writableImage = new WritableImage((double)n, (double)n2, (double)jRExporterGridCell.colSpan, (double)jRExporterGridCell.rowSpan, PngEncoderB.loadImageDataFromAWTImage((BufferedImage)bufferedImage));
                this.sheet.addImage(writableImage);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new JRException("The cell cannot be added", exception);
        }
        catch (Error error) {
            error.printStackTrace();
            throw new JRException("The cell cannot be added", error);
        }
    }

    private static Colour getNearestColour(Color color) {
        Colour colour = (Colour)colorsCache.get(color);
        if (colour == null) {
            Colour[] colourArray = Colour.getAllColours();
            if (colourArray != null && colourArray.length > 0) {
                Colour colour2 = null;
                int[] nArray = null;
                int n = 0;
                int n2 = 999;
                for (int i = 0; i < colourArray.length; ++i) {
                    colour2 = colourArray[i];
                    nArray = new int[]{colour2.getDefaultRGB().getRed(), colour2.getDefaultRGB().getGreen(), colour2.getDefaultRGB().getBlue()};
                    n = Math.abs(nArray[0] - color.getRed()) + Math.abs(nArray[1] - color.getGreen()) + Math.abs(nArray[2] - color.getBlue());
                    if (n >= n2) continue;
                    n2 = n;
                    colour = colour2;
                }
            }
            colorsCache.put(color, colour);
        }
        return colour;
    }

    private WritableFont getLoadedFont(JRFont jRFont, int n) throws JRException {
        int n2;
        WritableFont writableFont = null;
        if (this.loadedFonts != null && this.loadedFonts.size() > 0) {
            WritableFont writableFont2 = null;
            for (int i = 0; i < this.loadedFonts.size(); ++i) {
                writableFont2 = (WritableFont)this.loadedFonts.get(i);
                n2 = jRFont.getFontSize();
                if (this.isFontSizeFixEnabled) {
                    --n2;
                }
                if (!writableFont2.getName().equals(jRFont.getFontName()) || writableFont2.getColour().getValue() != n || writableFont2.getPointSize() != n2 || !(writableFont2.getUnderlineStyle() == UnderlineStyle.SINGLE ? jRFont.isUnderline() : !jRFont.isUnderline()) || writableFont2.isStruckout() != jRFont.isStrikeThrough() || !(writableFont2.getBoldWeight() == BoldStyle.BOLD.getValue() ? jRFont.isBold() : !jRFont.isBold()) || writableFont2.isItalic() != jRFont.isItalic()) continue;
                writableFont = writableFont2;
                break;
            }
        }
        try {
            if (writableFont == null) {
                n2 = jRFont.getFontSize();
                if (this.isFontSizeFixEnabled) {
                    --n2;
                }
                writableFont = new WritableFont(WritableFont.createFont((String)jRFont.getFontName()), n2, jRFont.isBold() ? WritableFont.BOLD : WritableFont.NO_BOLD, jRFont.isItalic(), jRFont.isUnderline() ? UnderlineStyle.SINGLE : UnderlineStyle.NO_UNDERLINE, Colour.getInternalColour((int)n));
                this.loadedFonts.add(writableFont);
            }
        }
        catch (Exception exception) {
            throw new JRException("Can't get loaded fonts.", exception);
        }
        return writableFont;
    }

    private WritableCellFormat getLoadedCellStyle(Pattern pattern, Colour colour, int n, int n2, int n3, WritableFont writableFont, JRExporterGridCell jRExporterGridCell) throws JRException {
        StyleKey styleKey = new StyleKey(pattern, colour, n, n2, n3, writableFont, jRExporterGridCell.getBox());
        WritableCellFormat writableCellFormat = (WritableCellFormat)this.loadedCellStyles.get(styleKey);
        if (writableCellFormat == null) {
            BorderLineStyle borderLineStyle = BorderLineStyle.NONE;
            BorderLineStyle borderLineStyle2 = BorderLineStyle.NONE;
            BorderLineStyle borderLineStyle3 = BorderLineStyle.NONE;
            BorderLineStyle borderLineStyle4 = BorderLineStyle.NONE;
            Colour colour2 = BLACK;
            Colour colour3 = BLACK;
            Colour colour4 = BLACK;
            Colour colour5 = BLACK;
            JRBox jRBox = jRExporterGridCell.getBox();
            if (jRBox != null) {
                if (jRBox.getTopBorder() != 0) {
                    borderLineStyle = this.getBorderLineStyle(jRBox.getTopBorder());
                    colour2 = JExcelApiExporter.getNearestColour(jRBox.getTopBorderColor());
                }
                if (jRBox.getBottomBorder() != 0) {
                    borderLineStyle2 = this.getBorderLineStyle(jRBox.getBottomBorder());
                    colour3 = JExcelApiExporter.getNearestColour(jRBox.getBottomBorderColor());
                }
                if (jRBox.getLeftBorder() != 0) {
                    borderLineStyle3 = this.getBorderLineStyle(jRBox.getLeftBorder());
                    colour4 = JExcelApiExporter.getNearestColour(jRBox.getLeftBorderColor());
                }
                if (jRBox.getRightBorder() != 0) {
                    borderLineStyle4 = this.getBorderLineStyle(jRBox.getRightBorder());
                    colour5 = JExcelApiExporter.getNearestColour(jRBox.getRightBorderColor());
                }
            }
            try {
                writableCellFormat = new WritableCellFormat(writableFont);
                writableCellFormat.setBackground(colour, pattern);
                writableCellFormat.setAlignment(Alignment.getAlignment((int)n));
                writableCellFormat.setVerticalAlignment(VerticalAlignment.getAlignment((int)n2));
                writableCellFormat.setOrientation(Orientation.getOrientation((int)n3));
                writableCellFormat.setWrap(true);
                writableCellFormat.setBorder(Border.TOP, borderLineStyle, colour2);
                writableCellFormat.setBorder(Border.BOTTOM, borderLineStyle2, colour3);
                writableCellFormat.setBorder(Border.LEFT, borderLineStyle3, colour4);
                writableCellFormat.setBorder(Border.RIGHT, borderLineStyle4, colour5);
            }
            catch (Exception exception) {
                throw new JRException("Error setting cellFormat-template.", exception);
            }
            this.loadedCellStyles.put(styleKey, writableCellFormat);
        }
        return writableCellFormat;
    }

    private BorderLineStyle getBorderLineStyle(byte by) {
        BorderLineStyle borderLineStyle = null;
        switch (by) {
            case 5: {
                borderLineStyle = BorderLineStyle.THIN;
                break;
            }
            case 1: 
            case 2: {
                borderLineStyle = BorderLineStyle.MEDIUM;
                break;
            }
            case 3: {
                borderLineStyle = BorderLineStyle.THICK;
                break;
            }
            case 4: {
                borderLineStyle = BorderLineStyle.DOTTED;
                break;
            }
            default: {
                borderLineStyle = BorderLineStyle.NONE;
            }
        }
        return borderLineStyle;
    }

    private final void setSheetSettings(WritableSheet writableSheet) {
        PageOrientation pageOrientation = this.jasperPrint.getOrientation() == 1 ? PageOrientation.PORTRAIT : PageOrientation.LANDSCAPE;
        PaperSize paperSize = this.getSuitablePaperSize(this.jasperPrint);
        if (paperSize != null) {
            writableSheet.setPageSetup(pageOrientation, paperSize, 0.0, 0.0);
        } else {
            writableSheet.setPageSetup(pageOrientation);
        }
        SheetSettings sheetSettings = writableSheet.getSettings();
        sheetSettings.setTopMargin(0.0);
        sheetSettings.setLeftMargin(0.0);
        sheetSettings.setRightMargin(0.0);
        sheetSettings.setBottomMargin(0.0);
        sheetSettings.setHeaderMargin(0.0);
        sheetSettings.setFooterMargin(0.0);
    }

    private final PaperSize getSuitablePaperSize(JasperPrint jasperPrint) {
        if (jasperPrint == null) {
            return null;
        }
        long l = 0L;
        long l2 = 0L;
        PaperSize paperSize = null;
        if (jasperPrint.getPageWidth() != 0 && jasperPrint.getPageHeight() != 0) {
            double d = (double)jasperPrint.getPageWidth() / 72.0;
            double d2 = (double)jasperPrint.getPageHeight() / 72.0;
            l2 = Math.round(d2 * 25.4);
            l = Math.round(d * 25.4);
            for (int i = 3; i < 6; ++i) {
                int n = this.calculateWidthForDinAN(i);
                int n2 = this.calculateHeightForDinAN(i);
                if (((long)n != l || (long)n2 != l2) && ((long)n2 != l || (long)n != l2)) continue;
                if (i == 3) {
                    paperSize = PaperSize.A3;
                    break;
                }
                if (i == 4) {
                    paperSize = PaperSize.A4;
                    break;
                }
                if (i != 5) break;
                paperSize = PaperSize.A5;
                break;
            }
            if (paperSize == null) {
                if (l == 216L && l2 == 279L || l == 279L && l2 == 216L) {
                    paperSize = PaperSize.LETTER;
                }
                if (l == 216L && l2 == 356L || l == 356L && l2 == 216L) {
                    paperSize = PaperSize.LEGAL;
                }
            }
        }
        return paperSize;
    }

    public static JRXlsAbstractExporter.TextAlignHolder getTextAlignHolder(JRPrintText jRPrintText) {
        short s;
        short s2;
        short s3 = jRPrintText.getRotation();
        block0 : switch (jRPrintText.getRotation()) {
            case 1: {
                switch (jRPrintText.getHorizontalAlignment()) {
                    case 1: {
                        s2 = 3;
                        break;
                    }
                    case 2: {
                        s2 = 2;
                        break;
                    }
                    case 3: {
                        s2 = 1;
                        break;
                    }
                    case 4: {
                        s2 = 4;
                        break;
                    }
                    default: {
                        s2 = 3;
                    }
                }
                switch (jRPrintText.getVerticalAlignment()) {
                    case 1: {
                        s = 1;
                        break block0;
                    }
                    case 2: {
                        s = 2;
                        break block0;
                    }
                    case 3: {
                        s = 3;
                        break block0;
                    }
                }
                s = 1;
                break;
            }
            case 2: {
                switch (jRPrintText.getHorizontalAlignment()) {
                    case 1: {
                        s2 = 1;
                        break;
                    }
                    case 2: {
                        s2 = 2;
                        break;
                    }
                    case 3: {
                        s2 = 3;
                        break;
                    }
                    case 4: {
                        s2 = 4;
                        break;
                    }
                    default: {
                        s2 = 1;
                    }
                }
                switch (jRPrintText.getVerticalAlignment()) {
                    case 1: {
                        s = 3;
                        break block0;
                    }
                    case 2: {
                        s = 2;
                        break block0;
                    }
                    case 3: {
                        s = 1;
                        break block0;
                    }
                }
                s = 3;
                break;
            }
            default: {
                s = jRPrintText.getHorizontalAlignment();
                s2 = jRPrintText.getVerticalAlignment();
            }
        }
        return new JRXlsAbstractExporter.TextAlignHolder(s, s2, s3);
    }

    private final int calculateWidthForDinAN(int n) {
        return (int)(Math.pow(2.0, -0.25 - (double)n / 2.0) * 1000.0);
    }

    private final int calculateHeightForDinAN(int n) {
        return (int)(Math.pow(2.0, 0.25 - (double)n / 2.0) * 1000.0);
    }

    private final int calculateWidthForDinBN(int n) {
        return (int)(Math.pow(2.0, -((double)n / 2.0)) * 1000.0);
    }

    private final int calculateHeightForDinBN(int n) {
        return (int)(Math.pow(2.0, 0.5 - (double)n / 2.0) * 1000.0);
    }

    private final int calculateWidthForDinCN(int n) {
        return (int)(Math.pow(2.0, -0.125 - (double)n / 2.0) * 1000.0);
    }

    private final int calculateHeightForDinCN(int n) {
        return (int)(Math.pow(2.0, 0.375 - (double)n / 2.0) * 1000.0);
    }

    protected JRGridLayout.ExporterElements getExporterElements() {
        return JRGridLayout.UNIVERSAL_EXPORTER;
    }

    protected void exportFrame(JRPrintFrame jRPrintFrame, JRExporterGridCell jRExporterGridCell, int n, int n2) throws JRException {
        this.addMergeRegion(jRExporterGridCell, n, n2);
        Colour colour = JExcelApiExporter.getNearestColour(jRPrintFrame.getForecolor());
        Colour colour2 = WHITE;
        Pattern pattern = this.backgroundMode;
        if (jRPrintFrame.getMode() == 1) {
            pattern = Pattern.SOLID;
            colour2 = JExcelApiExporter.getNearestColour(jRPrintFrame.getBackcolor());
        }
        WritableFont writableFont = this.getLoadedFont(this.getDefaultFont(), colour.getValue());
        WritableCellFormat writableCellFormat = this.getLoadedCellStyle(pattern, colour2, Alignment.LEFT.getValue(), VerticalAlignment.TOP.getValue(), Orientation.HORIZONTAL.getValue(), writableFont, jRExporterGridCell);
        Blank blank = new Blank(n, n2, (CellFormat)writableCellFormat);
        try {
            this.sheet.addCell((WritableCell)blank);
        }
        catch (JXLException jXLException) {
            throw new JRException("Can't add cell.", jXLException);
        }
    }

    protected static class StyleKey {
        int mode;
        int backcolor;
        int horizontalAlignment;
        int verticalAlignment;
        int rotation;
        int font;
        JRBox box;
        final int hashCode;

        protected StyleKey(Pattern pattern, Colour colour, int n, int n2, int n3, WritableFont writableFont, JRBox jRBox) {
            this.mode = pattern.getValue();
            this.backcolor = colour.getValue();
            this.horizontalAlignment = n;
            this.verticalAlignment = n2;
            this.rotation = n3;
            this.font = writableFont.getFontIndex();
            this.box = jRBox;
            int n4 = this.mode;
            n4 = 31 * n4 + this.backcolor;
            n4 = 31 * n4 + n;
            n4 = 31 * n4 + n2;
            n4 = 31 * n4 + n3;
            n4 = 31 * n4 + this.font;
            if (jRBox != null) {
                n4 = 31 * n4 + jRBox.hashCode();
            }
            this.hashCode = n4;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object object) {
            StyleKey styleKey = (StyleKey)object;
            return styleKey.mode == this.mode && styleKey.backcolor == this.backcolor && styleKey.horizontalAlignment == this.horizontalAlignment && styleKey.verticalAlignment == this.verticalAlignment && styleKey.rotation == this.rotation && styleKey.font == this.font && (styleKey.box == null ? this.box == null : this.box != null && styleKey.box.equals(this.box));
        }
    }
}

