/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.design;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.crosstabs.JRCellContents;
import net.sf.jasperreports.crosstabs.JRCrosstab;
import net.sf.jasperreports.crosstabs.JRCrosstabBucket;
import net.sf.jasperreports.crosstabs.JRCrosstabCell;
import net.sf.jasperreports.crosstabs.JRCrosstabColumnGroup;
import net.sf.jasperreports.crosstabs.JRCrosstabDataset;
import net.sf.jasperreports.crosstabs.JRCrosstabGroup;
import net.sf.jasperreports.crosstabs.JRCrosstabMeasure;
import net.sf.jasperreports.crosstabs.JRCrosstabParameter;
import net.sf.jasperreports.crosstabs.JRCrosstabRowGroup;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstab;
import net.sf.jasperreports.crosstabs.fill.JRPercentageCalculatorFactory;
import net.sf.jasperreports.engine.JRAnchor;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRBox;
import net.sf.jasperreports.engine.JRChart;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRDatasetParameter;
import net.sf.jasperreports.engine.JRDatasetRun;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRElementDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionChunk;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRFrame;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRHyperlink;
import net.sf.jasperreports.engine.JRImage;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRQuery;
import net.sf.jasperreports.engine.JRQueryChunk;
import net.sf.jasperreports.engine.JRReportFont;
import net.sf.jasperreports.engine.JRStaticText;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRSubreport;
import net.sf.jasperreports.engine.JRSubreportParameter;
import net.sf.jasperreports.engine.JRSubreportReturnValue;
import net.sf.jasperreports.engine.JRTextField;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.query.JRQueryExecuterFactory;
import net.sf.jasperreports.engine.util.JRQueryExecuterUtils;

public class JRVerifier {
    private static String[] textFieldClassNames = null;
    private static String[] imageClassNames = null;
    private static String[] subreportClassNames = null;
    private JasperDesign jasperDesign = null;
    private Collection brokenRules = null;
    private JRExpressionCollector expressionCollector;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$java$sql$Connection;
    static /* synthetic */ Class class$net$sf$jasperreports$engine$JRDataSource;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$sql$Timestamp;
    static /* synthetic */ Class class$java$sql$Time;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$java$io$File;
    static /* synthetic */ Class class$java$net$URL;
    static /* synthetic */ Class class$java$io$InputStream;
    static /* synthetic */ Class class$java$awt$Image;
    static /* synthetic */ Class class$net$sf$jasperreports$engine$JRRenderable;
    static /* synthetic */ Class class$net$sf$jasperreports$engine$JasperReport;
    static /* synthetic */ Class class$java$lang$Comparable;
    static /* synthetic */ Class class$java$util$Comparator;
    static /* synthetic */ Class class$net$sf$jasperreports$crosstabs$fill$JRPercentageCalculator;
    static /* synthetic */ Class class$net$sf$jasperreports$engine$fill$JRExtendedIncrementerFactory;

    protected JRVerifier(JasperDesign jasperDesign) {
        this(jasperDesign, null);
    }

    protected JRVerifier(JasperDesign jasperDesign, JRExpressionCollector jRExpressionCollector) {
        this.jasperDesign = jasperDesign;
        this.brokenRules = new ArrayList();
        if (jRExpressionCollector != null) {
            this.expressionCollector = jRExpressionCollector;
        } else {
            this.expressionCollector = new JRExpressionCollector();
            this.expressionCollector.collect(this.jasperDesign);
        }
    }

    public static Collection verifyDesign(JasperDesign jasperDesign, JRExpressionCollector jRExpressionCollector) {
        JRVerifier jRVerifier = new JRVerifier(jasperDesign, jRExpressionCollector);
        return jRVerifier.verifyDesign();
    }

    public static Collection verifyDesign(JasperDesign jasperDesign) {
        return JRVerifier.verifyDesign(jasperDesign, null);
    }

    protected Collection verifyDesign() {
        this.jasperDesign.preprocess();
        this.verifyDesignAttributes();
        this.verifyReportFonts();
        this.verifyDataset(this.jasperDesign.getMainDesignDataset());
        this.verifyDatasets();
        this.verifyStyles();
        this.verifyBand(this.jasperDesign.getBackground());
        this.verifyBand(this.jasperDesign.getTitle());
        this.verifyBand(this.jasperDesign.getPageHeader());
        this.verifyBand(this.jasperDesign.getColumnHeader());
        this.verifyBand(this.jasperDesign.getDetail());
        this.verifyBand(this.jasperDesign.getColumnFooter());
        this.verifyBand(this.jasperDesign.getPageFooter());
        this.verifyBand(this.jasperDesign.getLastPageFooter());
        this.verifyBand(this.jasperDesign.getSummary());
        return this.brokenRules;
    }

    private void verifyDesignAttributes() {
        if (this.jasperDesign.getName() == null || this.jasperDesign.getName().trim().length() == 0) {
            this.brokenRules.add("Report name is missing.");
        }
        if (this.jasperDesign.getColumnCount() <= 0) {
            this.brokenRules.add("Column count must be greater than zero.");
        }
        if (this.jasperDesign.getPageWidth() < 0) {
            this.brokenRules.add("Page width must be positive.");
        }
        if (this.jasperDesign.getPageHeight() < 0) {
            this.brokenRules.add("Page height must be positive.");
        }
        if (this.jasperDesign.getColumnWidth() < 0) {
            this.brokenRules.add("Column width must be positive.");
        }
        if (this.jasperDesign.getColumnSpacing() < 0) {
            this.brokenRules.add("Column spacing must be positive.");
        }
        if (this.jasperDesign.getLeftMargin() < 0) {
            this.brokenRules.add("Left margin must be positive.");
        }
        if (this.jasperDesign.getRightMargin() < 0) {
            this.brokenRules.add("Right margin must be positive.");
        }
        if (this.jasperDesign.getTopMargin() < 0) {
            this.brokenRules.add("Top margin must be positive.");
        }
        if (this.jasperDesign.getBottomMargin() < 0) {
            this.brokenRules.add("Bottom margin must be positive.");
        }
        if (this.jasperDesign.getLeftMargin() + this.jasperDesign.getColumnCount() * this.jasperDesign.getColumnWidth() + (this.jasperDesign.getColumnCount() - 1) * this.jasperDesign.getColumnSpacing() + this.jasperDesign.getRightMargin() > this.jasperDesign.getPageWidth()) {
            this.brokenRules.add("The columns and the margins do not fit the page width.");
        }
        if (this.jasperDesign.getTopMargin() + (this.jasperDesign.getBackground() != null ? this.jasperDesign.getBackground().getHeight() : 0) + this.jasperDesign.getBottomMargin() > this.jasperDesign.getPageHeight()) {
            this.brokenRules.add("The background section and the margins do not fit the page height.");
        }
        if (this.jasperDesign.isTitleNewPage()) {
            if (this.jasperDesign.getTopMargin() + (this.jasperDesign.getTitle() != null ? this.jasperDesign.getTitle().getHeight() : 0) + this.jasperDesign.getBottomMargin() > this.jasperDesign.getPageHeight()) {
                this.brokenRules.add("The title section and the margins do not fit the page height.");
            }
        } else if (this.jasperDesign.getTopMargin() + (this.jasperDesign.getTitle() != null ? this.jasperDesign.getTitle().getHeight() : 0) + (this.jasperDesign.getPageHeader() != null ? this.jasperDesign.getPageHeader().getHeight() : 0) + (this.jasperDesign.getColumnHeader() != null ? this.jasperDesign.getColumnHeader().getHeight() : 0) + (this.jasperDesign.getColumnFooter() != null ? this.jasperDesign.getColumnFooter().getHeight() : 0) + (this.jasperDesign.getPageFooter() != null ? this.jasperDesign.getPageFooter().getHeight() : 0) + this.jasperDesign.getBottomMargin() > this.jasperDesign.getPageHeight()) {
            this.brokenRules.add("The title section, the page and column headers and footers and the margins do not fit the page height.");
        }
        if (this.jasperDesign.getTopMargin() + (this.jasperDesign.getPageHeader() != null ? this.jasperDesign.getPageHeader().getHeight() : 0) + (this.jasperDesign.getColumnHeader() != null ? this.jasperDesign.getColumnHeader().getHeight() : 0) + (this.jasperDesign.getColumnFooter() != null ? this.jasperDesign.getColumnFooter().getHeight() : 0) + (this.jasperDesign.getPageFooter() != null ? this.jasperDesign.getPageFooter().getHeight() : 0) + this.jasperDesign.getBottomMargin() > this.jasperDesign.getPageHeight()) {
            this.brokenRules.add("The page and column headers and footers and the margins do not fit the page height.");
        }
        if (this.jasperDesign.getTopMargin() + (this.jasperDesign.getPageHeader() != null ? this.jasperDesign.getPageHeader().getHeight() : 0) + (this.jasperDesign.getColumnHeader() != null ? this.jasperDesign.getColumnHeader().getHeight() : 0) + (this.jasperDesign.getColumnFooter() != null ? this.jasperDesign.getColumnFooter().getHeight() : 0) + (this.jasperDesign.getLastPageFooter() != null ? this.jasperDesign.getLastPageFooter().getHeight() : 0) + this.jasperDesign.getBottomMargin() > this.jasperDesign.getPageHeight()) {
            this.brokenRules.add("The page and column headers and footers and the margins do not fit the last page height.");
        }
        if (this.jasperDesign.getTopMargin() + (this.jasperDesign.getSummary() != null ? this.jasperDesign.getSummary().getHeight() : 0) + this.jasperDesign.getBottomMargin() > this.jasperDesign.getPageHeight()) {
            this.brokenRules.add("The summary section and the margins do not fit the page height.");
        }
        if (this.jasperDesign.getTopMargin() + (this.jasperDesign.getPageHeader() != null ? this.jasperDesign.getPageHeader().getHeight() : 0) + (this.jasperDesign.getColumnHeader() != null ? this.jasperDesign.getColumnHeader().getHeight() : 0) + (this.jasperDesign.getDetail() != null ? this.jasperDesign.getDetail().getHeight() : 0) + (this.jasperDesign.getColumnFooter() != null ? this.jasperDesign.getColumnFooter().getHeight() : 0) + (this.jasperDesign.getPageFooter() != null ? this.jasperDesign.getPageFooter().getHeight() : 0) + this.jasperDesign.getBottomMargin() > this.jasperDesign.getPageHeight()) {
            this.brokenRules.add("The detail section, the page and column headers and footers and the margins do not fit the page height.");
        }
    }

    private void verifyQuery(JRDesignDataset jRDesignDataset) {
        JRQuery jRQuery = jRDesignDataset.getQuery();
        if (jRQuery != null) {
            String string = jRQuery.getLanguage();
            JRQueryExecuterFactory jRQueryExecuterFactory = null;
            if (string == null || string.length() == 0) {
                this.brokenRules.add("Query language not set.");
            } else {
                try {
                    jRQueryExecuterFactory = JRQueryExecuterUtils.getQueryExecuterFactory(jRQuery.getLanguage());
                }
                catch (JRException jRException) {
                    this.brokenRules.add("Query executer factory for " + string + " cannot be created.");
                }
            }
            JRQueryChunk[] jRQueryChunkArray = jRQuery.getChunks();
            if (jRQueryChunkArray != null && jRQueryChunkArray.length > 0) {
                Map map = jRDesignDataset.getParametersMap();
                block6: for (int i = 0; i < jRQueryChunkArray.length; ++i) {
                    JRQueryChunk jRQueryChunk = jRQueryChunkArray[i];
                    switch (jRQueryChunk.getType()) {
                        case 2: {
                            JRParameter jRParameter = (JRParameter)map.get(jRQueryChunk.getText());
                            if (jRParameter == null) {
                                this.brokenRules.add("Query parameter not found : " + jRQueryChunk.getText());
                                continue block6;
                            }
                            if (jRQueryExecuterFactory == null || jRQueryExecuterFactory.supportsQueryParameterType(jRParameter.getValueClassName())) continue block6;
                            this.brokenRules.add("Parameter type not supported in query : " + jRQueryChunk.getText() + " class " + jRParameter.getValueClassName());
                            continue block6;
                        }
                        case 3: {
                            if (map.containsKey(jRQueryChunk.getText())) continue block6;
                            this.brokenRules.add("Query parameter not found : " + jRQueryChunk.getText());
                            continue block6;
                        }
                    }
                }
            }
        }
    }

    private void verifyExpressions(List list, Map map, Map map2, Map map3) {
        if (list != null && list.size() > 0) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                JRExpression jRExpression = (JRExpression)iterator.next();
                JRExpressionChunk[] jRExpressionChunkArray = jRExpression.getChunks();
                if (jRExpressionChunkArray == null || jRExpressionChunkArray.length <= 0) continue;
                block6: for (int i = 0; i < jRExpressionChunkArray.length; ++i) {
                    JRExpressionChunk jRExpressionChunk = jRExpressionChunkArray[i];
                    switch (jRExpressionChunk.getType()) {
                        case 4: {
                            if (map3.containsKey(jRExpressionChunk.getText())) continue block6;
                            this.brokenRules.add("Variable not found : " + jRExpressionChunk.getText());
                            continue block6;
                        }
                        case 3: {
                            if (map2.containsKey(jRExpressionChunk.getText())) continue block6;
                            this.brokenRules.add("Field not found : " + jRExpressionChunk.getText());
                            continue block6;
                        }
                        case 2: {
                            if (map.containsKey(jRExpressionChunk.getText())) continue block6;
                            this.brokenRules.add("Parameter not found : " + jRExpressionChunk.getText());
                            continue block6;
                        }
                    }
                }
            }
        }
    }

    private void verifyExpressions(JRDesignDataset jRDesignDataset) {
        this.verifyExpressions(this.expressionCollector.getExpressions(jRDesignDataset), jRDesignDataset.getParametersMap(), jRDesignDataset.getFieldsMap(), jRDesignDataset.getVariablesMap());
    }

    private void verifyReportFonts() {
        JRReportFont[] jRReportFontArray = this.jasperDesign.getFonts();
        if (jRReportFontArray != null && jRReportFontArray.length > 0) {
            for (int i = 0; i < jRReportFontArray.length; ++i) {
                JRReportFont jRReportFont = jRReportFontArray[i];
                if (jRReportFont.getName() != null && jRReportFont.getName().trim().length() != 0) continue;
                this.brokenRules.add("Report font name missing.");
            }
        }
    }

    private void verifyStyles() {
        JRStyle[] jRStyleArray = this.jasperDesign.getStyles();
        if (jRStyleArray != null && jRStyleArray.length > 0) {
            for (int i = 0; i < jRStyleArray.length; ++i) {
                JRStyle jRStyle = jRStyleArray[i];
                if (jRStyle.getName() != null && jRStyle.getName().trim().length() != 0) continue;
                this.brokenRules.add("Report style name missing.");
            }
        }
    }

    private void verifyParameters(JRDesignDataset jRDesignDataset) {
        JRParameter[] jRParameterArray = jRDesignDataset.getParameters();
        if (jRParameterArray != null && jRParameterArray.length > 0) {
            for (int i = 0; i < jRParameterArray.length; ++i) {
                JRParameter jRParameter = jRParameterArray[i];
                if (jRParameter.getName() == null || jRParameter.getName().trim().length() == 0) {
                    this.brokenRules.add("Parameter name missing.");
                }
                if (jRParameter.getValueClassName() == null) {
                    this.brokenRules.add("Class not set for parameter : " + jRParameter.getName());
                    continue;
                }
                JRExpression jRExpression = jRParameter.getDefaultValueExpression();
                if (jRExpression == null) continue;
                if (jRExpression.getValueClass() == null) {
                    this.brokenRules.add("No value class defined for the expression in parameter: " + jRParameter.getName());
                    continue;
                }
                if (jRParameter.getValueClass().isAssignableFrom(jRExpression.getValueClass())) continue;
                this.brokenRules.add("The parameter default value expression class is not compatible with the parameter's class : " + jRParameter.getName());
            }
        }
    }

    private void verifyFields(JRDesignDataset jRDesignDataset) {
        JRField[] jRFieldArray = jRDesignDataset.getFields();
        if (jRFieldArray != null && jRFieldArray.length > 0) {
            for (int i = 0; i < jRFieldArray.length; ++i) {
                String string;
                JRField jRField = jRFieldArray[i];
                if (jRField.getName() == null || jRField.getName().trim().length() == 0) {
                    this.brokenRules.add("Field name missing.");
                }
                if ((string = jRField.getValueClassName()) != null) continue;
                this.brokenRules.add("Class not set for field : " + jRField.getName());
            }
        }
    }

    private void verifyVariables(JRDesignDataset jRDesignDataset) {
        JRVariable[] jRVariableArray = jRDesignDataset.getVariables();
        if (jRVariableArray != null && jRVariableArray.length > 0) {
            boolean bl = jRDesignDataset.isMainDataset();
            for (int i = 0; i < jRVariableArray.length; ++i) {
                byte by;
                Class clazz;
                JRVariable jRVariable = jRVariableArray[i];
                if (jRVariable.getName() == null || jRVariable.getName().trim().length() == 0) {
                    this.brokenRules.add("Variable name missing.");
                }
                if ((clazz = jRVariable.getValueClass()) == null) {
                    this.brokenRules.add("Class not set for variable : " + jRVariable.getName());
                } else {
                    JRExpression jRExpression = jRVariable.getExpression();
                    if (jRExpression != null) {
                        if (jRExpression.getValueClass() == null) {
                            this.brokenRules.add("No value class for the expression has been set in variable: " + jRVariable.getName());
                        } else if (jRVariable.getCalculation() != 1 && jRVariable.getCalculation() != 8 && !clazz.isAssignableFrom(jRExpression.getValueClass())) {
                            this.brokenRules.add("The variable expression class is not compatible with the variable's class : " + jRVariable.getName());
                        }
                    }
                    if (jRVariable.getInitialValueExpression() != null && !clazz.isAssignableFrom(jRVariable.getInitialValueExpression().getValueClass())) {
                        this.brokenRules.add("The initial value class is not compatible with the variable's class : " + jRVariable.getName());
                    }
                }
                byte by2 = jRVariable.getResetType();
                if (by2 == 4) {
                    if (jRVariable.getResetGroup() == null) {
                        this.brokenRules.add("Reset group missing for variable : " + jRVariable.getName());
                    } else {
                        Map map = jRDesignDataset.getGroupsMap();
                        if (!map.containsKey(jRVariable.getResetGroup().getName())) {
                            this.brokenRules.add("Reset group \"" + jRVariable.getResetGroup().getName() + "\" not found for variable : " + jRVariable.getName());
                        }
                    }
                }
                if ((by = jRVariable.getIncrementType()) == 4) {
                    if (jRVariable.getIncrementGroup() == null) {
                        this.brokenRules.add("Increment group missing for variable : " + jRVariable.getName());
                    } else {
                        Map map = jRDesignDataset.getGroupsMap();
                        if (!map.containsKey(jRVariable.getIncrementGroup().getName())) {
                            this.brokenRules.add("Increment group \"" + jRVariable.getIncrementGroup().getName() + "\" not found for variable : " + jRVariable.getName());
                        }
                    }
                }
                if (bl) continue;
                if (by2 == 3 || by2 == 2) {
                    this.brokenRules.add("Variable " + jRVariable.getName() + " of dataset " + jRDesignDataset.getName() + " cannot have Column or Page reset type.");
                }
                if (by != 3 && by != 2) continue;
                this.brokenRules.add("Variable " + jRVariable.getName() + " of dataset " + jRDesignDataset.getName() + " cannot have Column or Page increment type.");
            }
        }
    }

    private void verifyGroups(JRDesignDataset jRDesignDataset) {
        JRGroup[] jRGroupArray = jRDesignDataset.getGroups();
        if (jRGroupArray != null && jRGroupArray.length > 0) {
            boolean bl = jRDesignDataset.isMainDataset();
            for (int i = 0; i < jRGroupArray.length; ++i) {
                Class clazz;
                JRGroup jRGroup = jRGroupArray[i];
                if (jRGroup.getName() == null || jRGroup.getName().trim().length() == 0) {
                    this.brokenRules.add("Group name missing.");
                }
                if (bl) {
                    this.verifyGroupHeaderAndFooter(jRGroup);
                } else if (jRGroup.getGroupHeader() != null || jRGroup.getGroupFooter() != null) {
                    this.brokenRules.add("Group " + jRGroup.getName() + " cannot have header or footer sections.");
                }
                JRExpression jRExpression = jRGroup.getExpression();
                if (jRExpression != null && (clazz = jRExpression.getValueClass()) == null) {
                    this.brokenRules.add("Class not set for group expression : " + jRGroup.getName());
                }
                if (!bl) continue;
                this.verifyBand(jRGroup.getGroupHeader());
                this.verifyBand(jRGroup.getGroupFooter());
            }
        }
    }

    private void verifyGroupHeaderAndFooter(JRGroup jRGroup) {
        if (this.jasperDesign.isTitleNewPage()) {
            if (this.jasperDesign.getTopMargin() + (this.jasperDesign.getPageHeader() != null ? this.jasperDesign.getPageHeader().getHeight() : 0) + (this.jasperDesign.getColumnHeader() != null ? this.jasperDesign.getColumnHeader().getHeight() : 0) + (jRGroup.getGroupHeader() != null ? jRGroup.getGroupHeader().getHeight() : 0) + (this.jasperDesign.getColumnFooter() != null ? this.jasperDesign.getColumnFooter().getHeight() : 0) + (this.jasperDesign.getPageFooter() != null ? this.jasperDesign.getPageFooter().getHeight() : 0) + this.jasperDesign.getBottomMargin() > this.jasperDesign.getPageHeight()) {
                this.brokenRules.add("The '" + jRGroup.getName() + "' group header section, the page and column headers and footers and the margins do not fit the page height.");
            }
            if (this.jasperDesign.getTopMargin() + (this.jasperDesign.getPageHeader() != null ? this.jasperDesign.getPageHeader().getHeight() : 0) + (this.jasperDesign.getColumnHeader() != null ? this.jasperDesign.getColumnHeader().getHeight() : 0) + (jRGroup.getGroupFooter() != null ? jRGroup.getGroupFooter().getHeight() : 0) + (this.jasperDesign.getColumnFooter() != null ? this.jasperDesign.getColumnFooter().getHeight() : 0) + (this.jasperDesign.getPageFooter() != null ? this.jasperDesign.getPageFooter().getHeight() : 0) + this.jasperDesign.getBottomMargin() > this.jasperDesign.getPageHeight()) {
                this.brokenRules.add("The '" + jRGroup.getName() + "' group footer section, the page and column headers and footers and the margins do not fit the page height.");
            }
        } else {
            if (this.jasperDesign.getTopMargin() + (this.jasperDesign.getTitle() != null ? this.jasperDesign.getTitle().getHeight() : 0) + (this.jasperDesign.getPageHeader() != null ? this.jasperDesign.getPageHeader().getHeight() : 0) + (this.jasperDesign.getColumnHeader() != null ? this.jasperDesign.getColumnHeader().getHeight() : 0) + (jRGroup.getGroupHeader() != null ? jRGroup.getGroupHeader().getHeight() : 0) + (this.jasperDesign.getColumnFooter() != null ? this.jasperDesign.getColumnFooter().getHeight() : 0) + (this.jasperDesign.getPageFooter() != null ? this.jasperDesign.getPageFooter().getHeight() : 0) + this.jasperDesign.getBottomMargin() > this.jasperDesign.getPageHeight()) {
                this.brokenRules.add("The '" + jRGroup.getName() + "' group header section, the title, the page and column headers and footers and the margins do not fit the first page height.");
            }
            if (this.jasperDesign.getTopMargin() + (this.jasperDesign.getTitle() != null ? this.jasperDesign.getTitle().getHeight() : 0) + (this.jasperDesign.getPageHeader() != null ? this.jasperDesign.getPageHeader().getHeight() : 0) + (this.jasperDesign.getColumnHeader() != null ? this.jasperDesign.getColumnHeader().getHeight() : 0) + (jRGroup.getGroupFooter() != null ? jRGroup.getGroupFooter().getHeight() : 0) + (this.jasperDesign.getColumnFooter() != null ? this.jasperDesign.getColumnFooter().getHeight() : 0) + (this.jasperDesign.getPageFooter() != null ? this.jasperDesign.getPageFooter().getHeight() : 0) + this.jasperDesign.getBottomMargin() > this.jasperDesign.getPageHeight()) {
                this.brokenRules.add("The '" + jRGroup.getName() + "' group footer section, the title, the page and column headers and footers and the margins do not fit the first page height.");
            }
        }
    }

    private void verifyBand(JRBand jRBand) {
        JRElement[] jRElementArray;
        if (jRBand != null && (jRElementArray = jRBand.getElements()) != null && jRElementArray.length > 0) {
            JRExpression jRExpression = jRBand.getPrintWhenExpression();
            if (jRExpression != null) {
                Class clazz = jRExpression.getValueClass();
                if (clazz == null) {
                    this.brokenRules.add("Class not set for band \"print when\" expression.");
                } else if (!(class$java$lang$Boolean == null ? (class$java$lang$Boolean = JRVerifier.class$("java.lang.Boolean")) : class$java$lang$Boolean).isAssignableFrom(clazz)) {
                    this.brokenRules.add("Class " + clazz + " not supported for band \"print when\" expression. Use java.lang.Boolean instead.");
                }
            }
            for (int i = 0; i < jRElementArray.length; ++i) {
                JRElement jRElement = jRElementArray[i];
                this.verifyPrintWhenExpr(jRElement);
                if (jRElement.getY() + jRElement.getHeight() > jRBand.getHeight()) {
                    this.brokenRules.add("Warning : Element bottom reaches outside band area : y=" + jRElement.getY() + " height=" + jRElement.getHeight() + " band-height=" + jRBand.getHeight());
                }
                this.verifyElement(jRElement);
            }
        }
    }

    protected void verifyElement(JRElement jRElement) {
        if (jRElement instanceof JRStaticText) {
            this.verifyStaticText((JRStaticText)jRElement);
        } else if (jRElement instanceof JRTextField) {
            this.verifyTextField((JRTextField)jRElement);
        } else if (jRElement instanceof JRImage) {
            this.verifyImage((JRImage)jRElement);
        } else if (jRElement instanceof JRSubreport) {
            this.verifySubreport((JRSubreport)jRElement);
        } else if (jRElement instanceof JRCrosstab) {
            this.verifyCrosstab((JRDesignCrosstab)jRElement);
        } else if (jRElement instanceof JRChart) {
            this.verifyChart((JRChart)jRElement);
        } else if (jRElement instanceof JRFrame) {
            this.verifyFrame((JRFrame)jRElement);
        }
    }

    private void verifyPrintWhenExpr(JRElement jRElement) {
        JRExpression jRExpression = jRElement.getPrintWhenExpression();
        if (jRExpression != null) {
            Class clazz = jRExpression.getValueClass();
            if (clazz == null) {
                this.brokenRules.add("Class not set for element \"print when\" expression.");
            } else if (!(class$java$lang$Boolean == null ? (class$java$lang$Boolean = JRVerifier.class$("java.lang.Boolean")) : class$java$lang$Boolean).isAssignableFrom(clazz)) {
                this.brokenRules.add("Class " + clazz + " not supported for element \"print when\" expression. Use java.lang.Boolean instead.");
            }
        }
    }

    private void verifyStaticText(JRStaticText jRStaticText) {
        this.verifyFont(jRStaticText);
    }

    private void verifyTextField(JRTextField jRTextField) {
        JRExpression jRExpression;
        this.verifyFont(jRTextField);
        this.verifyAnchor(jRTextField);
        this.verifyHyperlink(jRTextField);
        if (jRTextField != null && (jRExpression = jRTextField.getExpression()) != null) {
            String string = jRExpression.getValueClassName();
            if (string == null) {
                this.brokenRules.add("Class not set for text field expression.");
            } else if (Arrays.binarySearch(JRVerifier.getTextFieldClassNames(), string) < 0) {
                this.brokenRules.add("Class \"" + string + "\" not supported for text field expression.");
            }
        }
    }

    private void verifyFont(JRFont jRFont) {
        Map map;
        JRReportFont jRReportFont = jRFont.getReportFont();
        if (jRReportFont != null && jRReportFont.getName() != null && !(map = this.jasperDesign.getFontsMap()).containsKey(jRReportFont.getName())) {
            this.brokenRules.add("Report font not found : " + jRReportFont.getName());
        }
    }

    private void verifyAnchor(JRAnchor jRAnchor) {
        if (jRAnchor != null) {
            JRExpression jRExpression = jRAnchor.getAnchorNameExpression();
            if (jRExpression != null) {
                Class clazz = jRExpression.getValueClass();
                if (clazz == null) {
                    this.brokenRules.add("Class not set for anchor name expression.");
                } else if (!(class$java$lang$String == null ? (class$java$lang$String = JRVerifier.class$("java.lang.String")) : class$java$lang$String).isAssignableFrom(clazz)) {
                    this.brokenRules.add("Class " + clazz + " not supported for anchor name expression. Use java.lang.String instead.");
                }
            }
            if (jRAnchor.getBookmarkLevel() != 0 && jRAnchor.getBookmarkLevel() < 1) {
                this.brokenRules.add("Bookmark level should be 0 or greater than 0");
            }
        }
    }

    private void verifyHyperlink(JRHyperlink jRHyperlink) {
        if (jRHyperlink != null) {
            Class clazz;
            JRExpression jRExpression = jRHyperlink.getHyperlinkReferenceExpression();
            if (jRExpression != null) {
                clazz = jRExpression.getValueClass();
                if (clazz == null) {
                    this.brokenRules.add("Class not set for hyperlink reference expression.");
                } else if (!(class$java$lang$String == null ? (class$java$lang$String = JRVerifier.class$("java.lang.String")) : class$java$lang$String).isAssignableFrom(clazz)) {
                    this.brokenRules.add("Class " + clazz + " not supported for hyperlink reference expression. Use java.lang.String instead.");
                }
            }
            if ((jRExpression = jRHyperlink.getHyperlinkAnchorExpression()) != null) {
                clazz = jRExpression.getValueClass();
                if (clazz == null) {
                    this.brokenRules.add("Class not set for hyperlink anchor expression.");
                } else if (!(class$java$lang$String == null ? (class$java$lang$String = JRVerifier.class$("java.lang.String")) : class$java$lang$String).isAssignableFrom(clazz)) {
                    this.brokenRules.add("Class " + clazz + " not supported for hyperlink anchor expression. Use java.lang.String instead.");
                }
            }
            if ((jRExpression = jRHyperlink.getHyperlinkPageExpression()) != null) {
                clazz = jRExpression.getValueClass();
                if (clazz == null) {
                    this.brokenRules.add("Class not set for hyperlink page expression.");
                } else if (!(class$java$lang$Integer == null ? (class$java$lang$Integer = JRVerifier.class$("java.lang.Integer")) : class$java$lang$Integer).isAssignableFrom(clazz)) {
                    this.brokenRules.add("Class " + clazz + " not supported for hyperlink page expression. Use java.lang.Integer instead.");
                }
            }
        }
    }

    private void verifyImage(JRImage jRImage) {
        JRExpression jRExpression;
        this.verifyAnchor(jRImage);
        this.verifyHyperlink(jRImage);
        if (jRImage != null && (jRExpression = jRImage.getExpression()) != null) {
            String string = jRExpression.getValueClassName();
            if (string == null) {
                this.brokenRules.add("Class not set for image expression.");
            } else if (Arrays.binarySearch(JRVerifier.getImageClassNames(), string) < 0) {
                this.brokenRules.add("Class \"" + string + "\" not supported for image expression.");
            }
        }
    }

    private void verifySubreport(JRSubreport jRSubreport) {
        if (jRSubreport != null) {
            JRSubreportReturnValue[] jRSubreportReturnValueArray;
            Object object;
            Object object2;
            JRExpression jRExpression = jRSubreport.getExpression();
            if (jRExpression != null) {
                object2 = jRExpression.getValueClassName();
                if (object2 == null) {
                    this.brokenRules.add("Class not set for subreport expression.");
                } else if (Arrays.binarySearch(JRVerifier.getSubreportClassNames(), object2) < 0) {
                    this.brokenRules.add("Class \"" + (String)object2 + "\" not supported for subreport expression.");
                }
            }
            if ((jRExpression = jRSubreport.getParametersMapExpression()) != null) {
                object2 = jRExpression.getValueClass();
                if (object2 == null) {
                    this.brokenRules.add("Class not set for subreport parameters map expression.");
                } else if (!(class$java$util$Map == null ? (class$java$util$Map = JRVerifier.class$("java.util.Map")) : class$java$util$Map).isAssignableFrom((Class<?>)object2)) {
                    this.brokenRules.add("Class " + object2 + " not supported for subreport parameters map expression. Use java.util.Map instead.");
                }
            }
            if ((object2 = jRSubreport.getParameters()) != null && ((JRSubreportParameter[])object2).length > 0) {
                for (int i = 0; i < ((JRSubreportParameter[])object2).length; ++i) {
                    JRSubreportParameter jRSubreportParameter = object2[i];
                    if (jRSubreportParameter.getName() == null || jRSubreportParameter.getName().trim().length() == 0) {
                        this.brokenRules.add("Subreport parameter name missing.");
                    }
                    if ((jRExpression = jRSubreportParameter.getExpression()) == null || (object = jRExpression.getValueClass()) != null) continue;
                    this.brokenRules.add("Class not set for subreport parameter expression : " + jRSubreportParameter.getName() + ". Use java.lang.Object class.");
                }
            }
            if (jRSubreport.getConnectionExpression() != null && jRSubreport.getDataSourceExpression() != null) {
                this.brokenRules.add("Subreport cannot have both connection expresion and data source expression.");
            }
            if ((jRExpression = jRSubreport.getConnectionExpression()) != null) {
                Class clazz = jRExpression.getValueClass();
                if (clazz == null) {
                    this.brokenRules.add("Class not set for subreport connection expression.");
                } else if (!(class$java$sql$Connection == null ? (class$java$sql$Connection = JRVerifier.class$("java.sql.Connection")) : class$java$sql$Connection).isAssignableFrom(clazz)) {
                    this.brokenRules.add("Class " + clazz + " not supported for subreport connection expression. Use java.sql.Connection instead.");
                }
            }
            if ((jRExpression = jRSubreport.getDataSourceExpression()) != null) {
                Class clazz = jRExpression.getValueClass();
                if (clazz == null) {
                    this.brokenRules.add("Class not set for subreport data source expression.");
                } else if (!(class$net$sf$jasperreports$engine$JRDataSource == null ? (class$net$sf$jasperreports$engine$JRDataSource = JRVerifier.class$("net.sf.jasperreports.engine.JRDataSource")) : class$net$sf$jasperreports$engine$JRDataSource).isAssignableFrom(clazz)) {
                    this.brokenRules.add("Class " + clazz + " not supported for subreport data source expression. Use net.sf.jasperreports.engine.JRDataSource instead.");
                }
            }
            if ((jRSubreportReturnValueArray = jRSubreport.getReturnValues()) != null && jRSubreportReturnValueArray.length > 0) {
                for (int i = 0; i < jRSubreportReturnValueArray.length; ++i) {
                    object = jRSubreportReturnValueArray[i];
                    if (object.getSubreportVariable() == null || object.getSubreportVariable().trim().length() == 0) {
                        this.brokenRules.add("Subreport return value variable name missing.");
                    }
                    if (object.getToVariable() == null || object.getToVariable().trim().length() == 0) {
                        this.brokenRules.add("Subreport return value to variable name missing.");
                    }
                    if (this.jasperDesign.getVariablesMap().containsKey(object.getToVariable())) continue;
                    this.brokenRules.add("Subreport return value to variable not found.");
                }
            }
        }
    }

    private static synchronized String[] getTextFieldClassNames() {
        if (textFieldClassNames == null) {
            textFieldClassNames = new String[]{(class$java$lang$Boolean == null ? (class$java$lang$Boolean = JRVerifier.class$("java.lang.Boolean")) : class$java$lang$Boolean).getName(), (class$java$lang$Byte == null ? (class$java$lang$Byte = JRVerifier.class$("java.lang.Byte")) : class$java$lang$Byte).getName(), (class$java$util$Date == null ? (class$java$util$Date = JRVerifier.class$("java.util.Date")) : class$java$util$Date).getName(), (class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = JRVerifier.class$("java.sql.Timestamp")) : class$java$sql$Timestamp).getName(), (class$java$sql$Time == null ? (class$java$sql$Time = JRVerifier.class$("java.sql.Time")) : class$java$sql$Time).getName(), (class$java$lang$Double == null ? (class$java$lang$Double = JRVerifier.class$("java.lang.Double")) : class$java$lang$Double).getName(), (class$java$lang$Float == null ? (class$java$lang$Float = JRVerifier.class$("java.lang.Float")) : class$java$lang$Float).getName(), (class$java$lang$Integer == null ? (class$java$lang$Integer = JRVerifier.class$("java.lang.Integer")) : class$java$lang$Integer).getName(), (class$java$lang$Long == null ? (class$java$lang$Long = JRVerifier.class$("java.lang.Long")) : class$java$lang$Long).getName(), (class$java$lang$Short == null ? (class$java$lang$Short = JRVerifier.class$("java.lang.Short")) : class$java$lang$Short).getName(), (class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = JRVerifier.class$("java.math.BigDecimal")) : class$java$math$BigDecimal).getName(), (class$java$lang$Number == null ? (class$java$lang$Number = JRVerifier.class$("java.lang.Number")) : class$java$lang$Number).getName(), (class$java$lang$String == null ? (class$java$lang$String = JRVerifier.class$("java.lang.String")) : class$java$lang$String).getName()};
            Arrays.sort(textFieldClassNames);
        }
        return textFieldClassNames;
    }

    private static synchronized String[] getImageClassNames() {
        if (imageClassNames == null) {
            imageClassNames = new String[]{(class$java$lang$String == null ? (class$java$lang$String = JRVerifier.class$("java.lang.String")) : class$java$lang$String).getName(), (class$java$io$File == null ? (class$java$io$File = JRVerifier.class$("java.io.File")) : class$java$io$File).getName(), (class$java$net$URL == null ? (class$java$net$URL = JRVerifier.class$("java.net.URL")) : class$java$net$URL).getName(), (class$java$io$InputStream == null ? (class$java$io$InputStream = JRVerifier.class$("java.io.InputStream")) : class$java$io$InputStream).getName(), (class$java$awt$Image == null ? (class$java$awt$Image = JRVerifier.class$("java.awt.Image")) : class$java$awt$Image).getName(), (class$net$sf$jasperreports$engine$JRRenderable == null ? (class$net$sf$jasperreports$engine$JRRenderable = JRVerifier.class$("net.sf.jasperreports.engine.JRRenderable")) : class$net$sf$jasperreports$engine$JRRenderable).getName()};
            Arrays.sort(imageClassNames);
        }
        return imageClassNames;
    }

    private static synchronized String[] getSubreportClassNames() {
        if (subreportClassNames == null) {
            subreportClassNames = new String[]{(class$java$lang$String == null ? (class$java$lang$String = JRVerifier.class$("java.lang.String")) : class$java$lang$String).getName(), (class$java$io$File == null ? (class$java$io$File = JRVerifier.class$("java.io.File")) : class$java$io$File).getName(), (class$java$net$URL == null ? (class$java$net$URL = JRVerifier.class$("java.net.URL")) : class$java$net$URL).getName(), (class$java$io$InputStream == null ? (class$java$io$InputStream = JRVerifier.class$("java.io.InputStream")) : class$java$io$InputStream).getName(), (class$net$sf$jasperreports$engine$JasperReport == null ? (class$net$sf$jasperreports$engine$JasperReport = JRVerifier.class$("net.sf.jasperreports.engine.JasperReport")) : class$net$sf$jasperreports$engine$JasperReport).getName()};
            Arrays.sort(subreportClassNames);
        }
        return subreportClassNames;
    }

    private void verifyCrosstab(JRDesignCrosstab jRDesignCrosstab) {
        this.verifyParameters(jRDesignCrosstab);
        JRCrosstabDataset jRCrosstabDataset = jRDesignCrosstab.getDataset();
        if (jRCrosstabDataset == null) {
            this.brokenRules.add("Crosstab dataset missing.");
        } else {
            this.verifyElementDataset(jRCrosstabDataset);
        }
        this.verifyCellContents(jRDesignCrosstab.getHeaderCell(), "crosstab cell");
        JRCrosstabRowGroup[] jRCrosstabRowGroupArray = jRDesignCrosstab.getRowGroups();
        if (jRCrosstabRowGroupArray == null || jRCrosstabRowGroupArray.length == 0) {
            this.brokenRules.add("Crosstab should have at least one row group.");
        } else {
            for (int i = 0; i < jRCrosstabRowGroupArray.length; ++i) {
                this.verifyCrosstabRowGroup(jRCrosstabRowGroupArray[i]);
            }
        }
        JRCrosstabColumnGroup[] jRCrosstabColumnGroupArray = jRDesignCrosstab.getColumnGroups();
        if (jRCrosstabColumnGroupArray == null || jRCrosstabColumnGroupArray.length == 0) {
            this.brokenRules.add("Crosstab should have at least one column group.");
        } else {
            for (int i = 0; i < jRCrosstabColumnGroupArray.length; ++i) {
                this.verifyCrosstabColumnGroup(jRCrosstabColumnGroupArray[i]);
            }
        }
        JRCrosstabMeasure[] jRCrosstabMeasureArray = jRDesignCrosstab.getMeasures();
        if (jRCrosstabMeasureArray == null || jRCrosstabMeasureArray.length == 0) {
            this.brokenRules.add("Crosstab should have at least one measure.");
        } else {
            for (int i = 0; i < jRCrosstabMeasureArray.length; ++i) {
                this.verifyCrosstabMeasure(jRCrosstabMeasureArray[i]);
            }
        }
        this.verifyCrosstabCells(jRDesignCrosstab);
        this.verifyCellContents(jRDesignCrosstab.getWhenNoDataCell(), "when no data cell");
        this.verifyExpressions(jRDesignCrosstab);
    }

    private void verifyParameters(JRDesignCrosstab jRDesignCrosstab) {
        JRCrosstabParameter[] jRCrosstabParameterArray;
        JRExpression jRExpression = jRDesignCrosstab.getParametersMapExpression();
        if (jRExpression != null) {
            jRCrosstabParameterArray = jRExpression.getValueClass();
            if (jRCrosstabParameterArray == null) {
                this.brokenRules.add("Class not set for crosstab parameters map expression.");
            } else if (!(class$java$util$Map == null ? (class$java$util$Map = JRVerifier.class$("java.util.Map")) : class$java$util$Map).isAssignableFrom((Class<?>)jRCrosstabParameterArray)) {
                this.brokenRules.add("Class " + jRCrosstabParameterArray + " not supported for crosstab parameters map expression. Use java.util.Map instead.");
            }
        }
        if ((jRCrosstabParameterArray = jRDesignCrosstab.getParameters()) != null) {
            for (int i = 0; i < jRCrosstabParameterArray.length; ++i) {
                Class clazz;
                JRCrosstabParameter jRCrosstabParameter = jRCrosstabParameterArray[i];
                String string = jRCrosstabParameter.getName();
                if (string == null || string.length() == 0) {
                    this.brokenRules.add("Missing parameter name for crosstab.");
                }
                JRExpression jRExpression2 = jRCrosstabParameter.getExpression();
                Class clazz2 = null;
                if (jRExpression2 != null && (clazz2 = jRExpression2.getValueClass()) == null) {
                    this.brokenRules.add("Expression class not set for crosstab parameter " + string + ".");
                }
                if ((clazz = jRCrosstabParameter.getValueClass()) == null) {
                    this.brokenRules.add("Class not set for crosstab parameter " + string + ".");
                    continue;
                }
                if (clazz2 == null || clazz.isAssignableFrom(clazz2)) continue;
                this.brokenRules.add("Incompatible expression class for crosstab parameter " + string + ".");
            }
        }
    }

    private void verifyCrosstabRowGroup(JRCrosstabRowGroup jRCrosstabRowGroup) {
        this.verifyCrosstabGroup(jRCrosstabRowGroup);
    }

    private void verifyCrosstabColumnGroup(JRCrosstabColumnGroup jRCrosstabColumnGroup) {
        this.verifyCrosstabGroup(jRCrosstabColumnGroup);
    }

    private void verifyCrosstabGroup(JRCrosstabGroup jRCrosstabGroup) {
        String string = jRCrosstabGroup.getName();
        if (string == null || string.length() == 0) {
            this.brokenRules.add("Crosstab group name missing.");
        }
        this.verifyCrosstabBucket(jRCrosstabGroup);
        this.verifyCellContents(jRCrosstabGroup.getHeader(), string + " header");
        if (jRCrosstabGroup.hasTotal()) {
            this.verifyCellContents(jRCrosstabGroup.getTotalHeader(), string + " total header");
        }
    }

    private void verifyCrosstabBucket(JRCrosstabGroup jRCrosstabGroup) {
        Class clazz;
        JRCrosstabBucket jRCrosstabBucket = jRCrosstabGroup.getBucket();
        JRExpression jRExpression = jRCrosstabBucket.getExpression();
        Class clazz2 = null;
        if (jRExpression == null) {
            this.brokenRules.add("Crosstab bucket expression missing for group " + jRCrosstabGroup.getName() + ".");
        } else {
            clazz2 = jRExpression.getValueClass();
            if (clazz2 == null) {
                this.brokenRules.add("Crosstab bucket expression class missing for group " + jRCrosstabGroup.getName() + ".");
            }
        }
        Class clazz3 = clazz = jRExpression == null ? null : jRExpression.getValueClass();
        if (clazz == null) {
            this.brokenRules.add("Crosstab bucket value class missing for group " + jRCrosstabGroup.getName() + ".");
        } else if (clazz2 != null && !clazz.isAssignableFrom(clazz2)) {
            this.brokenRules.add("The class of the expression is not compatible with the class of the crosstab bucket for group " + jRCrosstabGroup.getName() + ".");
        }
        JRExpression jRExpression2 = jRCrosstabBucket.getComparatorExpression();
        if (jRExpression2 == null) {
            if (clazz != null && !(class$java$lang$Comparable == null ? (class$java$lang$Comparable = JRVerifier.class$("java.lang.Comparable")) : class$java$lang$Comparable).isAssignableFrom(clazz)) {
                this.brokenRules.add("No comparator expression specified and the value class is not comparable for crosstab group " + jRCrosstabGroup.getName() + ".");
            }
        } else {
            Class clazz4 = jRExpression2.getValueClass();
            if (clazz4 == null) {
                this.brokenRules.add("Crosstab bucket comparator expression class missing for group " + jRCrosstabGroup.getName() + ".");
            } else if (!(class$java$util$Comparator == null ? (class$java$util$Comparator = JRVerifier.class$("java.util.Comparator")) : class$java$util$Comparator).isAssignableFrom(clazz4)) {
                this.brokenRules.add("The comparator expression should be compatible with java.util.Comparator for crosstab group " + jRCrosstabGroup.getName() + ".");
            }
        }
    }

    private void verifyCrosstabCells(JRDesignCrosstab jRDesignCrosstab) {
        JRCrosstabColumnGroup[] jRCrosstabColumnGroupArray;
        JRCrosstabRowGroup[] jRCrosstabRowGroupArray;
        JRCrosstabCell[][] jRCrosstabCellArray = jRDesignCrosstab.getCells();
        JRCrosstabCell jRCrosstabCell = jRCrosstabCellArray[(jRCrosstabRowGroupArray = jRDesignCrosstab.getRowGroups()).length][(jRCrosstabColumnGroupArray = jRDesignCrosstab.getColumnGroups()).length];
        if (jRCrosstabCell == null || jRCrosstabCell.getWidth() == null) {
            this.brokenRules.add("Crosstab base cell width not specified.");
        }
        if (jRCrosstabCell == null || jRCrosstabCell.getHeight() == null) {
            this.brokenRules.add("Crosstab base cell height not specified.");
        }
        for (int i = jRCrosstabRowGroupArray.length; i >= 0; --i) {
            for (int j = jRCrosstabColumnGroupArray.length; j >= 0; --j) {
                JRCrosstabCell jRCrosstabCell2;
                JRCrosstabCell jRCrosstabCell3 = jRCrosstabCellArray[i][j];
                String string = this.getCrosstabCellText(jRCrosstabRowGroupArray, jRCrosstabColumnGroupArray, i, j);
                if (jRCrosstabCell3 == null) continue;
                JRCellContents jRCellContents = jRCrosstabCell3.getContents();
                if (i < jRCrosstabRowGroupArray.length && (jRCrosstabCell2 = jRCrosstabCellArray[jRCrosstabRowGroupArray.length][j]) != null && jRCrosstabCell2.getContents().getWidth() != jRCellContents.getWidth()) {
                    this.brokenRules.add("Crosstab " + string + " width should be " + jRCrosstabCell2.getContents().getWidth() + ".");
                }
                if (j < jRCrosstabColumnGroupArray.length && (jRCrosstabCell2 = jRCrosstabCellArray[i][jRCrosstabColumnGroupArray.length]) != null && jRCrosstabCell2.getContents().getHeight() != jRCellContents.getHeight()) {
                    this.brokenRules.add("Crosstab " + string + " height should be " + jRCrosstabCell2.getContents().getHeight() + ".");
                }
                this.verifyCellContents(jRCellContents, string);
            }
        }
    }

    private String getCrosstabCellText(JRCrosstabRowGroup[] jRCrosstabRowGroupArray, JRCrosstabColumnGroup[] jRCrosstabColumnGroupArray, int n, int n2) {
        String string = n == jRCrosstabRowGroupArray.length ? (n2 == jRCrosstabColumnGroupArray.length ? "cell" : jRCrosstabColumnGroupArray[n2].getName() + " total cell") : (n2 == jRCrosstabColumnGroupArray.length ? jRCrosstabRowGroupArray[n].getName() + " total cell" : jRCrosstabRowGroupArray[n].getName() + "," + jRCrosstabColumnGroupArray[n2].getName() + " total cell");
        return string;
    }

    private void verifyCrosstabMeasure(JRCrosstabMeasure jRCrosstabMeasure) {
        Class clazz;
        byte by;
        String string = jRCrosstabMeasure.getName();
        if (string == null || string.trim().length() == 0) {
            this.brokenRules.add("Measure name missing.");
        }
        if ((by = jRCrosstabMeasure.getCalculation()) == 8) {
            this.brokenRules.add("Crosstab mesures cannot have system calculation");
        }
        JRExpression jRExpression = jRCrosstabMeasure.getValueExpression();
        Class clazz2 = null;
        if (jRExpression == null) {
            this.brokenRules.add("Missing expression for measure " + string);
        } else {
            clazz2 = jRExpression.getValueClass();
            if (clazz2 == null) {
                this.brokenRules.add("Crosstab measure expression class missing for " + string + ".");
            }
        }
        Class clazz3 = jRCrosstabMeasure.getValueClass();
        if (clazz3 == null) {
            this.brokenRules.add("Measure value class missing.");
        } else if (clazz2 != null && by != 1 && !clazz3.isAssignableFrom(clazz2)) {
            this.brokenRules.add("The class of the expression is not compatible with the class of the measure " + string + ".");
        }
        if (jRCrosstabMeasure.getPercentageOfType() != 0) {
            clazz = jRCrosstabMeasure.getPercentageCalculatorClass();
            if (clazz == null) {
                if (clazz3 != null && !JRPercentageCalculatorFactory.hasBuiltInCalculator(clazz3)) {
                    this.brokenRules.add("Percentage calculator class needs to be specified for measure " + string + ".");
                }
            } else if (!(class$net$sf$jasperreports$crosstabs$fill$JRPercentageCalculator == null ? (class$net$sf$jasperreports$crosstabs$fill$JRPercentageCalculator = JRVerifier.class$("net.sf.jasperreports.crosstabs.fill.JRPercentageCalculator")) : class$net$sf$jasperreports$crosstabs$fill$JRPercentageCalculator).isAssignableFrom(clazz)) {
                this.brokenRules.add("Incompatible percentage calculator class for measure " + string + ".");
            }
        }
        if ((clazz = jRCrosstabMeasure.getIncrementerFactoryClass()) != null && !(class$net$sf$jasperreports$engine$fill$JRExtendedIncrementerFactory == null ? (class$net$sf$jasperreports$engine$fill$JRExtendedIncrementerFactory = JRVerifier.class$("net.sf.jasperreports.engine.fill.JRExtendedIncrementerFactory")) : class$net$sf$jasperreports$engine$fill$JRExtendedIncrementerFactory).isAssignableFrom(clazz)) {
            this.brokenRules.add("Crosstab measures need extended incrementers (net.sf.jasperreports.engine.fill.JRExtendedIncrementerFactory).");
        }
    }

    private void verifyExpressions(JRDesignCrosstab jRDesignCrosstab) {
        this.verifyExpressions(this.expressionCollector.getExpressions(jRDesignCrosstab), jRDesignCrosstab.getParametersMap(), new HashMap(), jRDesignCrosstab.getVariablesMap());
    }

    private void verifyChart(JRChart jRChart) {
        if (jRChart.getEvaluationTime() == 7) {
            this.brokenRules.add("Charts do not support Auto evaluation time.");
        }
        this.verifyElementDataset(jRChart.getDataset());
    }

    private void verifyCellContents(JRCellContents jRCellContents, String string) {
        JRElement[] jRElementArray;
        if (jRCellContents != null && (jRElementArray = jRCellContents.getElements()) != null && jRElementArray.length > 0) {
            int n;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            JRBox jRBox = jRCellContents.getBox();
            if (jRBox != null) {
                n2 = jRBox.getTopPadding();
                n3 = jRBox.getLeftPadding();
                n4 = jRBox.getBottomPadding();
                n5 = jRBox.getRightPadding();
            }
            boolean bl = (n = jRCellContents.getWidth()) != Integer.MIN_VALUE;
            int n6 = n - n3 - n5;
            int n7 = jRCellContents.getHeight();
            boolean bl2 = n7 != Integer.MIN_VALUE;
            int n8 = n7 - n2 - n4;
            for (int i = 0; i < jRElementArray.length; ++i) {
                JRHyperlink jRHyperlink;
                JRElement jRElement = jRElementArray[i];
                this.verifyPrintWhenExpr(jRElement);
                if (bl && jRElement.getX() + jRElement.getWidth() > n6) {
                    this.brokenRules.add("Element reaches outside " + string + " width: x=" + jRElement.getX() + ", width=" + jRElement.getWidth() + ", available width=" + n6 + ".");
                }
                if (bl2 && jRElement.getY() + jRElement.getHeight() > n8) {
                    this.brokenRules.add("Element reaches outside " + string + " height: y=" + jRElement.getY() + ", height=" + jRElement.getHeight() + ", available height=" + n8 + ".");
                }
                if (jRElement instanceof JRStaticText) {
                    this.verifyStaticText((JRStaticText)jRElement);
                    continue;
                }
                if (jRElement instanceof JRTextField) {
                    jRHyperlink = (JRTextField)jRElement;
                    if (jRHyperlink.getEvaluationTime() != 1) {
                        this.brokenRules.add("Elements with delayed evaluation time are not supported inside crosstab cells.");
                    }
                    this.verifyTextField((JRTextField)jRHyperlink);
                    continue;
                }
                if (jRElement instanceof JRImage) {
                    jRHyperlink = (JRImage)jRElement;
                    if (jRHyperlink.getEvaluationTime() != 1) {
                        this.brokenRules.add("Elements with delayed evaluation time are not supported inside crosstab cells.");
                    }
                    this.verifyImage((JRImage)jRHyperlink);
                    continue;
                }
                if (jRElement instanceof JRFrame) {
                    this.verifyFrame((JRFrame)jRElement);
                    continue;
                }
                if (jRElement instanceof JRSubreport) {
                    this.brokenRules.add("Subreports are not allowed inside crosstab cells.");
                    continue;
                }
                if (jRElement instanceof JRCrosstab) {
                    this.brokenRules.add("Crosstabs are not allowed inside crosstab cells.");
                    continue;
                }
                if (!(jRElement instanceof JRChart)) continue;
                this.brokenRules.add("Charts are not allowed inside crosstab cells.");
            }
        }
    }

    private void verifyElementDataset(JRElementDataset jRElementDataset) {
        JRDatasetRun jRDatasetRun = jRElementDataset.getDatasetRun();
        if (jRDatasetRun != null) {
            byte by;
            byte by2 = jRElementDataset.getIncrementType();
            if (by2 == 2 || by2 == 3) {
                this.brokenRules.add("Chart datasets with dataset run cannont have Column or Page increment type.");
            }
            if ((by = jRElementDataset.getResetType()) == 2 || by == 3) {
                this.brokenRules.add("Chart datasets with dataset run cannont have Column or Page reset type.");
            } else if (by != 1) {
                // empty if block
            }
            this.verifyDatasetRun(jRDatasetRun);
        }
    }

    private void verifyDatasetRun(JRDatasetRun jRDatasetRun) {
        Object object;
        Object object2;
        JRDatasetParameter[] jRDatasetParameterArray;
        JRDesignDataset jRDesignDataset = null;
        String string = jRDatasetRun.getDatasetName();
        if (string == null || string.length() == 0) {
            this.brokenRules.add("Dataset name is missing for dataset run.");
        } else {
            jRDesignDataset = (JRDesignDataset)this.jasperDesign.getDatasetMap().get(string);
            if (jRDesignDataset == null) {
                this.brokenRules.add("Unknown dataset name " + string + ".");
            }
        }
        JRExpression jRExpression = jRDatasetRun.getParametersMapExpression();
        if (jRExpression != null) {
            jRDatasetParameterArray = jRExpression.getValueClass();
            if (jRDatasetParameterArray == null) {
                this.brokenRules.add("Class not set for dataset " + string + " parameters map expression.");
            } else if (!(class$java$util$Map == null ? (class$java$util$Map = JRVerifier.class$("java.util.Map")) : class$java$util$Map).isAssignableFrom((Class<?>)jRDatasetParameterArray)) {
                this.brokenRules.add("Class " + jRDatasetParameterArray + " not supported for dataset " + string + " parameters map expression. Use java.util.Map instead.");
            }
        }
        if ((jRDatasetParameterArray = jRDatasetRun.getParameters()) != null && jRDatasetParameterArray.length > 0) {
            for (int i = 0; i < jRDatasetParameterArray.length; ++i) {
                JRExpression jRExpression2;
                object2 = jRDatasetParameterArray[i];
                object = object2.getName();
                if (object == null || ((String)object).trim().length() == 0) {
                    this.brokenRules.add("Dataset " + string + " parameter name missing.");
                }
                JRParameter jRParameter = null;
                if (jRDesignDataset != null && (jRParameter = (JRParameter)jRDesignDataset.getParametersMap().get(object)) == null) {
                    this.brokenRules.add("Unknown parameter " + (String)object + " in dataset " + string + ".");
                }
                if ((jRExpression2 = object2.getExpression()) == null) continue;
                Class clazz = jRExpression2.getValueClass();
                if (clazz == null) {
                    this.brokenRules.add("Class not set for dataset " + string + " parameter expression : " + (String)object + ".");
                    continue;
                }
                if (jRParameter == null || jRParameter.getValueClass().isAssignableFrom(clazz)) continue;
                this.brokenRules.add("Class " + clazz + " not supported for parameter " + (String)object + " of dataset " + string + ". Use " + jRParameter.getValueClass() + " instead.");
            }
        }
        JRExpression jRExpression3 = jRDatasetRun.getConnectionExpression();
        object2 = jRDatasetRun.getDataSourceExpression();
        if (jRExpression3 != null && object2 != null) {
            this.brokenRules.add("Dataset " + string + " cannot have both connection expresion and data source expression.");
        }
        if (jRExpression3 != null) {
            object = jRExpression3.getValueClass();
            if (object == null) {
                this.brokenRules.add("Class not set for dataset " + string + " connection expression.");
            } else if (!(class$java$sql$Connection == null ? (class$java$sql$Connection = JRVerifier.class$("java.sql.Connection")) : class$java$sql$Connection).isAssignableFrom((Class<?>)object)) {
                this.brokenRules.add("Class " + object + " not supported for dataset " + string + " connection expression. Use java.sql.Connection instead.");
            }
        }
        if (object2 != null) {
            object = object2.getValueClass();
            if (object == null) {
                this.brokenRules.add("Class not set for dataset " + string + " data source expression.");
            } else if (!(class$net$sf$jasperreports$engine$JRDataSource == null ? (class$net$sf$jasperreports$engine$JRDataSource = JRVerifier.class$("net.sf.jasperreports.engine.JRDataSource")) : class$net$sf$jasperreports$engine$JRDataSource).isAssignableFrom((Class<?>)object)) {
                this.brokenRules.add("Class " + object + " not supported for dataset " + string + " data source expression. Use net.sf.jasperreports.engine.JRDataSource instead.");
            }
        }
    }

    private void verifyDatasets() {
        JRDataset[] jRDatasetArray = this.jasperDesign.getDatasets();
        if (jRDatasetArray != null && jRDatasetArray.length > 0) {
            for (int i = 0; i < jRDatasetArray.length; ++i) {
                JRDesignDataset jRDesignDataset = (JRDesignDataset)jRDatasetArray[i];
                if (jRDesignDataset.getName() == null || jRDesignDataset.getName().trim().length() == 0) {
                    this.brokenRules.add("Dataset name is missing.");
                }
                this.verifyDataset(jRDesignDataset);
            }
        }
    }

    private void verifyDataset(JRDesignDataset jRDesignDataset) {
        this.verifyExpressions(jRDesignDataset);
        this.verifyParameters(jRDesignDataset);
        this.verifyQuery(jRDesignDataset);
        this.verifyFields(jRDesignDataset);
        this.verifyVariables(jRDesignDataset);
        this.verifyGroups(jRDesignDataset);
    }

    private void verifyFrame(JRFrame jRFrame) {
        JRElement[] jRElementArray = jRFrame.getElements();
        if (jRElementArray != null && jRElementArray.length > 0) {
            int n = jRFrame.getTopPadding();
            int n2 = jRFrame.getLeftPadding();
            int n3 = jRFrame.getBottomPadding();
            int n4 = jRFrame.getRightPadding();
            int n5 = jRFrame.getWidth() - n2 - n4;
            int n6 = jRFrame.getHeight() - n - n3;
            for (int i = 0; i < jRElementArray.length; ++i) {
                JRElement jRElement = jRElementArray[i];
                if (jRElement.getX() + jRElement.getWidth() > n5) {
                    this.brokenRules.add("Element reaches outside frame width: x=" + jRElement.getX() + ", width=" + jRElement.getWidth() + ", available width=" + n5 + ".");
                }
                if (jRElement.getY() + jRElement.getHeight() > n6) {
                    this.brokenRules.add("Element reaches outside frame height: y=" + jRElement.getY() + ", height=" + jRElement.getHeight() + ", available height=" + n6 + ".");
                }
                this.verifyElement(jRElement);
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

