/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.design;

import net.sf.jasperreports.crosstabs.JRCrosstab;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.design.JRCompiler;
import net.sf.jasperreports.engine.design.JRJavacCompiler;
import net.sf.jasperreports.engine.design.JRJdk12Compiler;
import net.sf.jasperreports.engine.design.JRJdk13Compiler;
import net.sf.jasperreports.engine.design.JRJdtCompiler;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.fill.JREvaluator;
import net.sf.jasperreports.engine.util.JRClassLoader;
import net.sf.jasperreports.engine.util.JRProperties;

public final class JRDefaultCompiler
implements JRCompiler {
    private static final JRDefaultCompiler instance = new JRDefaultCompiler();
    static /* synthetic */ Class class$net$sf$jasperreports$engine$design$JRDefaultCompiler;

    private JRDefaultCompiler() {
    }

    public static JRDefaultCompiler getInstance() {
        return instance;
    }

    public JasperReport compileReport(JasperDesign jasperDesign) throws JRException {
        JRCompiler jRCompiler = null;
        String string = JRProperties.getProperty("net.sf.jasperreports.compiler.class");
        if (string == null || string.trim().length() == 0) {
            try {
                JRClassLoader.loadClassForName("org.eclipse.jdt.internal.compiler.Compiler");
                jRCompiler = new JRJdtCompiler();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (jRCompiler == null) {
                try {
                    JRClassLoader.loadClassForName("com.sun.tools.javac.Main");
                    jRCompiler = new JRJdk13Compiler();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (jRCompiler == null) {
                try {
                    JRClassLoader.loadClassForName("sun.tools.javac.Main");
                    jRCompiler = new JRJdk12Compiler();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (jRCompiler == null) {
                jRCompiler = new JRJavacCompiler();
            }
        } else {
            try {
                Class clazz = JRClassLoader.loadClassForName(string);
                jRCompiler = (JRCompiler)clazz.newInstance();
            }
            catch (Exception exception) {
                throw new JRException("Could not instantiate report compiler : " + string, exception);
            }
        }
        return jRCompiler.compileReport(jasperDesign);
    }

    private JRCompiler getCompiler(JasperReport jasperReport) throws JRException {
        JRCompiler jRCompiler = null;
        String string = jasperReport.getCompilerClass();
        Class<?> clazz = null;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null) {
            try {
                clazz = classLoader.loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (clazz == null) {
            classLoader = (class$net$sf$jasperreports$engine$design$JRDefaultCompiler == null ? (class$net$sf$jasperreports$engine$design$JRDefaultCompiler = JRDefaultCompiler.class$("net.sf.jasperreports.engine.design.JRDefaultCompiler")) : class$net$sf$jasperreports$engine$design$JRDefaultCompiler).getClassLoader();
            try {
                clazz = classLoader == null ? Class.forName(string) : classLoader.loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new JRException("Report compiler class not found : " + string);
            }
        }
        try {
            jRCompiler = (JRCompiler)clazz.newInstance();
        }
        catch (Exception exception) {
            throw new JRException("Could not instantiate report compiler : " + string, exception);
        }
        return jRCompiler;
    }

    public JREvaluator loadEvaluator(JasperReport jasperReport, JRDataset jRDataset) throws JRException {
        JRCompiler jRCompiler = this.getCompiler(jasperReport);
        return jRCompiler.loadEvaluator(jasperReport, jRDataset);
    }

    public JREvaluator loadEvaluator(JasperReport jasperReport, JRCrosstab jRCrosstab) throws JRException {
        JRCompiler jRCompiler = this.getCompiler(jasperReport);
        return jRCompiler.loadEvaluator(jasperReport, jRCrosstab);
    }

    public JREvaluator loadEvaluator(JasperReport jasperReport) throws JRException {
        return this.loadEvaluator(jasperReport, jasperReport.getMainDataset());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

