/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.data;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import javax.xml.transform.TransformerException;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import net.sf.jasperreports.engine.design.JRDesignField;
import net.sf.jasperreports.engine.util.JRXmlUtils;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.xpath.CachedXPathAPI;
import org.apache.xpath.objects.XObject;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class JRXmlDataSource
implements JRRewindableDataSource {
    private Document document;
    private String selectExpression;
    private NodeList nodeList;
    private int nodeListLength;
    private Node currentNode;
    private int currentNodeIndex = -1;
    private CachedXPathAPI xpathAPI = new CachedXPathAPI();
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$String;

    public JRXmlDataSource(Document document) throws JRException {
        this(document, ".");
    }

    public JRXmlDataSource(Document document, String string) throws JRException {
        this.document = document;
        this.selectExpression = string;
        this.moveFirst();
    }

    public JRXmlDataSource(InputStream inputStream) throws JRException {
        this(inputStream, ".");
    }

    public JRXmlDataSource(InputStream inputStream, String string) throws JRException {
        this(JRXmlUtils.parse(new InputSource(inputStream)), string);
    }

    public JRXmlDataSource(String string) throws JRException {
        this(string, ".");
    }

    public JRXmlDataSource(String string, String string2) throws JRException {
        this(JRXmlUtils.parse(string), string2);
    }

    public JRXmlDataSource(File file) throws JRException {
        this(file, ".");
    }

    public JRXmlDataSource(File file, String string) throws JRException {
        this(JRXmlUtils.parse(file), string);
    }

    public void moveFirst() throws JRException {
        if (this.document == null) {
            throw new JRException("document cannot be not null");
        }
        if (this.selectExpression == null) {
            throw new JRException("selectExpression cannot be not null");
        }
        try {
            this.currentNode = null;
            this.currentNodeIndex = -1;
            this.nodeListLength = 0;
            this.nodeList = this.xpathAPI.selectNodeList((Node)this.document, this.selectExpression);
            this.nodeListLength = this.nodeList.getLength();
        }
        catch (TransformerException transformerException) {
            throw new JRException("XPath selection failed. Expression: " + this.selectExpression, transformerException);
        }
    }

    public boolean next() {
        if (this.currentNodeIndex == this.nodeListLength - 1) {
            return false;
        }
        this.currentNode = this.nodeList.item(++this.currentNodeIndex);
        return true;
    }

    public Object getFieldValue(JRField jRField) throws JRException {
        Class clazz;
        if (this.currentNode == null) {
            return null;
        }
        String string = jRField.getDescription();
        if (string == null || string.length() == 0) {
            return null;
        }
        Object object = null;
        if ((class$java$lang$Object == null ? (class$java$lang$Object = JRXmlDataSource.class$("java.lang.Object")) : class$java$lang$Object) != (clazz = jRField.getValueClass())) {
            String string2 = null;
            try {
                XObject xObject = this.xpathAPI.eval(this.currentNode, string);
                if (xObject.getType() == 4) {
                    Node node = xObject.nodeset().nextNode();
                    if (node != null) {
                        string2 = this.getText(node);
                    }
                } else {
                    string2 = xObject.str();
                }
            }
            catch (TransformerException transformerException) {
                throw new JRException("XPath selection failed. Expression: " + string, transformerException);
            }
            if (string2 != null) {
                object = (class$java$lang$String == null ? (class$java$lang$String = JRXmlDataSource.class$("java.lang.String")) : class$java$lang$String) == clazz ? string2 : ConvertUtils.convert((String)string2.trim(), (Class)clazz);
            }
        }
        return object;
    }

    public JRXmlDataSource subDataSource(String string) throws JRException {
        Document document = this.subDocument();
        return new JRXmlDataSource(document, string);
    }

    public JRXmlDataSource subDataSource() throws JRException {
        return this.subDataSource(".");
    }

    public Document subDocument() throws JRException {
        if (this.currentNode == null) {
            throw new JRException("No node available. Iterate or rewind the data source.");
        }
        Document document = JRXmlUtils.createDocument(this.currentNode);
        return document;
    }

    public JRXmlDataSource dataSource(String string) throws JRException {
        return new JRXmlDataSource(this.document, string);
    }

    public JRXmlDataSource dataSource() throws JRException {
        return this.dataSource(".");
    }

    public String getText(Node node) {
        if (!node.hasChildNodes()) {
            return node.getNodeValue();
        }
        StringBuffer stringBuffer = new StringBuffer();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String string;
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() == 3) {
                string = node2.getNodeValue();
                if (string == null) continue;
                stringBuffer.append(string);
                continue;
            }
            if (node2.getNodeType() == 4) {
                string = node2.getNodeValue();
                if (string == null) continue;
                stringBuffer.append(string);
                continue;
            }
            if (node2.getNodeType() != 5 || (string = this.getText(node2)) == null) continue;
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) throws Exception {
        JRXmlDataSource jRXmlDataSource = new JRXmlDataSource(new FileInputStream("northwind.xml"), "/Northwind/Customers");
        JRDesignField jRDesignField = new JRDesignField();
        jRDesignField.setDescription("CustomerID");
        jRDesignField.setValueClass(class$java$lang$String == null ? (class$java$lang$String = JRXmlDataSource.class$("java.lang.String")) : class$java$lang$String);
        jRXmlDataSource.next();
        String string = (String)jRXmlDataSource.getFieldValue(jRDesignField);
        System.out.println(jRDesignField.getDescription() + "=" + string);
        JRXmlDataSource jRXmlDataSource2 = jRXmlDataSource.dataSource("/Northwind/Orders");
        JRDesignField jRDesignField2 = new JRDesignField();
        jRDesignField2.setDescription("OrderID");
        jRDesignField2.setValueClass(class$java$lang$String == null ? (class$java$lang$String = JRXmlDataSource.class$("java.lang.String")) : class$java$lang$String);
        jRXmlDataSource2.next();
        String string2 = (String)jRXmlDataSource2.getFieldValue(jRDesignField2);
        System.out.println(jRDesignField2.getDescription() + "=" + string2);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

