/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.data;

import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.data.JRAbstractBeanDataSource;
import net.sf.jasperreports.engine.query.JRHibernateQueryExecuter;
import org.hibernate.type.Type;

public abstract class JRHibernateAbstractDataSource
implements JRDataSource {
    private final boolean useFieldDescription;
    private final Map fieldReaders;
    protected final JRHibernateQueryExecuter queryExecuter;
    private Object currentReturnValue;

    protected JRHibernateAbstractDataSource(JRHibernateQueryExecuter jRHibernateQueryExecuter, boolean bl, boolean bl2) {
        this.useFieldDescription = bl;
        this.queryExecuter = jRHibernateQueryExecuter;
        this.fieldReaders = this.assignReaders(bl2);
    }

    protected Map assignReaders(boolean bl) {
        HashMap<String, FieldReader> hashMap;
        block9: {
            int n;
            HashMap<String, Integer> hashMap2;
            Type[] typeArray;
            JRField[] jRFieldArray;
            block7: {
                block8: {
                    hashMap = new HashMap<String, FieldReader>();
                    jRFieldArray = this.queryExecuter.getDataset().getFields();
                    typeArray = this.queryExecuter.getReturnTypes();
                    String[] stringArray = this.queryExecuter.getReturnAliases();
                    hashMap2 = new HashMap<String, Integer>();
                    if (stringArray != null) {
                        for (n = 0; n < stringArray.length; ++n) {
                            hashMap2.put(stringArray[n], new Integer(n));
                        }
                    }
                    if (typeArray.length != 1) break block7;
                    if (!typeArray[0].isEntityType() && !typeArray[0].isComponentType()) break block8;
                    for (n = 0; n < jRFieldArray.length; ++n) {
                        JRField jRField = jRFieldArray[n];
                        hashMap.put(jRField.getName(), this.getFieldReaderSingleReturn(hashMap2, jRField, bl));
                    }
                    break block9;
                }
                if (jRFieldArray.length > 1) {
                    throw new JRRuntimeException("The HQL query returns only one non-entity and non-component result but there are more than one fields.");
                }
                if (jRFieldArray.length != 1) break block9;
                JRField jRField = jRFieldArray[0];
                if (bl) {
                    hashMap.put(jRField.getName(), new IndexFieldReader(0));
                } else {
                    hashMap.put(jRField.getName(), new IdentityFieldReader());
                }
                break block9;
            }
            for (n = 0; n < jRFieldArray.length; ++n) {
                JRField jRField = jRFieldArray[n];
                hashMap.put(jRField.getName(), this.getFieldReader(typeArray, hashMap2, jRField));
            }
        }
        return hashMap;
    }

    protected FieldReader getFieldReaderSingleReturn(Map map, JRField jRField, boolean bl) {
        FieldReader fieldReader;
        String string = this.getFieldMapping(jRField);
        if (map.containsKey(string)) {
            fieldReader = bl ? new IndexFieldReader(0) : new IdentityFieldReader();
        } else {
            int n = string.indexOf(46);
            if (n >= 0 && map.containsKey(string.substring(0, n))) {
                string = string.substring(n + 1);
            }
            fieldReader = bl ? new IndexPropertyFieldReader(0, string) : new PropertyFieldReader(string);
        }
        return fieldReader;
    }

    protected FieldReader getFieldReader(Type[] typeArray, Map map, JRField jRField) {
        FieldReader fieldReader;
        String string = this.getFieldMapping(jRField);
        Integer n = (Integer)map.get(string);
        if (n == null) {
            int n2 = string.indexOf(46);
            if (n2 < 0) {
                throw new JRRuntimeException("Unknown HQL return alias \"" + string + "\".");
            }
            String string2 = string.substring(0, n2);
            String string3 = string.substring(n2 + 1);
            n = (Integer)map.get(string2);
            if (n == null) {
                throw new JRRuntimeException("The HQL query does not have a \"" + string2 + "\" alias.");
            }
            Type type = typeArray[n];
            if (!type.isEntityType() && !type.isComponentType()) {
                throw new JRRuntimeException("The HQL query does not have a \"" + string2 + "\" alias.");
            }
            fieldReader = new IndexPropertyFieldReader(n, string3);
        } else {
            fieldReader = new IndexFieldReader(n);
        }
        return fieldReader;
    }

    protected void setCurrentRowValue(Object object) {
        this.currentReturnValue = object;
    }

    public Object getFieldValue(JRField jRField) throws JRException {
        FieldReader fieldReader = (FieldReader)this.fieldReaders.get(jRField.getName());
        if (fieldReader == null) {
            throw new JRRuntimeException("No filed reader for " + jRField.getName());
        }
        return fieldReader.getFieldValue(this.currentReturnValue);
    }

    protected String getFieldMapping(JRField jRField) {
        return (this.useFieldDescription ? JRAbstractBeanDataSource.FIELD_DESCRIPTION_PROPERTY_NAME_PROVIDER : JRAbstractBeanDataSource.FIELD_NAME_PROPERTY_NAME_PROVIDER).getPropertyName(jRField);
    }

    protected static class IndexPropertyFieldReader
    implements FieldReader {
        private final int idx;
        private final String property;

        protected IndexPropertyFieldReader(int n, String string) {
            this.idx = n;
            this.property = string;
        }

        public Object getFieldValue(Object object) throws JRException {
            return JRAbstractBeanDataSource.getBeanProperty(((Object[])object)[this.idx], this.property);
        }
    }

    protected static class PropertyFieldReader
    implements FieldReader {
        private final String property;

        protected PropertyFieldReader(String string) {
            this.property = string;
        }

        public Object getFieldValue(Object object) throws JRException {
            return JRAbstractBeanDataSource.getBeanProperty(object, this.property);
        }
    }

    protected static class IndexFieldReader
    implements FieldReader {
        private final int idx;

        protected IndexFieldReader(int n) {
            this.idx = n;
        }

        public Object getFieldValue(Object object) {
            return ((Object[])object)[this.idx];
        }
    }

    protected static class IdentityFieldReader
    implements FieldReader {
        protected IdentityFieldReader() {
        }

        public Object getFieldValue(Object object) {
            return object;
        }
    }

    protected static interface FieldReader {
        public Object getFieldValue(Object var1) throws JRException;
    }
}

