/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.data;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Vector;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRRuntimeException;

public class JRCsvDataSource
implements JRDataSource {
    private DateFormat dateFormat = new SimpleDateFormat();
    private char fieldDelimiter = (char)44;
    private String recordDelimiter = "\n";
    private HashMap columnNames = new HashMap();
    private boolean useFirstRowAsHeader;
    private Vector fields;
    private Reader reader;
    private char[] buffer = new char[1024];
    private int position;
    private int bufSize;
    private boolean processingStarted;
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$sql$Timestamp;
    static /* synthetic */ Class class$java$sql$Time;

    public JRCsvDataSource(InputStream inputStream) {
        this(new InputStreamReader(inputStream));
    }

    public JRCsvDataSource(File file) throws FileNotFoundException {
        this(new FileReader(file));
    }

    public JRCsvDataSource(Reader reader) {
        this.reader = reader;
    }

    public boolean next() throws JRException {
        try {
            if (!this.processingStarted) {
                if (this.useFirstRowAsHeader) {
                    this.parseRow();
                    for (int i = 0; i < this.fields.size(); ++i) {
                        String string = (String)this.fields.get(i);
                        this.columnNames.put(string, new Integer(i));
                    }
                }
                this.processingStarted = true;
            }
            return this.parseRow();
        }
        catch (IOException iOException) {
            throw new JRException(iOException);
        }
    }

    public Object getFieldValue(JRField jRField) throws JRException {
        String string = jRField.getName();
        Integer n = (Integer)this.columnNames.get(string);
        if (n == null && string.startsWith("COLUMN_")) {
            n = Integer.valueOf(string.substring(7));
        }
        if (n == null) {
            throw new JRException("Unknown column name : " + string);
        }
        if (this.fields.size() > n) {
            Class clazz;
            String string2 = (String)this.fields.get(n);
            if ((class$java$lang$Number == null ? (class$java$lang$Number = JRCsvDataSource.class$("java.lang.Number")) : class$java$lang$Number).isAssignableFrom(clazz = jRField.getValueClass())) {
                string2 = string2.trim();
            }
            try {
                if (clazz.equals(class$java$lang$String == null ? (class$java$lang$String = JRCsvDataSource.class$("java.lang.String")) : class$java$lang$String)) {
                    return string2;
                }
                if (clazz.equals(class$java$lang$Boolean == null ? (class$java$lang$Boolean = JRCsvDataSource.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
                    return string2.equalsIgnoreCase("true") ? Boolean.TRUE : Boolean.FALSE;
                }
                if (clazz.equals(class$java$lang$Byte == null ? (class$java$lang$Byte = JRCsvDataSource.class$("java.lang.Byte")) : class$java$lang$Byte)) {
                    return new Byte(string2);
                }
                if (clazz.equals(class$java$lang$Integer == null ? (class$java$lang$Integer = JRCsvDataSource.class$("java.lang.Integer")) : class$java$lang$Integer)) {
                    return new Integer(string2);
                }
                if (clazz.equals(class$java$lang$Long == null ? (class$java$lang$Long = JRCsvDataSource.class$("java.lang.Long")) : class$java$lang$Long)) {
                    return new Long(string2);
                }
                if (clazz.equals(class$java$lang$Short == null ? (class$java$lang$Short = JRCsvDataSource.class$("java.lang.Short")) : class$java$lang$Short)) {
                    return new Short(string2);
                }
                if (clazz.equals(class$java$lang$Double == null ? (class$java$lang$Double = JRCsvDataSource.class$("java.lang.Double")) : class$java$lang$Double)) {
                    return new Double(string2);
                }
                if (clazz.equals(class$java$lang$Float == null ? (class$java$lang$Float = JRCsvDataSource.class$("java.lang.Float")) : class$java$lang$Float)) {
                    return new Float(string2);
                }
                if (clazz.equals(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = JRCsvDataSource.class$("java.math.BigDecimal")) : class$java$math$BigDecimal)) {
                    return new BigDecimal(string2);
                }
                if (clazz.equals(class$java$util$Date == null ? (class$java$util$Date = JRCsvDataSource.class$("java.util.Date")) : class$java$util$Date)) {
                    return this.dateFormat.parse(string2);
                }
                if (clazz.equals(class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = JRCsvDataSource.class$("java.sql.Timestamp")) : class$java$sql$Timestamp)) {
                    return new Timestamp(this.dateFormat.parse(string2).getTime());
                }
                if (clazz.equals(class$java$sql$Time == null ? (class$java$sql$Time = JRCsvDataSource.class$("java.sql.Time")) : class$java$sql$Time)) {
                    return new Time(this.dateFormat.parse(string2).getTime());
                }
                throw new JRException("Field '" + jRField.getName() + "' is of class '" + clazz.getName() + "' and can not be converted");
            }
            catch (Exception exception) {
                throw new JRException("Unable to get value for field '" + jRField.getName() + "' of class '" + clazz.getName() + "'", exception);
            }
        }
        throw new JRException("Unknown column name : " + string);
    }

    private boolean parseRow() throws IOException {
        String string;
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        this.fields = new Vector();
        String string2 = this.getRow();
        if (string2 == null || string2.length() == 0) {
            return false;
        }
        while (n < string2.length()) {
            char c = string2.charAt(n);
            if (c == '\"') {
                if (!bl) {
                    if (!bl2) {
                        bl = true;
                        bl2 = true;
                    } else {
                        bl3 = true;
                    }
                } else if (n + 1 < string2.length() && string2.charAt(n + 1) == '\"') {
                    ++n;
                } else {
                    bl = false;
                }
            }
            if (c == this.fieldDelimiter && !bl) {
                string = string2.substring(n2, n);
                if (bl3) {
                    bl3 = false;
                    bl2 = false;
                    string = "";
                } else if (bl2) {
                    if ((string = string.trim()).startsWith("\"") && string.endsWith("\"")) {
                        string = string.substring(1, string.length() - 1);
                        string = this.replaceAll(string, "\"\"", "\"");
                    } else {
                        string = "";
                    }
                    bl2 = false;
                }
                this.fields.add(string);
                n2 = n + 1;
            }
            if (++n != string2.length() || !bl) continue;
            string2 = string2 + this.recordDelimiter + this.getRow();
        }
        string = string2.substring(n2, n);
        if (string == null || string.length() == 0) {
            return true;
        }
        if (bl3) {
            string = "";
        } else if (bl2) {
            if ((string = string.trim()).startsWith("\"") && string.endsWith("\"")) {
                string = string.substring(1, string.length() - 1);
                string = this.replaceAll(string, "\"\"", "\"");
            } else {
                string = "";
            }
        }
        this.fields.add(string);
        return true;
    }

    private String getRow() throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            while (true) {
                char c;
                if ((c = this.getChar()) == this.recordDelimiter.charAt(0)) {
                    int n;
                    char[] cArray = new char[this.recordDelimiter.length()];
                    cArray[0] = c;
                    boolean bl = true;
                    for (n = 1; n < this.recordDelimiter.length() && bl; ++n) {
                        cArray[n] = this.getChar();
                        if (cArray[n] == this.recordDelimiter.charAt(n)) continue;
                        bl = false;
                    }
                    if (bl) {
                        return stringBuffer.toString();
                    }
                    stringBuffer.append(cArray, 0, n);
                }
                stringBuffer.append(c);
            }
        }
        catch (JRException jRException) {
            return stringBuffer.toString();
        }
    }

    private char getChar() throws IOException, JRException {
        if (this.position + 1 > this.bufSize) {
            this.bufSize = this.reader.read(this.buffer);
            this.position = 0;
            if (this.bufSize == -1) {
                throw new JRException("No more chars");
            }
        }
        return this.buffer[this.position++];
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(DateFormat dateFormat) {
        if (this.processingStarted) {
            throw new JRRuntimeException("Cannot modify data source properties after data reading has started");
        }
        this.dateFormat = dateFormat;
    }

    public char getFieldDelimiter() {
        return this.fieldDelimiter;
    }

    public void setFieldDelimiter(char c) {
        if (this.processingStarted) {
            throw new JRRuntimeException("Cannot modify data source properties after data reading has started");
        }
        this.fieldDelimiter = c;
    }

    public String getRecordDelimiter() {
        return this.recordDelimiter;
    }

    public void setRecordDelimiter(String string) {
        if (this.processingStarted) {
            throw new JRRuntimeException("Cannot modify data source properties after data reading has started");
        }
        this.recordDelimiter = string;
    }

    public void setColumnNames(String[] stringArray) {
        if (this.processingStarted) {
            throw new JRRuntimeException("Cannot modify data source properties after data reading has started");
        }
        for (int i = 0; i < stringArray.length; ++i) {
            this.columnNames.put(stringArray[i], new Integer(i));
        }
    }

    public void setUseFirstRowAsHeader(boolean bl) {
        if (this.processingStarted) {
            throw new JRRuntimeException("Cannot modify data source properties after data reading has started");
        }
        this.useFirstRowAsHeader = bl;
    }

    private String replaceAll(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.indexOf(string2);
        int n2 = 0;
        while (n >= 0) {
            stringBuffer.append(string.substring(n2, n));
            stringBuffer.append(string3);
            n2 = n += string2.length();
            n = string.indexOf(string2, n);
        }
        if (n2 < string.length()) {
            stringBuffer.append(string.substring(n2, string.length()));
        }
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

