/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.data;

import java.lang.reflect.InvocationTargetException;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import org.apache.commons.beanutils.PropertyUtils;

public abstract class JRAbstractBeanDataSource
implements JRRewindableDataSource {
    protected PropertyNameProvider propertyNameProvider = null;
    protected static final PropertyNameProvider FIELD_NAME_PROPERTY_NAME_PROVIDER = new PropertyNameProvider(){

        public String getPropertyName(JRField jRField) {
            return jRField.getName();
        }
    };
    protected static final PropertyNameProvider FIELD_DESCRIPTION_PROPERTY_NAME_PROVIDER = new PropertyNameProvider(){

        public String getPropertyName(JRField jRField) {
            if (jRField.getDescription() == null) {
                return jRField.getName();
            }
            return jRField.getDescription();
        }
    };

    public JRAbstractBeanDataSource(boolean bl) {
        this.propertyNameProvider = bl ? FIELD_DESCRIPTION_PROPERTY_NAME_PROVIDER : FIELD_NAME_PROPERTY_NAME_PROVIDER;
    }

    protected Object getFieldValue(Object object, JRField jRField) throws JRException {
        return JRAbstractBeanDataSource.getBeanProperty(object, this.getPropertyName(jRField));
    }

    protected static Object getBeanProperty(Object object, String string) throws JRException {
        Object object2;
        block6: {
            object2 = null;
            if (object != null) {
                try {
                    object2 = PropertyUtils.getProperty((Object)object, (String)string);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new JRException("Error retrieving field value from bean : " + string, illegalAccessException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw new JRException("Error retrieving field value from bean : " + string, invocationTargetException);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new JRException("Error retrieving field value from bean : " + string, noSuchMethodException);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if (illegalArgumentException.getMessage().startsWith("Null property value for ")) break block6;
                    throw illegalArgumentException;
                }
            }
        }
        return object2;
    }

    protected String getPropertyName(JRField jRField) {
        return this.propertyNameProvider.getPropertyName(jRField);
    }

    static interface PropertyNameProvider {
        public String getPropertyName(JRField var1);
    }
}

