/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.base;

import java.awt.Graphics2D;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRRenderable;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRVirtualizable;
import net.sf.jasperreports.engine.JRVirtualizationHelper;
import net.sf.jasperreports.engine.JRVirtualizer;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.fill.JRTemplateElement;
import net.sf.jasperreports.engine.fill.JRTemplatePrintElement;
import net.sf.jasperreports.engine.fill.JRVirtualizationContext;

public class JRVirtualPrintPage
implements JRPrintPage,
JRVirtualizable,
Serializable {
    private static final long serialVersionUID = 10200L;
    private static final Random random = new Random(System.currentTimeMillis());
    private static short counter = 1;
    protected List elements = new ArrayList();
    private String uid;
    private transient JRVirtualizer virtualizer;
    private transient IdentityDataProvider[] identityProviders;
    private JRVirtualizationContext virtualizationContext;

    public JRVirtualPrintPage(JasperPrint jasperPrint, JRVirtualizer jRVirtualizer, JRVirtualizationContext jRVirtualizationContext) {
        this.uid = JRVirtualPrintPage.makeUID(jasperPrint);
        this.virtualizer = jRVirtualizer;
        this.identityProviders = null;
        if (jRVirtualizer != null) {
            jRVirtualizer.registerObject(this);
        }
        this.virtualizationContext = jRVirtualizationContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String makeUID(JasperPrint jasperPrint) {
        Random random = JRVirtualPrintPage.random;
        synchronized (random) {
            short s = counter;
            counter = (short)(s + 1);
            return Integer.toString(System.identityHashCode(jasperPrint)) + "_" + jasperPrint.getPages().size() + "_" + Integer.toString(s) + "_" + Integer.toString(JRVirtualPrintPage.random.nextInt());
        }
    }

    public final String getUID() {
        return this.uid;
    }

    public void setVirtualData(Object object) {
        this.elements = (List)object;
    }

    public Object getVirtualData() {
        return this.elements;
    }

    public void removeVirtualData() {
        this.elements = null;
    }

    public void setIdentityData(Object object) {
        if (this.identityProviders != null) {
            for (int i = 0; i < this.identityProviders.length; ++i) {
                this.identityProviders[i].setIdentityData(this, (ObjectIDPair[])object);
            }
        }
    }

    public Object getIdentityData() {
        ObjectIDPair[] objectIDPairArray;
        if (this.identityProviders != null) {
            if (this.identityProviders.length == 1) {
                objectIDPairArray = this.identityProviders[0].getIdentityData(this);
            } else if (this.identityProviders.length > 1) {
                HashSet<ObjectIDPair> hashSet = new HashSet<ObjectIDPair>();
                for (int i = 0; i < this.identityProviders.length; ++i) {
                    ObjectIDPair[] objectIDPairArray2 = this.identityProviders[i].getIdentityData(this);
                    if (objectIDPairArray2 == null) continue;
                    for (int j = 0; j < objectIDPairArray2.length; ++j) {
                        hashSet.add(objectIDPairArray2[j]);
                    }
                }
                objectIDPairArray = hashSet.toArray(new ObjectIDPair[hashSet.size()]);
            } else {
                objectIDPairArray = null;
            }
        } else {
            objectIDPairArray = null;
        }
        return objectIDPairArray;
    }

    public boolean isVirtualized() {
        return this.elements == null;
    }

    public void setVirtualizer(JRVirtualizer jRVirtualizer) {
        this.virtualizer = jRVirtualizer;
    }

    public JRVirtualizer getVirtualizer() {
        return this.virtualizer;
    }

    public void addIdentityDataProvider(IdentityDataProvider identityDataProvider) {
        if (this.identityProviders == null) {
            this.identityProviders = new IdentityDataProvider[]{identityDataProvider};
        } else {
            IdentityDataProvider[] identityDataProviderArray = new IdentityDataProvider[this.identityProviders.length + 1];
            System.arraycopy(this.identityProviders, 0, identityDataProviderArray, 0, this.identityProviders.length);
            identityDataProviderArray[this.identityProviders.length] = identityDataProvider;
            this.identityProviders = identityDataProviderArray;
        }
    }

    public void removeIdentityDataProvider(IdentityDataProvider identityDataProvider) {
        if (this.identityProviders != null) {
            for (int i = 0; i < this.identityProviders.length; ++i) {
                if (this.identityProviders[i] != identityDataProvider) continue;
                IdentityDataProvider[] identityDataProviderArray = new IdentityDataProvider[this.identityProviders.length - 1];
                System.arraycopy(this.identityProviders, 0, identityDataProviderArray, 0, i);
                int n = this.identityProviders.length - i - 1;
                if (n > 0) {
                    System.arraycopy(this.identityProviders, i + 1, identityDataProviderArray, i, n);
                }
                this.identityProviders = identityDataProviderArray;
                break;
            }
        }
    }

    public List getElements() {
        this.ensureVirtualData();
        return this.elements;
    }

    protected void ensureVirtualData() {
        if (this.virtualizer != null) {
            if (this.isVirtualized()) {
                this.virtualizer.requestData(this);
            } else {
                this.virtualizer.touch(this);
            }
        }
    }

    public void setElements(List list) {
        this.cleanVirtualData();
        this.elements = list;
    }

    protected void cleanVirtualData() {
        if (this.virtualizer != null) {
            if (this.isVirtualized()) {
                this.virtualizer.clearData(this);
            } else {
                this.virtualizer.touch(this);
            }
        }
    }

    public void addElement(JRPrintElement jRPrintElement) {
        this.ensureVirtualData();
        this.elements.add(jRPrintElement);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.uid = (String)objectInputStream.readObject();
        this.virtualizationContext = (JRVirtualizationContext)objectInputStream.readObject();
        int n = objectInputStream.readInt();
        byte[] byArray = new byte[n];
        objectInputStream.readFully(byArray);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, 0, byArray.length);
        ObjectInputStream objectInputStream2 = new ObjectInputStream(byteArrayInputStream);
        this.elements = (List)objectInputStream2.readObject();
        this.afterInternalization();
        this.setThreadVirtualizer();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.ensureVirtualData();
        this.beforeExternalization();
        objectOutputStream.writeObject(this.uid);
        objectOutputStream.writeObject(this.virtualizationContext);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream2 = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream2.writeObject(this.elements);
        objectOutputStream2.flush();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        objectOutputStream.writeInt(byArray.length);
        objectOutputStream.write(byArray);
    }

    private void setThreadVirtualizer() {
        JRVirtualizer jRVirtualizer = JRVirtualizationHelper.getThreadVirtualizer();
        if (jRVirtualizer != null) {
            this.virtualizer = jRVirtualizer;
            this.virtualizer.registerObject(this);
        }
    }

    protected void finalize() {
        if (this.virtualizer != null) {
            this.virtualizer.deregisterObject(this);
        }
    }

    protected List getDeepElements() {
        ArrayList arrayList = new ArrayList(this.elements.size());
        this.collectDeepElements(this.elements, arrayList);
        return arrayList;
    }

    protected void collectDeepElements(List list, List list2) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            JRPrintElement jRPrintElement = (JRPrintElement)iterator.next();
            list2.add(jRPrintElement);
            if (!(jRPrintElement instanceof JRPrintFrame)) continue;
            JRPrintFrame jRPrintFrame = (JRPrintFrame)jRPrintElement;
            this.collectDeepElements(jRPrintFrame.getElements(), list2);
        }
    }

    public void beforeExternalization() {
        List list = this.getDeepElements();
        HashMap<String, JRIdHolderTemplateElement> hashMap = new HashMap<String, JRIdHolderTemplateElement>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            JRPrintElement jRPrintElement;
            Serializable serializable;
            JRPrintElement jRPrintElement2 = (JRPrintElement)iterator.next();
            if (jRPrintElement2 instanceof JRTemplatePrintElement && (serializable = ((JRTemplatePrintElement)(jRPrintElement = (JRTemplatePrintElement)jRPrintElement2)).getTemplate()) != null) {
                this.virtualizationContext.cacheTemplate((JRTemplateElement)serializable);
                String string = ((JRTemplateElement)serializable).getId();
                JRIdHolderTemplateElement jRIdHolderTemplateElement = (JRIdHolderTemplateElement)hashMap.get(string);
                if (jRIdHolderTemplateElement == null) {
                    jRIdHolderTemplateElement = new JRIdHolderTemplateElement(string);
                    hashMap.put(string, jRIdHolderTemplateElement);
                }
                ((JRTemplatePrintElement)jRPrintElement).setTemplate(jRIdHolderTemplateElement);
            }
            if (!(jRPrintElement2 instanceof JRPrintImage) || (serializable = (jRPrintElement = (JRPrintImage)jRPrintElement2).getRenderer()) == null || !this.virtualizationContext.hasCachedRenderer(serializable.getId())) continue;
            jRPrintElement.setRenderer(new JRIdHolderRenderer((JRRenderable)serializable));
        }
    }

    public void afterInternalization() {
        List list = this.getDeepElements();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Serializable serializable;
            JRPrintElement jRPrintElement;
            Serializable serializable2;
            JRPrintElement jRPrintElement2 = (JRPrintElement)iterator.next();
            if (jRPrintElement2 instanceof JRTemplatePrintElement && (serializable2 = ((JRTemplatePrintElement)(jRPrintElement = (JRTemplatePrintElement)jRPrintElement2)).getTemplate()) != null) {
                if (!(serializable2 instanceof JRIdHolderTemplateElement)) {
                    throw new JRRuntimeException("Virtualization error.");
                }
                serializable = this.virtualizationContext.getCachedTemplate(((JRTemplateElement)serializable2).getId());
                if (serializable == null) {
                    throw new JRRuntimeException("Template " + ((JRTemplateElement)serializable2).getId() + " not found in virtualization context.");
                }
                ((JRTemplatePrintElement)jRPrintElement).setTemplate((JRTemplateElement)serializable);
            }
            if (!(jRPrintElement2 instanceof JRPrintImage) || (serializable2 = (jRPrintElement = (JRPrintImage)jRPrintElement2).getRenderer()) == null || !(serializable2 instanceof JRIdHolderRenderer)) continue;
            serializable = this.virtualizationContext.getCachedRenderer(serializable2.getId());
            if (serializable == null) {
                throw new JRRuntimeException("Renderer " + serializable2.getId() + " not found in virtualization context.");
            }
            jRPrintElement.setRenderer((JRRenderable)serializable);
        }
    }

    protected static class JRIdHolderTemplateElement
    extends JRTemplateElement {
        private static final long serialVersionUID = 10200L;

        protected JRIdHolderTemplateElement(String string) {
            super(string);
        }
    }

    protected static class JRIdHolderRenderer
    implements JRRenderable,
    Serializable {
        private static final long serialVersionUID = 10200L;
        protected final String id;

        protected JRIdHolderRenderer(JRRenderable jRRenderable) {
            this.id = jRRenderable.getId();
        }

        public String getId() {
            return this.id;
        }

        public byte getType() {
            return 0;
        }

        public byte getImageType() {
            return 0;
        }

        public Dimension2D getDimension() throws JRException {
            return null;
        }

        public byte[] getImageData() throws JRException {
            return null;
        }

        public void render(Graphics2D graphics2D, Rectangle2D rectangle2D) throws JRException {
        }
    }

    public static interface IdentityDataProvider {
        public ObjectIDPair[] getIdentityData(JRVirtualPrintPage var1);

        public void setIdentityData(JRVirtualPrintPage var1, ObjectIDPair[] var2);
    }

    public static class ObjectIDPair
    implements Serializable {
        private static final long serialVersionUID = 10200L;
        private final Object o;
        private final int id;

        public ObjectIDPair(Object object) {
            this.o = object;
            this.id = System.identityHashCode(object);
        }

        public Object getObject() {
            return this.o;
        }

        public int getIdentity() {
            return this.id;
        }
    }
}

