/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.base;

import java.io.Serializable;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JRQuery;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;

public class JRBaseDataset
implements JRDataset,
Serializable {
    private static final long serialVersionUID = 10200L;
    protected final boolean isMain;
    protected String name = null;
    protected String scriptletClass = null;
    protected JRParameter[] parameters = null;
    protected JRQuery query = null;
    protected JRField[] fields = null;
    protected JRVariable[] variables = null;
    protected JRGroup[] groups = null;
    protected String resourceBundle = null;
    protected byte whenResourceMissingType = 1;
    protected JRPropertiesMap propertiesMap;

    protected JRBaseDataset(boolean bl) {
        this.isMain = bl;
        this.propertiesMap = new JRPropertiesMap();
    }

    protected JRBaseDataset(JRDataset jRDataset, JRBaseObjectFactory jRBaseObjectFactory) {
        JRGroup[] jRGroupArray;
        JRVariable[] jRVariableArray;
        JRField[] jRFieldArray;
        jRBaseObjectFactory.put(jRDataset, this);
        this.name = jRDataset.getName();
        this.scriptletClass = jRDataset.getScriptletClass();
        this.resourceBundle = jRDataset.getResourceBundle();
        this.whenResourceMissingType = jRDataset.getWhenResourceMissingType();
        this.propertiesMap = new JRPropertiesMap(jRDataset.getPropertiesMap());
        this.query = jRBaseObjectFactory.getQuery(jRDataset.getQuery());
        this.isMain = jRDataset.isMainDataset();
        JRParameter[] jRParameterArray = jRDataset.getParameters();
        if (jRParameterArray != null && jRParameterArray.length > 0) {
            this.parameters = new JRParameter[jRParameterArray.length];
            for (int i = 0; i < this.parameters.length; ++i) {
                this.parameters[i] = jRBaseObjectFactory.getParameter(jRParameterArray[i]);
            }
        }
        if ((jRFieldArray = jRDataset.getFields()) != null && jRFieldArray.length > 0) {
            this.fields = new JRField[jRFieldArray.length];
            for (int i = 0; i < this.fields.length; ++i) {
                this.fields[i] = jRBaseObjectFactory.getField(jRFieldArray[i]);
            }
        }
        if ((jRVariableArray = jRDataset.getVariables()) != null && jRVariableArray.length > 0) {
            this.variables = new JRVariable[jRVariableArray.length];
            for (int i = 0; i < this.variables.length; ++i) {
                this.variables[i] = jRBaseObjectFactory.getVariable(jRVariableArray[i]);
            }
        }
        if ((jRGroupArray = jRDataset.getGroups()) != null && jRGroupArray.length > 0) {
            this.groups = new JRGroup[jRGroupArray.length];
            for (int i = 0; i < this.groups.length; ++i) {
                this.groups[i] = jRBaseObjectFactory.getGroup(jRGroupArray[i]);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public String getScriptletClass() {
        return this.scriptletClass;
    }

    public JRQuery getQuery() {
        return this.query;
    }

    public JRParameter[] getParameters() {
        return this.parameters;
    }

    public JRField[] getFields() {
        return this.fields;
    }

    public JRVariable[] getVariables() {
        return this.variables;
    }

    public JRGroup[] getGroups() {
        return this.groups;
    }

    public boolean isMainDataset() {
        return this.isMain;
    }

    public String getResourceBundle() {
        return this.resourceBundle;
    }

    public byte getWhenResourceMissingType() {
        return this.whenResourceMissingType;
    }

    public void setWhenResourceMissingType(byte by) {
        this.whenResourceMissingType = by;
    }

    public JRPropertiesMap getPropertiesMap() {
        return this.propertiesMap;
    }
}

