/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.design.JRDefaultCompiler;
import net.sf.jasperreports.engine.design.JRVerifier;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.util.JRSaver;
import net.sf.jasperreports.engine.xml.JRXmlLoader;
import net.sf.jasperreports.engine.xml.JRXmlWriter;

public class JasperCompileManager {
    public static String compileReportToFile(String string) throws JRException {
        File file = new File(string);
        JasperDesign jasperDesign = JRXmlLoader.load(string);
        File file2 = new File(file.getParent(), jasperDesign.getName() + ".jasper");
        String string2 = file2.toString();
        JasperCompileManager.compileReportToFile(jasperDesign, string2);
        return string2;
    }

    public static void compileReportToFile(String string, String string2) throws JRException {
        JasperDesign jasperDesign = JRXmlLoader.load(string);
        JasperCompileManager.compileReportToFile(jasperDesign, string2);
    }

    public static void compileReportToFile(JasperDesign jasperDesign, String string) throws JRException {
        JasperReport jasperReport = JRDefaultCompiler.getInstance().compileReport(jasperDesign);
        JRSaver.saveObject((Object)jasperReport, string);
    }

    public static JasperReport compileReport(String string) throws JRException {
        JasperDesign jasperDesign = JRXmlLoader.load(string);
        return JasperCompileManager.compileReport(jasperDesign);
    }

    public static void compileReportToStream(InputStream inputStream, OutputStream outputStream) throws JRException {
        JasperDesign jasperDesign = JRXmlLoader.load(inputStream);
        JasperCompileManager.compileReportToStream(jasperDesign, outputStream);
    }

    public static void compileReportToStream(JasperDesign jasperDesign, OutputStream outputStream) throws JRException {
        JasperReport jasperReport = JRDefaultCompiler.getInstance().compileReport(jasperDesign);
        JRSaver.saveObject((Object)jasperReport, outputStream);
    }

    public static JasperReport compileReport(InputStream inputStream) throws JRException {
        JasperDesign jasperDesign = JRXmlLoader.load(inputStream);
        return JasperCompileManager.compileReport(jasperDesign);
    }

    public static JasperReport compileReport(JasperDesign jasperDesign) throws JRException {
        return JRDefaultCompiler.getInstance().compileReport(jasperDesign);
    }

    public static Collection verifyDesign(JasperDesign jasperDesign) {
        return JRVerifier.verifyDesign(jasperDesign);
    }

    public static String writeReportToXmlFile(String string) throws JRException {
        File file = new File(string);
        JRReport jRReport = (JRReport)JRLoader.loadObject(file);
        File file2 = new File(file.getParent(), jRReport.getName() + ".jasper.jrxml");
        String string2 = file2.toString();
        JasperCompileManager.writeReportToXmlFile(jRReport, string2);
        return string2;
    }

    public static void writeReportToXmlFile(String string, String string2) throws JRException {
        JRReport jRReport = (JRReport)JRLoader.loadObject(string);
        JasperCompileManager.writeReportToXmlFile(jRReport, string2);
    }

    public static void writeReportToXmlFile(JRReport jRReport, String string) throws JRException {
        JRXmlWriter.writeReport(jRReport, string, "UTF-8");
    }

    public static void writeReportToXmlStream(InputStream inputStream, OutputStream outputStream) throws JRException {
        JRReport jRReport = (JRReport)JRLoader.loadObject(inputStream);
        JasperCompileManager.writeReportToXmlStream(jRReport, outputStream);
    }

    public static void writeReportToXmlStream(JRReport jRReport, OutputStream outputStream) throws JRException {
        JRXmlWriter.writeReport(jRReport, outputStream, "UTF-8");
    }

    public static String writeReportToXml(JRReport jRReport) {
        return JRXmlWriter.writeReport(jRReport, "UTF-8");
    }
}

