/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.util.JRImageLoader;

public class JRResultSetDataSource
implements JRDataSource {
    private ResultSet resultSet = null;
    private Map columnIndexMap = new HashMap();
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$sql$Timestamp;
    static /* synthetic */ Class class$java$sql$Time;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$io$InputStream;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$sql$Clob;
    static /* synthetic */ Class class$java$io$Reader;
    static /* synthetic */ Class class$java$sql$Blob;
    static /* synthetic */ Class class$java$awt$Image;

    public JRResultSetDataSource(ResultSet resultSet) {
        this.resultSet = resultSet;
    }

    public boolean next() throws JRException {
        boolean bl = false;
        if (this.resultSet != null) {
            try {
                bl = this.resultSet.next();
            }
            catch (SQLException sQLException) {
                throw new JRException("Unable to get next record.", sQLException);
            }
        }
        return bl;
    }

    public Object getFieldValue(JRField jRField) throws JRException {
        Object object;
        block42: {
            object = null;
            if (jRField != null && this.resultSet != null) {
                Integer n = this.getColumnIndex(jRField.getName());
                Class clazz = jRField.getValueClass();
                try {
                    if (clazz.equals(class$java$lang$Boolean == null ? (class$java$lang$Boolean = JRResultSetDataSource.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
                        object = this.resultSet.getBoolean(n) ? Boolean.TRUE : Boolean.FALSE;
                        break block42;
                    }
                    if (clazz.equals(class$java$lang$Byte == null ? (class$java$lang$Byte = JRResultSetDataSource.class$("java.lang.Byte")) : class$java$lang$Byte)) {
                        object = new Byte(this.resultSet.getByte(n));
                        if (this.resultSet.wasNull()) {
                            object = null;
                        }
                        break block42;
                    }
                    if (clazz.equals(class$java$util$Date == null ? (class$java$util$Date = JRResultSetDataSource.class$("java.util.Date")) : class$java$util$Date)) {
                        object = this.resultSet.getDate(n);
                        if (this.resultSet.wasNull()) {
                            object = null;
                        }
                        break block42;
                    }
                    if (clazz.equals(class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = JRResultSetDataSource.class$("java.sql.Timestamp")) : class$java$sql$Timestamp)) {
                        object = this.resultSet.getTimestamp(n);
                        if (this.resultSet.wasNull()) {
                            object = null;
                        }
                        break block42;
                    }
                    if (clazz.equals(class$java$sql$Time == null ? (class$java$sql$Time = JRResultSetDataSource.class$("java.sql.Time")) : class$java$sql$Time)) {
                        object = this.resultSet.getTime(n);
                        if (this.resultSet.wasNull()) {
                            object = null;
                        }
                        break block42;
                    }
                    if (clazz.equals(class$java$lang$Double == null ? (class$java$lang$Double = JRResultSetDataSource.class$("java.lang.Double")) : class$java$lang$Double)) {
                        object = new Double(this.resultSet.getDouble(n));
                        if (this.resultSet.wasNull()) {
                            object = null;
                        }
                        break block42;
                    }
                    if (clazz.equals(class$java$lang$Float == null ? (class$java$lang$Float = JRResultSetDataSource.class$("java.lang.Float")) : class$java$lang$Float)) {
                        object = new Float(this.resultSet.getFloat(n));
                        if (this.resultSet.wasNull()) {
                            object = null;
                        }
                        break block42;
                    }
                    if (clazz.equals(class$java$lang$Integer == null ? (class$java$lang$Integer = JRResultSetDataSource.class$("java.lang.Integer")) : class$java$lang$Integer)) {
                        object = new Integer(this.resultSet.getInt(n));
                        if (this.resultSet.wasNull()) {
                            object = null;
                        }
                        break block42;
                    }
                    if (clazz.equals(class$java$io$InputStream == null ? (class$java$io$InputStream = JRResultSetDataSource.class$("java.io.InputStream")) : class$java$io$InputStream)) {
                        byte[] byArray = this.readBytes(n);
                        object = byArray == null ? null : new ByteArrayInputStream(byArray);
                        break block42;
                    }
                    if (clazz.equals(class$java$lang$Long == null ? (class$java$lang$Long = JRResultSetDataSource.class$("java.lang.Long")) : class$java$lang$Long)) {
                        object = new Long(this.resultSet.getLong(n));
                        if (this.resultSet.wasNull()) {
                            object = null;
                        }
                        break block42;
                    }
                    if (clazz.equals(class$java$lang$Short == null ? (class$java$lang$Short = JRResultSetDataSource.class$("java.lang.Short")) : class$java$lang$Short)) {
                        object = new Short(this.resultSet.getShort(n));
                        if (this.resultSet.wasNull()) {
                            object = null;
                        }
                        break block42;
                    }
                    if (clazz.equals(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = JRResultSetDataSource.class$("java.math.BigDecimal")) : class$java$math$BigDecimal)) {
                        object = this.resultSet.getBigDecimal(n);
                        if (this.resultSet.wasNull()) {
                            object = null;
                        }
                        break block42;
                    }
                    if (clazz.equals(class$java$lang$String == null ? (class$java$lang$String = JRResultSetDataSource.class$("java.lang.String")) : class$java$lang$String)) {
                        int n2 = this.resultSet.getMetaData().getColumnType(n);
                        switch (n2) {
                            case 2005: {
                                Clob clob = this.resultSet.getClob(n);
                                if (this.resultSet.wasNull()) {
                                    object = null;
                                    break;
                                }
                                object = this.clobToString(clob);
                                break;
                            }
                            default: {
                                object = this.resultSet.getString(n);
                                if (this.resultSet.wasNull()) {
                                    object = null;
                                    break;
                                } else {
                                    break;
                                }
                            }
                        }
                        break block42;
                    }
                    if (clazz.equals(class$java$sql$Clob == null ? (class$java$sql$Clob = JRResultSetDataSource.class$("java.sql.Clob")) : class$java$sql$Clob)) {
                        object = this.resultSet.getClob(n);
                        if (this.resultSet.wasNull()) {
                            object = null;
                        }
                    } else if (clazz.equals(class$java$io$Reader == null ? (class$java$io$Reader = JRResultSetDataSource.class$("java.io.Reader")) : class$java$io$Reader)) {
                        Reader reader = null;
                        long l = -1L;
                        int n3 = this.resultSet.getMetaData().getColumnType(n);
                        switch (n3) {
                            case 2005: {
                                Clob clob = this.resultSet.getClob(n);
                                if (this.resultSet.wasNull()) break;
                                reader = clob.getCharacterStream();
                                l = clob.length();
                                break;
                            }
                            default: {
                                reader = this.resultSet.getCharacterStream(n);
                                if (!this.resultSet.wasNull()) break;
                                reader = null;
                            }
                        }
                        object = reader == null ? null : this.getArrayReader(reader, l);
                    } else if (clazz.equals(class$java$sql$Blob == null ? (class$java$sql$Blob = JRResultSetDataSource.class$("java.sql.Blob")) : class$java$sql$Blob)) {
                        object = this.resultSet.getBlob(n);
                        if (this.resultSet.wasNull()) {
                            object = null;
                        }
                    } else {
                        byte[] byArray;
                        object = clazz.equals(class$java$awt$Image == null ? (class$java$awt$Image = JRResultSetDataSource.class$("java.awt.Image")) : class$java$awt$Image) ? ((byArray = this.readBytes(n)) == null ? null : JRImageLoader.loadImage(byArray)) : this.resultSet.getObject(n);
                    }
                }
                catch (Exception exception) {
                    throw new JRException("Unable to get value for field '" + jRField.getName() + "' of class '" + clazz.getName() + "'", exception);
                }
            }
        }
        return object;
    }

    private Integer getColumnIndex(String string) throws JRException {
        Integer n = (Integer)this.columnIndexMap.get(string);
        if (n == null) {
            block6: {
                try {
                    ResultSetMetaData resultSetMetaData = this.resultSet.getMetaData();
                    for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
                        if (!string.equalsIgnoreCase(resultSetMetaData.getColumnName(i))) continue;
                        n = new Integer(i);
                        break;
                    }
                    if (n != null) break block6;
                    if (string.startsWith("COLUMN_")) {
                        n = new Integer(string.substring(7));
                        if (n <= 0 || n > this.resultSet.getMetaData().getColumnCount()) {
                            throw new JRException("Column index out of range : " + n);
                        }
                        break block6;
                    }
                    throw new JRException("Unknown column name : " + string);
                }
                catch (SQLException sQLException) {
                    throw new JRException("Unable to retrieve result set metadata.", sQLException);
                }
            }
            this.columnIndexMap.put(string, n);
        }
        return n;
    }

    protected String clobToString(Clob clob) throws JRException {
        try {
            int n = 8192;
            char[] cArray = new char[n];
            BufferedReader bufferedReader = new BufferedReader(clob.getCharacterStream(), n);
            StringBuffer stringBuffer = new StringBuffer((int)clob.length());
            int n2 = bufferedReader.read(cArray);
            while (n2 > 0) {
                stringBuffer.append(cArray, 0, n2);
                n2 = bufferedReader.read(cArray);
            }
            return stringBuffer.toString();
        }
        catch (SQLException sQLException) {
            throw new JRException("Unable to read clob value", sQLException);
        }
        catch (IOException iOException) {
            throw new JRException("Unable to read clob value", iOException);
        }
    }

    protected CharArrayReader getArrayReader(Reader reader, long l) throws IOException {
        char[] cArray = new char[8192];
        CharArrayWriter charArrayWriter = new CharArrayWriter(l > 0L ? (int)l : 8192);
        BufferedReader bufferedReader = new BufferedReader(reader, 8192);
        int n = bufferedReader.read(cArray);
        while (n > 0) {
            charArrayWriter.write(cArray, 0, n);
            n = bufferedReader.read(cArray);
        }
        charArrayWriter.flush();
        return new CharArrayReader(charArrayWriter.toCharArray());
    }

    protected byte[] readBytes(Integer n) throws SQLException, IOException {
        Object object;
        InputStream inputStream = null;
        long l = -1L;
        int n2 = this.resultSet.getMetaData().getColumnType(n);
        switch (n2) {
            case 2004: {
                object = this.resultSet.getBlob(n);
                if (this.resultSet.wasNull()) break;
                inputStream = object.getBinaryStream();
                l = object.length();
                break;
            }
            default: {
                inputStream = this.resultSet.getBinaryStream(n);
                if (!this.resultSet.wasNull()) break;
                inputStream = null;
            }
        }
        object = null;
        if (inputStream != null) {
            object = this.readBytes(inputStream, l);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] readBytes(InputStream inputStream, long l) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(l > 0L ? (int)l : 1000);
        byte[] byArray = new byte[1000];
        int n = 0;
        try {
            while ((n = inputStream.read(byArray)) > 0) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            byteArrayOutputStream.flush();
        }
        finally {
            try {
                byteArrayOutputStream.close();
            }
            catch (IOException iOException) {}
        }
        return byteArrayOutputStream.toByteArray();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

