/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.charts.JRAreaPlot;
import net.sf.jasperreports.charts.JRBar3DPlot;
import net.sf.jasperreports.charts.JRBarPlot;
import net.sf.jasperreports.charts.JRBubblePlot;
import net.sf.jasperreports.charts.JRCandlestickPlot;
import net.sf.jasperreports.charts.JRCategoryDataset;
import net.sf.jasperreports.charts.JRCategorySeries;
import net.sf.jasperreports.charts.JRHighLowDataset;
import net.sf.jasperreports.charts.JRHighLowPlot;
import net.sf.jasperreports.charts.JRLinePlot;
import net.sf.jasperreports.charts.JRPieDataset;
import net.sf.jasperreports.charts.JRScatterPlot;
import net.sf.jasperreports.charts.JRTimePeriodDataset;
import net.sf.jasperreports.charts.JRTimePeriodSeries;
import net.sf.jasperreports.charts.JRTimeSeries;
import net.sf.jasperreports.charts.JRTimeSeriesDataset;
import net.sf.jasperreports.charts.JRTimeSeriesPlot;
import net.sf.jasperreports.charts.JRXyDataset;
import net.sf.jasperreports.charts.JRXySeries;
import net.sf.jasperreports.charts.JRXyzDataset;
import net.sf.jasperreports.charts.JRXyzSeries;
import net.sf.jasperreports.crosstabs.JRCellContents;
import net.sf.jasperreports.crosstabs.JRCrosstab;
import net.sf.jasperreports.crosstabs.JRCrosstabCell;
import net.sf.jasperreports.crosstabs.JRCrosstabColumnGroup;
import net.sf.jasperreports.crosstabs.JRCrosstabDataset;
import net.sf.jasperreports.crosstabs.JRCrosstabMeasure;
import net.sf.jasperreports.crosstabs.JRCrosstabParameter;
import net.sf.jasperreports.crosstabs.JRCrosstabRowGroup;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstab;
import net.sf.jasperreports.engine.JRAnchor;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRChart;
import net.sf.jasperreports.engine.JRConditionalStyle;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRDatasetParameter;
import net.sf.jasperreports.engine.JRDatasetRun;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRElementDataset;
import net.sf.jasperreports.engine.JREllipse;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRFrame;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRHyperlink;
import net.sf.jasperreports.engine.JRImage;
import net.sf.jasperreports.engine.JRLine;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRRectangle;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRStaticText;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRSubreport;
import net.sf.jasperreports.engine.JRSubreportParameter;
import net.sf.jasperreports.engine.JRTextField;
import net.sf.jasperreports.engine.JRVariable;

public class JRExpressionCollector {
    private List expressions = new ArrayList();
    private Map expressionIds = new HashMap();
    private Map crosstabIds = new HashMap();
    private Map datasetCollectors;
    private Map crosstabCollectors;
    private final Set collectedStyles;
    private final Map expressionIdToOwnerNameMap = new HashMap();
    private JRChart chart;

    public JRExpressionCollector() {
        this(true);
    }

    private JRExpressionCollector(boolean bl) {
        if (bl) {
            this.datasetCollectors = new HashMap();
            this.crosstabCollectors = new HashMap();
        }
        this.collectedStyles = new HashSet();
    }

    private void addExpression(JRExpression jRExpression, Object object, String string) {
        if (jRExpression != null && !this.expressionIds.containsKey(jRExpression)) {
            Integer n = new Integer(this.expressions.size());
            this.registerExpressionOwnerAndName(n, object, string);
            this.expressionIds.put(jRExpression, n);
            this.expressions.add(jRExpression);
        }
    }

    private JRExpressionCollector getCollector(JRElementDataset jRElementDataset) {
        JRDatasetRun jRDatasetRun = jRElementDataset.getDatasetRun();
        JRExpressionCollector jRExpressionCollector = jRDatasetRun == null ? this : this.getDatasetCollector(jRDatasetRun.getDatasetName());
        return jRExpressionCollector;
    }

    private JRExpressionCollector getDatasetCollector(String string) {
        JRExpressionCollector jRExpressionCollector = (JRExpressionCollector)this.datasetCollectors.get(string);
        if (jRExpressionCollector == null) {
            jRExpressionCollector = new JRExpressionCollector(false);
            this.datasetCollectors.put(string, jRExpressionCollector);
        }
        return jRExpressionCollector;
    }

    private JRExpressionCollector getCollector(JRDataset jRDataset) {
        JRExpressionCollector jRExpressionCollector = jRDataset.isMainDataset() || this.datasetCollectors == null ? this : this.getDatasetCollector(jRDataset.getName());
        return jRExpressionCollector;
    }

    private JRExpressionCollector getCollector(JRCrosstab jRCrosstab) {
        JRExpressionCollector jRExpressionCollector = (JRExpressionCollector)this.crosstabCollectors.get(jRCrosstab);
        if (jRExpressionCollector == null) {
            jRExpressionCollector = new JRExpressionCollector(false);
            this.crosstabCollectors.put(jRCrosstab, jRExpressionCollector);
        }
        return jRExpressionCollector;
    }

    public List getExpressions() {
        return this.expressions;
    }

    public List getExpressions(JRDataset jRDataset) {
        return this.getCollector(jRDataset).getExpressions();
    }

    public List getExpressions(JRCrosstab jRCrosstab) {
        return this.getCollector(jRCrosstab).getExpressions();
    }

    public Integer getExpressionId(JRExpression jRExpression) {
        return (Integer)this.expressionIds.get(jRExpression);
    }

    public Integer getCrosstabId(JRCrosstab jRCrosstab) {
        return (Integer)this.crosstabIds.get(jRCrosstab);
    }

    private void collectIds() {
        JRExpressionCollector jRExpressionCollector;
        Iterator iterator = this.datasetCollectors.values().iterator();
        while (iterator.hasNext()) {
            jRExpressionCollector = (JRExpressionCollector)iterator.next();
            this.collectIds(jRExpressionCollector);
        }
        iterator = this.crosstabCollectors.values().iterator();
        while (iterator.hasNext()) {
            jRExpressionCollector = (JRExpressionCollector)iterator.next();
            this.collectIds(jRExpressionCollector);
        }
    }

    private void collectIds(JRExpressionCollector jRExpressionCollector) {
        Iterator iterator = jRExpressionCollector.expressionIds.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Object k = entry.getKey();
            if (this.expressionIds.containsKey(k)) {
                throw new JRRuntimeException("Same expression found in different datasets.");
            }
            this.expressionIds.put(k, entry.getValue());
        }
    }

    public Collection collect(JRReport jRReport) {
        this.collect(jRReport.getMainDataset());
        JRDataset[] jRDatasetArray = jRReport.getDatasets();
        if (jRDatasetArray != null && jRDatasetArray.length > 0) {
            for (int i = 0; i < jRDatasetArray.length; ++i) {
                JRExpressionCollector jRExpressionCollector = this.getCollector(jRDatasetArray[i]);
                jRExpressionCollector.collect(jRDatasetArray[i]);
            }
        }
        this.collect(jRReport.getBackground());
        this.collect(jRReport.getTitle());
        this.collect(jRReport.getPageHeader());
        this.collect(jRReport.getColumnHeader());
        this.collect(jRReport.getDetail());
        this.collect(jRReport.getColumnFooter());
        this.collect(jRReport.getPageFooter());
        this.collect(jRReport.getLastPageFooter());
        this.collect(jRReport.getSummary());
        this.collectIds();
        return this.expressions;
    }

    private void collect(JRStyle jRStyle) {
        JRConditionalStyle[] jRConditionalStyleArray;
        if (jRStyle != null && this.collectedStyles.add(jRStyle) && (jRConditionalStyleArray = jRStyle.getConditionalStyles()) != null && jRConditionalStyleArray.length > 0) {
            for (int i = 0; i < jRConditionalStyleArray.length; ++i) {
                this.addExpression(jRConditionalStyleArray[i].getConditionExpression(), jRConditionalStyleArray[i], "Condition");
            }
        }
    }

    private void collect(JRParameter[] jRParameterArray) {
        if (jRParameterArray != null && jRParameterArray.length > 0) {
            for (int i = 0; i < jRParameterArray.length; ++i) {
                this.addExpression(jRParameterArray[i].getDefaultValueExpression(), jRParameterArray[i], "Default Value");
            }
        }
    }

    private void collect(JRVariable[] jRVariableArray) {
        if (jRVariableArray != null && jRVariableArray.length > 0) {
            for (int i = 0; i < jRVariableArray.length; ++i) {
                JRVariable jRVariable = jRVariableArray[i];
                this.addExpression(jRVariable.getExpression(), jRVariable, "Expression");
                this.addExpression(jRVariable.getInitialValueExpression(), jRVariable, "Initial Value");
            }
        }
    }

    private void collect(JRGroup[] jRGroupArray) {
        if (jRGroupArray != null && jRGroupArray.length > 0) {
            for (int i = 0; i < jRGroupArray.length; ++i) {
                JRGroup jRGroup = jRGroupArray[i];
                this.addExpression(jRGroup.getExpression(), jRGroup, "Expression");
                this.collect(jRGroup.getGroupHeader());
                this.collect(jRGroup.getGroupFooter());
            }
        }
    }

    private void collect(JRBand jRBand) {
        if (jRBand != null) {
            this.addExpression(jRBand.getPrintWhenExpression(), jRBand, "Print When");
            JRElement[] jRElementArray = jRBand.getElements();
            if (jRElementArray != null && jRElementArray.length > 0) {
                for (int i = 0; i < jRElementArray.length; ++i) {
                    jRElementArray[i].collectExpressions(this);
                }
            }
        }
    }

    private void collectElement(JRElement jRElement) {
        this.collect(jRElement.getStyle());
        this.addExpression(jRElement.getPrintWhenExpression(), jRElement, "Print When");
    }

    private void collectAnchor(JRAnchor jRAnchor) {
        this.addExpression(jRAnchor.getAnchorNameExpression(), jRAnchor, "Anchor Name");
    }

    private void collectHyperlink(JRHyperlink jRHyperlink) {
        this.addExpression(jRHyperlink.getHyperlinkReferenceExpression(), jRHyperlink, "Hyperlink Reference");
        this.addExpression(jRHyperlink.getHyperlinkAnchorExpression(), jRHyperlink, "Hyperlink Anchor");
        this.addExpression(jRHyperlink.getHyperlinkPageExpression(), jRHyperlink, "Hyperlink Page");
    }

    public void collect(JRLine jRLine) {
        this.collectElement(jRLine);
    }

    public void collect(JRRectangle jRRectangle) {
        this.collectElement(jRRectangle);
    }

    public void collect(JREllipse jREllipse) {
        this.collectElement(jREllipse);
    }

    public void collect(JRImage jRImage) {
        this.collectElement(jRImage);
        this.addExpression(jRImage.getExpression(), jRImage, "Expression");
        this.collectAnchor(jRImage);
        this.collectHyperlink(jRImage);
    }

    public void collect(JRStaticText jRStaticText) {
        this.collectElement(jRStaticText);
    }

    public void collect(JRTextField jRTextField) {
        this.collectElement(jRTextField);
        this.addExpression(jRTextField.getExpression(), jRTextField, "Expression");
        this.collectAnchor(jRTextField);
        this.collectHyperlink(jRTextField);
    }

    public void collect(JRSubreport jRSubreport) {
        this.collectElement(jRSubreport);
        this.addExpression(jRSubreport.getParametersMapExpression(), jRSubreport, "Parameters Map");
        JRSubreportParameter[] jRSubreportParameterArray = jRSubreport.getParameters();
        if (jRSubreportParameterArray != null && jRSubreportParameterArray.length > 0) {
            for (int i = 0; i < jRSubreportParameterArray.length; ++i) {
                this.addExpression(jRSubreportParameterArray[i].getExpression(), jRSubreportParameterArray[i], "Expression");
            }
        }
        this.addExpression(jRSubreport.getConnectionExpression(), jRSubreport, "Connection");
        this.addExpression(jRSubreport.getDataSourceExpression(), jRSubreport, "Data Source");
        this.addExpression(jRSubreport.getExpression(), jRSubreport, "Expression");
    }

    public void collect(JRChart jRChart) {
        this.collectElement(jRChart);
        this.collectAnchor(jRChart);
        this.collectHyperlink(jRChart);
        this.addExpression(jRChart.getTitleExpression(), jRChart, "Title");
        this.addExpression(jRChart.getSubtitleExpression(), jRChart, "Subtitle");
        jRChart.getDataset().collectExpressions(this);
        this.chart = jRChart;
        jRChart.getPlot().collectExpressions(this);
        this.chart = null;
    }

    public void collect(JRPieDataset jRPieDataset) {
        this.collect((JRElementDataset)jRPieDataset);
        JRExpressionCollector jRExpressionCollector = this.getCollector(jRPieDataset);
        jRExpressionCollector.addExpression(jRPieDataset.getKeyExpression(), jRPieDataset, "Key");
        jRExpressionCollector.addExpression(jRPieDataset.getValueExpression(), jRPieDataset, "Value");
        jRExpressionCollector.addExpression(jRPieDataset.getLabelExpression(), jRPieDataset, "Label");
    }

    public void collect(JRCategoryDataset jRCategoryDataset) {
        this.collect((JRElementDataset)jRCategoryDataset);
        JRCategorySeries[] jRCategorySeriesArray = jRCategoryDataset.getSeries();
        if (jRCategorySeriesArray != null && jRCategorySeriesArray.length > 0) {
            JRExpressionCollector jRExpressionCollector = this.getCollector(jRCategoryDataset);
            for (int i = 0; i < jRCategorySeriesArray.length; ++i) {
                jRExpressionCollector.collect(jRCategorySeriesArray[i]);
            }
        }
    }

    public void collect(JRXyDataset jRXyDataset) {
        this.collect((JRElementDataset)jRXyDataset);
        JRXySeries[] jRXySeriesArray = jRXyDataset.getSeries();
        if (jRXySeriesArray != null && jRXySeriesArray.length > 0) {
            JRExpressionCollector jRExpressionCollector = this.getCollector(jRXyDataset);
            for (int i = 0; i < jRXySeriesArray.length; ++i) {
                jRExpressionCollector.collect(jRXySeriesArray[i]);
            }
        }
    }

    public void collect(JRTimeSeriesDataset jRTimeSeriesDataset) {
        this.collect((JRElementDataset)jRTimeSeriesDataset);
        JRTimeSeries[] jRTimeSeriesArray = jRTimeSeriesDataset.getSeries();
        if (jRTimeSeriesArray != null && jRTimeSeriesArray.length > 0) {
            JRExpressionCollector jRExpressionCollector = this.getCollector(jRTimeSeriesDataset);
            for (int i = 0; i < jRTimeSeriesArray.length; ++i) {
                jRExpressionCollector.collect(jRTimeSeriesArray[i]);
            }
        }
    }

    public void collect(JRTimePeriodDataset jRTimePeriodDataset) {
        this.collect((JRElementDataset)jRTimePeriodDataset);
        JRTimePeriodSeries[] jRTimePeriodSeriesArray = jRTimePeriodDataset.getSeries();
        if (jRTimePeriodSeriesArray != null && jRTimePeriodSeriesArray.length > 0) {
            JRExpressionCollector jRExpressionCollector = this.getCollector(jRTimePeriodDataset);
            for (int i = 0; i < jRTimePeriodSeriesArray.length; ++i) {
                jRExpressionCollector.collect(jRTimePeriodSeriesArray[i]);
            }
        }
    }

    private void collect(JRXySeries jRXySeries) {
        this.addExpression(jRXySeries.getSeriesExpression(), jRXySeries, "Series");
        this.addExpression(jRXySeries.getXValueExpression(), jRXySeries, "X Value");
        this.addExpression(jRXySeries.getYValueExpression(), jRXySeries, "Y Value");
        this.addExpression(jRXySeries.getLabelExpression(), jRXySeries, "Label");
    }

    private void collect(JRCategorySeries jRCategorySeries) {
        this.addExpression(jRCategorySeries.getSeriesExpression(), jRCategorySeries, "Series");
        this.addExpression(jRCategorySeries.getCategoryExpression(), jRCategorySeries, "Category");
        this.addExpression(jRCategorySeries.getValueExpression(), jRCategorySeries, "Value");
        this.addExpression(jRCategorySeries.getLabelExpression(), jRCategorySeries, "Label");
    }

    public void collect(JRBarPlot jRBarPlot) {
        this.addExpression(jRBarPlot.getCategoryAxisLabelExpression(), this.chart, "Category Axis Label");
        this.addExpression(jRBarPlot.getValueAxisLabelExpression(), this.chart, "Value Axis Label");
    }

    public void collect(JRBar3DPlot jRBar3DPlot) {
        this.addExpression(jRBar3DPlot.getCategoryAxisLabelExpression(), this.chart, "Category Axis Label");
        this.addExpression(jRBar3DPlot.getValueAxisLabelExpression(), this.chart, "Value Axis Label");
    }

    public void collect(JRLinePlot jRLinePlot) {
        this.addExpression(jRLinePlot.getCategoryAxisLabelExpression(), this.chart, "Category Axis Label");
        this.addExpression(jRLinePlot.getValueAxisLabelExpression(), this.chart, "Value Axis Label");
    }

    public void collect(JRTimeSeriesPlot jRTimeSeriesPlot) {
        this.addExpression(jRTimeSeriesPlot.getTimeAxisLabelExpression(), this.chart, "Time Axis Label");
        this.addExpression(jRTimeSeriesPlot.getValueAxisLabelExpression(), this.chart, "Value Axis Label");
    }

    public void collect(JRScatterPlot jRScatterPlot) {
        this.addExpression(jRScatterPlot.getXAxisLabelExpression(), this.chart, "X Axis Label");
        this.addExpression(jRScatterPlot.getYAxisLabelExpression(), this.chart, "Y Axis Label");
    }

    public void collect(JRAreaPlot jRAreaPlot) {
        this.addExpression(jRAreaPlot.getCategoryAxisLabelExpression(), this.chart, "Category Axis Label");
        this.addExpression(jRAreaPlot.getValueAxisLabelExpression(), this.chart, "Value Axis Label");
    }

    private void collect(JRTimeSeries jRTimeSeries) {
        this.addExpression(jRTimeSeries.getSeriesExpression(), jRTimeSeries, "Series");
        this.addExpression(jRTimeSeries.getTimePeriodExpression(), jRTimeSeries, "Time Period");
        this.addExpression(jRTimeSeries.getValueExpression(), jRTimeSeries, "Value");
        this.addExpression(jRTimeSeries.getLabelExpression(), jRTimeSeries, "Label");
    }

    private void collect(JRTimePeriodSeries jRTimePeriodSeries) {
        this.addExpression(jRTimePeriodSeries.getSeriesExpression(), jRTimePeriodSeries, "Series");
        this.addExpression(jRTimePeriodSeries.getStartDateExpression(), jRTimePeriodSeries, "Start Date");
        this.addExpression(jRTimePeriodSeries.getEndDateExpression(), jRTimePeriodSeries, "End Date");
        this.addExpression(jRTimePeriodSeries.getValueExpression(), jRTimePeriodSeries, "Value");
        this.addExpression(jRTimePeriodSeries.getLabelExpression(), jRTimePeriodSeries, "Label");
    }

    public void collect(JRXyzDataset jRXyzDataset) {
        this.collect((JRElementDataset)jRXyzDataset);
        JRXyzSeries[] jRXyzSeriesArray = jRXyzDataset.getSeries();
        if (jRXyzSeriesArray != null && jRXyzSeriesArray.length > 0) {
            JRExpressionCollector jRExpressionCollector = this.getCollector(jRXyzDataset);
            for (int i = 0; i < jRXyzSeriesArray.length; ++i) {
                jRExpressionCollector.collect(jRXyzSeriesArray[i]);
            }
        }
    }

    private void collect(JRXyzSeries jRXyzSeries) {
        this.addExpression(jRXyzSeries.getSeriesExpression(), jRXyzSeries, "Series");
        this.addExpression(jRXyzSeries.getXValueExpression(), jRXyzSeries, "X Value");
        this.addExpression(jRXyzSeries.getYValueExpression(), jRXyzSeries, "Y Value");
        this.addExpression(jRXyzSeries.getZValueExpression(), jRXyzSeries, "Z Value");
    }

    public void collect(JRBubblePlot jRBubblePlot) {
        this.addExpression(jRBubblePlot.getXAxisLabelExpression(), this.chart, "X Axis Label");
        this.addExpression(jRBubblePlot.getYAxisLabelExpression(), this.chart, "Y Axis Label");
    }

    public void collect(JRHighLowPlot jRHighLowPlot) {
        this.addExpression(jRHighLowPlot.getTimeAxisLabelExpression(), this.chart, "Time Axis Label");
        this.addExpression(jRHighLowPlot.getValueAxisLabelExpression(), this.chart, "Value Axis Label");
    }

    public void collect(JRHighLowDataset jRHighLowDataset) {
        this.collect((JRElementDataset)jRHighLowDataset);
        JRExpressionCollector jRExpressionCollector = this.getCollector(jRHighLowDataset);
        jRExpressionCollector.addExpression(jRHighLowDataset.getSeriesExpression(), jRHighLowDataset, "Series");
        jRExpressionCollector.addExpression(jRHighLowDataset.getDateExpression(), jRHighLowDataset, "Date");
        jRExpressionCollector.addExpression(jRHighLowDataset.getHighExpression(), jRHighLowDataset, "High");
        jRExpressionCollector.addExpression(jRHighLowDataset.getLowExpression(), jRHighLowDataset, "Low");
        jRExpressionCollector.addExpression(jRHighLowDataset.getOpenExpression(), jRHighLowDataset, "Open");
        jRExpressionCollector.addExpression(jRHighLowDataset.getCloseExpression(), jRHighLowDataset, "Close");
        jRExpressionCollector.addExpression(jRHighLowDataset.getVolumeExpression(), jRHighLowDataset, "Volume");
    }

    public void collect(JRCandlestickPlot jRCandlestickPlot) {
        this.addExpression(jRCandlestickPlot.getTimeAxisLabelExpression(), this.chart, "Time Axis Label");
        this.addExpression(jRCandlestickPlot.getValueAxisLabelExpression(), this.chart, "Value Axis Label");
    }

    public void collect(JRCrosstab jRCrosstab) {
        JRCrosstabMeasure[] jRCrosstabMeasureArray;
        JRCrosstabColumnGroup[] jRCrosstabColumnGroupArray;
        Object object;
        this.collectElement(jRCrosstab);
        this.createCrosstabId(jRCrosstab);
        JRCrosstabDataset jRCrosstabDataset = jRCrosstab.getDataset();
        this.collect(jRCrosstabDataset);
        JRExpressionCollector jRExpressionCollector = this.getCollector(jRCrosstabDataset);
        JRExpressionCollector jRExpressionCollector2 = this.getCollector(jRCrosstab);
        this.addExpression(jRCrosstab.getParametersMapExpression(), jRCrosstab, "Parameters Map");
        JRCrosstabParameter[] jRCrosstabParameterArray = jRCrosstab.getParameters();
        if (jRCrosstabParameterArray != null) {
            for (int i = 0; i < jRCrosstabParameterArray.length; ++i) {
                this.addExpression(jRCrosstabParameterArray[i].getExpression(), jRCrosstabDataset, "Expression");
            }
        }
        jRExpressionCollector2.collect(jRCrosstab.getHeaderCell());
        JRCrosstabRowGroup[] jRCrosstabRowGroupArray = jRCrosstab.getRowGroups();
        if (jRCrosstabRowGroupArray != null) {
            for (int i = 0; i < jRCrosstabRowGroupArray.length; ++i) {
                JRCrosstabRowGroup jRCrosstabRowGroup = jRCrosstabRowGroupArray[i];
                object = jRCrosstabRowGroup.getBucket();
                jRExpressionCollector.addExpression(object.getExpression(), jRCrosstabRowGroup, "Expression");
                this.addExpression(object.getComparatorExpression(), jRCrosstabRowGroup, "Comparator");
                jRExpressionCollector2.collect(jRCrosstabRowGroup.getHeader());
                jRExpressionCollector2.collect(jRCrosstabRowGroup.getTotalHeader());
            }
        }
        if ((jRCrosstabColumnGroupArray = jRCrosstab.getColumnGroups()) != null) {
            for (int i = 0; i < jRCrosstabColumnGroupArray.length; ++i) {
                object = jRCrosstabColumnGroupArray[i];
                jRExpressionCollector.addExpression(object.getBucket().getExpression(), object, "Expression");
                this.addExpression(object.getBucket().getComparatorExpression(), object, "Comparator");
                jRExpressionCollector2.collect(object.getHeader());
                jRExpressionCollector2.collect(object.getTotalHeader());
            }
        }
        if ((jRCrosstabMeasureArray = jRCrosstab.getMeasures()) != null) {
            for (int i = 0; i < jRCrosstabMeasureArray.length; ++i) {
                jRExpressionCollector.addExpression(jRCrosstabMeasureArray[i].getValueExpression(), jRCrosstabMeasureArray[i], "Value");
            }
        }
        jRExpressionCollector2.collect(jRCrosstab.getWhenNoDataCell());
        this.collectCrosstabCells(jRCrosstab, jRExpressionCollector2);
    }

    private void createCrosstabId(JRCrosstab jRCrosstab) {
        this.crosstabIds.put(jRCrosstab, new Integer(this.crosstabIds.size()));
    }

    private void collectCrosstabCells(JRCrosstab jRCrosstab, JRExpressionCollector jRExpressionCollector) {
        block5: {
            block4: {
                if (!(jRCrosstab instanceof JRDesignCrosstab)) break block4;
                List list = ((JRDesignCrosstab)jRCrosstab).getCellsList();
                if (list == null) break block5;
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    JRCrosstabCell jRCrosstabCell = (JRCrosstabCell)iterator.next();
                    jRExpressionCollector.collect(jRCrosstabCell.getContents());
                }
                break block5;
            }
            JRCrosstabCell[][] jRCrosstabCellArray = jRCrosstab.getCells();
            if (jRCrosstabCellArray != null) {
                for (int i = 0; i < jRCrosstabCellArray.length; ++i) {
                    for (int j = 0; j < jRCrosstabCellArray[i].length; ++j) {
                        if (jRCrosstabCellArray[i][j] == null) continue;
                        jRExpressionCollector.collect(jRCrosstabCellArray[i][j].getContents());
                    }
                }
            }
        }
    }

    public Collection collect(JRDataset jRDataset) {
        JRExpressionCollector jRExpressionCollector = this.getCollector(jRDataset);
        jRExpressionCollector.collect(jRDataset.getParameters());
        jRExpressionCollector.collect(jRDataset.getVariables());
        jRExpressionCollector.collect(jRDataset.getGroups());
        return this.expressions;
    }

    protected void collect(JRElementDataset jRElementDataset) {
        this.collect(jRElementDataset, jRElementDataset.getDatasetRun());
    }

    private void collect(JRElementDataset jRElementDataset, JRDatasetRun jRDatasetRun) {
        if (jRDatasetRun != null) {
            this.addExpression(jRDatasetRun.getParametersMapExpression(), jRElementDataset, "Parameters Map");
            this.addExpression(jRDatasetRun.getConnectionExpression(), jRElementDataset, "Connection");
            this.addExpression(jRDatasetRun.getDataSourceExpression(), jRElementDataset, "Data Source");
            JRDatasetParameter[] jRDatasetParameterArray = jRDatasetRun.getParameters();
            if (jRDatasetParameterArray != null && jRDatasetParameterArray.length > 0) {
                for (int i = 0; i < jRDatasetParameterArray.length; ++i) {
                    this.addExpression(jRDatasetParameterArray[i].getExpression(), jRElementDataset, jRDatasetParameterArray[i].getName());
                }
            }
        }
    }

    protected void collect(JRCellContents jRCellContents) {
        if (jRCellContents != null) {
            this.collect(jRCellContents.getStyle());
            JRElement[] jRElementArray = jRCellContents.getElements();
            if (jRElementArray != null && jRElementArray.length > 0) {
                for (int i = 0; i < jRElementArray.length; ++i) {
                    jRElementArray[i].collectExpressions(this);
                }
            }
        }
    }

    public void collect(JRFrame jRFrame) {
        this.collectElement(jRFrame);
        JRElement[] jRElementArray = jRFrame.getElements();
        if (jRElementArray != null) {
            for (int i = 0; i < jRElementArray.length; ++i) {
                jRElementArray[i].collectExpressions(this);
            }
        }
    }

    private void registerExpressionOwnerAndName(Integer n, Object object, String string) {
        if (!string.endsWith("Expression")) {
            string = string + " Expression";
        }
        this.expressionIdToOwnerNameMap.put(n, new Object[]{object, string});
    }

    public Object getExpressionOwner(int n) {
        return ((Object[])this.expressionIdToOwnerNameMap.get(new Integer(n)))[0];
    }

    public String getExpressionName(int n) {
        return (String)((Object[])this.expressionIdToOwnerNameMap.get(new Integer(n)))[1];
    }

    public JRExpressionCollector getDatasetExpressionCollector(JRDataset jRDataset) {
        String string = jRDataset.getName();
        Iterator iterator = this.datasetCollectors.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string2 = (String)entry.getKey();
            if (!string2.equals(string)) continue;
            return (JRExpressionCollector)entry.getValue();
        }
        throw new JRRuntimeException("No expression collector for dataset: " + string);
    }

    public JRExpressionCollector getCrosstabExpressionCollector(JRCrosstab jRCrosstab) {
        JRExpressionCollector jRExpressionCollector = (JRExpressionCollector)this.crosstabCollectors.get(jRCrosstab);
        if (jRExpressionCollector == null) {
            throw new JRRuntimeException("No expression collector for crosstab: " + this.getCrosstabId(jRCrosstab));
        }
        return jRExpressionCollector;
    }
}

