/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine;

import java.awt.Color;
import java.awt.font.TextAttribute;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.net.URLStreamHandlerFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRBox;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporter;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintGraphicElement;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.base.JRBaseBox;
import net.sf.jasperreports.engine.base.JRBaseFont;
import net.sf.jasperreports.engine.util.JRFontUtil;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.util.JRResourcesUtil;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.engine.util.JRStyledTextParser;
import org.xml.sax.SAXException;

public abstract class JRAbstractExporter
implements JRExporter {
    protected Map parameters = new HashMap();
    protected List jasperPrintList = null;
    protected JasperPrint jasperPrint = null;
    protected boolean isModeBatch = true;
    protected int startPageIndex = 0;
    protected int endPageIndex = 0;
    protected int globalOffsetX = 0;
    protected int globalOffsetY = 0;
    protected ClassLoader classLoader = null;
    protected boolean classLoaderSet;
    protected URLStreamHandlerFactory urlHandlerFactory;
    protected boolean urlHandlerFactorySet;
    protected JRFont defaultFont = null;
    private LinkedList elementOffsetStack;
    private int elementOffsetX;
    private int elementOffsetY;
    private Map penBoxes;
    protected JRStyledTextParser styledTextParser = new JRStyledTextParser();

    protected JRAbstractExporter() {
        this.elementOffsetStack = new LinkedList();
        this.elementOffsetX = this.globalOffsetX;
        this.elementOffsetY = this.globalOffsetY;
        this.penBoxes = new HashMap();
    }

    public void setParameter(JRExporterParameter jRExporterParameter, Object object) {
        this.parameters.put(jRExporterParameter, object);
    }

    public Object getParameter(JRExporterParameter jRExporterParameter) {
        return this.parameters.get(jRExporterParameter);
    }

    public void setParameters(Map map) {
        this.parameters = map;
    }

    public Map getParameters() {
        return this.parameters;
    }

    public abstract void exportReport() throws JRException;

    protected void setOffset() {
        Integer n;
        Integer n2 = (Integer)this.parameters.get(JRExporterParameter.OFFSET_X);
        if (n2 != null) {
            this.globalOffsetX = n2;
        }
        if ((n = (Integer)this.parameters.get(JRExporterParameter.OFFSET_Y)) != null) {
            this.globalOffsetY = n;
        }
        this.elementOffsetX = this.globalOffsetX;
        this.elementOffsetY = this.globalOffsetY;
    }

    protected void setExportContext() {
        this.classLoaderSet = false;
        this.urlHandlerFactorySet = false;
        this.classLoader = (ClassLoader)this.parameters.get(JRExporterParameter.CLASS_LOADER);
        if (this.classLoader != null) {
            JRResourcesUtil.setThreadClassLoader(this.classLoader);
            this.classLoaderSet = true;
        }
        this.urlHandlerFactory = (URLStreamHandlerFactory)this.parameters.get(JRExporterParameter.URL_HANDLER_FACTORY);
        if (this.urlHandlerFactory != null) {
            JRResourcesUtil.setThreadURLHandlerFactory(this.urlHandlerFactory);
            this.urlHandlerFactorySet = true;
        }
    }

    protected void resetExportContext() {
        if (this.classLoaderSet) {
            JRResourcesUtil.resetClassLoader();
        }
        if (this.urlHandlerFactorySet) {
            JRResourcesUtil.resetThreadURLHandlerFactory();
        }
    }

    protected void setClassLoader() {
        this.setExportContext();
    }

    protected void resetClassLoader() {
        this.resetExportContext();
    }

    protected void setInput() throws JRException {
        this.jasperPrintList = (List)this.parameters.get(JRExporterParameter.JASPER_PRINT_LIST);
        if (this.jasperPrintList == null) {
            this.isModeBatch = false;
            this.jasperPrint = (JasperPrint)this.parameters.get(JRExporterParameter.JASPER_PRINT);
            if (this.jasperPrint == null) {
                InputStream inputStream = (InputStream)this.parameters.get(JRExporterParameter.INPUT_STREAM);
                if (inputStream != null) {
                    this.jasperPrint = (JasperPrint)JRLoader.loadObject(inputStream);
                } else {
                    URL uRL = (URL)this.parameters.get(JRExporterParameter.INPUT_URL);
                    if (uRL != null) {
                        this.jasperPrint = (JasperPrint)JRLoader.loadObject(uRL);
                    } else {
                        File file = (File)this.parameters.get(JRExporterParameter.INPUT_FILE);
                        if (file != null) {
                            this.jasperPrint = (JasperPrint)JRLoader.loadObject(file);
                        } else {
                            String string = (String)this.parameters.get(JRExporterParameter.INPUT_FILE_NAME);
                            if (string != null) {
                                this.jasperPrint = (JasperPrint)JRLoader.loadObject(string);
                            } else {
                                throw new JRException("No input source supplied to the exporter.");
                            }
                        }
                    }
                }
            }
            this.jasperPrintList = new ArrayList();
            this.jasperPrintList.add(this.jasperPrint);
        } else {
            this.isModeBatch = true;
            if (this.jasperPrintList.size() == 0) {
                throw new JRException("Empty input source supplied to the exporter in batch mode.");
            }
            this.jasperPrint = (JasperPrint)this.jasperPrintList.get(0);
        }
    }

    protected void setPageRange() throws JRException {
        Integer n;
        int n2 = -1;
        if (this.jasperPrint.getPages() != null) {
            n2 = this.jasperPrint.getPages().size() - 1;
        }
        if ((n = (Integer)this.parameters.get(JRExporterParameter.START_PAGE_INDEX)) == null) {
            this.startPageIndex = 0;
        } else {
            this.startPageIndex = n;
            if (this.startPageIndex < 0 || this.startPageIndex > n2) {
                throw new JRException("Start page index out of range : " + this.startPageIndex + " of " + n2);
            }
        }
        Integer n3 = (Integer)this.parameters.get(JRExporterParameter.END_PAGE_INDEX);
        if (n3 == null) {
            this.endPageIndex = n2;
        } else {
            this.endPageIndex = n3;
            if (this.endPageIndex < 0 || this.endPageIndex > n2) {
                throw new JRException("End page index out of range : " + this.endPageIndex + " of " + n2);
            }
        }
        Integer n4 = (Integer)this.parameters.get(JRExporterParameter.PAGE_INDEX);
        if (n4 != null) {
            int n5 = n4;
            if (n5 < 0 || n5 > n2) {
                throw new JRException("Page index out of range : " + n5 + " of " + n2);
            }
            this.startPageIndex = n5;
            this.endPageIndex = n5;
        }
    }

    protected JRFont getDefaultFont() {
        if (this.defaultFont == null) {
            this.defaultFont = this.jasperPrint.getDefaultFont();
            if (this.defaultFont == null) {
                this.defaultFont = new JRBaseFont();
            }
        }
        return this.defaultFont;
    }

    protected JRStyledText getStyledText(JRPrintText jRPrintText, boolean bl) {
        JRStyledText jRStyledText = null;
        String string = jRPrintText.getText();
        if (string != null) {
            HashMap<TextAttribute, Color> hashMap = new HashMap<TextAttribute, Color>();
            hashMap.putAll(JRFontUtil.setAttributes(hashMap, jRPrintText));
            hashMap.put(TextAttribute.FOREGROUND, jRPrintText.getForecolor());
            if (bl && jRPrintText.getMode() == 1) {
                hashMap.put(TextAttribute.BACKGROUND, jRPrintText.getBackcolor());
            }
            if (jRPrintText.isStyledText()) {
                try {
                    jRStyledText = this.styledTextParser.parse(hashMap, string);
                }
                catch (SAXException sAXException) {
                    // empty catch block
                }
            }
            if (jRStyledText == null) {
                jRStyledText = new JRStyledText();
                jRStyledText.append(string);
                jRStyledText.addRun(new JRStyledText.Run(hashMap, 0, string.length()));
            }
        }
        return jRStyledText;
    }

    protected JRStyledText getStyledText(JRPrintText jRPrintText) {
        return this.getStyledText(jRPrintText, true);
    }

    protected void setOutput() {
    }

    protected int getOffsetX() {
        return this.elementOffsetX;
    }

    protected int getOffsetY() {
        return this.elementOffsetY;
    }

    protected void setFrameElementsOffset(JRPrintFrame jRPrintFrame, boolean bl) {
        if (bl) {
            this.setElementOffsets(0, 0);
        } else {
            int n = jRPrintFrame.getTopPadding();
            int n2 = jRPrintFrame.getLeftPadding();
            this.setElementOffsets(this.getOffsetX() + jRPrintFrame.getX() + n2, this.getOffsetY() + jRPrintFrame.getY() + n);
        }
    }

    private void setElementOffsets(int n, int n2) {
        this.elementOffsetStack.addLast(new int[]{this.elementOffsetX, this.elementOffsetY});
        this.elementOffsetX = n;
        this.elementOffsetY = n2;
    }

    protected void restoreElementOffsets() {
        int[] nArray = (int[])this.elementOffsetStack.removeLast();
        this.elementOffsetX = nArray[0];
        this.elementOffsetY = nArray[1];
    }

    protected JRBox getBox(JRPrintGraphicElement jRPrintGraphicElement) {
        byte by = jRPrintGraphicElement.getPen();
        Byte by2 = new Byte(by);
        JRBox jRBox = (JRBox)this.penBoxes.get(by2);
        if (jRBox == null) {
            jRBox = new JRBaseBox(by, jRPrintGraphicElement.getForecolor());
            this.penBoxes.put(by2, jRBox);
        }
        return jRBox;
    }
}

