/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.compilers;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionChunk;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.design.JRSourceCompileTask;
import net.sf.jasperreports.engine.util.JRStringUtil;

public class JRGroovyGenerator {
    private static final int EXPR_MAX_COUNT_PER_METHOD = 100;
    private static Map fieldPrefixMap = null;
    private static Map variablePrefixMap = null;
    private static Map methodSuffixMap = null;
    protected final JRSourceCompileTask sourceTask;
    protected Map parametersMap;
    protected Map fieldsMap;
    protected Map variablesMap;
    protected JRVariable[] variables;

    protected JRGroovyGenerator(JRSourceCompileTask jRSourceCompileTask) {
        this.sourceTask = jRSourceCompileTask;
        this.parametersMap = jRSourceCompileTask.getParametersMap();
        this.fieldsMap = jRSourceCompileTask.getFieldsMap();
        this.variablesMap = jRSourceCompileTask.getVariablesMap();
        this.variables = jRSourceCompileTask.getVariables();
    }

    public static String generateClass(JRSourceCompileTask jRSourceCompileTask) throws JRException {
        JRGroovyGenerator jRGroovyGenerator = new JRGroovyGenerator(jRSourceCompileTask);
        return jRGroovyGenerator.generateClass();
    }

    protected String generateClass() throws JRException {
        StringBuffer stringBuffer = new StringBuffer();
        this.generateClassStart(stringBuffer);
        this.generateDeclarations(stringBuffer);
        this.generateInitMethod(stringBuffer);
        this.generateInitParamsMethod(stringBuffer);
        if (this.fieldsMap != null) {
            this.generateInitFieldsMethod(stringBuffer);
        }
        this.generateInitVarsMethod(stringBuffer);
        List list = this.sourceTask.getExpressions();
        stringBuffer.append(this.generateMethod((byte)3, list));
        if (this.sourceTask.isOnlyDefaultEvaluation()) {
            ArrayList arrayList = new ArrayList();
            stringBuffer.append(this.generateMethod((byte)1, arrayList));
            stringBuffer.append(this.generateMethod((byte)2, arrayList));
        } else {
            stringBuffer.append(this.generateMethod((byte)1, list));
            stringBuffer.append(this.generateMethod((byte)2, list));
        }
        stringBuffer.append("}\n");
        return stringBuffer.toString();
    }

    private void generateInitMethod(StringBuffer stringBuffer) {
        stringBuffer.append("\n");
        stringBuffer.append("\n");
        stringBuffer.append("    /**\n");
        stringBuffer.append("     *\n");
        stringBuffer.append("     */\n");
        stringBuffer.append("    void customizedInit(\n");
        stringBuffer.append("        Map pm,\n");
        stringBuffer.append("        Map fm,\n");
        stringBuffer.append("        Map vm\n");
        stringBuffer.append("        )\n");
        stringBuffer.append("    {\n");
        stringBuffer.append("        initParams(pm);\n");
        if (this.fieldsMap != null) {
            stringBuffer.append("        initFields(fm);\n");
        }
        stringBuffer.append("        initVars(vm);\n");
        stringBuffer.append("    }\n");
        stringBuffer.append("\n");
        stringBuffer.append("\n");
    }

    protected final void generateClassStart(StringBuffer stringBuffer) {
        stringBuffer.append("/*\n");
        stringBuffer.append(" * Generated by JasperReports - ");
        stringBuffer.append(new SimpleDateFormat().format(new Date()));
        stringBuffer.append("\n");
        stringBuffer.append(" */\n");
        stringBuffer.append("import net.sf.jasperreports.engine.*;\n");
        stringBuffer.append("import net.sf.jasperreports.engine.fill.*;\n");
        stringBuffer.append("\n");
        stringBuffer.append("import java.util.*;\n");
        stringBuffer.append("import java.math.*;\n");
        stringBuffer.append("import java.text.*;\n");
        stringBuffer.append("import java.io.*;\n");
        stringBuffer.append("import java.net.*;\n");
        stringBuffer.append("\n");
        String[] stringArray = this.sourceTask.getImports();
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuffer.append("import ");
                stringBuffer.append(stringArray[i]);
                stringBuffer.append(";\n");
            }
        }
        stringBuffer.append("\n");
        stringBuffer.append("\n");
        stringBuffer.append("/**\n");
        stringBuffer.append(" *\n");
        stringBuffer.append(" */\n");
        stringBuffer.append("class ");
        stringBuffer.append(this.sourceTask.getUnitName());
        stringBuffer.append(" extends JREvaluator\n");
        stringBuffer.append("{\n");
        stringBuffer.append("\n");
        stringBuffer.append("\n");
        stringBuffer.append("    /**\n");
        stringBuffer.append("     *\n");
        stringBuffer.append("     */\n");
    }

    protected final void generateDeclarations(StringBuffer stringBuffer) {
        Iterator iterator;
        Set set;
        if (this.parametersMap != null && this.parametersMap.size() > 0) {
            set = this.parametersMap.keySet();
            iterator = set.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append("    private property JRFillParameter parameter_");
                stringBuffer.append(JRStringUtil.getLiteral((String)iterator.next()));
                stringBuffer.append(" = null;\n");
            }
        }
        if (this.fieldsMap != null && this.fieldsMap.size() > 0) {
            set = this.fieldsMap.keySet();
            iterator = set.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append("    private property JRFillField field_");
                stringBuffer.append(JRStringUtil.getLiteral((String)iterator.next()));
                stringBuffer.append(" = null;\n");
            }
        }
        if (this.variables != null && this.variables.length > 0) {
            for (int i = 0; i < this.variables.length; ++i) {
                stringBuffer.append("    private property JRFillVariable variable_");
                stringBuffer.append(JRStringUtil.getLiteral(this.variables[i].getName()));
                stringBuffer.append(" = null;\n");
            }
        }
    }

    protected final void generateInitParamsMethod(StringBuffer stringBuffer) throws JRException {
        Iterator<Object> iterator = null;
        iterator = this.parametersMap != null && this.parametersMap.size() > 0 ? this.parametersMap.keySet().iterator() : Collections.EMPTY_SET.iterator();
        this.generateInitParamsMethod(stringBuffer, iterator, 0);
    }

    protected final void generateInitFieldsMethod(StringBuffer stringBuffer) throws JRException {
        Iterator<Object> iterator = null;
        iterator = this.fieldsMap != null && this.fieldsMap.size() > 0 ? this.fieldsMap.keySet().iterator() : Collections.EMPTY_SET.iterator();
        this.generateInitFieldsMethod(stringBuffer, iterator, 0);
    }

    protected final void generateInitVarsMethod(StringBuffer stringBuffer) throws JRException {
        Iterator<Object> iterator = null;
        iterator = this.variables != null && this.variables.length > 0 ? Arrays.asList(this.variables).iterator() : Collections.EMPTY_LIST.iterator();
        this.generateInitVarsMethod(stringBuffer, iterator, 0);
    }

    private void generateInitParamsMethod(StringBuffer stringBuffer, Iterator iterator, int n) throws JRException {
        stringBuffer.append("    /**\n");
        stringBuffer.append("     *\n");
        stringBuffer.append("     */\n");
        stringBuffer.append("    void initParams");
        if (n > 0) {
            stringBuffer.append(n);
        }
        stringBuffer.append("(Map pm)\n");
        stringBuffer.append("    {\n");
        for (int i = 0; i < 100 && iterator.hasNext(); ++i) {
            String string = (String)iterator.next();
            stringBuffer.append("        parameter_");
            stringBuffer.append(JRStringUtil.getLiteral(string));
            stringBuffer.append(" = (JRFillParameter)pm.get(\"");
            stringBuffer.append(string);
            stringBuffer.append("\");\n");
        }
        if (iterator.hasNext()) {
            stringBuffer.append("        initParams");
            stringBuffer.append(n + 1);
            stringBuffer.append("(pm);\n");
        }
        stringBuffer.append("    }\n");
        stringBuffer.append("\n");
        stringBuffer.append("\n");
        if (iterator.hasNext()) {
            this.generateInitParamsMethod(stringBuffer, iterator, n + 1);
        }
    }

    private void generateInitFieldsMethod(StringBuffer stringBuffer, Iterator iterator, int n) throws JRException {
        stringBuffer.append("    /**\n");
        stringBuffer.append("     *\n");
        stringBuffer.append("     */\n");
        stringBuffer.append("    void initFields");
        if (n > 0) {
            stringBuffer.append(n);
        }
        stringBuffer.append("(Map fm)\n");
        stringBuffer.append("    {\n");
        for (int i = 0; i < 100 && iterator.hasNext(); ++i) {
            String string = (String)iterator.next();
            stringBuffer.append("        field_");
            stringBuffer.append(JRStringUtil.getLiteral(string));
            stringBuffer.append(" = (JRFillField)fm.get(\"");
            stringBuffer.append(string);
            stringBuffer.append("\");\n");
        }
        if (iterator.hasNext()) {
            stringBuffer.append("        initFields");
            stringBuffer.append(n + 1);
            stringBuffer.append("(fm);\n");
        }
        stringBuffer.append("    }\n");
        stringBuffer.append("\n");
        stringBuffer.append("\n");
        if (iterator.hasNext()) {
            this.generateInitFieldsMethod(stringBuffer, iterator, n + 1);
        }
    }

    private void generateInitVarsMethod(StringBuffer stringBuffer, Iterator iterator, int n) throws JRException {
        stringBuffer.append("    /**\n");
        stringBuffer.append("     *\n");
        stringBuffer.append("     */\n");
        stringBuffer.append("    void initVars");
        if (n > 0) {
            stringBuffer.append(n);
        }
        stringBuffer.append("(Map vm)\n");
        stringBuffer.append("    {\n");
        for (int i = 0; i < 100 && iterator.hasNext(); ++i) {
            String string = ((JRVariable)iterator.next()).getName();
            stringBuffer.append("        variable_");
            stringBuffer.append(JRStringUtil.getLiteral(string));
            stringBuffer.append(" = (JRFillVariable)vm.get(\"");
            stringBuffer.append(string);
            stringBuffer.append("\");\n");
        }
        if (iterator.hasNext()) {
            stringBuffer.append("        initVars");
            stringBuffer.append(n + 1);
            stringBuffer.append("(vm);\n");
        }
        stringBuffer.append("    }\n");
        stringBuffer.append("\n");
        stringBuffer.append("\n");
        if (iterator.hasNext()) {
            this.generateInitVarsMethod(stringBuffer, iterator, n + 1);
        }
    }

    protected final String generateMethod(byte by, List list) throws JRException {
        StringBuffer stringBuffer = new StringBuffer();
        if (list != null && !list.isEmpty()) {
            stringBuffer.append(this.generateMethod(list.iterator(), 0, by, list.size()));
        } else {
            stringBuffer.append("    /**\n");
            stringBuffer.append("     *\n");
            stringBuffer.append("     */\n");
            stringBuffer.append("    Object evaluate");
            stringBuffer.append((String)methodSuffixMap.get(new Byte(by)));
            stringBuffer.append("(int id)\n");
            stringBuffer.append("    {\n");
            stringBuffer.append("        return null;\n");
            stringBuffer.append("    }\n");
            stringBuffer.append("\n");
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    private String generateMethod(Iterator iterator, int n, byte by, int n2) throws JRException {
        boolean bl;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("    /**\n");
        stringBuffer.append("     *\n");
        stringBuffer.append("     */\n");
        stringBuffer.append("    Object evaluate");
        stringBuffer.append((String)methodSuffixMap.get(new Byte(by)));
        if (n > 0) {
            stringBuffer.append(n);
        }
        stringBuffer.append("(int id)\n");
        stringBuffer.append("    {\n");
        stringBuffer.append("        Object value = null;\n");
        stringBuffer.append("\n");
        int n3 = (n + 1) * 100;
        boolean bl2 = bl = n2 > n3;
        if (bl) {
            stringBuffer.append("        if (id >= ");
            stringBuffer.append(n3);
            stringBuffer.append(")\n");
            stringBuffer.append("        {\n");
            stringBuffer.append("            value = evaluate");
            stringBuffer.append((String)methodSuffixMap.get(new Byte(by)));
            stringBuffer.append(n + 1);
            stringBuffer.append("(id);\n");
            stringBuffer.append("        }\n");
        }
        for (int i = 0; iterator.hasNext() && i < 100; ++i) {
            JRExpression jRExpression = (JRExpression)iterator.next();
            stringBuffer.append("        ");
            if (i > 0 || bl) {
                stringBuffer.append("else ");
            }
            stringBuffer.append("if (id == ");
            stringBuffer.append(this.sourceTask.getExpressionId(jRExpression));
            stringBuffer.append(")\n");
            stringBuffer.append("        {\n");
            stringBuffer.append("            value = (");
            stringBuffer.append(jRExpression.getValueClassName());
            stringBuffer.append(")(");
            stringBuffer.append(this.generateExpression(jRExpression, by));
            stringBuffer.append(");\n");
            stringBuffer.append("        }\n");
        }
        stringBuffer.append("\n");
        stringBuffer.append("        return value;\n");
        stringBuffer.append("    }\n");
        stringBuffer.append("\n");
        stringBuffer.append("\n");
        if (bl) {
            stringBuffer.append(this.generateMethod(iterator, n + 1, by, n2));
        }
        return stringBuffer.toString();
    }

    private String generateExpression(JRExpression jRExpression, byte by) {
        JRParameter jRParameter = null;
        JRField jRField = null;
        JRVariable jRVariable = null;
        StringBuffer stringBuffer = new StringBuffer();
        JRExpressionChunk[] jRExpressionChunkArray = jRExpression.getChunks();
        JRExpressionChunk jRExpressionChunk = null;
        String string = null;
        if (jRExpressionChunkArray != null && jRExpressionChunkArray.length > 0) {
            block7: for (int i = 0; i < jRExpressionChunkArray.length; ++i) {
                jRExpressionChunk = jRExpressionChunkArray[i];
                string = jRExpressionChunk.getText();
                if (string == null) {
                    string = "";
                }
                switch (jRExpressionChunk.getType()) {
                    case 1: {
                        stringBuffer.append(string);
                        continue block7;
                    }
                    case 2: {
                        jRParameter = (JRParameter)this.parametersMap.get(string);
                        stringBuffer.append("((");
                        stringBuffer.append(jRParameter.getValueClassName());
                        stringBuffer.append(")parameter_");
                        stringBuffer.append(JRStringUtil.getLiteral(string));
                        stringBuffer.append(".getValue())");
                        continue block7;
                    }
                    case 3: {
                        jRField = (JRField)this.fieldsMap.get(string);
                        stringBuffer.append("((");
                        stringBuffer.append(jRField.getValueClassName());
                        stringBuffer.append(")field_");
                        stringBuffer.append(JRStringUtil.getLiteral(string));
                        stringBuffer.append(".get");
                        stringBuffer.append((String)fieldPrefixMap.get(new Byte(by)));
                        stringBuffer.append("Value())");
                        continue block7;
                    }
                    case 4: {
                        jRVariable = (JRVariable)this.variablesMap.get(string);
                        stringBuffer.append("((");
                        stringBuffer.append(jRVariable.getValueClassName());
                        stringBuffer.append(")variable_");
                        stringBuffer.append(JRStringUtil.getLiteral(string));
                        stringBuffer.append(".get");
                        stringBuffer.append((String)variablePrefixMap.get(new Byte(by)));
                        stringBuffer.append("Value())");
                        continue block7;
                    }
                    case 5: {
                        stringBuffer.append("str(\"");
                        stringBuffer.append(string);
                        stringBuffer.append("\")");
                    }
                }
            }
        }
        if (stringBuffer.length() == 0) {
            stringBuffer.append("null");
        }
        return stringBuffer.toString();
    }

    static {
        fieldPrefixMap = new HashMap();
        fieldPrefixMap.put(new Byte(1), "Old");
        fieldPrefixMap.put(new Byte(2), "");
        fieldPrefixMap.put(new Byte(3), "");
        variablePrefixMap = new HashMap();
        variablePrefixMap.put(new Byte(1), "Old");
        variablePrefixMap.put(new Byte(2), "Estimated");
        variablePrefixMap.put(new Byte(3), "");
        methodSuffixMap = new HashMap();
        methodSuffixMap.put(new Byte(1), "Old");
        methodSuffixMap.put(new Byte(2), "Estimated");
        methodSuffixMap.put(new Byte(3), "");
    }
}

