/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.compilers;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.compilers.JRGroovyGenerator;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.design.JRAbstractJavaCompiler;
import net.sf.jasperreports.engine.design.JRCompilationUnit;
import net.sf.jasperreports.engine.design.JRSourceCompileTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

public class JRGroovyCompiler
extends JRAbstractJavaCompiler {
    private static final Log log = LogFactory.getLog((Class)(class$net$sf$jasperreports$compilers$JRGroovyCompiler == null ? (class$net$sf$jasperreports$compilers$JRGroovyCompiler = JRGroovyCompiler.class$("net.sf.jasperreports.compilers.JRGroovyCompiler")) : class$net$sf$jasperreports$compilers$JRGroovyCompiler));
    public static final String LANGUAGE_GROOVY = "groovy";
    static /* synthetic */ Class class$net$sf$jasperreports$compilers$JRGroovyCompiler;

    public JRGroovyCompiler() {
        super(false);
    }

    protected String compileUnits(JRCompilationUnit[] jRCompilationUnitArray, String string, File file) throws JRException {
        CompilerConfiguration compilerConfiguration = new CompilerConfiguration();
        compilerConfiguration.setClasspath(string);
        CompilationUnit compilationUnit = new CompilationUnit(compilerConfiguration);
        for (int i = 0; i < jRCompilationUnitArray.length; ++i) {
            compilationUnit.addSource("calculator_" + jRCompilationUnitArray[i].getName(), (InputStream)new ByteArrayInputStream(jRCompilationUnitArray[i].getSourceCode().getBytes()));
        }
        ClassCollector classCollector = new ClassCollector();
        compilationUnit.setClassgenCallback((CompilationUnit.ClassgenCallback)classCollector);
        try {
            compilationUnit.compile(7);
        }
        catch (CompilationFailedException compilationFailedException) {
            throw new JRException("Errors were encountered when compiling report expressions class file:\n" + compilationFailedException.toString());
        }
        if (classCollector.classes.size() < jRCompilationUnitArray.length) {
            throw new JRException("Too few groovy class were generated.");
        }
        if (classCollector.classCount > jRCompilationUnitArray.length) {
            throw new JRException("Too many groovy classes were generated.\nPlease make sure that you don't use Groovy features such as closures that are not supported by this report compiler.\n");
        }
        for (int i = 0; i < jRCompilationUnitArray.length; ++i) {
            jRCompilationUnitArray[i].setCompileData((Serializable)classCollector.classes.get(jRCompilationUnitArray[i].getName()));
        }
        return null;
    }

    protected void checkLanguage(String string) throws JRException {
        if (!LANGUAGE_GROOVY.equals(string)) {
            throw new JRException("Language \"" + string + "\" not supported by this report compiler.\n" + "Expecting \"groovy\" instead.");
        }
    }

    protected String generateSourceCode(JRSourceCompileTask jRSourceCompileTask) throws JRException {
        return JRGroovyGenerator.generateClass(jRSourceCompileTask);
    }

    protected String getSourceFileName(String string) {
        return string + ".groovy";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class ClassCollector
    extends CompilationUnit.ClassgenCallback {
        public Map classes = new HashMap();
        public int classCount;

        private ClassCollector() {
        }

        public void call(ClassVisitor classVisitor, ClassNode classNode) throws CompilationFailedException {
            ++this.classCount;
            String string = classNode.getName();
            if (!this.classes.containsKey(string)) {
                byte[] byArray = ((ClassWriter)classVisitor).toByteArray();
                this.classes.put(string, byArray);
            }
        }
    }
}

