/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.charts.fill;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.charts.JRXyDataset;
import net.sf.jasperreports.charts.JRXySeries;
import net.sf.jasperreports.charts.fill.JRFillXySeries;
import net.sf.jasperreports.charts.util.XYDatasetLabelGenerator;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.fill.JRCalculator;
import net.sf.jasperreports.engine.fill.JRExpressionEvalException;
import net.sf.jasperreports.engine.fill.JRFillChartDataset;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import org.jfree.data.general.Dataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class JRFillXyDataset
extends JRFillChartDataset
implements JRXyDataset {
    protected JRFillXySeries[] xySeries = null;
    private List seriesNames = null;
    private Map seriesMap = null;
    private Map labelsMap = null;

    public JRFillXyDataset(JRXyDataset jRXyDataset, JRFillObjectFactory jRFillObjectFactory) {
        super(jRXyDataset, jRFillObjectFactory);
        JRXySeries[] jRXySeriesArray = jRXyDataset.getSeries();
        if (jRXySeriesArray != null && jRXySeriesArray.length > 0) {
            this.xySeries = new JRFillXySeries[jRXySeriesArray.length];
            for (int i = 0; i < this.xySeries.length; ++i) {
                this.xySeries[i] = (JRFillXySeries)jRFillObjectFactory.getXySeries(jRXySeriesArray[i]);
            }
        }
    }

    public JRXySeries[] getSeries() {
        return this.xySeries;
    }

    protected void customInitialize() {
        this.seriesNames = null;
        this.seriesMap = null;
        this.labelsMap = null;
    }

    protected void customEvaluate(JRCalculator jRCalculator) throws JRExpressionEvalException {
        if (this.xySeries != null && this.xySeries.length > 0) {
            for (int i = 0; i < this.xySeries.length; ++i) {
                this.xySeries[i].evaluate(jRCalculator);
            }
        }
    }

    protected void customIncrement() {
        if (this.xySeries != null && this.xySeries.length > 0) {
            if (this.seriesNames == null) {
                this.seriesNames = new ArrayList();
                this.seriesMap = new HashMap();
                this.labelsMap = new HashMap();
            }
            for (int i = 0; i < this.xySeries.length; ++i) {
                JRFillXySeries jRFillXySeries = this.xySeries[i];
                Comparable comparable = jRFillXySeries.getSeries();
                XYSeries xYSeries = (XYSeries)this.seriesMap.get(comparable);
                if (xYSeries == null) {
                    xYSeries = new XYSeries(comparable);
                    this.seriesNames.add(comparable);
                    this.seriesMap.put(comparable, xYSeries);
                }
                xYSeries.addOrUpdate(jRFillXySeries.getXValue(), jRFillXySeries.getYValue());
                if (jRFillXySeries.getLabelExpression() == null) continue;
                HashMap<Number, String> hashMap = (HashMap<Number, String>)this.labelsMap.get(comparable);
                if (hashMap == null) {
                    hashMap = new HashMap<Number, String>();
                    this.labelsMap.put(comparable, hashMap);
                }
                hashMap.put(jRFillXySeries.getXValue(), jRFillXySeries.getLabel());
            }
        }
    }

    public Dataset getCustomDataset() {
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection();
        if (this.seriesNames != null) {
            for (int i = 0; i < this.seriesNames.size(); ++i) {
                Comparable comparable = (Comparable)this.seriesNames.get(i);
                xYSeriesCollection.addSeries((XYSeries)this.seriesMap.get(comparable));
            }
        }
        return xYSeriesCollection;
    }

    public byte getDatasetType() {
        return 3;
    }

    public XYDatasetLabelGenerator getLabelGenerator() {
        return new XYDatasetLabelGenerator(this.labelsMap);
    }

    public void collectExpressions(JRExpressionCollector jRExpressionCollector) {
        jRExpressionCollector.collect(this);
    }
}

