/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.charts.fill;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import net.sf.jasperreports.charts.JRTimeSeries;
import net.sf.jasperreports.charts.JRTimeSeriesDataset;
import net.sf.jasperreports.charts.fill.JRFillTimeSeries;
import net.sf.jasperreports.charts.util.TimeSeriesLabelGenerator;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.fill.JRCalculator;
import net.sf.jasperreports.engine.fill.JRExpressionEvalException;
import net.sf.jasperreports.engine.fill.JRFillChartDataset;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import org.jfree.data.general.Dataset;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;

public class JRFillTimeSeriesDataset
extends JRFillChartDataset
implements JRTimeSeriesDataset {
    protected JRFillTimeSeries[] timeSeries = null;
    private List seriesNames = null;
    private Map seriesMap = null;
    private Map labelsMap = null;

    public JRFillTimeSeriesDataset(JRTimeSeriesDataset jRTimeSeriesDataset, JRFillObjectFactory jRFillObjectFactory) {
        super(jRTimeSeriesDataset, jRFillObjectFactory);
        JRTimeSeries[] jRTimeSeriesArray = jRTimeSeriesDataset.getSeries();
        if (jRTimeSeriesArray != null && jRTimeSeriesArray.length > 0) {
            this.timeSeries = new JRFillTimeSeries[jRTimeSeriesArray.length];
            for (int i = 0; i < this.timeSeries.length; ++i) {
                this.timeSeries[i] = (JRFillTimeSeries)jRFillObjectFactory.getTimeSeries(jRTimeSeriesArray[i]);
            }
        }
    }

    public JRTimeSeries[] getSeries() {
        return this.timeSeries;
    }

    protected void customInitialize() {
        this.seriesNames = null;
        this.seriesMap = null;
        this.labelsMap = null;
    }

    protected void customEvaluate(JRCalculator jRCalculator) throws JRExpressionEvalException {
        if (this.timeSeries != null && this.timeSeries.length > 0) {
            for (int i = 0; i < this.timeSeries.length; ++i) {
                this.timeSeries[i].evaluate(jRCalculator);
            }
        }
    }

    protected void customIncrement() {
        if (this.timeSeries != null && this.timeSeries.length > 0) {
            if (this.seriesNames == null) {
                this.seriesNames = new ArrayList();
                this.seriesMap = new HashMap();
                this.labelsMap = new HashMap();
            }
            for (int i = 0; i < this.timeSeries.length; ++i) {
                JRFillTimeSeries jRFillTimeSeries = this.timeSeries[i];
                Comparable comparable = jRFillTimeSeries.getSeries();
                TimeSeries timeSeries = (TimeSeries)this.seriesMap.get(comparable);
                if (timeSeries == null) {
                    timeSeries = new TimeSeries(comparable.toString(), this.getTimePeriod());
                    this.seriesNames.add(comparable);
                    this.seriesMap.put(comparable, timeSeries);
                }
                RegularTimePeriod regularTimePeriod = RegularTimePeriod.createInstance((Class)this.getTimePeriod(), (Date)jRFillTimeSeries.getTimePeriod(), (TimeZone)TimeZone.getDefault());
                timeSeries.addOrUpdate(regularTimePeriod, jRFillTimeSeries.getValue());
                if (jRFillTimeSeries.getLabelExpression() == null) continue;
                HashMap<RegularTimePeriod, String> hashMap = (HashMap<RegularTimePeriod, String>)this.labelsMap.get(comparable);
                if (hashMap == null) {
                    hashMap = new HashMap<RegularTimePeriod, String>();
                    this.labelsMap.put(comparable, hashMap);
                }
                hashMap.put(regularTimePeriod, jRFillTimeSeries.getLabel());
            }
        }
    }

    public Dataset getCustomDataset() {
        TimeSeriesCollection timeSeriesCollection = new TimeSeriesCollection();
        if (this.seriesNames != null) {
            for (int i = 0; i < this.seriesNames.size(); ++i) {
                Comparable comparable = (Comparable)this.seriesNames.get(i);
                timeSeriesCollection.addSeries((TimeSeries)this.seriesMap.get(comparable));
            }
        }
        return timeSeriesCollection;
    }

    public Class getTimePeriod() {
        return ((JRTimeSeriesDataset)this.parent).getTimePeriod();
    }

    public void setTimePeriod(Class clazz) {
    }

    public byte getDatasetType() {
        return 6;
    }

    public TimeSeriesLabelGenerator getLabelGenerator() {
        return new TimeSeriesLabelGenerator(this.labelsMap);
    }

    public void collectExpressions(JRExpressionCollector jRExpressionCollector) {
        jRExpressionCollector.collect(this);
    }
}

