/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.charts.fill;

import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.charts.JRCategoryDataset;
import net.sf.jasperreports.charts.JRCategorySeries;
import net.sf.jasperreports.charts.fill.JRFillCategorySeries;
import net.sf.jasperreports.charts.util.CategoryLabelGenerator;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.fill.JRCalculator;
import net.sf.jasperreports.engine.fill.JRExpressionEvalException;
import net.sf.jasperreports.engine.fill.JRFillChartDataset;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.Dataset;

public class JRFillCategoryDataset
extends JRFillChartDataset
implements JRCategoryDataset {
    protected JRFillCategorySeries[] categorySeries = null;
    private DefaultCategoryDataset dataset = null;
    private Map labelsMap = null;

    public JRFillCategoryDataset(JRCategoryDataset jRCategoryDataset, JRFillObjectFactory jRFillObjectFactory) {
        super(jRCategoryDataset, jRFillObjectFactory);
        JRCategorySeries[] jRCategorySeriesArray = jRCategoryDataset.getSeries();
        if (jRCategorySeriesArray != null && jRCategorySeriesArray.length > 0) {
            this.categorySeries = new JRFillCategorySeries[jRCategorySeriesArray.length];
            for (int i = 0; i < this.categorySeries.length; ++i) {
                this.categorySeries[i] = (JRFillCategorySeries)jRFillObjectFactory.getCategorySeries(jRCategorySeriesArray[i]);
            }
        }
    }

    public JRCategorySeries[] getSeries() {
        return this.categorySeries;
    }

    protected void customInitialize() {
        this.dataset = null;
        this.labelsMap = null;
    }

    protected void customEvaluate(JRCalculator jRCalculator) throws JRExpressionEvalException {
        if (this.categorySeries != null && this.categorySeries.length > 0) {
            for (int i = 0; i < this.categorySeries.length; ++i) {
                this.categorySeries[i].evaluate(jRCalculator);
            }
        }
    }

    protected void customIncrement() {
        if (this.categorySeries != null && this.categorySeries.length > 0) {
            if (this.dataset == null) {
                this.dataset = new DefaultCategoryDataset();
                this.labelsMap = new HashMap();
            }
            for (int i = 0; i < this.categorySeries.length; ++i) {
                JRFillCategorySeries jRFillCategorySeries = this.categorySeries[i];
                Comparable comparable = jRFillCategorySeries.getSeries();
                comparable.toString();
                this.dataset.addValue(jRFillCategorySeries.getValue(), jRFillCategorySeries.getSeries(), jRFillCategorySeries.getCategory());
                if (jRFillCategorySeries.getLabelExpression() == null) continue;
                HashMap<Comparable, String> hashMap = (HashMap<Comparable, String>)this.labelsMap.get(comparable);
                if (hashMap == null) {
                    hashMap = new HashMap<Comparable, String>();
                    this.labelsMap.put(comparable, hashMap);
                }
                hashMap.put(jRFillCategorySeries.getCategory(), jRFillCategorySeries.getLabel());
            }
        }
    }

    public Dataset getCustomDataset() {
        return this.dataset;
    }

    public byte getDatasetType() {
        return 2;
    }

    public CategoryLabelGenerator getLabelGenerator() {
        return new CategoryLabelGenerator(this.labelsMap);
    }

    public void collectExpressions(JRExpressionCollector jRExpressionCollector) {
        jRExpressionCollector.collect(this);
    }
}

