/*
 * Decompiled with CFR 0.152.
 */
package br.com.linkcom.neo.view.combo;

import br.com.linkcom.neo.exception.NeoException;
import br.com.linkcom.neo.util.ReflectionCache;
import br.com.linkcom.neo.util.ReflectionCacheFactory;
import br.com.linkcom.neo.util.Util;
import br.com.linkcom.neo.view.BaseTag;
import br.com.linkcom.neo.view.LogicalTag;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.jsp.JspContext;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.el.ELException;
import javax.servlet.jsp.tagext.JspFragment;
import javax.servlet.jsp.tagext.JspTag;

public class ComboTag
extends BaseTag
implements LogicalTag {
    protected void invoke(TagHolder holder) throws JspException, IOException {
        TagHolderFragment fragment = new TagHolderFragment(this.getJspContext(), Arrays.asList(holder), this);
        fragment.invoke((Writer)this.getOut());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TagHolder {
        protected BaseTag baseTag;
        protected List<TagHolder> children = new ArrayList<TagHolder>();
        protected Map<String, String> rtexprs = new HashMap<String, String>();

        public TagHolder(BaseTag tag) {
            if (tag == null) {
                throw new NullPointerException("baseTag null");
            }
            this.baseTag = tag;
        }

        public TagHolder(BaseTag tag, String ... exprs) {
            this(tag);
            if (exprs.length % 2 != 0) {
                throw new IllegalArgumentException("exprs invalidos " + exprs);
            }
            int i = 0;
            while (i < exprs.length) {
                this.rtexprs.put(exprs[i], exprs[i + 1]);
                i += 2;
            }
        }

        public boolean addChild(TagHolder o) {
            return this.children.add(o);
        }

        public BaseTag getBaseTag() {
            return this.baseTag;
        }

        public List<TagHolder> getChildren() {
            return this.children;
        }

        public void setBaseTag(BaseTag baseTag) {
            this.baseTag = baseTag;
        }

        public void setChildren(List<TagHolder> children) {
            this.children = children;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TagHolderFragment
    extends JspFragment {
        JspContext jspContext;
        List<TagHolder> tagHolders = new ArrayList<TagHolder>();
        BaseTag parent;

        public TagHolderFragment(JspContext context, List<TagHolder> holders, BaseTag parent) {
            this.jspContext = context;
            this.tagHolders = holders;
            this.parent = parent;
            for (TagHolder holder : this.tagHolders) {
                holder.baseTag.setParent((JspTag)parent);
            }
        }

        public void invoke(Writer out) throws JspException, IOException {
            for (TagHolder holder : this.tagHolders) {
                holder.baseTag.setJspContext(this.jspContext);
                Set<String> keySet = holder.rtexprs.keySet();
                for (String propertyName : keySet) {
                    String expr = holder.rtexprs.get(propertyName);
                    try {
                        this.setProperty(holder.baseTag, propertyName, ComboTag.evaluate(expr, this.jspContext));
                    }
                    catch (ELException e) {
                        throw new NeoException("Cannot set property " + propertyName + " of tag " + (Object)((Object)holder.baseTag) + " value " + expr + ". Parsing problem");
                    }
                }
                if (holder.getChildren().size() > 0) {
                    holder.baseTag.setJspBody(new TagHolderFragment(this.getJspContext(), holder.getChildren(), holder.baseTag));
                }
                this.jspContext.pushBody(out);
                holder.baseTag.doTag();
                this.jspContext.popBody();
            }
        }

        private void setProperty(BaseTag baseTag, String property, Object object) {
            if (object != null) {
                Method setter = null;
                ReflectionCache reflectionCache = ReflectionCacheFactory.getReflectionCache();
                try {
                    setter = reflectionCache.getMethod(((Object)((Object)baseTag)).getClass(), "set" + Util.strings.captalize(property), object.getClass());
                }
                catch (SecurityException e) {
                    throw new NeoException("Cannot set property " + property + " of tag " + (Object)((Object)baseTag) + " value " + object);
                }
                catch (NoSuchMethodException e) {
                    try {
                        setter = reflectionCache.getMethod(((Object)((Object)baseTag)).getClass(), "set" + Util.strings.captalize(property), String.class);
                        object = object.toString();
                    }
                    catch (SecurityException e1) {
                        throw new NeoException("Cannot set property " + property + " of tag " + (Object)((Object)baseTag) + " value " + object);
                    }
                    catch (NoSuchMethodException e1) {
                        try {
                            setter = reflectionCache.getMethod(((Object)((Object)baseTag)).getClass(), "set" + Util.strings.captalize(property), Object.class);
                        }
                        catch (SecurityException e2) {
                            throw new NeoException("Cannot set property " + property + " of tag " + (Object)((Object)baseTag) + " value " + object);
                        }
                        catch (NoSuchMethodException e2) {
                            throw new NeoException("Cannot set property " + property + " of tag " + (Object)((Object)baseTag) + " value " + object + "  " + e.getMessage(), e);
                        }
                    }
                }
                try {
                    setter.invoke((Object)baseTag, object);
                }
                catch (IllegalArgumentException e) {
                    throw new NeoException("Cannot set property " + property + " of tag " + (Object)((Object)baseTag) + " value " + object);
                }
                catch (IllegalAccessException e) {
                    throw new NeoException("Cannot set property " + property + " of tag " + (Object)((Object)baseTag) + " value " + object);
                }
                catch (InvocationTargetException e) {
                    throw new NeoException("Cannot set property " + property + " of tag " + (Object)((Object)baseTag) + " value " + object);
                }
            }
        }

        public JspContext getJspContext() {
            return this.jspContext;
        }
    }
}

