/*
 * Decompiled with CFR 0.152.
 */
package br.com.linkcom.neo.view;

import br.com.linkcom.neo.bean.BeanDescriptor;
import br.com.linkcom.neo.bean.PageContextIndexResolver;
import br.com.linkcom.neo.bean.PropertyDescriptor;
import br.com.linkcom.neo.core.web.NeoWeb;
import br.com.linkcom.neo.view.BaseTag;
import br.com.linkcom.neo.view.BeanTag;
import br.com.linkcom.neo.view.ForEachBeanTag;
import br.com.linkcom.neo.view.LogicalTag;
import br.com.linkcom.neo.view.PropertySetter;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.hibernate.LazyInitializationException;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.validation.BindException;
import org.springframework.validation.FieldError;

public class PropertyTag
extends BaseTag
implements LogicalTag {
    protected String name;
    protected String varValue = "value";
    protected String varError = "error";
    protected String varLabel = "label";
    protected String varName = "name";
    protected String varType = "type";
    protected String varParameterizedTypes = "parameterizedTypes";
    protected String varPropertySetter = "propertySetter";
    protected String varAnnotations = "annotations";
    protected String fullName;
    protected String fullNestedName;

    public String getFullNestedName() {
        return this.fullNestedName;
    }

    protected void doComponent() throws Exception {
        BindException errors = NeoWeb.getRequestContext().getBindException();
        this.montarFullPropertyName();
        this.montarFullNestedName();
        final BeanDescriptor beanDescriptor = this.findParent(BeanTag.class, true).getBeanDescriptor();
        beanDescriptor.setIndexValueResolver(new PageContextIndexResolver(this.getPageContext()));
        PropertyDescriptor propertyDescriptor = null;
        if (!"".equals(this.fullNestedName)) {
            propertyDescriptor = beanDescriptor.getPropertyDescriptor(this.fullNestedName);
        }
        FieldError error = errors.getFieldError(this.fullName);
        boolean containError = errors.hasErrors() && errors.getTarget().getClass().equals(beanDescriptor.getTargetClass()) && error != null;
        Type type = propertyDescriptor != null ? propertyDescriptor.getType() : (Type)beanDescriptor.getTargetClass();
        Type[] actualTypeArguments = new Type[]{};
        if (containError) {
            this.pushAttribute(this.varValue, error.getRejectedValue());
            this.pushAttribute(this.varError, error.getDefaultMessage());
            this.pushAttribute(this.varType, type);
            if (type instanceof ParameterizedType) {
                actualTypeArguments = ((ParameterizedType)type).getActualTypeArguments();
            }
            this.pushAttribute(this.varParameterizedTypes, actualTypeArguments);
        } else {
            try {
                Object propertyValue = propertyDescriptor != null ? propertyDescriptor.getValue() : beanDescriptor.getTargetBean();
                Object value = propertyValue;
                this.pushAttribute(this.varValue, value);
                this.pushAttribute(this.varType, type);
                if (type instanceof ParameterizedType) {
                    actualTypeArguments = ((ParameterizedType)type).getActualTypeArguments();
                }
                this.pushAttribute(this.varParameterizedTypes, actualTypeArguments);
            }
            catch (LazyInitializationException e) {
                this.pushAttribute(this.varValue, "[Could not initializate proxy] " + propertyDescriptor.getPropertyName());
                this.pushAttribute(this.varType, String.class);
            }
        }
        if (propertyDescriptor != null) {
            this.pushAttribute(this.varLabel, propertyDescriptor.getDisplayName());
        } else {
            this.pushAttribute(this.varLabel, beanDescriptor.getDisplayName());
        }
        this.pushAttribute(this.varName, this.fullName);
        if (propertyDescriptor != null) {
            PropertySetter propertySetter = new PropertySetter(){

                public void set(Object value) {
                    Object targetBean = beanDescriptor.getTargetBean();
                    BeanWrapperImpl beanWrapperImpl = new BeanWrapperImpl(targetBean);
                    beanWrapperImpl.setPropertyValue(PropertyTag.this.fullNestedName, value);
                }
            };
            this.pushAttribute(this.varPropertySetter, propertySetter);
        }
        if (propertyDescriptor != null) {
            this.pushAttribute(this.varAnnotations, propertyDescriptor.getAnnotations());
        } else {
            this.pushAttribute(this.varAnnotations, new Annotation[0]);
        }
        this.doBody();
        if (containError) {
            this.popAttribute(this.varError);
        }
        if (propertyDescriptor != null) {
            this.popAttribute(this.varPropertySetter);
        }
        this.popAttribute(this.varValue);
        this.popAttribute(this.varLabel);
        this.popAttribute(this.varName);
        this.popAttribute(this.varType);
        this.popAttribute(this.varAnnotations);
        this.popAttribute(this.varParameterizedTypes);
    }

    protected void montarFullNestedName() {
        BaseTag firstParent = this.findFirst(ForEachBeanTag.class, PropertyTag.class, BeanTag.class);
        String separator = this.name.startsWith("[") ? "" : ".";
        this.fullNestedName = firstParent instanceof PropertyTag ? String.valueOf(((PropertyTag)firstParent).getFullNestedName()) + separator + this.name : this.name;
    }

    protected void montarFullPropertyName() {
        String separator;
        BaseTag firstParent = this.findFirst(ForEachBeanTag.class, PropertyTag.class, BeanTag.class);
        String string = separator = this.name.startsWith("[") ? "" : ".";
        if (firstParent instanceof PropertyTag) {
            this.fullName = String.valueOf(((PropertyTag)firstParent).getFullName()) + separator + this.name;
        } else {
            BeanTag parentBean = (BeanTag)firstParent;
            if (parentBean == null) {
                throw new NullPointerException("Tag property (" + this.name + ") n\u00e3o est\u00e1 aninhada a uma outra tag Property ou Bean");
            }
            String propertyPrefix = parentBean.getPropertyPrefix();
            String propertyIndex = parentBean.getPropertyIndex();
            String prefix = "";
            if (propertyPrefix != null) {
                prefix = propertyPrefix;
            }
            if (propertyIndex != null) {
                prefix = String.valueOf(prefix) + "[" + propertyIndex + "]";
            }
            if (prefix.length() != 0 && this.name != null && !this.name.equals("this")) {
                prefix = String.valueOf(prefix) + ".";
            }
            if ("this".equals(this.name) || this.name == null) {
                this.fullName = prefix;
                return;
            }
            this.fullName = String.valueOf(prefix) + this.name;
        }
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getVarAnnotations() {
        return this.varAnnotations;
    }

    public String getVarLabel() {
        return this.varLabel;
    }

    public String getName() {
        return this.name;
    }

    public String getVarName() {
        return this.varName;
    }

    public String getVarValue() {
        return this.varValue;
    }

    public void setVarAnnotations(String annotationsVar) {
        this.varAnnotations = annotationsVar;
    }

    public void setVarLabel(String displayNameVar) {
        this.varLabel = displayNameVar;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setVarName(String nameVar) {
        this.varName = nameVar;
    }

    public void setVarValue(String valueVar) {
        this.varValue = valueVar;
    }

    public String getVarParameterizedTypes() {
        return this.varParameterizedTypes;
    }

    public String getVarType() {
        return this.varType;
    }

    public void setVarParameterizedTypes(String varParameterizedTypes) {
        this.varParameterizedTypes = varParameterizedTypes;
    }

    public void setVarType(String varType) {
        this.varType = varType;
    }
}

