/*
 * Decompiled with CFR 0.152.
 */
package br.com.linkcom.neo.view;

import br.com.linkcom.neo.exception.ExpressionParseException;
import java.util.HashMap;
import java.util.Map;
import ognl.Ognl;
import ognl.OgnlException;
import org.springframework.beans.BeanWrapperImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OgnlExpressionParser {
    public static Map<String, Object> expressionCache = new HashMap<String, Object>();

    public static Object parse(String expression, Map contextMap) throws ExpressionParseException {
        Object value;
        try {
            Object tree = OgnlExpressionParser.getExpressionTree(expression);
            value = Ognl.getValue((Object)tree, (Object)contextMap, null);
        }
        catch (OgnlException e) {
            throw new ExpressionParseException("Erro ao fazer parsing de " + expression, e);
        }
        return value;
    }

    public static <X> X parse(String expression, Class<X> expectedClass, Map contextMap) throws ExpressionParseException {
        Object value;
        try {
            Object tree = OgnlExpressionParser.getExpressionTree(expression);
            value = Ognl.getValue((Object)tree, (Object)contextMap, null);
        }
        catch (OgnlException e) {
            if (!e.getMessage().startsWith("source is null")) {
                throw new ExpressionParseException("Erro ao fazer parsing de " + expression, e);
            }
            value = null;
        }
        if (value != null && !expectedClass.isAssignableFrom(value.getClass())) {
            BeanWrapperImpl beanWrapperImpl = new BeanWrapperImpl();
            value = beanWrapperImpl.doTypeConversionIfNecessary(value, expectedClass);
        }
        if (value != null && !expectedClass.isAssignableFrom(value.getClass())) {
            if (value != null && String.class.isAssignableFrom(expectedClass)) {
                String toString = value.toString();
                return (X)toString;
            }
            throw new ExpressionParseException("A express\u00e3o #{" + expression + "} retornou um objeto do tipo " + value.getClass().getName() + " era esperado " + expectedClass.getName() + "! N\u00e3o foi poss\u00edvel fazer a convers\u00e3o");
        }
        Object x = value;
        return (X)x;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object getExpressionTree(String expression) throws OgnlException {
        Object tree = expressionCache.get(expression);
        if (tree == null) {
            Map<String, Object> map = expressionCache;
            synchronized (map) {
                tree = expressionCache.get(expression);
                if (tree == null) {
                    tree = Ognl.parseExpression((String)expression);
                    expressionCache.put(expression, tree);
                }
            }
        }
        return tree;
    }
}

