/*
 * Decompiled with CFR 0.152.
 */
package br.com.linkcom.neo.view;

import br.com.linkcom.neo.controller.resource.Resource;
import br.com.linkcom.neo.core.standard.Neo;
import br.com.linkcom.neo.persistence.FileDAO;
import br.com.linkcom.neo.types.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DownloadFileServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    public static final String DOWNLOAD_FILE_PATH = "/DOWNLOADFILE";
    public static final String DOWNLOAD_FILE_MAP = "NEO_DOWNLOAD_FILE_MAP";

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Long cdfile;
        try {
            cdfile = this.extractCdfile(request);
        }
        catch (Exception e) {
            response.sendError(404);
            return;
        }
        if (DownloadFileServlet.getCdfile(request.getSession(), cdfile) == null) {
            response.sendError(403);
            return;
        }
        Resource resource = this.getResource(request, cdfile);
        if (resource == null) {
            response.sendError(404);
            return;
        }
        response.setContentType(resource.getContentType());
        response.setHeader("Content-Disposition", "attachment; filename=\"" + resource.getFileName() + "\";");
        if (resource.getSize() >= 0) {
            response.setContentLength(resource.getSize());
        }
        response.getOutputStream().write(resource.getContents());
        response.flushBuffer();
    }

    protected long getLastModified(HttpServletRequest request) {
        try {
            return this.getLastModified(request, this.extractCdfile(request));
        }
        catch (Exception e) {
            return 0L;
        }
    }

    protected Long extractCdfile(HttpServletRequest request) throws Exception {
        String requestURI = request.getRequestURI();
        Pattern pattern = Pattern.compile(".+?/([0-9]+)");
        Matcher matcher = pattern.matcher(requestURI);
        if (matcher.find()) {
            return new Long(matcher.group(1));
        }
        throw new Exception("URL inv\u00e1lida");
    }

    public static void addCdfile(HttpSession session, Long cdfile) {
        DownloadFileServlet.getMap(session).put(cdfile, cdfile);
    }

    public static Long getCdfile(HttpSession session, Long cdfile) {
        return DownloadFileServlet.getMap(session).get(cdfile);
    }

    private static HashMap<Long, Long> getMap(HttpSession session) {
        HashMap map = (HashMap)session.getAttribute(DOWNLOAD_FILE_MAP);
        if (map == null) {
            map = new HashMap();
            session.setAttribute(DOWNLOAD_FILE_MAP, map);
        }
        return map;
    }

    protected Resource getResource(HttpServletRequest request, Long cdfile) {
        Map beansOfType;
        DefaultListableBeanFactory defaultListableBeanFactory = Neo.getApplicationContext().getConfig().getDefaultListableBeanFactory();
        while ((beansOfType = defaultListableBeanFactory.getBeansOfType(FileDAO.class)).size() == 0 && (defaultListableBeanFactory = (DefaultListableBeanFactory)defaultListableBeanFactory.getParentBeanFactory()) != null) {
        }
        if (beansOfType.size() == 1) {
            FileDAO fileDAO = (FileDAO)((Object)beansOfType.values().iterator().next());
            Class<?>[] allClassesOfTypeFile = Neo.getApplicationContext().getClassManager().getAllClassesOfType(File.class);
            if (allClassesOfTypeFile.length == 1) {
                try {
                    File file = (File)allClassesOfTypeFile[0].newInstance();
                    file.setCdfile(cdfile);
                    file = fileDAO.loadWithContents(file);
                    Resource resource = new Resource(file.getContenttype(), file.getName(), file.getContent());
                    Long size = file.getSize();
                    if (size != null) {
                        resource.setSize(size.intValue());
                    }
                    return resource;
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
        }
        throw new RuntimeException("Estenda a classe DownloadFileServlet e sobrescreva o m\u00e9todo getResource");
    }

    protected long getLastModified(HttpServletRequest request, Long cdfile) {
        return -1L;
    }
}

