/*
 * Decompiled with CFR 0.152.
 */
package br.com.linkcom.neo.validation.validators;

import br.com.linkcom.neo.core.config.ValidatorRegistry;
import br.com.linkcom.neo.validation.JavascriptValidationItem;
import br.com.linkcom.neo.validation.PropertyValidator;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ValidationHolder {
    protected List<JavascriptValidationItem> validationItens;
    protected ValidatorRegistry validatorRegistry;

    public ValidationHolder(List<JavascriptValidationItem> validationItens, ValidatorRegistry validatorRegistry) {
        this.validationItens = validationItens;
        this.validatorRegistry = validatorRegistry;
    }

    public Map<PropertyValidator, List<JavascriptValidationItem>> getValidationMap() {
        HashMap<PropertyValidator, List<JavascriptValidationItem>> map = new HashMap<PropertyValidator, List<JavascriptValidationItem>>();
        for (JavascriptValidationItem validationItem : this.validationItens) {
            List<Annotation> list = validationItem.getValidations();
            PropertyValidator typeValidator = validationItem.getTypeValidator();
            if (typeValidator != null && typeValidator.getJavascriptFunctionPath() != null) {
                ArrayList<JavascriptValidationItem> validationItensForValidator = (ArrayList<JavascriptValidationItem>)map.get(typeValidator);
                if (validationItensForValidator == null) {
                    validationItensForValidator = new ArrayList<JavascriptValidationItem>();
                    map.put(typeValidator, validationItensForValidator);
                }
                validationItensForValidator.add(validationItem);
            }
            for (Annotation annotation : list) {
                PropertyValidator validator = this.validatorRegistry.getPropertyValidator(annotation.annotationType());
                if (validator.getJavascriptFunctionPath() == null) continue;
                ArrayList<JavascriptValidationItem> validationItensForValidator = (ArrayList<JavascriptValidationItem>)map.get(validator);
                if (validationItensForValidator == null) {
                    validationItensForValidator = new ArrayList<JavascriptValidationItem>();
                    map.put(validator, validationItensForValidator);
                }
                validationItensForValidator.add(validationItem);
            }
        }
        return map;
    }
}

