/*
 * Decompiled with CFR 0.152.
 */
package br.com.linkcom.neo.persistence;

import br.com.linkcom.neo.util.ReflectionCache;
import br.com.linkcom.neo.util.ReflectionCacheFactory;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.metadata.CollectionMetadata;
import org.hibernate.persister.entity.AbstractEntityPersister;
import org.hibernate.type.CollectionType;
import org.hibernate.type.ManyToOneType;
import org.hibernate.type.Type;
import org.springframework.jdbc.support.SQLExceptionTranslator;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.HibernateTemplate;
import org.springframework.orm.hibernate3.SessionFactoryUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SaveOrUpdateStrategy {
    private Object entity;
    private HibernateTemplate hibernateTemplate;
    private List<HibernateCallback> firstCallbacks = new ArrayList<HibernateCallback>();
    private List<HibernateCallback> callbacks = new ArrayList<HibernateCallback>();
    private List<HibernateCallback> attachments = new ArrayList<HibernateCallback>();

    public SaveOrUpdateStrategy(HibernateTemplate hibernateTemplate, Object entity) {
        this.hibernateTemplate = hibernateTemplate;
        this.entity = entity;
    }

    public Object getEntity() {
        return this.entity;
    }

    public SaveOrUpdateStrategy setEntity(Object entity) {
        this.entity = entity;
        return this;
    }

    public SaveOrUpdateStrategy setParent(String path, String parentProperty) {
        try {
            ReflectionCache reflectionCache = ReflectionCacheFactory.getReflectionCache();
            Method method = reflectionCache.getMethod(this.entity.getClass(), "get" + StringUtils.capitalize((String)path), new Class[0]);
            Collection collection = (Collection)method.invoke(this.entity, new Object[0]);
            Method parentSetMethod = null;
            if (collection != null) {
                for (Object object : collection) {
                    if (parentSetMethod == null) {
                        Method[] methods;
                        Method[] methodArray = methods = reflectionCache.getMethods(object.getClass());
                        int n = methods.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Class<?>[] parameterTypes;
                            Method setMethod = methodArray[n2];
                            if (setMethod.getName().equals("set" + StringUtils.capitalize((String)parentProperty)) && (parameterTypes = setMethod.getParameterTypes()).length == 1 && parameterTypes[0].isAssignableFrom(this.entity.getClass())) {
                                if (parentSetMethod != null) {
                                    throw new RuntimeException("N\u00e3o \u00e9 poss\u00edvel determinar m\u00e9todo setter para " + this.entity.getClass().getName() + " na classe " + object.getClass().getName() + ". Existe mais de um setter");
                                }
                                parentSetMethod = setMethod;
                            }
                            ++n2;
                        }
                        if (parentSetMethod == null) {
                            throw new RuntimeException("N\u00e3o \u00e9 poss\u00edvel determinar m\u00e9todo setter para " + this.entity.getClass().getName() + " '" + "set" + StringUtils.capitalize((String)parentProperty) + "()' na classe " + object.getClass().getName() + ". N\u00e3o existe nenhum setter");
                        }
                    }
                    parentSetMethod.invoke(object, this.entity);
                }
            }
            return this;
        }
        catch (Exception e) {
            throw new RuntimeException("Problema ao configurar a propriedade pai", e);
        }
    }

    public SaveOrUpdateStrategy saveEntity() {
        HibernateCallback callback = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                session.clear();
                session.saveOrUpdate(SaveOrUpdateStrategy.this.entity);
                return null;
            }
        };
        this.callbacks.add(callback);
        return this;
    }

    public SaveOrUpdateStrategy flush() {
        return this.flush(false);
    }

    private SaveOrUpdateStrategy flush(boolean insertFirst) {
        HibernateCallback callback = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                session.flush();
                return null;
            }
        };
        if (insertFirst) {
            this.firstCallbacks.add(callback);
        } else {
            this.callbacks.add(callback);
        }
        return this;
    }

    public SaveOrUpdateStrategy saveCollection(String path) {
        try {
            ReflectionCache reflectionCache = ReflectionCacheFactory.getReflectionCache();
            Method method = reflectionCache.getMethod(this.entity.getClass(), "get" + StringUtils.capitalize((String)path), new Class[0]);
            final Collection collection = (Collection)method.invoke(this.entity, new Object[0]);
            this.callbacks.add(new HibernateCallback(){

                public Object doInHibernate(Session session) throws HibernateException, SQLException {
                    if (collection == null) {
                        return null;
                    }
                    for (Object next : collection) {
                        session.saveOrUpdate(next);
                    }
                    return null;
                }
            });
            return this;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public SaveOrUpdateStrategy deleteNotInEntity(String path, String parentProperty, Class itemClass) {
        return this.deleteNotInEntity(path, parentProperty, itemClass, false);
    }

    public SaveOrUpdateStrategy deleteNotInEntity(String path) {
        SessionFactory sessionFactory = this.hibernateTemplate.getSessionFactory();
        Class itemClass = this.getItemClass(path, sessionFactory);
        String parentProperty = this.getParentProperty(sessionFactory, itemClass);
        return this.deleteNotInEntity(path, parentProperty, itemClass);
    }

    private SaveOrUpdateStrategy deleteNotInEntity(String path, String parentProperty, Class itemClass, boolean insertFirst) {
        try {
            Object deleteCallback;
            Serializable entityid = this.hibernateTemplate.getSessionFactory().getClassMetadata(this.entity.getClass()).getIdentifier(this.entity, EntityMode.POJO);
            if (entityid == null) {
                return this;
            }
            ReflectionCache reflectionCache = ReflectionCacheFactory.getReflectionCache();
            Method method = reflectionCache.getMethod(this.entity.getClass(), "get" + StringUtils.capitalize((String)path), new Class[0]);
            Collection collection = (Collection)method.invoke(this.entity, new Object[0]);
            if (collection == null || collection.size() == 0) {
                final String deleteQueryString = "delete " + itemClass.getName() + " where " + parentProperty + " = :" + parentProperty;
                final String _parentProperty = parentProperty;
                deleteCallback = new HibernateCallback(){

                    public Object doInHibernate(Session session) throws HibernateException {
                        Query queryObject = session.createQuery(deleteQueryString);
                        queryObject.setEntity(_parentProperty, SaveOrUpdateStrategy.this.entity);
                        queryObject.executeUpdate();
                        return null;
                    }
                };
            } else {
                ClassMetadata metadata = this.hibernateTemplate.getSessionFactory().getClassMetadata(itemClass);
                final List toDelete = this.findItensToDelete(parentProperty, itemClass, collection, metadata);
                if (toDelete.size() == 0) {
                    return this;
                }
                deleteCallback = new HibernateCallback(){

                    public Object doInHibernate(Session session) throws HibernateException {
                        for (Object object : toDelete) {
                            session.delete(object);
                        }
                        return null;
                    }
                };
            }
            if (insertFirst) {
                this.firstCallbacks.add((HibernateCallback)deleteCallback);
            } else {
                this.callbacks.add((HibernateCallback)deleteCallback);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    private List findItensToDelete(final String parentProperty, final Class itemClass, final Collection<?> collection, final ClassMetadata metadata) {
        List toDelete = this.hibernateTemplate.executeFind(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q;
                String findQueryString;
                ArrayList itens = new ArrayList(collection);
                Iterator iter = itens.iterator();
                while (iter.hasNext()) {
                    Object entity = iter.next();
                    Serializable id = metadata.getIdentifier(entity, EntityMode.POJO);
                    if (id != null) continue;
                    iter.remove();
                }
                if (itens.size() == 0) {
                    findQueryString = "from " + itemClass.getName() + " " + StringUtils.uncapitalize((String)itemClass.getSimpleName()) + " where " + StringUtils.uncapitalize((String)itemClass.getSimpleName()) + '.' + parentProperty + " = :" + SaveOrUpdateStrategy.this.entity.getClass().getSimpleName();
                    q = session.createQuery(findQueryString);
                    q.setEntity(SaveOrUpdateStrategy.this.entity.getClass().getSimpleName(), SaveOrUpdateStrategy.this.entity);
                    return q.list();
                }
                findQueryString = "from " + itemClass.getName() + " " + StringUtils.uncapitalize((String)itemClass.getSimpleName()) + " where " + StringUtils.uncapitalize((String)itemClass.getSimpleName()) + " not in (:collection)  and " + StringUtils.uncapitalize((String)itemClass.getSimpleName()) + '.' + parentProperty + " = :" + SaveOrUpdateStrategy.this.entity.getClass().getSimpleName();
                q = session.createQuery(findQueryString);
                q.setParameterList("collection", itens);
                q.setEntity(SaveOrUpdateStrategy.this.entity.getClass().getSimpleName(), SaveOrUpdateStrategy.this.entity);
                return q.list();
            }
        });
        return toDelete;
    }

    public SaveOrUpdateStrategy saveOrUpdateManaged(String path, String parentProperty, Class itemClass) {
        this.executeManagedSaving(path, itemClass, parentProperty);
        return this;
    }

    public SaveOrUpdateStrategy saveOrUpdateManagedDeleteFirst(String path) {
        try {
            SessionFactory sessionFactory = this.hibernateTemplate.getSessionFactory();
            Class itemClass = this.getItemClass(path, sessionFactory);
            String parentProperty = this.getParentProperty(sessionFactory, itemClass);
            this.executeManagedSavingDeleteFirst(path, itemClass, parentProperty);
        }
        catch (Exception e) {
            throw new RuntimeException("N\u00e3o foi poss\u00edvel usar o saveOrUpdateManaged(String) para " + this.entity.getClass().getName() + "! Poss\u00edveis causas: " + "A os itens do collection n\u00e3o possuem referencia para o pai, O path estava incorreto. O path leva a uma cole\u00e7\u00e3o que n\u00e3o tem classe persistente", e);
        }
        return this;
    }

    private void executeManagedSavingDeleteFirst(String path, Class itemClass, String parentProperty) {
        this.deleteNotInEntity(path, parentProperty, itemClass, true);
        this.flush(true);
        this.setParent(path, parentProperty);
        this.saveCollection(path);
    }

    public SaveOrUpdateStrategy saveOrUpdateManaged(String path) {
        return this.saveOrUpdateManagedDeleteFirst(path);
    }

    public SaveOrUpdateStrategy saveOrUpdateManagedNormal(String path) {
        try {
            SessionFactory sessionFactory = this.hibernateTemplate.getSessionFactory();
            Class itemClass = this.getItemClass(path, sessionFactory);
            String parentProperty = this.getParentProperty(sessionFactory, itemClass);
            this.executeManagedSaving(path, itemClass, parentProperty);
        }
        catch (Exception e) {
            throw new RuntimeException("N\u00e3o foi poss\u00edvel usar o saveOrUpdateManaged(String) para " + this.entity.getClass().getName() + "! Poss\u00edveis causas: " + "A os itens do collection n\u00e3o possuem referencia para o pai, O path estava incorreto. O path leva a uma cole\u00e7\u00e3o que n\u00e3o tem classe persistente", e);
        }
        return this;
    }

    private String getParentProperty(SessionFactory sessionFactory, Class itemClass) {
        AbstractEntityPersister persister = (AbstractEntityPersister)sessionFactory.getClassMetadata(itemClass);
        int i = 0;
        ArrayList<Integer> propriedadesPai = new ArrayList<Integer>();
        Type[] typeArray = persister.getPropertyTypes();
        int n = typeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ManyToOneType manyToOneType;
            Class returnedClass;
            Type ptype = typeArray[n2];
            if (ptype instanceof ManyToOneType && (returnedClass = (manyToOneType = (ManyToOneType)ptype).getReturnedClass()).isAssignableFrom(this.entity.getClass())) {
                manyToOneType.getName();
                propriedadesPai.add(i);
            }
            ++i;
            ++n2;
        }
        if (propriedadesPai.size() > 1) {
            throw new RuntimeException("N\u00e3o \u00e9 poss\u00edvel determinar a classe pai para a propriedade. Existem " + propriedadesPai.size() + " referencias da classe " + itemClass.getSimpleName() + " para a classe " + this.entity.getClass().getSimpleName());
        }
        if (propriedadesPai.size() == 0) {
            throw new RuntimeException("N\u00e3o \u00e9 poss\u00edvel determinar a classe pai para a propriedade. N\u00e3o existem referencias da classe " + itemClass.getSimpleName() + " para a classe " + this.entity.getClass().getSimpleName());
        }
        String parentProperty = persister.getPropertyNames()[(Integer)propriedadesPai.get(0)];
        return parentProperty;
    }

    private Class getItemClass(String path, SessionFactory sessionFactory) {
        AbstractEntityPersister metadata = (AbstractEntityPersister)sessionFactory.getClassMetadata(this.entity.getClass());
        CollectionType type = (CollectionType)metadata.getPropertyType(path);
        String role = type.getRole();
        CollectionMetadata collectionMetadata = sessionFactory.getCollectionMetadata(role);
        Type collectionElementType = collectionMetadata.getElementType();
        Class itemClass = collectionElementType.getReturnedClass();
        return itemClass;
    }

    private void executeManagedSaving(String path, Class itemClass, String parentProperty) {
        this.setParent(path, parentProperty);
        this.deleteNotInEntity(path, parentProperty, itemClass);
        this.saveCollection(path);
    }

    public void execute() {
        Session session = SessionFactoryUtils.getSession((SessionFactory)this.hibernateTemplate.getSessionFactory(), (Interceptor)this.hibernateTemplate.getEntityInterceptor(), (SQLExceptionTranslator)this.hibernateTemplate.getJdbcExceptionTranslator());
        Transaction transaction = session.getTransaction();
        boolean intransaction = true;
        if (!transaction.isActive()) {
            transaction = session.beginTransaction();
            intransaction = false;
        }
        try {
            try {
                this.hibernateTemplate.execute(new HibernateCallback(){

                    public Object doInHibernate(Session session) throws HibernateException, SQLException {
                        List callbacks = SaveOrUpdateStrategy.this.getCallbacks();
                        for (HibernateCallback callback : callbacks) {
                            callback.doInHibernate(session);
                        }
                        return null;
                    }
                });
                if (!intransaction) {
                    transaction.commit();
                }
            }
            catch (RuntimeException e) {
                if (!intransaction) {
                    transaction.rollback();
                }
                throw e;
            }
            catch (Exception e) {
                if (!intransaction) {
                    transaction.rollback();
                }
                throw new RuntimeException(e);
            }
        }
        finally {
            SessionFactoryUtils.releaseSession((Session)session, (SessionFactory)this.hibernateTemplate.getSessionFactory());
        }
    }

    @Deprecated
    public void executeInTransaction() {
        this.hibernateTemplate.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                List callbacks = SaveOrUpdateStrategy.this.getCallbacks();
                for (HibernateCallback callback : callbacks) {
                    callback.doInHibernate(session);
                }
                return null;
            }
        });
    }

    public SaveOrUpdateStrategy attach(SaveOrUpdateStrategy strategy) {
        if (strategy == null) {
            throw new NullPointerException("SaveOrUpdateStrategy null");
        }
        this.attachments.addAll(strategy.getCallbacks());
        return this;
    }

    public SaveOrUpdateStrategy attach(HibernateCallback callback) {
        if (callback == null) {
            throw new NullPointerException("HibernateCallback null");
        }
        this.attachments.add(callback);
        return this;
    }

    private List<HibernateCallback> getCallbacks() {
        ArrayList<HibernateCallback> callbacks = new ArrayList<HibernateCallback>();
        callbacks.addAll(this.firstCallbacks);
        callbacks.addAll(this.callbacks);
        callbacks.addAll(this.attachments);
        return callbacks;
    }
}

