/*
 * Decompiled with CFR 0.152.
 */
package br.com.linkcom.neo.persistence;

import br.com.linkcom.neo.core.standard.Neo;
import br.com.linkcom.neo.util.ReflectionCache;
import br.com.linkcom.neo.util.ReflectionCacheFactory;
import java.sql.SQLException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.support.SQLErrorCodeSQLExceptionTranslator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PostgreSQLErrorCodeSQLExceptionTranslator
extends SQLErrorCodeSQLExceptionTranslator {
    static String errorRegexInglesNull = "ERROR: null value in column \"(.*)\" violates not-null constraint";
    static Pattern patternInglesNull = Pattern.compile(errorRegexInglesNull);
    static String errorRegexNull = "ERRO: valor nulo na coluna \"(.*)\" viola a restri\u00e7\u00e3o n\u00e3o-nula";
    static Pattern patternNull = Pattern.compile(errorRegexNull);
    static String errorRegex = "ERRO: atualiza\u00e7\u00e3o ou exclus\u00e3o em \"(.*)\" viola restri\u00e7\u00e3o de chave estrangeira \"(.*)\" em \"(.*)\"";
    static String errorRegexIngles = "ERROR: update or delete on \"(.*)\" violates foreign key constraint \"(.*)\" on \"(.*)\"";
    static Pattern pattern = Pattern.compile(errorRegex);
    static Pattern patternIngles = Pattern.compile(errorRegexIngles);
    static final Log log = LogFactory.getLog(PostgreSQLErrorCodeSQLExceptionTranslator.class);
    private DataSource dataSource;

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        super.setDataSource(dataSource);
        this.dataSource = dataSource;
    }

    private String getTableName(Class<?> entityClass) {
        ReflectionCache reflectionCache = ReflectionCacheFactory.getReflectionCache();
        Table table = reflectionCache.getAnnotation(entityClass, Table.class);
        if (table != null) {
            return table.name().toUpperCase();
        }
        return entityClass.getSimpleName().toUpperCase();
    }

    protected DataAccessException customTranslate(String task, String sql, SQLException sqlEx) {
        if (sqlEx.getNextException() == null) {
            return null;
        }
        String errorMessage = sqlEx.getNextException().getMessage();
        Matcher matcher = pattern.matcher(errorMessage);
        Matcher matcherIngles = patternIngles.matcher(errorMessage);
        Matcher matcherNullIngles = patternInglesNull.matcher(errorMessage);
        Matcher matcherNull = patternNull.matcher(errorMessage);
        System.out.println(">>> " + errorMessage);
        if (!matcher.find()) {
            matcher = matcherIngles;
        } else {
            matcher.reset();
        }
        if (matcher.find()) {
            String fk_table_name = matcher.group(3).toUpperCase();
            String pk_table_name = matcher.group(1).toUpperCase();
            String fkTableDisplayName = null;
            String pkTableDisplayName = null;
            Class<?>[] entities = Neo.getApplicationContext().getClassManager().getClassesWithAnnotation(Entity.class);
            pkTableDisplayName = pk_table_name;
            fkTableDisplayName = fk_table_name;
            Class<?>[] classArray = entities;
            int n = entities.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> entityClass = classArray[n2];
                String tableName = this.getTableName(entityClass);
                if (tableName.equals(pk_table_name)) {
                    pkTableDisplayName = Neo.getApplicationContext().getBeanDescriptor(null, entityClass).getDisplayName();
                }
                if (tableName.equals(fk_table_name)) {
                    fkTableDisplayName = Neo.getApplicationContext().getBeanDescriptor(null, entityClass).getDisplayName();
                }
                ++n2;
            }
            String mensagem = null;
            if (sql.toLowerCase().trim().startsWith("delete")) {
                mensagem = "N\u00e3o foi poss\u00edvel remover " + pkTableDisplayName + ". Existe(m) registro(s) vinculado(s) em " + fkTableDisplayName + ".";
            } else if (sql.toLowerCase().trim().startsWith("update")) {
                mensagem = "N\u00e3o foi poss\u00edvel atualizar " + fkTableDisplayName + ". A refer\u00eancia para " + pkTableDisplayName + " \u00e9 inv\u00e1lida.";
            } else if (sql.toLowerCase().trim().startsWith("insert")) {
                mensagem = "N\u00e3o foi poss\u00edvel inserir " + fkTableDisplayName + ". A refer\u00eancia para " + pkTableDisplayName + " \u00e9 inv\u00e1lida.";
            }
            return new ForeignKeyException(mensagem);
        }
        if (matcherNullIngles.find()) {
            return new ApplicationDatabaseException(errorMessage);
        }
        if (matcherNull.find()) {
            return new ApplicationDatabaseException(errorMessage);
        }
        int indexOf = errorMessage.indexOf("APP");
        if (indexOf > 0) {
            errorMessage = errorMessage.substring(indexOf + 3);
            return new ApplicationDatabaseException(errorMessage);
        }
        return null;
    }

    public static void main(String[] args) {
        String msg = "ERROR: update or delete on \"campus\" violates foreign key constraint \"fk_curso_campus\" on \"curso\"\n  Detalhe: Key (cdcampus)=(1) is still referenced from table \"curso\".";
        Matcher matcher = patternIngles.matcher(msg);
        if (matcher.find()) {
            String fk_name = matcher.group(2);
            System.out.println(fk_name);
            String fk_table_name = matcher.group(3).toUpperCase();
            System.out.println(fk_table_name);
            String pk_table_name = matcher.group(1).toUpperCase();
            System.out.println(pk_table_name);
        } else {
            System.out.println("false");
        }
    }

    public static class ApplicationDatabaseException
    extends DataAccessException {
        private static final long serialVersionUID = 1L;

        public ApplicationDatabaseException(String msg) {
            super(msg);
        }
    }

    public static class ForeignKeyException
    extends DataAccessException {
        private static final long serialVersionUID = 1L;

        public ForeignKeyException(String msg) {
            super(msg);
        }
    }
}

