/*
 * Decompiled with CFR 0.152.
 */
package br.com.linkcom.neo.persistence;

import br.com.linkcom.neo.persistence.AliasMap;
import br.com.linkcom.neo.persistence.ObjectTree;
import br.com.linkcom.neo.persistence.QueryBuilderResultTranslatorImpl;
import br.com.linkcom.neo.util.Util;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

class ObjectTreeBuilder {
    List<ObjectCreator> creators = new ArrayList<ObjectCreator>();

    ObjectTreeBuilder() {
    }

    void init(AliasMap[] aliasMaps) {
        AliasMap[] aliasMapArray = aliasMaps;
        int n = aliasMaps.length;
        int n2 = 0;
        while (n2 < n) {
            AliasMap map = aliasMapArray[n2];
            if (map.path == null) {
                this.creators.add(new RootObjectCreator(map.type, map.alias, map.pkPropertyIndex));
            } else if (map.collectionType != null) {
                this.creators.add(new CollectionObjectCreator(map, map.collectionType, map.type, map.alias, map.path, aliasMaps, map.pkPropertyIndex));
            } else {
                this.creators.add(new ReferenceObjectCreator(map.type, map.alias, map.path, aliasMaps, map.pkPropertyIndex));
            }
            ++n2;
        }
    }

    public ObjectTreeBuilder getThreadSafeInstance() {
        ObjectTreeBuilder objectTreeBuilder = new ObjectTreeBuilder();
        for (ObjectCreator creator : this.creators) {
            objectTreeBuilder.creators.add(creator.getThreadSafeObjectCretor());
        }
        return objectTreeBuilder;
    }

    ObjectTree buildObjectTree(Object[] values) {
        ObjectTree objectTree = new ObjectTree();
        for (ObjectCreator creator : this.creators) {
            CreateResult create = creator.create(objectTree, values);
            String alias = creator.getAlias();
            objectTree.aliasObject.put(alias, create.object);
            if (!(creator instanceof RootObjectCreator)) continue;
            objectTree.root = create.object;
            objectTree.isNew = create.isNew;
        }
        for (ObjectCreator creator : this.creators) {
            creator.setMapping(objectTree);
        }
        return objectTree;
    }

    class CollectionObjectCreator
    implements ObjectCreator {
        private String alias;
        private Class collectionItemClass;
        private String path;
        private String owneralias;
        private Method setter;
        private Object lastCreatedObject;
        private int i;
        private Class collectionClass;
        private Method getter;
        private Set<AliasMap> dependencias;
        private Map<Map<String, Object>, Object> objects = new HashMap<Map<String, Object>, Object>();

        public CollectionObjectCreator() {
        }

        public CollectionObjectCreator(AliasMap map, Class collectionItemClass, Class collectionClass, String alias, String path, AliasMap[] aliasMaps, int i) {
            this.alias = alias;
            this.collectionItemClass = collectionItemClass;
            this.collectionClass = collectionClass;
            this.path = path;
            this.owneralias = path.substring(0, path.indexOf(46));
            this.i = i;
            String property = path.substring(path.indexOf(46) + 1);
            Class owner = QueryBuilderResultTranslatorImpl.getOwner(aliasMaps, this.owneralias);
            this.setter = Util.beans.getSetterMethod(owner, property);
            this.getter = Util.beans.getGetterMethod(owner, property);
            this.dependencias = map.dependencias;
        }

        public CreateResult create(ObjectTree objectTree, Object[] values) {
            try {
                Object newInstance = null;
                HashMap<String, Object> chave = new HashMap<String, Object>();
                for (AliasMap dp : this.dependencias) {
                    chave.put(dp.alias, values[dp.pkPropertyIndex]);
                }
                boolean usenull = false;
                if (values[this.i] != null && (newInstance = this.objects.get(chave)) == null) {
                    newInstance = this.collectionItemClass.newInstance();
                    this.objects.put(chave, newInstance);
                } else {
                    usenull = true;
                }
                this.lastCreatedObject = newInstance;
                if (usenull) {
                    this.lastCreatedObject = null;
                }
                CreateResult createResult = new CreateResult(false, newInstance);
                return createResult;
            }
            catch (InstantiationException e) {
                if (Collection.class.isAssignableFrom(this.collectionItemClass)) {
                    throw new RuntimeException("Erro ao criar o objeto da query: " + this.collectionItemClass.getName() + "  " + this.path + ". Joins com tipos Collection (Set, List) n\u00e3o s\u00e3o suportados", e);
                }
                throw new RuntimeException("Erro ao criar o objeto da query: " + this.collectionItemClass.getName() + "  " + this.path, e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Erro ao criar o objeto da query. " + this.collectionItemClass.getSimpleName() + "  " + this.path, e);
            }
        }

        public String getAlias() {
            return this.alias;
        }

        public void setMapping(ObjectTree objectTree) {
            Object owner = objectTree.aliasObject.get(this.owneralias);
            try {
                if (owner == null && objectTree.getAliasObject().get(this.alias) == null) {
                    return;
                }
                Collection collection = (Collection)this.getter.invoke(owner, new Object[0]);
                if (collection == null) {
                    collection = (Collection)this.collectionClass.newInstance();
                }
                if (this.lastCreatedObject != null) {
                    collection.add(this.lastCreatedObject);
                }
                this.setter.invoke(owner, collection);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public ObjectCreator getThreadSafeObjectCretor() {
            CollectionObjectCreator collectionObjectCreator = new CollectionObjectCreator();
            collectionObjectCreator.alias = this.alias;
            collectionObjectCreator.collectionItemClass = this.collectionItemClass;
            collectionObjectCreator.path = this.path;
            collectionObjectCreator.owneralias = this.owneralias;
            collectionObjectCreator.setter = this.setter;
            collectionObjectCreator.lastCreatedObject = this.lastCreatedObject;
            collectionObjectCreator.i = this.i;
            collectionObjectCreator.collectionClass = this.collectionClass;
            collectionObjectCreator.getter = this.getter;
            collectionObjectCreator.dependencias = this.dependencias;
            return collectionObjectCreator;
        }
    }

    class CreateResult {
        boolean isNew = false;
        Object object;

        public CreateResult(Object object) {
            this.object = object;
        }

        public CreateResult(boolean isNew, Object object) {
            this.isNew = isNew;
            this.object = object;
        }
    }

    static interface ObjectCreator {
        public CreateResult create(ObjectTree var1, Object[] var2);

        public String getAlias();

        public void setMapping(ObjectTree var1);

        public ObjectCreator getThreadSafeObjectCretor();
    }

    class ReferenceObjectCreator
    implements ObjectCreator {
        private String alias;
        private Class clazz;
        private String path;
        private String owneralias;
        private Method setter;
        private Object lastCreatedObject;
        private int i;

        public ReferenceObjectCreator(Class clazz, String alias, String path, AliasMap[] aliasMaps, int i) {
            this.alias = alias;
            this.clazz = clazz;
            this.path = path;
            this.owneralias = path.substring(0, path.indexOf(46));
            this.i = i;
            String property = path.substring(path.indexOf(46) + 1);
            Class owner = QueryBuilderResultTranslatorImpl.getOwner(aliasMaps, this.owneralias);
            this.setter = Util.beans.getSetterMethod(owner, property);
        }

        public CreateResult create(ObjectTree objectTree, Object[] values) {
            try {
                Object newInstance = null;
                if (values[this.i] != null) {
                    newInstance = this.clazz.newInstance();
                }
                this.lastCreatedObject = newInstance;
                CreateResult createResult = new CreateResult(false, newInstance);
                return createResult;
            }
            catch (InstantiationException e) {
                if (Collection.class.isAssignableFrom(this.clazz)) {
                    throw new RuntimeException("Erro ao criar o objeto da query: " + this.clazz.getName() + "  " + this.path + ". Joins com tipos Collection (Set, List) n\u00e3o s\u00e3o suportados", e);
                }
                throw new RuntimeException("Erro ao criar o objeto da query: " + this.clazz.getName() + "  " + this.path, e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Erro ao criar o objeto da query. " + this.clazz.getSimpleName() + "  " + this.path, e);
            }
        }

        public String getAlias() {
            return this.alias;
        }

        public void setMapping(ObjectTree objectTree) {
            if (this.lastCreatedObject != null) {
                Object owner = objectTree.aliasObject.get(this.owneralias);
                try {
                    this.setter.invoke(owner, this.lastCreatedObject);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }

        public ObjectCreator getThreadSafeObjectCretor() {
            return this;
        }
    }

    class RootObjectCreator
    implements ObjectCreator {
        private Class clazz;
        private String alias;
        private Map<Object, Object> resultados = new HashMap<Object, Object>();
        private int i;

        public RootObjectCreator(Class clazz, String alias, int i) {
            this.clazz = clazz;
            this.alias = alias;
            this.i = i;
        }

        public RootObjectCreator() {
        }

        public CreateResult create(ObjectTree objectTree, Object[] values) {
            try {
                Object id = values[this.i];
                Object object = this.resultados.get(id);
                boolean isNew = false;
                if (object == null) {
                    object = this.clazz.newInstance();
                    this.resultados.put(id, object);
                    isNew = true;
                }
                CreateResult createResult = new CreateResult(isNew, object);
                return createResult;
            }
            catch (InstantiationException e) {
                throw new RuntimeException("Erro ao criar o objeto raiz da query. " + this.clazz.getSimpleName(), e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Erro ao criar o objeto raiz da query. " + this.clazz.getSimpleName(), e);
            }
        }

        public String getAlias() {
            return this.alias;
        }

        public void setMapping(ObjectTree objectTree) {
        }

        public ObjectCreator getThreadSafeObjectCretor() {
            RootObjectCreator rootObjectCreator = new RootObjectCreator();
            rootObjectCreator.clazz = this.clazz;
            rootObjectCreator.alias = this.alias;
            rootObjectCreator.i = this.i;
            return rootObjectCreator;
        }
    }
}

