/*
 * Decompiled with CFR 0.152.
 */
package br.com.linkcom.neo.persistence;

import br.com.linkcom.neo.bean.BeanDescriptor;
import br.com.linkcom.neo.bean.BeanDescriptorFactoryImpl;
import br.com.linkcom.neo.bean.annotation.DescriptionProperty;
import br.com.linkcom.neo.controller.crud.FiltroListagem;
import br.com.linkcom.neo.core.standard.Neo;
import br.com.linkcom.neo.persistence.AliasMap;
import br.com.linkcom.neo.persistence.DefaultOrderBy;
import br.com.linkcom.neo.persistence.ListagemResult;
import br.com.linkcom.neo.persistence.QueryBuilder;
import br.com.linkcom.neo.persistence.QueryBuilderResultTranslator;
import br.com.linkcom.neo.persistence.QueryBuilderResultTranslatorImpl;
import br.com.linkcom.neo.persistence.SaveOrUpdateStrategy;
import br.com.linkcom.neo.util.ReflectionCache;
import br.com.linkcom.neo.util.ReflectionCacheFactory;
import br.com.linkcom.neo.util.Util;
import java.lang.annotation.Annotation;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.persistence.Entity;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.SQLExceptionTranslator;
import org.springframework.orm.hibernate3.HibernateTemplate;
import org.springframework.orm.hibernate3.SessionFactoryUtils;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;
import org.springframework.transaction.support.TransactionTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericDAO<BEAN>
extends HibernateDaoSupport {
    protected Class<BEAN> beanClass;
    protected String orderBy;
    protected TransactionTemplate transactionTemplate;
    private JdbcTemplate jdbcTemplate;
    private long cacheTime = 5000L;
    private static final long TEMPO_5_SEGUNDOS = 5000L;
    private QueryBuilderResultTranslator translatorQueryFindForCombo;
    private String queryFindForCombo;
    private long lastRead;
    private WeakReference<List> findForComboCache = new WeakReference<Object>(null);
    private Map<Class, String> mapaQueryFindByForCombo = new WeakHashMap<Class, String>();
    private Map<Class, String> mapaQueryFindBy = new WeakHashMap<Class, String>();
    private String comboSelect;

    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    protected SaveOrUpdateStrategy save(Object entity) {
        return new SaveOrUpdateStrategy(this.getHibernateTemplate(), entity).saveEntity();
    }

    protected final List<BEAN> empty() {
        return new ArrayList();
    }

    protected HibernateTemplate createHibernateTemplate(SessionFactory sessionFactory) {
        if (this.getHibernateTemplate() != null) {
            return this.getHibernateTemplate();
        }
        return super.createHibernateTemplate(sessionFactory);
    }

    public TransactionTemplate getTransactionTemplate() {
        return this.transactionTemplate;
    }

    public void setTransactionTemplate(TransactionTemplate transactionTemplate) {
        this.transactionTemplate = transactionTemplate;
    }

    public GenericDAO(Class<BEAN> beanClass) {
        this.beanClass = beanClass;
        ReflectionCache reflectionCache = ReflectionCacheFactory.getReflectionCache();
        DefaultOrderBy orderBy = reflectionCache.getAnnotation(((Object)((Object)this)).getClass(), DefaultOrderBy.class);
        if (orderBy != null) {
            this.orderBy = orderBy.value();
        }
    }

    public GenericDAO() {
        Class[] classes = Util.generics.getGenericTypes(((Object)((Object)this)).getClass());
        if (classes.length != 1) {
            classes = Util.generics.getGenericTypes2(((Object)((Object)this)).getClass());
            if (classes.length == 1 && !classes[0].equals(Object.class)) {
                this.beanClass = classes[0];
                ReflectionCache reflectionCache = ReflectionCacheFactory.getReflectionCache();
                DefaultOrderBy orderBy = reflectionCache.getAnnotation(((Object)((Object)this)).getClass(), DefaultOrderBy.class);
                if (orderBy != null) {
                    this.orderBy = orderBy.value();
                }
                return;
            }
            throw new RuntimeException("A classe " + ((Object)((Object)this)).getClass().getName() + " deveria especificar um tipo generico BEAN");
        }
        this.beanClass = classes[0];
        ReflectionCache reflectionCache = ReflectionCacheFactory.getReflectionCache();
        DefaultOrderBy orderBy = reflectionCache.getAnnotation(((Object)((Object)this)).getClass(), DefaultOrderBy.class);
        if (orderBy != null) {
            this.orderBy = orderBy.value();
        }
        this.init();
    }

    protected void init() {
    }

    protected QueryBuilder<BEAN> query() {
        return this.newQueryBuilder(this.beanClass).from(this.beanClass);
    }

    public <E> QueryBuilder<E> newQueryBuilder(Class<E> clazz) {
        return new QueryBuilder(this.getHibernateTemplate());
    }

    public <E> QueryBuilder<E> newQueryBuilderWithFrom(Class<E> clazz) {
        return new QueryBuilder(this.getHibernateTemplate()).from(this.beanClass);
    }

    protected QueryBuilder<BEAN> queryWithOrderBy() {
        QueryBuilder<BEAN> from = this.newQueryBuilder(this.beanClass).from(this.beanClass);
        if (this.orderBy != null) {
            from.orderBy(this.orderBy);
        }
        return from;
    }

    public void saveOrUpdate(BEAN bean) {
        SaveOrUpdateStrategy save = this.save(bean);
        this.updateSaveOrUpdate(save);
        save.execute();
        this.getHibernateTemplate().flush();
    }

    public BEAN load(BEAN bean) {
        if (bean == null) {
            return null;
        }
        return this.query().entity(bean).unique();
    }

    public BEAN loadForEntrada(BEAN bean) {
        if (bean == null) {
            return null;
        }
        QueryBuilder<BEAN> query = this.newQueryBuilder(this.beanClass).from(this.beanClass).entity(bean);
        this.updateEntradaQuery(query);
        return query.unique();
    }

    public List<BEAN> findForCombo(String ... extraFields) {
        List listCached;
        if (extraFields != null && extraFields.length > 0) {
            return this.newQueryBuilder(this.beanClass).select(this.getComboSelect(extraFields)).from(this.beanClass).orderBy(this.orderBy).list();
        }
        if (this.queryFindForCombo == null) {
            this.initQueryFindForCombo();
        }
        if ((listCached = (List)this.findForComboCache.get()) == null || System.currentTimeMillis() - this.lastRead > this.cacheTime) {
            listCached = this.getHibernateTemplate().find(this.queryFindForCombo);
            listCached = this.translatorQueryFindForCombo.translate(listCached);
            this.findForComboCache = new WeakReference(listCached);
            this.lastRead = System.currentTimeMillis();
        }
        return listCached;
    }

    @Deprecated
    public List<BEAN> findForCombo() {
        return this.findForCombo(null);
    }

    public List<BEAN> findBy(Object o, boolean forCombo, String ... extraFields) {
        if (o == null) {
            return new ArrayList();
        }
        Class<?> propertyClass = o.getClass();
        while (propertyClass.getName().contains("$$")) {
            propertyClass = propertyClass.getSuperclass();
        }
        String queryString = null;
        if (extraFields != null && extraFields.length > 0 || forCombo && (queryString = this.mapaQueryFindByForCombo.get(propertyClass)) == null || !forCombo && (queryString = this.mapaQueryFindBy.get(propertyClass)) == null) {
            Object[] propertiesForClass = this.findPropertiesForClass(propertyClass);
            if (propertiesForClass.length == 1) {
                String alias = Util.strings.uncaptalize(this.beanClass.getSimpleName());
                String property = propertiesForClass[0];
                QueryBuilder<BEAN> qb = this.queryWithOrderBy();
                qb.where(String.valueOf(alias) + "." + property + " = ? ", o);
                this.updateFindByQuery(qb);
                if (forCombo) {
                    String hbquery;
                    if (extraFields != null && extraFields.length > 0) {
                        String hbquery2;
                        int i = 0;
                        int j = 0;
                        while (j < extraFields.length) {
                            String extra = extraFields[j];
                            BeanDescriptor<Object> beanDescriptor = Neo.getApplicationContext().getBeanDescriptor(null, this.beanClass);
                            Type type = beanDescriptor.getPropertyDescriptor(extra).getType();
                            if (type instanceof Class && ((Class)type).isAnnotationPresent(Entity.class)) {
                                extra = String.valueOf(extra) + "." + Neo.getApplicationContext().getBeanDescriptor(null, (Class)type).getDescriptionPropertyName();
                            }
                            if (extra.contains(".")) {
                                int ultimoponto = extra.lastIndexOf(".");
                                String path = extra.substring(0, ultimoponto);
                                qb.join(String.valueOf(alias) + "." + path + " autojoin" + i);
                                extraFields[j] = "autojoin" + i + extra.substring(ultimoponto);
                            }
                            ++i;
                            ++j;
                        }
                        qb.select(this.getComboSelect(extraFields));
                        queryString = hbquery2 = qb.getQuery();
                        return qb.list();
                    }
                    qb.select(this.getComboSelect(new String[0]));
                    queryString = hbquery = qb.getQuery();
                    this.mapaQueryFindByForCombo.put(propertyClass, queryString);
                } else {
                    String hbquery;
                    queryString = hbquery = qb.getQuery();
                    this.mapaQueryFindByForCombo.put(propertyClass, queryString);
                }
            } else {
                if (propertiesForClass.length > 1) {
                    throw new RuntimeException("N\u00e3o foi poss\u00edvel executar findBy(..). Existe mais de uma propriedade da classe " + propertyClass.getName() + " na classe " + this.beanClass.getName() + "  " + Arrays.deepToString(propertiesForClass));
                }
                throw new RuntimeException("N\u00e3o foi poss\u00edvel executar findBy(..). N\u00e3o existe nenhuma propriedade da classe " + propertyClass.getName() + " na classe " + this.beanClass.getName());
            }
        }
        List list = this.getHibernateTemplate().find(queryString, o);
        if (forCombo) {
            this.initQueryFindForCombo();
            list = this.translatorQueryFindForCombo.translate(list);
        }
        return list;
    }

    protected void updateFindByQuery(QueryBuilder query) {
    }

    private String[] findPropertiesForClass(Class<? extends Object> propertyClass) {
        Method[] methods;
        ArrayList<String> properties = new ArrayList<String>();
        ReflectionCache reflectionCache = ReflectionCacheFactory.getReflectionCache();
        Method[] methodArray = methods = reflectionCache.getMethods(this.beanClass);
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (Util.beans.isGetter(method) && method.getReturnType().equals(propertyClass)) {
                properties.add(Util.beans.getPropertyFromGetter(method.getName()));
            }
            ++n2;
        }
        return properties.toArray(new String[properties.size()]);
    }

    public String getComboSelect(String ... extraFields) {
        if (this.comboSelect == null || extraFields != null && extraFields.length > 0) {
            String alias = Util.strings.uncaptalize(this.beanClass.getSimpleName());
            String[] selectedProperties = this.getComboSelectedProperties(alias);
            selectedProperties = this.organizeExtraFields(alias, selectedProperties, extraFields);
            String comboSelect = "";
            int i = 0;
            while (i < selectedProperties.length) {
                String prop = selectedProperties[i];
                comboSelect = String.valueOf(comboSelect) + prop;
                if (i + 1 < selectedProperties.length) {
                    comboSelect = String.valueOf(comboSelect) + ", ";
                }
                ++i;
            }
            if (extraFields == null || extraFields.length <= 0) {
                this.comboSelect = comboSelect;
            } else {
                return comboSelect;
            }
        }
        return this.comboSelect;
    }

    protected String[] getComboSelectedProperties(String alias) {
        String[] selectedProperties;
        BeanDescriptor<Object> beanDescriptor = new BeanDescriptorFactoryImpl().createBeanDescriptor(null, this.beanClass);
        String descriptionPropertyName = beanDescriptor.getDescriptionPropertyName();
        String idPropertyName = beanDescriptor.getIdPropertyName();
        if (descriptionPropertyName == null) {
            selectedProperties = new String[]{String.valueOf(alias) + "." + idPropertyName};
        } else {
            Annotation[] annotations = beanDescriptor.getPropertyDescriptor(descriptionPropertyName).getAnnotations();
            DescriptionProperty descriptionProperty = null;
            Annotation[] annotationArray = annotations;
            int n = annotations.length;
            int n2 = 0;
            while (n2 < n) {
                Annotation annotation = annotationArray[n2];
                if (DescriptionProperty.class.isAssignableFrom(annotation.annotationType())) {
                    descriptionProperty = (DescriptionProperty)annotation;
                    break;
                }
                ++n2;
            }
            String[] usingFields = null;
            if (descriptionProperty != null) {
                usingFields = descriptionProperty.usingFields();
            }
            if (usingFields != null && usingFields.length > 0) {
                selectedProperties = new String[usingFields.length + 1];
                selectedProperties[0] = String.valueOf(alias) + "." + idPropertyName;
                int i = 0;
                while (i < usingFields.length) {
                    selectedProperties[i + 1] = String.valueOf(alias) + "." + usingFields[i];
                    ++i;
                }
            } else {
                selectedProperties = new String[]{String.valueOf(alias) + "." + idPropertyName, String.valueOf(alias) + "." + descriptionPropertyName};
            }
        }
        return selectedProperties;
    }

    private void initQueryFindForCombo() {
        if (this.translatorQueryFindForCombo == null) {
            String alias = Util.strings.uncaptalize(this.beanClass.getSimpleName());
            String[] selectedProperties = this.getComboSelectedProperties(alias);
            String hbQueryFindForCombo = "select " + this.getComboSelect(new String[0]) + " " + "from " + this.beanClass.getName() + " " + alias;
            hbQueryFindForCombo = this.getQueryFindForCombo(hbQueryFindForCombo);
            if (this.orderBy != null) {
                hbQueryFindForCombo = String.valueOf(hbQueryFindForCombo) + "  order by " + this.orderBy;
            }
            this.translatorQueryFindForCombo = new QueryBuilderResultTranslatorImpl();
            this.translatorQueryFindForCombo.init(selectedProperties, new AliasMap[]{new AliasMap(alias, null, this.beanClass)});
            this.queryFindForCombo = hbQueryFindForCombo;
        }
    }

    private String[] organizeExtraFields(String alias, String[] selectedProperties, String ... extraFields) {
        if (extraFields != null && extraFields.length > 0) {
            int i = 0;
            while (i < extraFields.length) {
                if (!extraFields[i].contains(".")) {
                    extraFields[i] = String.valueOf(alias) + "." + extraFields[i];
                }
                ++i;
            }
            String[] oldselectedProperties = selectedProperties;
            selectedProperties = new String[selectedProperties.length + extraFields.length];
            System.arraycopy(oldselectedProperties, 0, selectedProperties, 0, oldselectedProperties.length);
            System.arraycopy(extraFields, 0, selectedProperties, oldselectedProperties.length, extraFields.length);
        }
        return selectedProperties;
    }

    protected String getQueryFindForCombo(String hbQueryFindForCombo) {
        return hbQueryFindForCombo;
    }

    public List<BEAN> findAll() {
        return this.findAll(null);
    }

    public List<BEAN> findAll(String orderBy) {
        return this.query().orderBy(orderBy).list();
    }

    public ListagemResult<BEAN> findForListagem(FiltroListagem filtro) {
        QueryBuilder<BEAN> query = this.query();
        query.orderBy(String.valueOf(Util.strings.uncaptalize(this.beanClass.getSimpleName())) + ".id");
        this.updateListagemQuery(query, filtro);
        QueryBuilder<BEAN> queryBuilder = query;
        return new ListagemResult<BEAN>(queryBuilder, filtro);
    }

    public void updateListagemQuery(QueryBuilder<BEAN> query, FiltroListagem _filtro) {
    }

    public void updateEntradaQuery(QueryBuilder<BEAN> query) {
    }

    public void updateSaveOrUpdate(SaveOrUpdateStrategy save) {
    }

    public void delete(BEAN bean) {
        Session session = SessionFactoryUtils.getSession((SessionFactory)this.getHibernateTemplate().getSessionFactory(), (Interceptor)this.getHibernateTemplate().getEntityInterceptor(), (SQLExceptionTranslator)this.getHibernateTemplate().getJdbcExceptionTranslator());
        Transaction transaction = session.getTransaction();
        boolean intransaction = true;
        if (!transaction.isActive()) {
            transaction = session.beginTransaction();
            intransaction = false;
        }
        try {
            try {
                this.getHibernateTemplate().delete(bean);
                session.flush();
                if (!intransaction) {
                    transaction.commit();
                }
            }
            catch (HibernateException ex) {
                if (!intransaction) {
                    transaction.rollback();
                }
                throw this.convertHibernateAccessException(ex);
            }
            catch (RuntimeException e) {
                if (!intransaction) {
                    transaction.rollback();
                }
                throw e;
            }
            catch (Exception e) {
                if (!intransaction) {
                    transaction.rollback();
                }
                throw new RuntimeException(e);
            }
        }
        finally {
            SessionFactoryUtils.releaseSession((Session)session, (SessionFactory)this.getHibernateTemplate().getSessionFactory());
        }
    }
}

