/*
 * Decompiled with CFR 0.152.
 */
package br.com.linkcom.neo.core.web.init;

import br.com.linkcom.neo.core.web.init.DataSourceConfigStrategy;
import br.com.linkcom.neo.core.web.init.DataSourceInfo;
import br.com.linkcom.neo.exception.CouldNotCreateDataSourceException;
import br.com.linkcom.neo.exception.NeoException;
import br.com.linkcom.neo.util.Util;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.jdbc.datasource.DriverManagerDataSource;
import org.springframework.jndi.JndiObjectFactoryBean;

class WebDataSourceConfigStrategy
implements DataSourceConfigStrategy {
    Log log = LogFactory.getLog(WebDataSourceConfigStrategy.class);
    private DataSourceInfo dataSourceInfo;
    boolean fromResource = false;

    private void init() {
        ResourceBundle bundle = null;
        try {
            bundle = ResourceBundle.getBundle("connection");
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        if (bundle != null) {
            try {
                String jndi = null;
                try {
                    jndi = bundle.getString("jndi");
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
                String driver = null;
                String url = null;
                String username = null;
                String password = null;
                if (jndi == null) {
                    driver = bundle.getString("driver");
                    url = bundle.getString("url");
                    try {
                        username = bundle.getString("username");
                        password = bundle.getString("password");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.dataSourceInfo = new DataSourceInfo(jndi, driver, url, username, password);
            }
            catch (MissingResourceException e) {
                throw new NeoException("Erro ao carregar informa\u00e7\u00f5es de connection.properties. O arquivo est\u00e1 incorreto, faltando algum dos parametros: driver, url, jndi");
            }
        }
    }

    public boolean configureDataSource(ConfigurableListableBeanFactory beanFactory) throws CouldNotCreateDataSourceException {
        boolean containsDataSource;
        String dataSourceBeanName = this.getDataSourceBeanName(beanFactory);
        boolean bl = containsDataSource = dataSourceBeanName != null;
        if (!containsDataSource) {
            this.init();
            if (this.dataSourceInfo != null) {
                boolean jndi = this.dataSourceInfo.jndi != null;
                this.log.info((Object)("Criando dataSource com informa\u00e7\u00f5es do arquivo connection.properties. Utilizando: " + (jndi ? " jndi " : " driver, url")));
                final DriverManagerDataSource dmds = new DriverManagerDataSource();
                if (!jndi) {
                    dmds.setUrl(this.dataSourceInfo.url);
                    dmds.setDriverClassName(this.dataSourceInfo.driver);
                    dmds.setUsername(this.dataSourceInfo.username);
                    dmds.setPassword(this.dataSourceInfo.password);
                }
                dataSourceBeanName = dataSourceBeanName != null ? dataSourceBeanName : "dataSource";
                FactoryBean factoryBean = new FactoryBean(){

                    public Object getObject() throws Exception {
                        return dmds;
                    }

                    public Class getObjectType() {
                        return DataSource.class;
                    }

                    public boolean isSingleton() {
                        return true;
                    }
                };
                if (!jndi) {
                    beanFactory.registerSingleton(dataSourceBeanName, (Object)factoryBean);
                } else {
                    MutablePropertyValues propertyValues = new MutablePropertyValues();
                    propertyValues.addPropertyValue("jndiName", (Object)this.dataSourceInfo.jndi);
                    Util.beanFacotries.registerBean(beanFactory, JndiObjectFactoryBean.class, "dataSource", propertyValues);
                }
                containsDataSource = true;
            }
        }
        return containsDataSource;
    }

    private String getDataSourceBeanName(ConfigurableListableBeanFactory beanFactory) {
        String[] beanDefinitionNames;
        String[] stringArray = beanDefinitionNames = beanFactory.getBeanDefinitionNames();
        int n = beanDefinitionNames.length;
        int n2 = 0;
        while (n2 < n) {
            String beanDefinitionName = stringArray[n2];
            BeanDefinition beanDefinition = beanFactory.getBeanDefinition(beanDefinitionName);
            if (beanDefinition instanceof RootBeanDefinition) {
                String beanClassName = ((RootBeanDefinition)beanDefinition).getBeanClassName();
                try {
                    Class<?> forName = Class.forName(beanClassName);
                    if (DataSource.class.isAssignableFrom(forName)) {
                        return beanDefinitionName;
                    }
                    if (FactoryBean.class.isAssignableFrom(forName) && JndiObjectFactoryBean.class.isAssignableFrom(forName) && beanDefinitionName.equals("dataSource")) {
                        return beanDefinitionName;
                    }
                }
                catch (ClassNotFoundException e) {
                    throw new NeoException("O bean configurado com o nome " + beanDefinitionName + " est\u00e1 " + "configurado com uma classe inexistente", e);
                }
            }
            ++n2;
        }
        return null;
    }
}

