/*
 * Decompiled with CFR 0.152.
 */
package br.com.linkcom.neo.core.web.init;

import br.com.linkcom.neo.authorization.AuthorizationDAO;
import br.com.linkcom.neo.classmanager.ClassManager;
import br.com.linkcom.neo.controller.NeoCommonsMultipartResolver;
import br.com.linkcom.neo.core.config.Config;
import br.com.linkcom.neo.core.config.DefaultConfig;
import br.com.linkcom.neo.core.web.init.DataSourceConfigStrategy;
import br.com.linkcom.neo.exception.ConfigurationException;
import br.com.linkcom.neo.exception.NeoException;
import br.com.linkcom.neo.hibernate.AnnotationSessionFactoryBean;
import br.com.linkcom.neo.persistence.OracleSQLErrorCodeSQLExceptionTranslator;
import br.com.linkcom.neo.persistence.PostgreSQLErrorCodeSQLExceptionTranslator;
import br.com.linkcom.neo.persistence.SQLServerSQLErrorCodeSQLExceptionTranslator;
import br.com.linkcom.neo.util.NeoFormater;
import br.com.linkcom.neo.util.NeoImageResolver;
import br.com.linkcom.neo.util.Util;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.SessionFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.SQLErrorCodeSQLExceptionTranslator;
import org.springframework.orm.hibernate3.HibernateTemplate;
import org.springframework.orm.hibernate3.HibernateTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NeoBeanFactoryPostProcessor
implements BeanFactoryPostProcessor {
    protected Map<String, Class> mapaDatabaseSqlErrorTranslators = new HashMap<String, Class>();
    protected Map<String, String> mapaDatabaseDialect = new HashMap<String, String>();
    protected static final Log log = LogFactory.getLog(NeoBeanFactoryPostProcessor.class);
    private ClassManager classManager;
    private boolean configInXML = false;
    private DataSourceConfigStrategy dataSourceConfigStrategy;
    private String configName;
    private boolean authorizationDAOAutoconfig;

    public NeoBeanFactoryPostProcessor(ClassManager classManager, DataSourceConfigStrategy dataSourceConfigStrategy) {
        this.classManager = classManager;
        this.dataSourceConfigStrategy = dataSourceConfigStrategy;
        this.registerMaps();
    }

    private void registerMaps() {
        this.mapaDatabaseSqlErrorTranslators.put("PostgreSQL", PostgreSQLErrorCodeSQLExceptionTranslator.class);
        this.mapaDatabaseSqlErrorTranslators.put("Oracle", OracleSQLErrorCodeSQLExceptionTranslator.class);
        this.mapaDatabaseSqlErrorTranslators.put("Microsoft SQL Server", SQLServerSQLErrorCodeSQLExceptionTranslator.class);
        this.mapaDatabaseDialect.put("PostgreSQL", "org.hibernate.dialect.PostgreSQLDialect");
        this.mapaDatabaseDialect.put("Oracle", "org.hibernate.dialect.Oracle9Dialect");
        this.mapaDatabaseDialect.put("Microsoft SQL Server", "org.hibernate.dialect.SQLServerDialect");
        this.mapaDatabaseDialect.put("MySQL5", "org.hibernate.dialect.MySQL5Dialect");
        this.mapaDatabaseDialect.put("MySQL4", "org.hibernate.dialect.MySQLInnoDBDialect");
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        String databaseName;
        Class class1;
        boolean containsDataSource = this.dataSourceConfigStrategy.configureDataSource(beanFactory);
        this.verificarConfig(beanFactory);
        boolean containsSQLErrorCodeSQLExceptionTranslator = Util.beanFacotries.containsBeanOfClass(beanFactory, SQLErrorCodeSQLExceptionTranslator.class);
        boolean containsNeoImageResolver = Util.beanFacotries.containsBeanOfClass(beanFactory, NeoImageResolver.class);
        boolean containsNeoFormater = Util.beanFacotries.containsBeanOfClass(beanFactory, NeoFormater.class);
        boolean containsAuthorizationDAO = Util.beanFacotries.containsBeanOfClass(beanFactory, AuthorizationDAO.class);
        boolean containsSessionFactory = Util.beanFacotries.containsBeanOfClass(beanFactory, SessionFactory.class);
        boolean containsJdbcTemplate = Util.beanFacotries.containsBeanOfClass(beanFactory, JdbcTemplate.class);
        boolean containsHibernateTemplate = Util.beanFacotries.containsBeanOfClass(beanFactory, HibernateTemplate.class);
        boolean containsPlatformTransactionManager = Util.beanFacotries.containsBeanOfClass(beanFactory, PlatformTransactionManager.class);
        boolean containsTransactionTemplate = Util.beanFacotries.containsBeanOfClass(beanFactory, TransactionTemplate.class);
        if (containsDataSource && !containsSQLErrorCodeSQLExceptionTranslator && (class1 = this.mapaDatabaseSqlErrorTranslators.get(databaseName = this.getDatabaseName(beanFactory))) != null) {
            MutablePropertyValues mpvs = new MutablePropertyValues();
            mpvs.addPropertyValue("dataSource", (Object)new RuntimeBeanReference(this.getDataSourceBeanName(beanFactory)));
            Util.beanFacotries.registerBean(beanFactory, class1, "sqlErrorCodesTranslator", mpvs, false);
            log.info((Object)("Registrando SQLErrorCodesTranslator .. " + class1.getSimpleName() + " para banco de dados " + databaseName));
            containsSQLErrorCodeSQLExceptionTranslator = true;
            this.autowireBean(beanFactory, HibernateTransactionManager.class);
            this.autowireBean(beanFactory, HibernateTemplate.class);
        }
        if (!containsNeoImageResolver) {
            Util.beanFacotries.registerBean(beanFactory, NeoImageResolver.class);
        }
        if (!containsNeoFormater) {
            Util.beanFacotries.registerBean(beanFactory, NeoFormater.class);
        }
        if (!containsAuthorizationDAO) {
            this.configureAuthorizationDAO(beanFactory);
        }
        if (containsDataSource && !containsJdbcTemplate) {
            Util.beanFacotries.registerBean(beanFactory, JdbcTemplate.class);
            containsJdbcTemplate = true;
        }
        if (containsDataSource && !containsSessionFactory) {
            databaseName = this.getDatabaseName(beanFactory);
            Properties properties = new Properties();
            properties.setProperty("hibernate.dialect", this.mapaDatabaseDialect.get(databaseName));
            properties.setProperty("hibernate.show_sql", "true");
            MutablePropertyValues mutablePropertyValues = new MutablePropertyValues();
            mutablePropertyValues.addPropertyValue("hibernateProperties", (Object)properties);
            mutablePropertyValues.addPropertyValue("dataSource", (Object)new RuntimeBeanReference(this.getDataSourceBeanName(beanFactory)));
            Util.beanFacotries.registerBean(beanFactory, AnnotationSessionFactoryBean.class, "sessionFactory", mutablePropertyValues, false);
            containsSessionFactory = true;
        }
        if (containsSessionFactory && !containsHibernateTemplate) {
            Util.beanFacotries.registerBean(beanFactory, HibernateTemplate.class);
            containsHibernateTemplate = true;
        }
        if (containsDataSource && containsSessionFactory && !containsPlatformTransactionManager) {
            Util.beanFacotries.registerBean(beanFactory, HibernateTransactionManager.class);
            containsPlatformTransactionManager = true;
        }
        if (containsPlatformTransactionManager && !containsTransactionTemplate) {
            Util.beanFacotries.registerBean(beanFactory, TransactionTemplate.class);
        }
        if (this.configInXML && this.authorizationDAOAutoconfig) {
            beanFactory.autowireBeanProperties((Object)this.getConfig(beanFactory), 2, false);
        }
        if (!this.authorizationDAOAutoconfig) {
            this.autowireBean(beanFactory, AuthorizationDAO.class);
        }
        try {
            Class.forName("javax.servlet.http.HttpServletRequest");
            MutablePropertyValues mutablePropertyValues = new MutablePropertyValues();
            mutablePropertyValues.addPropertyValue("maxUploadSize", (Object)this.getConfig(beanFactory).getMaxUploadSize());
            Util.beanFacotries.registerBean(beanFactory, NeoCommonsMultipartResolver.class, "multipartResolver", mutablePropertyValues);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    private String getDataSourceBeanName(ConfigurableListableBeanFactory beanFactory) {
        Map map = beanFactory.getBeansOfType(DataSource.class);
        String dataSourcePropertyName = (String)map.keySet().iterator().next();
        return dataSourcePropertyName;
    }

    private String getDatabaseName(ConfigurableListableBeanFactory beanFactory) {
        DataSource dataSource = this.getDataSource(beanFactory);
        if (dataSource != null) {
            Connection connection = null;
            DatabaseMetaData metaData = null;
            try {
                connection = dataSource.getConnection();
                metaData = connection.getMetaData();
                String databaseProductName = metaData.getDatabaseProductName();
                if ("MySQL".equals(databaseProductName)) {
                    int databaseMajorVersion = metaData.getDatabaseMajorVersion();
                    databaseProductName = String.valueOf(databaseProductName) + databaseMajorVersion;
                }
                String string = databaseProductName;
                return string;
            }
            catch (SQLException e) {
                String extra = " ";
                if (connection == null) {
                    extra = "N\u00e3o foi poss\u00edvel estabelecer conex\u00e3o com o banco de dados. ";
                }
                throw new NeoException("Erro ao tentar adquirir o nome do banco de dados. " + extra + e.getMessage(), e);
            }
            finally {
                try {
                    if (metaData != null) {
                        connection.close();
                    }
                    if (connection != null && !connection.isClosed()) {
                        connection.close();
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    private void configureAuthorizationDAO(ConfigurableListableBeanFactory beanFactory) {
        Class<?>[] allClassesOfType = this.classManager.getAllClassesOfType(AuthorizationDAO.class);
        if (allClassesOfType.length == 1) {
            log.info((Object)("AuthorizationDAO n\u00e3o configurado no XML mas encontrado na aplica\u00e7\u00e3o. Utilizando classe: " + allClassesOfType[0].getName()));
            Util.beanFacotries.registerBean(beanFactory, allClassesOfType[0], "authorizationDAO");
            if (this.configInXML) {
                this.autowireConfig(beanFactory);
            }
            this.authorizationDAOAutoconfig = true;
        } else if (allClassesOfType.length > 1) {
            throw new NeoException("Nenhum authorizationDAO foi configurado no XML mas foram encontrados mais de uma classe que implementa AuthorizationDAO na aplica\u00e7\u00e3o. N\u00e3o \u00e9 poss\u00edvel escolher qual classe utilizar. Configure uma das classes no XML de configura\u00e7\u00e3o ou mantenha apenas uma classe implementando AuthorizationDAO na aplica\u00e7\u00e3o");
        }
    }

    private void autowireConfig(ConfigurableListableBeanFactory beanFactory) {
        AbstractBeanDefinition configBean = (AbstractBeanDefinition)beanFactory.getBeanDefinition(this.configName);
        configBean.setAutowireMode(2);
    }

    private <E> void autowireBean(ConfigurableListableBeanFactory beanFactory, Class<E> class1) {
        E e = this.getBean(beanFactory, class1);
        if (e != null) {
            beanFactory.autowireBeanProperties(e, 2, false);
        }
    }

    private DataSource getDataSource(ConfigurableListableBeanFactory beanFactory) {
        Map map = beanFactory.getBeansOfType(DataSource.class);
        if (map.size() > 1) {
            log.warn((Object)"ATEN\u00c7\u00c3O: Foi configurado mais de um DataSource na aplica\u00e7\u00e3o. Em alguns locais o NEO pode precisar de algumas informa\u00e7\u00f5es do DataSource e com mais de um DataSource n\u00e3o \u00e9 poss\u00edvel determinar qual \u00e9 o DataSource correto. Isso pode levar a problemas na aplica\u00e7\u00e3o como a escolha de um dialeto incorreto");
        }
        if (map.size() >= 1) {
            DataSource next = (DataSource)map.values().iterator().next();
            return next;
        }
        log.warn((Object)"Nenhum dataSource configurado na aplica\u00e7\u00e3o");
        return null;
    }

    private Config getConfig(ConfigurableListableBeanFactory beanFactory) {
        return this.getBean(beanFactory, Config.class);
    }

    private <E> E getBean(ConfigurableListableBeanFactory beanFactory, Class<E> class1) {
        Iterator iterator = beanFactory.getBeansOfType(class1).values().iterator();
        if (iterator.hasNext()) {
            Object config = iterator.next();
            return (E)config;
        }
        return null;
    }

    private void verificarConfig(ConfigurableListableBeanFactory beanFactory) {
        Map map = beanFactory.getBeansOfType(Config.class);
        if (map.size() > 1) {
            throw new ConfigurationException("Foram registrados mais de um bean no spring do tipo Config, s\u00f3 \u00e9 poss\u00edvel especificar um bean desse tipo");
        }
        if (map.isEmpty()) {
            log.info((Object)"Config n\u00e3o encontrado. Utilizando default.");
            this.registerConfig(beanFactory);
        } else {
            Object nomeBean = map.keySet().iterator().next();
            this.configInXML = true;
            this.configName = (String)nomeBean;
            log.info((Object)("Encontrado Config. Utilizando bean " + nomeBean));
        }
    }

    private void registerConfig(ConfigurableListableBeanFactory beanFactory) {
        MutablePropertyValues mutablePropertyValues = new MutablePropertyValues();
        RootBeanDefinition beanDefinition = new RootBeanDefinition(DefaultConfig.class, mutablePropertyValues);
        beanDefinition.setAutowireMode(2);
        ((DefaultListableBeanFactory)beanFactory).registerBeanDefinition("config", (BeanDefinition)beanDefinition);
    }
}

