/*
 * Decompiled with CFR 0.152.
 */
package br.com.linkcom.neo.core.web;

import br.com.linkcom.neo.core.config.Config;
import br.com.linkcom.neo.core.standard.Neo;
import br.com.linkcom.neo.core.standard.RequestContext;
import br.com.linkcom.neo.core.web.DefaultWebApplicationContext;
import br.com.linkcom.neo.core.web.DefaultWebRequestContext;
import br.com.linkcom.neo.core.web.WebApplicationContext;
import br.com.linkcom.neo.core.web.WebRequestContext;
import br.com.linkcom.neo.core.web.init.ContextLoaderListener;
import br.com.linkcom.neo.exception.NotInNeoContextException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NeoWeb
extends Neo {
    protected static final Log log = LogFactory.getLog(NeoWeb.class);

    public static void createRequestContext(HttpServletRequest request, HttpServletResponse response) {
        if (request == null || response == null) {
            throw new NullPointerException();
        }
        ServletContext servletContext = request.getSession().getServletContext();
        NeoWeb.getWebApplicationContext(servletContext);
        NeoWeb.getRequestContext(request, response);
    }

    public static WebRequestContext getRequestContext() throws NotInNeoContextException {
        WebRequestContext context = (WebRequestContext)requestContext.get();
        if (context == null) {
            StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
            String msg = "O c\u00f3digo n\u00e3o est\u00e1 sendo executado em um contexto NEO!";
            if (stackTrace.length >= 4) {
                msg = String.valueOf(msg) + "\nClasse: " + stackTrace[3].getClassName() + " " + "\nM\u00e9todo: " + stackTrace[3].getMethodName() + " " + "\nLinha: " + stackTrace[3].getLineNumber();
            }
            msg = String.valueOf(msg) + "\nSe voc\u00ea estiver executanto em um ambiente J2EE, verifique se voc\u00ea configurou no web.xml o filtro da classe ???.\nA configura\u00e7\u00e3o desse filtro \u00e9 importante porque \u00e9 ele quem cria o contexto NEO.";
            throw new NotInNeoContextException(msg);
        }
        return context;
    }

    public static void createApplicationContext(ServletContext servletContext, Config config) {
        DefaultWebApplicationContext applicationContext = new DefaultWebApplicationContext(config, servletContext);
        servletContext.setAttribute(WebApplicationContext.APPLICATION_CONTEXT_ATTRIBUTE, (Object)applicationContext);
        Neo.applicationContext.set(applicationContext);
    }

    public static WebRequestContext getRequestContext(HttpServletRequest request, HttpServletResponse response) {
        NeoWeb.getWebApplicationContext(request.getSession().getServletContext());
        WebRequestContext requestContext = (WebRequestContext)request.getAttribute(WebRequestContext.REQUEST_CONTEXT_ATTRIBUTE);
        if (requestContext == null) {
            log.trace((Object)"Criando contexto de requisi\u00e7\u00e3o Neo... ");
            requestContext = new DefaultWebRequestContext(request, response, NeoWeb.getWebApplicationContext(request.getSession().getServletContext()));
            request.setAttribute(WebRequestContext.REQUEST_CONTEXT_ATTRIBUTE, (Object)requestContext);
            Neo.requestContext.set(requestContext);
        } else {
            requestContext = new DefaultWebRequestContext(request, response, NeoWeb.getWebApplicationContext(request.getSession().getServletContext()));
            request.setAttribute(WebRequestContext.REQUEST_CONTEXT_ATTRIBUTE, (Object)requestContext);
            Neo.requestContext.set(requestContext);
        }
        return requestContext;
    }

    public static WebApplicationContext getWebApplicationContext(ServletContext servletContext) {
        WebApplicationContext applicationContext = (WebApplicationContext)servletContext.getAttribute(WebApplicationContext.APPLICATION_CONTEXT_ATTRIBUTE);
        if (applicationContext == null) {
            throw new NotInNeoContextException("O contexto de aplica\u00e7\u00e3o NEO ainda n\u00e3o foi criado. Verifique se o listener " + ContextLoaderListener.class.getName() + " est\u00e1 configurado no web.xml");
        }
        Neo.applicationContext.set(applicationContext);
        return applicationContext;
    }

    public static /* bridge */ /* synthetic */ RequestContext getRequestContext() throws NotInNeoContextException {
        return NeoWeb.getRequestContext();
    }
}

