/*
 * Decompiled with CFR 0.152.
 */
package br.com.linkcom.neo.controller.resource;

import br.com.linkcom.neo.controller.resource.Resource;
import br.com.linkcom.neo.controller.resource.ResourceGenerationException;
import br.com.linkcom.neo.controller.resource.ResourceSenderController;
import br.com.linkcom.neo.core.standard.Neo;
import br.com.linkcom.neo.core.web.WebRequestContext;
import br.com.linkcom.neo.exception.NeoException;
import br.com.linkcom.neo.report.IReport;
import br.com.linkcom.neo.report.ReportGenerator;
import br.com.linkcom.neo.util.Util;
import org.apache.commons.lang.StringUtils;
import org.springframework.web.servlet.ModelAndView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ReportController<FILTRO>
extends ResourceSenderController<FILTRO> {
    protected String name;
    protected Class<FILTRO> filtroClass;

    public void setName(String name) {
        this.name = name;
    }

    public ReportController() {
        Class clazz;
        Class[] genericTypes = Util.generics.getGenericTypes(((Object)((Object)this)).getClass());
        if (genericTypes.length < 1) {
            boolean invalido = false;
            try {
                genericTypes = Util.generics.getGenericTypes2(((Object)((Object)this)).getClass());
                if (genericTypes.length != 1) {
                    invalido = true;
                }
            }
            catch (Exception e) {
                genericTypes = new Class[]{Object.class};
            }
            if (invalido) {
                throw new RuntimeException("A classe " + ((Object)((Object)this)).getClass().getName() + " deve declarar um tipo gen\u00e9rico que indique o command que ser\u00e1 usado");
            }
        }
        this.filtroClass = clazz = genericTypes[0];
    }

    @Override
    public ModelAndView doFiltro(WebRequestContext request, FILTRO filtro) throws ResourceGenerationException {
        try {
            this.filtro(request, filtro);
        }
        catch (Exception e) {
            throw new ResourceGenerationException("filtro", e);
        }
        return this.getFiltroModelAndView(request, filtro);
    }

    protected ModelAndView getFiltroModelAndView(WebRequestContext request, FILTRO filtro) {
        if (this.name == null) {
            if (!((Object)((Object)this)).getClass().getSimpleName().endsWith("Report")) {
                throw new NeoException("Um controller de relat\u00f3rios deve ter o sufixo Report ou ent\u00e3o setar a vari\u00e1vel name");
            }
            String className = StringUtils.uncapitalize((String)((Object)((Object)this)).getClass().getSimpleName());
            this.name = className.substring(0, className.length() - "Report".length());
        }
        return new ModelAndView("relatorio/" + this.name, "filtro", filtro);
    }

    protected void filtro(WebRequestContext request, FILTRO filtro) throws Exception {
        request.setAttribute("filtro", filtro);
    }

    @Override
    public Resource generateResource(WebRequestContext request, FILTRO filtro) throws Exception {
        IReport report = this.createReport(request, filtro);
        String name = this.getReportName(report);
        byte[] bytes = this.getReportBytes(report);
        return this.getPdfResource(name, bytes);
    }

    protected Resource getPdfResource(String name, byte[] bytes) {
        Resource resource = new Resource();
        resource.setContentType("application/pdf");
        resource.setFileName(name);
        resource.setContents(bytes);
        return resource;
    }

    protected byte[] getReportBytes(IReport report) {
        return this.getReportGenerator().toPdf(report);
    }

    protected String getReportName(IReport report) {
        String name = report.getFileName();
        if (name == null && (name = report.getName()).indexOf(47) != -1) {
            name = name.substring(report.getName().lastIndexOf(47) + 1);
        }
        if (!name.endsWith(".pdf")) {
            name = String.valueOf(name) + ".pdf";
        }
        return name;
    }

    protected ReportGenerator getReportGenerator() {
        return Neo.getApplicationContext().getReportGenerator();
    }

    public abstract IReport createReport(WebRequestContext var1, FILTRO var2) throws Exception;
}

