/*
 * Decompiled with CFR 0.152.
 */
package br.com.linkcom.neo.controller.crud;

import br.com.linkcom.neo.controller.crud.AbstractCrudController;
import br.com.linkcom.neo.controller.crud.CrudException;
import br.com.linkcom.neo.controller.crud.FiltroListagem;
import br.com.linkcom.neo.core.standard.Neo;
import br.com.linkcom.neo.core.web.DefaultWebRequestContext;
import br.com.linkcom.neo.core.web.WebRequestContext;
import br.com.linkcom.neo.exception.NeoException;
import br.com.linkcom.neo.persistence.ListagemResult;
import br.com.linkcom.neo.service.GenericService;
import br.com.linkcom.neo.util.Util;
import br.com.linkcom.neo.view.ajax.View;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import org.springframework.validation.BindException;
import org.springframework.web.servlet.ModelAndView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CrudController<FILTRO extends FiltroListagem, FORMBEAN, BEAN>
extends AbstractCrudController<FILTRO, FORMBEAN> {
    protected Class<? extends FILTRO> listagemCommandClass;
    protected Class<FORMBEAN> entradaCommandClass;
    protected Class<BEAN> beanClass;
    protected GenericService<BEAN> genericService;

    public GenericService<BEAN> getGenericService() {
        return this.genericService;
    }

    public void setGenericService(GenericService<BEAN> genericService) {
        this.genericService = genericService;
    }

    public void setBeanClass(Class<BEAN> beanClass) {
        this.beanClass = beanClass;
    }

    public void setEntradaCommandClass(Class<FORMBEAN> entradaCommandClass) {
        this.entradaCommandClass = entradaCommandClass;
    }

    public void setListagemCommandClass(Class<FILTRO> listagemCommandClass) {
        this.listagemCommandClass = listagemCommandClass;
    }

    @Override
    protected void validate(Object obj, BindException errors, String acao) {
        if (obj != null) {
            if (this.listagemCommandClass.isAssignableFrom(obj.getClass())) {
                this.validateFilter((FiltroListagem)obj, errors);
            }
            if (this.entradaCommandClass.isAssignableFrom(obj.getClass())) {
                this.validateBean(obj, errors);
            }
        }
    }

    protected void validateBean(FORMBEAN bean, BindException errors) {
    }

    protected void validateFilter(FILTRO filtro, BindException errors) {
    }

    public CrudController() {
        Class[] classes = Util.generics.getGenericTypes(((Object)((Object)this)).getClass());
        if (classes.length != 3) {
            classes = Util.generics.getGenericTypes2(((Object)((Object)this)).getClass());
            if (classes.length == 3 && !classes[1].equals(Object.class) && !classes[2].equals(Object.class)) {
                this.setListagemCommandClass(classes[0]);
                this.setEntradaCommandClass(classes[1]);
                this.setBeanClass(classes[2]);
                return;
            }
            throw new RuntimeException("A classe " + ((Object)((Object)this)).getClass().getName() + " deve declarar tres tipos gen\u00e9ricos LISTAGEM, FORMBEAN, BEAN");
        }
        this.setListagemCommandClass(classes[0]);
        this.setEntradaCommandClass(classes[1]);
        this.setBeanClass(classes[2]);
    }

    @Override
    public ModelAndView doListagem(WebRequestContext request, FILTRO filtro) throws CrudException {
        try {
            this.setInfoForTemplate(request);
            this.setListagemInfo(request, filtro);
            this.listagem(request, filtro);
        }
        catch (Exception e) {
            throw new CrudException("listagem", e);
        }
        return this.getListagemModelAndView(request, filtro);
    }

    protected void setInfoForTemplate(WebRequestContext request) {
        request.setAttribute("TEMPLATE_listagem", "true");
        request.setAttribute("TEMPLATE_beanNameUncaptalized", this.getBeanName());
        request.setAttribute("TEMPLATE_beanName", this.getBeanName());
        request.setAttribute("TEMPLATE_beanDisplayName", Neo.getApplicationContext().getBeanDescriptor(null, this.beanClass).getDisplayName());
        request.setAttribute("TEMPLATE_beanClass", this.beanClass);
    }

    protected void setInfoForTemplate(WebRequestContext request, FORMBEAN form) {
        request.setAttribute("TEMPLATE_beanNameUncaptalized", this.getBeanName());
        request.setAttribute("TEMPLATE_beanName", this.getBeanName());
        request.setAttribute("TEMPLATE_enviar", "salvar");
        request.setAttribute("TEMPLATE_voltar", "listagem");
        request.setAttribute("TEMPLATE_beanDisplayName", Neo.getApplicationContext().getBeanDescriptor(null, this.beanClass).getDisplayName());
        request.setAttribute("TEMPLATE_beanClass", this.beanClass);
    }

    protected ModelAndView getListagemModelAndView(WebRequestContext request, FILTRO filtro) {
        return new ModelAndView("crud/" + this.getBeanName() + "Listagem");
    }

    protected void setListagemInfo(WebRequestContext request, FILTRO filtro) throws Exception {
        if (!this.listagemVaziaPrimeiraVez() || ((FiltroListagem)filtro).isNotFirstTime()) {
            ListagemResult<BEAN> listagemResult = this.getLista(request, filtro);
            request.setAttribute("lista", listagemResult.list());
            request.setAttribute("currentPage", ((FiltroListagem)filtro).getCurrentPage());
            request.setAttribute("numberOfPages", ((FiltroListagem)filtro).getNumberOfPages());
            request.setAttribute("filtro", filtro);
        } else {
            request.setAttribute("lista", new ArrayList());
            request.setAttribute("currentPage", 0);
            request.setAttribute("numberOfPages", 0);
            request.setAttribute("filtro", filtro);
        }
    }

    protected ListagemResult<BEAN> getLista(WebRequestContext request, FILTRO filtro) {
        return this.genericService.findForListagem((FiltroListagem)filtro);
    }

    protected boolean listagemVaziaPrimeiraVez() {
        return false;
    }

    protected void listagem(WebRequestContext request, FILTRO filtro) throws Exception {
    }

    @Override
    public ModelAndView doEntrada(WebRequestContext request, FORMBEAN form) throws CrudException {
        if ("true".equals(request.getParameter("forcarConsulta"))) {
            request.setAttribute("consultar", true);
        }
        try {
            this.setInfoForTemplate(request, form);
            this.setEntradaDefaultInfo(request, form);
            this.entrada(request, form);
        }
        catch (Exception e) {
            throw new CrudException("entrada", e);
        }
        return this.getEntradaModelAndView(request, form);
    }

    protected ModelAndView getEntradaModelAndView(WebRequestContext request, FORMBEAN form) {
        if (Boolean.TRUE.equals(request.getAttribute("consultar"))) {
            return new ModelAndView("crud/" + this.getBeanName() + "Consulta");
        }
        return new ModelAndView("crud/" + this.getBeanName() + "Entrada");
    }

    protected void setEntradaDefaultInfo(WebRequestContext request, FORMBEAN form) throws Exception {
        request.setAttribute(this.getBeanName(), form);
    }

    protected void entrada(WebRequestContext request, FORMBEAN form) throws Exception {
    }

    @Override
    public ModelAndView doCriar(WebRequestContext request, FORMBEAN form) throws CrudException {
        try {
            BEAN bean = this.formToBean(form);
            bean = this.criar(request, bean);
            form = this.beanToForm(bean);
        }
        catch (Exception e) {
            throw new CrudException("criar", e);
        }
        return this.getCriarModelAndView(request, form);
    }

    protected ModelAndView getCriarModelAndView(WebRequestContext request, FORMBEAN form) throws CrudException {
        ((DefaultWebRequestContext)request).setLastAction("entrada");
        return this.doEntrada(request, form);
    }

    protected BEAN criar(WebRequestContext request, BEAN form) throws Exception {
        try {
            return this.beanClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new NeoException("N\u00e3o foi poss\u00edvel instanciar classe " + this.entradaCommandClass, e);
        }
        catch (IllegalAccessException e) {
            throw new NeoException("N\u00e3o foi poss\u00edvel instanciar classe " + this.entradaCommandClass, e);
        }
    }

    @Override
    public ModelAndView doEditar(WebRequestContext request, FORMBEAN form) throws CrudException {
        if (request.getAttribute("consultar") == null) {
            request.setAttribute("consultar", false);
        }
        if ("true".equals(request.getParameter("forcarConsulta"))) {
            request.setAttribute("consultar", true);
        }
        try {
            BEAN bean = this.formToBean(form);
            bean = this.carregar(request, bean);
            form = this.beanToForm(bean);
        }
        catch (Exception e) {
            throw new CrudException("editar", e);
        }
        return this.getEditarModelAndView(request, form);
    }

    protected ModelAndView getEditarModelAndView(WebRequestContext request, FORMBEAN form) throws CrudException {
        ((DefaultWebRequestContext)request).setLastAction("entrada");
        return this.doEntrada(request, form);
    }

    protected BEAN carregar(WebRequestContext request, BEAN bean) throws Exception {
        return this.genericService.loadForEntrada(bean);
    }

    @Override
    public ModelAndView doSalvar(WebRequestContext request, FORMBEAN form) throws CrudException {
        BEAN bean = null;
        try {
            bean = this.formToBean(form);
            this.salvar(request, bean);
        }
        catch (Exception e) {
            throw new CrudException("salvar", e);
        }
        return this.getSalvarModelAndView(request, bean);
    }

    protected ModelAndView getSalvarModelAndView(WebRequestContext request, BEAN bean) {
        if ("true".equals(request.getParameter("fromInsertOne"))) {
            Object id = Util.beans.getId(bean);
            String description = Util.strings.toStringDescription(bean);
            View.getCurrent().println("<html><script language=\"JavaScript\" src=\"" + request.getServletRequest().getContextPath() + "/resource/js/util.js\"></script>" + "<script language=\"JavaScript\">selecionar('" + id + "', '" + description + "', true);</script>" + "</html>");
            return null;
        }
        return this.sendRedirectToAction("listagem");
    }

    protected void salvar(WebRequestContext request, BEAN bean) throws Exception {
        this.genericService.saveOrUpdate(bean);
    }

    @Override
    public ModelAndView doExcluir(WebRequestContext request, FORMBEAN form) throws CrudException {
        BEAN bean = null;
        try {
            bean = this.formToBean(form);
            this.excluir(request, bean);
        }
        catch (Exception e) {
            throw new CrudException("excluir", e);
        }
        return this.getExcluirModelAndView(request, bean);
    }

    protected ModelAndView getExcluirModelAndView(WebRequestContext request, BEAN bean) {
        return this.sendRedirectToAction("listagem");
    }

    protected void excluir(WebRequestContext request, BEAN bean) throws Exception {
        this.genericService.delete(bean);
    }

    public FORMBEAN beanToForm(BEAN bean) {
        if (this.entradaCommandClass.equals(this.beanClass)) {
            return (FORMBEAN)bean;
        }
        throw new NeoException("N\u00e3o foi poss\u00edvel converter de bean para form. Sobrescrever o m\u00e9todo beanToForm");
    }

    public BEAN formToBean(FORMBEAN form) {
        if (this.beanClass.equals(this.entradaCommandClass)) {
            return (BEAN)form;
        }
        throw new NeoException("N\u00e3o foi poss\u00edvel converter de form para bean. Sobrescrever o m\u00e9todo formToBean");
    }

    public String getBeanName() {
        return Util.strings.uncaptalize(this.beanClass.getSimpleName());
    }

    protected String[] getAllowedFieldsForSaving(HttpServletRequest request) {
        return null;
    }
}

